/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.entity;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.util.ByteArraySizedInputStream;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/dbms/entity/EntityMetadata;", "", "created", "", "columns", "", "", "(JLjava/util/List;)V", "getColumns", "()Ljava/util/List;", "getCreated", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "cottontaildb-dbms"})
public final class EntityMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long created;
    @NotNull
    private final List<String> columns;
    @NotNull
    private static final String CATALOGUE_ENTITY_STORE_NAME = "org.vitrivr.cottontail.entity";

    public EntityMetadata(long created, @NotNull List<String> columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        this.created = created;
        this.columns = columns2;
    }

    public final long getCreated() {
        return this.created;
    }

    @NotNull
    public final List<String> getColumns() {
        return this.columns;
    }

    public final long component1() {
        return this.created;
    }

    @NotNull
    public final List<String> component2() {
        return this.columns;
    }

    @NotNull
    public final EntityMetadata copy(long created, @NotNull List<String> columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        return new EntityMetadata(created, columns2);
    }

    public static /* synthetic */ EntityMetadata copy$default(EntityMetadata entityMetadata, long l, List list, int n, Object object) {
        if ((n & 1) != 0) {
            l = entityMetadata.created;
        }
        if ((n & 2) != 0) {
            list = entityMetadata.columns;
        }
        return entityMetadata.copy(l, list);
    }

    @NotNull
    public String toString() {
        return "EntityMetadata(created=" + this.created + ", columns=" + this.columns + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.created);
        result = result * 31 + ((Object)this.columns).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EntityMetadata)) {
            return false;
        }
        EntityMetadata entityMetadata = (EntityMetadata)other;
        if (this.created != entityMetadata.created) {
            return false;
        }
        return Intrinsics.areEqual(this.columns, entityMetadata.columns);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/vitrivr/cottontail/dbms/entity/EntityMetadata$Companion;", "", "()V", "CATALOGUE_ENTITY_STORE_NAME", "", "fromEntry", "Lorg/vitrivr/cottontail/dbms/entity/EntityMetadata;", "entry", "Ljetbrains/exodus/ByteIterable;", "init", "", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "transaction", "Ljetbrains/exodus/env/Transaction;", "store", "Ljetbrains/exodus/env/Store;", "toEntry", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nEntityMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityMetadata.kt\norg/vitrivr/cottontail/dbms/entity/EntityMetadata$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1549#2:80\n1620#2,3:81\n*S KotlinDebug\n*F\n+ 1 EntityMetadata.kt\norg/vitrivr/cottontail/dbms/entity/EntityMetadata$Companion\n*L\n57#1:80\n57#1:81,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void init(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            if (catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(EntityMetadata.CATALOGUE_ENTITY_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, transaction, true) == null) {
                throw new DatabaseException.DataCorruptionException("Failed to create entity catalogue.");
            }
        }

        @NotNull
        public final Store store(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Store store = catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(EntityMetadata.CATALOGUE_ENTITY_STORE_NAME, StoreConfig.USE_EXISTING, transaction, false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Failed to open store for entity catalogue.");
            }
            return store;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final EntityMetadata fromEntry(@NotNull ByteIterable entry) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            ByteArraySizedInputStream stream = new ByteArraySizedInputStream(entry.getBytesUnsafe(), 0, entry.getLength());
            long created = LongBinding.readCompressed((ByteArrayInputStream)((ByteArrayInputStream)stream));
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)IntegerBinding.readCompressed((ByteArrayInputStream)((ByteArrayInputStream)stream)));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringBinding.BINDING.readObject((ByteArrayInputStream)stream));
            }
            List columns2 = (List)destination$iv$iv;
            return new EntityMetadata(created, columns2);
        }

        @NotNull
        public final ByteIterable toEntry(@NotNull EntityMetadata entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            LightOutputStream output = new LightOutputStream();
            LongBinding.writeCompressed((LightOutputStream)output, (long)entry.getCreated());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)entry.getColumns().size());
            for (String columnName : entry.getColumns()) {
                StringBinding.BINDING.writeObject(output, (Comparable)((Object)columnName));
            }
            ArrayByteIterable arrayByteIterable = output.asArrayByteIterable();
            Intrinsics.checkNotNullExpressionValue((Object)arrayByteIterable, (String)"asArrayByteIterable(...)");
            return (ByteIterable)arrayByteIterable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

