/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.execution.services;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.CatalogueTx;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.events.Event;
import org.vitrivr.cottontail.dbms.events.IndexEvent;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.execution.services.AutoRebuilderService;
import org.vitrivr.cottontail.dbms.execution.transactions.Transaction;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionObserver;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionType;
import org.vitrivr.cottontail.dbms.index.basic.Index;
import org.vitrivr.cottontail.dbms.index.basic.IndexState;
import org.vitrivr.cottontail.dbms.index.basic.IndexType;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.AsyncIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.IndexRebuilderState;
import org.vitrivr.cottontail.dbms.queries.context.DefaultQueryContext;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.dbms.schema.SchemaTx;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016J\u0014\u0010\u0016\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0016J\u0016\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/services/AutoRebuilderService;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionObserver;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "(Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;)V", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "failures", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "", "isRelevant", "", "event", "Lorg/vitrivr/cottontail/dbms/events/Event;", "onCommit", "", "txId", "", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "events", "", "onDeliveryFailure", "schedule", "index", "type", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "Companion", "Task", "cottontaildb-dbms"})
public final class AutoRebuilderService
implements TransactionObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Catalogue catalogue;
    @NotNull
    private final ConcurrentHashMap<Name.IndexName, Integer> failures;
    @NotNull
    private final AtomicLong counter;
    private static final int MAX_INDEX_REBUILDING_RETRY = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoRebuilderService.class);

    public AutoRebuilderService(@NotNull Catalogue catalogue) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        this.catalogue = catalogue;
        this.failures = new ConcurrentHashMap(10);
        this.counter = new AtomicLong(0L);
    }

    @Override
    public boolean isRelevant(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return event instanceof IndexEvent;
    }

    @Override
    public void onCommit(long txId, @NotNull List<? extends Event> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        for (Event pair : events) {
            Event event = pair;
            if (event instanceof IndexEvent.State) {
                if (((IndexEvent.State)pair).getState() == IndexState.STALE) {
                    set.add((Object)TuplesKt.to((Object)((IndexEvent.State)pair).getIndex(), (Object)((Object)((IndexEvent.State)pair).getType())));
                    continue;
                }
                set.remove((Object)TuplesKt.to((Object)((IndexEvent.State)pair).getIndex(), (Object)((Object)((IndexEvent.State)pair).getType())));
                continue;
            }
            if (event instanceof IndexEvent.Created) {
                set.add((Object)TuplesKt.to((Object)((IndexEvent.Created)pair).getIndex(), (Object)((Object)((IndexEvent.Created)pair).getType())));
                continue;
            }
            if (!(event instanceof IndexEvent.Dropped)) continue;
            set.remove((Object)TuplesKt.to((Object)((IndexEvent.Dropped)pair).getIndex(), (Object)((Object)((IndexEvent.Dropped)pair).getType())));
        }
        for (Pair pair : set) {
            Name.IndexName index = (Name.IndexName)pair.component1();
            IndexType type = (IndexType)((Object)pair.component2());
            this.schedule(index, type);
        }
    }

    @Override
    public void onDeliveryFailure(long txId) {
    }

    public final void schedule(@NotNull Name.IndexName index, @NotNull IndexType type) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.catalogue.getTransactionManager().getExecutionManager().getServiceWorkerPool$cottontaildb_dbms().schedule(new Task(index, type), 500L, TimeUnit.MILLISECONDS);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/services/AutoRebuilderService$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MAX_INDEX_REBUILDING_RETRY", "", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/services/AutoRebuilderService$Task;", "Ljava/lang/Runnable;", "index", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "type", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "(Lorg/vitrivr/cottontail/dbms/execution/services/AutoRebuilderService;Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;)V", "performConcurrentRebuild", "", "performRebuild", "run", "", "tryScheduleRetry", "cottontaildb-dbms"})
    public final class Task
    implements Runnable {
        @NotNull
        private final Name.IndexName index;
        @NotNull
        private final IndexType type;

        public Task(@NotNull Name.IndexName index, IndexType type) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.index = index;
            this.type = type;
        }

        @Override
        public void run() {
            boolean bl;
            long start = System.currentTimeMillis();
            if (this.type.getDescriptor().getSupportsAsyncRebuild() && this.type.getDescriptor().getSupportsIncrementalUpdate()) {
                LOGGER.info("Starting asynchronous index auto-rebuilding for " + this.index + ".");
                bl = this.performConcurrentRebuild();
            } else {
                LOGGER.info("Starting index auto-rebuilding for " + this.index + ".");
                bl = this.performRebuild();
            }
            boolean success = bl;
            long end = System.currentTimeMillis();
            if (success) {
                LOGGER.info("Index auto-rebuilding for " + this.index + " completed (took " + (end - start) + "ms).");
            } else {
                this.tryScheduleRetry();
            }
        }

        private final void tryScheduleRetry() {
            Integer failures2;
            Integer n = failures2 = AutoRebuilderService.this.failures.compute(this.index, (arg_0, arg_1) -> Task.tryScheduleRetry$lambda$0(tryScheduleRetry.failures.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull((Object)n);
            if (n <= 3) {
                LOGGER.warn("Index auto-rebuilding for " + this.index + " failed " + failures2 + " time(s). Re-scheduling the task...");
                AutoRebuilderService.this.catalogue.getTransactionManager().getExecutionManager().getServiceWorkerPool$cottontaildb_dbms().schedule(new Task(this.index, this.type), 5000L, TimeUnit.MILLISECONDS);
            } else {
                LOGGER.error("Index auto-rebuilding for " + this.index + " failed " + failures2 + " time(s). Aborting...");
                AutoRebuilderService.this.failures.remove(this.index);
            }
        }

        private final boolean performRebuild() {
            Transaction transaction = AutoRebuilderService.this.catalogue.getTransactionManager().startTransaction(TransactionType.SYSTEM_EXCLUSIVE);
            DefaultQueryContext context2 = new DefaultQueryContext("auto-rebuild-" + AutoRebuilderService.this.counter.incrementAndGet(), AutoRebuilderService.this.catalogue, transaction, null, 8, null);
            try {
                CatalogueTx catalogueTx = AutoRebuilderService.this.catalogue.newTx(context2);
                Schema schema = catalogueTx.schemaForName(this.index.schema());
                SchemaTx schemaTx = schema.newTx(context2);
                Entity entity = schemaTx.entityForName(this.index.entity());
                EntityTx entityTx = entity.newTx(context2);
                Index index = entityTx.indexForName(this.index);
                boolean ret = index.newRebuilder(context2).rebuild();
                if (ret) {
                    transaction.commit();
                } else {
                    transaction.rollback();
                }
                return ret;
            }
            catch (Throwable e) {
                Throwable throwable = e;
                if ((throwable instanceof DatabaseException.SchemaDoesNotExistException ? true : throwable instanceof DatabaseException.EntityAlreadyExistsException) ? true : throwable instanceof DatabaseException.IndexDoesNotExistException) {
                    LOGGER.warn("Index auto-rebuilding for " + this.index + " failed because DBO no longer exists.");
                } else {
                    LOGGER.error("Index auto-rebuilding for " + this.index + " failed due to exception: " + e.getMessage() + ".");
                }
                transaction.rollback();
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean performConcurrentRebuild() {
            Object catalogueTx2;
            Transaction transaction = AutoRebuilderService.this.catalogue.getTransactionManager().startTransaction(TransactionType.SYSTEM_READONLY);
            DefaultQueryContext context2 = new DefaultQueryContext("auto-rebuild-prepare", AutoRebuilderService.this.catalogue, transaction, null, 8, null);
            try {
                catalogueTx2 = AutoRebuilderService.this.catalogue.newTx(context2);
                Schema schema = catalogueTx2.schemaForName(this.index.schema());
                SchemaTx schemaTx = schema.newTx(context2);
                Entity entity = schemaTx.entityForName(this.index.entity());
                EntityTx entityTx = entity.newTx(context2);
                Index index = entityTx.indexForName(this.index);
                AsyncIndexRebuilder<?> ret = index.newAsyncRebuilder(context2);
                transaction.commit();
                catalogueTx2 = ret;
            }
            catch (Throwable e) {
                Throwable throwable = e;
                if ((throwable instanceof DatabaseException.SchemaDoesNotExistException ? true : throwable instanceof DatabaseException.EntityAlreadyExistsException) ? true : throwable instanceof DatabaseException.IndexDoesNotExistException) {
                    LOGGER.warn("Index auto-rebuilding for " + this.index + " failed because DBO no longer exists.");
                } else {
                    LOGGER.error("Index auto-rebuilding (SCAN) for " + this.index + " failed due to exception: " + e.getMessage() + ".");
                }
                transaction.rollback();
                return false;
            }
            Object rebuilder = catalogueTx2;
            try {
                rebuilder.build();
                if (rebuilder.getState() != IndexRebuilderState.REBUILT) {
                    boolean catalogueTx2 = false;
                    return catalogueTx2;
                }
                rebuilder.replace();
                if (rebuilder.getState() != IndexRebuilderState.FINISHED) {
                    boolean catalogueTx2 = false;
                    return catalogueTx2;
                }
                boolean catalogueTx2 = true;
                return catalogueTx2;
            }
            catch (Throwable e) {
                LOGGER.error("Index auto-rebuilding (MERGE) for " + this.index + " failed due to exception: " + e.getMessage() + ".");
                boolean bl = false;
                return bl;
            }
            finally {
                AutoRebuilderService.this.catalogue.getTransactionManager().deregister((TransactionObserver)rebuilder);
                rebuilder.close();
            }
        }

        private static final Integer tryScheduleRetry$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Integer)$tmp0.invoke(p0, p1);
        }
    }
}

