/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.execution.transactions;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.vfs.ClusteringStrategy;
import jetbrains.exodus.vfs.VfsConfig;
import jetbrains.exodus.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.dbms.events.Event;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.ExecutionManager;
import org.vitrivr.cottontail.dbms.execution.locking.LockManager;
import org.vitrivr.cottontail.dbms.execution.operators.basics.Operator;
import org.vitrivr.cottontail.dbms.execution.transactions.FinishedTransaction;
import org.vitrivr.cottontail.dbms.execution.transactions.Transaction;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionMetadata;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionObserver;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionStatus;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionType;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.Tx;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003<=>B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0,\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0018J\u0017\u00101\u001a\u0004\u0018\u0001022\n\u00103\u001a\u00060\"j\u0002`4H\u0086\u0002J\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001f06J\u000e\u00107\u001a\u00020/2\u0006\u00100\u001a\u00020\u0018J\u0006\u00108\u001a\u00020/J\u000e\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020;R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R2\u0010\u0016\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018 \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u001a0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R^\u0010 \u001aR\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\"0\"\u0012\u0014\u0012\u0012 \u0019*\b\u0018\u00010#R\u00020\u00000#R\u00020\u0000 \u0019*(\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\"0\"\u0012\u0014\u0012\u0012 \u0019*\b\u0018\u00010#R\u00020\u00000#R\u00020\u0000\u0018\u00010$0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006?"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "", "executionManager", "Lorg/vitrivr/cottontail/dbms/execution/ExecutionManager;", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/dbms/execution/ExecutionManager;Lorg/vitrivr/cottontail/config/Config;)V", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "environment", "Ljetbrains/exodus/env/Environment;", "getEnvironment$cottontaildb_dbms", "()Ljetbrains/exodus/env/Environment;", "exclusiveLock", "Ljava/util/concurrent/locks/StampedLock;", "getExecutionManager", "()Lorg/vitrivr/cottontail/dbms/execution/ExecutionManager;", "lockManager", "Lorg/vitrivr/cottontail/dbms/execution/locking/LockManager;", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "getLockManager$cottontaildb_dbms", "()Lorg/vitrivr/cottontail/dbms/execution/locking/LockManager;", "observers", "", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionObserver;", "kotlin.jvm.PlatformType", "", "tidCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "transactionHistory", "", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionMetadata;", "transactions", "", "", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$AbstractTransaction;", "", "vfs", "Ljetbrains/exodus/vfs/VirtualFileSystem;", "getVfs$cottontaildb_dbms", "()Ljetbrains/exodus/vfs/VirtualFileSystem;", "computeExclusively", "T", "callback", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "deregister", "", "observer", "get", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "txId", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "history", "", "register", "shutdown", "startTransaction", "type", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "AbstractTransaction", "ExclusiveTransaction", "ReadonlyTransaction", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionManager.kt\norg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager\n+ 2 StampedLocksExtensions.kt\norg/vitrivr/cottontail/utilities/extensions/StampedLocksExtensionsKt\n*L\n1#1,469:1\n49#2,7:470\n*S KotlinDebug\n*F\n+ 1 TransactionManager.kt\norg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager\n*L\n134#1:470,7\n*E\n"})
public final class TransactionManager {
    @NotNull
    private final ExecutionManager executionManager;
    @NotNull
    private final Config config;
    private final Map<Long, AbstractTransaction> transactions;
    @NotNull
    private final List<TransactionMetadata> transactionHistory;
    private final Set<TransactionObserver> observers;
    @NotNull
    private final AtomicLong tidCounter;
    @NotNull
    private final StampedLock exclusiveLock;
    @NotNull
    private final LockManager<DBO> lockManager;
    @NotNull
    private final Environment environment;
    @NotNull
    private final VirtualFileSystem vfs;

    public TransactionManager(@NotNull ExecutionManager executionManager, @NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)executionManager, (String)"executionManager");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.executionManager = executionManager;
        this.config = config;
        this.transactions = Collections.synchronizedMap((Map)new Long2ObjectOpenHashMap(this.config.getExecution().getTransactionTableSize(), 0.25f));
        List list = Collections.synchronizedList(new ArrayList(this.config.getExecution().getTransactionHistorySize()));
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        this.transactionHistory = list;
        this.observers = Collections.synchronizedSet((Set)new ObjectOpenHashSet());
        this.tidCounter = new AtomicLong(1L);
        this.exclusiveLock = new StampedLock();
        this.lockManager = new LockManager();
        File file = this.config.dataFolder().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        this.environment = Environments.newInstance((File)file, (EnvironmentConfig)this.config.getXodus().toEnvironmentConfig());
        jetbrains.exodus.env.Transaction transaction = this.environment.beginExclusiveTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"beginExclusiveTransaction(...)");
        jetbrains.exodus.env.Transaction tx = transaction;
        try {
            VfsConfig config2 = new VfsConfig();
            config2.setClusteringStrategy((ClusteringStrategy)new ClusteringStrategy.QuadraticClusteringStrategy(65536));
            config2.getClusteringStrategy().setMaxClusterSize(0x100000);
            this.vfs = new VirtualFileSystem(this.environment, config2, tx);
            tx.commit();
        }
        catch (Throwable e) {
            tx.abort();
            throw e;
        }
    }

    @NotNull
    public final ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public final LockManager<DBO> getLockManager$cottontaildb_dbms() {
        return this.lockManager;
    }

    @NotNull
    public final Environment getEnvironment$cottontaildb_dbms() {
        return this.environment;
    }

    @NotNull
    public final VirtualFileSystem getVfs$cottontaildb_dbms() {
        return this.vfs;
    }

    @Nullable
    public final Transaction get(long txId) {
        return this.transactions.get(txId);
    }

    @NotNull
    public final List<TransactionMetadata> history() {
        return CollectionsKt.plus((Collection)this.transactionHistory, (Iterable)CollectionsKt.toList((Iterable)this.transactions.values()));
    }

    public final void register(@NotNull TransactionObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.observers.add(observer);
    }

    public final void deregister(@NotNull TransactionObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.observers.remove(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T computeExclusively(@NotNull Function0<? extends T> callback) {
        Object $i$a$-write-TransactionManager$computeExclusively$22;
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        StampedLock $this$write$iv = this.exclusiveLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-TransactionManager$computeExclusively$22 = false;
            $i$a$-write-TransactionManager$computeExclusively$22 = callback.invoke();
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
        return (T)$i$a$-write-TransactionManager$computeExclusively$22;
    }

    @NotNull
    public final Transaction startTransaction(@NotNull TransactionType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return type.getReadonly() ? (Transaction)new ReadonlyTransaction(type) : (Transaction)new ExclusiveTransaction(type);
    }

    public final void shutdown() {
        this.vfs.shutdown();
        this.executionManager.shutdownAndWait();
        this.environment.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u00a2\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000201H\u0016J\b\u00107\u001a\u000208H\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u000208H\u0014J!\u0010?\u001a\u0004\u0018\u0001H@\"\b\b\u0000\u0010@*\u0002012\u0006\u0010A\u001a\u00020BH\u0016\u00a2\u0006\u0002\u0010CJ\b\u0010D\u001a\u000208H\u0016J\b\u0010E\u001a\u000208H\u0002J\b\u0010F\u001a\u000208H\u0002J\b\u0010G\u001a\u000208H\u0016J\u0010\u0010H\u001a\u0002082\u0006\u0010I\u001a\u00020\u001cH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R&\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0019\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000bR\u0011\u0010%\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000bR\u001e\u0010'\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u000bR\u001e\u0010*\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0011R\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006J"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$AbstractTransaction;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "type", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "(Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;)V", "activeContexts", "Ljava/util/HashSet;", "Lkotlin/coroutines/CoroutineContext;", "availableIntraQueryWorkers", "", "getAvailableIntraQueryWorkers", "()I", "availableQueryWorkers", "getAvailableQueryWorkers", "created", "", "getCreated", "()J", "<set-?>", "ended", "getEnded", "()Ljava/lang/Long;", "Ljava/lang/Long;", "localObservers", "", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionObserver;", "Ljava/lang/ref/SoftReference;", "", "Lorg/vitrivr/cottontail/dbms/events/Event;", "manager", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "getManager", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "numberOfError", "getNumberOfError", "numberOfOngoing", "getNumberOfOngoing", "numberOfSuccess", "getNumberOfSuccess", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionStatus;", "state", "getState", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionStatus;", "transactionId", "getTransactionId", "txns", "Lorg/vitrivr/cottontail/core/database/Name;", "Lorg/vitrivr/cottontail/dbms/general/Tx;", "getType", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "cacheTx", "", "tx", "commit", "", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "operator", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "finalizeTransaction", "getCachedTxForDBO", "T", "dbo", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "(Lorg/vitrivr/cottontail/dbms/general/DBO;)Lorg/vitrivr/cottontail/dbms/general/Tx;", "kill", "notifyObservers", "performRollback", "rollback", "signalEvent", "event", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionManager.kt\norg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$AbstractTransaction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,469:1\n800#2,11:470\n*S KotlinDebug\n*F\n+ 1 TransactionManager.kt\norg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$AbstractTransaction\n*L\n383#1:470,11\n*E\n"})
    private abstract class AbstractTransaction
    implements Transaction {
        @NotNull
        private final TransactionType type;
        private final long transactionId;
        @NotNull
        private volatile TransactionStatus state;
        @NotNull
        private final Map<TransactionObserver, SoftReference<List<Event>>> localObservers;
        @NotNull
        private final Map<Name, Tx> txns;
        @NotNull
        private final Mutex mutex;
        @NotNull
        private final HashSet<CoroutineContext> activeContexts;
        @Nullable
        private Long ended;
        private volatile int numberOfSuccess;
        private volatile int numberOfError;

        public AbstractTransaction(TransactionType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.transactionId = TransactionManager.this.tidCounter.getAndIncrement();
            this.state = TransactionStatus.IDLE;
            Object2ObjectMap object2ObjectMap = Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)new Object2ObjectLinkedOpenHashMap()));
            Intrinsics.checkNotNullExpressionValue((Object)object2ObjectMap, (String)"synchronize(...)");
            this.localObservers = (Map)object2ObjectMap;
            Object2ObjectMap object2ObjectMap2 = Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)new Object2ObjectLinkedOpenHashMap()));
            Intrinsics.checkNotNullExpressionValue((Object)object2ObjectMap2, (String)"synchronize(...)");
            this.txns = (Map)object2ObjectMap2;
            this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
            this.activeContexts = new HashSet();
            Map map2 = TransactionManager.this.transactions;
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"access$getTransactions$p(...)");
            Map map3 = map2;
            map3.put(this.transactionId, this);
            for (TransactionObserver observer : TransactionManager.this.observers) {
                Intrinsics.checkNotNull((Object)observer);
                this.localObservers.put(observer, new SoftReference(new LinkedList()));
            }
        }

        @Override
        @NotNull
        public TransactionType getType() {
            return this.type;
        }

        @Override
        public final long getTransactionId() {
            return this.transactionId;
        }

        @Override
        @NotNull
        public final TransactionStatus getState() {
            return this.state;
        }

        @Override
        @NotNull
        public TransactionManager getManager() {
            return TransactionManager.this;
        }

        @Override
        public final long getCreated() {
            return this.getXodusTx().getStartTime();
        }

        @Override
        @Nullable
        public final Long getEnded() {
            return this.ended;
        }

        @Override
        public final int getNumberOfSuccess() {
            return this.numberOfSuccess;
        }

        @Override
        public final int getNumberOfError() {
            return this.numberOfError;
        }

        @Override
        public final int getNumberOfOngoing() {
            return this.activeContexts.size();
        }

        @Override
        public int getAvailableQueryWorkers() {
            return TransactionManager.this.getExecutionManager().availableQueryWorkers();
        }

        @Override
        public int getAvailableIntraQueryWorkers() {
            return TransactionManager.this.getExecutionManager().availableIntraQueryWorkers();
        }

        @Override
        public boolean cacheTx(@NotNull Tx tx) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            return this.txns.putIfAbsent(tx.getDbo().getName(), tx) != null;
        }

        @Override
        @Nullable
        public <T extends Tx> T getCachedTxForDBO(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            return (T)this.txns.get(dbo.getName());
        }

        @Override
        public void signalEvent(@NotNull Event event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            for (Map.Entry<TransactionObserver, SoftReference<List<Event>>> entry : this.localObservers.entrySet()) {
                TransactionObserver observer = entry.getKey();
                SoftReference<List<Event>> listRef = entry.getValue();
                List<Event> list = listRef.get();
                if (list == null || !observer.isRelevant(event)) continue;
                list.add(event);
            }
        }

        @Override
        @NotNull
        public Flow<Tuple> execute(@NotNull Operator operator) {
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            return FlowKt.cancellable((Flow)FlowKt.onCompletion((Flow)FlowKt.onStart((Flow)FlowKt.flowOn(operator.toFlow(), (CoroutineContext)((CoroutineContext)TransactionManager.this.getExecutionManager().getQueryDispatcher())), (Function2)((Function2)new Function2<FlowCollector<? super Tuple>, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ AbstractTransaction this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = AbstractTransaction.access$getMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var4_4 = (AbstractTransaction)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$AbstractTransaction$execute$1$1 = false;
                                if (!var4_4.getState().getCanExecute()) {
                                    $i$a$-check-TransactionManager$AbstractTransaction$execute$1$1$1 = false;
                                    $i$a$-check-TransactionManager$AbstractTransaction$execute$1$1$1 = "Cannot start execution of transaction " + var4_4.getTransactionId() + " because it is in the wrong state (s = " + var4_4.getState() + ").";
                                    throw new IllegalStateException($i$a$-check-TransactionManager$AbstractTransaction$execute$1$1$1.toString());
                                }
                                AbstractTransaction.access$setState$p(var4_4, TransactionStatus.RUNNING);
                                $i$f$currentCoroutineContext = false;
                                AbstractTransaction.access$getActiveContexts$p(var4_4).add(this.getContext());
                                var8_12 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull FlowCollector<? super Tuple> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (Function3)((Function3)new Function3<FlowCollector<? super Tuple>, Throwable, Continuation<? super Unit>, Object>(this, null){
                Object L$1;
                Object L$2;
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ AbstractTransaction this$0;
                {
                    this.this$0 = $receiver;
                    super(3, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            it = (Throwable)this.L$0;
                            var3_4 = AbstractTransaction.access$getMutex$p(this.this$0);
                            var5_5 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            this.L$0 = it;
                            this.L$1 = $this$withLock_u24default$iv;
                            this.L$2 = var5_5;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl27
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var5_5 = (AbstractTransaction)this.L$2;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$1;
                            it = (Throwable)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl27:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$AbstractTransaction$execute$2$1 = false;
                                $i$f$currentCoroutineContext = false;
                                AbstractTransaction.access$getActiveContexts$p(var5_5).remove(this.getContext());
                                if (it == null) {
                                    AbstractTransaction.access$setNumberOfSuccess$p(var5_5, var5_5.getNumberOfSuccess() + 1);
                                } else {
                                    AbstractTransaction.access$setNumberOfError$p(var5_5, var5_5.getNumberOfError() + 1);
                                    AbstractTransaction.access$setState$p(var5_5, TransactionStatus.ERROR);
                                }
                                if (var5_5.getState() == TransactionStatus.RUNNING && AbstractTransaction.access$getActiveContexts$p(var5_5).isEmpty()) {
                                    AbstractTransaction.access$setState$p(var5_5, TransactionStatus.IDLE);
                                }
                                var9_11 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull FlowCollector<? super Tuple> p1, @Nullable Throwable p2, @Nullable Continuation<? super Unit> p3) {
                    var var4_4 = new /* invalid duplicate definition of identical inner class */;
                    var4_4.L$0 = p2;
                    return var4_4.invokeSuspend(Unit.INSTANCE);
                }
            })));
        }

        @Override
        public void commit() {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ AbstractTransaction this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = AbstractTransaction.access$getMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var16_2) {
                                return var16_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var4_4 = (AbstractTransaction)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$AbstractTransaction$commit$1$1 = false;
                                if (!var4_4.getState().getCanCommit()) {
                                    throw new TransactionException.Commit(var4_4.getTransactionId(), "Unable to COMMIT because transaction is in wrong state (s = " + var4_4.getState() + ").");
                                }
                                AbstractTransaction.access$setState$p(var4_4, TransactionStatus.FINALIZING);
                                try {
                                    $this$filterIsInstance$iv = AbstractTransaction.access$getTxns$p(var4_4).values();
                                    $i$f$filterIsInstance = false;
                                    var9_10 = $this$filterIsInstance$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterIsInstanceTo = false;
                                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                        if (!(element$iv$iv instanceof Tx.WithCommitFinalization)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    for (Tx.WithCommitFinalization txn : (List)destination$iv$iv) {
                                        txn.beforeCommit();
                                    }
                                    if (var4_4.getXodusTx().isIdempotent()) {
                                        var4_4.getXodusTx().abort();
                                    } else if (!var4_4.getXodusTx().commit()) {
                                        throw new TransactionException.InConflict(var4_4.getTransactionId());
                                    }
                                    AbstractTransaction.access$setState$p(var4_4, TransactionStatus.COMMIT);
                                }
                                catch (Throwable e) {
                                    var4_4.getXodusTx().abort();
                                    AbstractTransaction.access$setState$p(var4_4, TransactionStatus.ROLLBACK);
                                    throw e;
                                }
                                finally {
                                    var4_4.finalizeTransaction();
                                    if (var4_4.getState() == TransactionStatus.COMMIT) {
                                        AbstractTransaction.access$notifyObservers(var4_4);
                                    }
                                }
                                var15_18 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        @Override
        public void rollback() {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ AbstractTransaction this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = AbstractTransaction.access$getMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var4_4 = (AbstractTransaction)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$AbstractTransaction$rollback$1$1 = false;
                                if (!var4_4.getState().getCanRollback()) {
                                    throw new TransactionException.Rollback(var4_4.getTransactionId(), "Unable to ROLLBACK because transaction is in wrong state (s = " + var4_4.getState() + ").");
                                }
                                AbstractTransaction.access$performRollback(var4_4);
                                var7_9 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        @Override
        public void kill() {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ AbstractTransaction this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = AbstractTransaction.access$getMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var14_2) {
                                return var14_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var4_4 = (AbstractTransaction)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$AbstractTransaction$kill$1$1 = false;
                                if (var4_4.getState() == TransactionStatus.RUNNING) {
                                    $this$forEach$iv = AbstractTransaction.access$getActiveContexts$p(var4_4);
                                    $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        it = (CoroutineContext)element$iv;
                                        $i$a$-forEach-TransactionManager$AbstractTransaction$kill$1$1$1 = false;
                                        JobKt.cancel((CoroutineContext)it, (CancellationException)new CancellationException("Transaction " + var4_4.getTransactionId() + " was killed by user."));
                                    }
                                }
                                AbstractTransaction.access$setState$p(var4_4, TransactionStatus.FINALIZING);
                                var13_14 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
lbl43:
                            // 3 sources

                            while (((Collection)AbstractTransaction.access$getActiveContexts$p(this.this$0)).isEmpty() == false) {
                                this.L$0 = null;
                                this.L$1 = null;
                                this.label = 2;
                                v1 = DelayKt.delay((long)250L, (Continuation)((Continuation)this));
                                if (v1 != var14_2) continue;
                                return var14_2;
                            }
                            break;
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl43
                        }
                    }
                    AbstractTransaction.access$performRollback(this.this$0);
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void performRollback() {
            this.state = TransactionStatus.FINALIZING;
            try {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = this.txns.values();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Tx.WithRollbackFinalization)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Tx.WithRollbackFinalization txn : (List)destination$iv$iv) {
                    txn.beforeRollback();
                }
                this.getXodusTx().abort();
                this.state = TransactionStatus.ROLLBACK;
            }
            finally {
                this.finalizeTransaction();
            }
        }

        protected void finalizeTransaction() {
            this.txns.clear();
            this.ended = System.currentTimeMillis();
            TransactionManager.this.transactions.remove(this.transactionId);
            TransactionManager.this.transactionHistory.add(new FinishedTransaction(this));
            if (TransactionManager.this.transactionHistory.size() > TransactionManager.this.getConfig().getExecution().getTransactionHistorySize()) {
                TransactionManager.this.transactionHistory.remove(0);
            }
        }

        private final void notifyObservers() {
            for (Map.Entry<TransactionObserver, SoftReference<List<Event>>> entry : this.localObservers.entrySet()) {
                TransactionObserver observer = entry.getKey();
                SoftReference<List<Event>> listRef = entry.getValue();
                List<Event> list = listRef.get();
                if (list != null) {
                    observer.onCommit(this.transactionId, list);
                    continue;
                }
                observer.onDeliveryFailure(this.transactionId);
            }
            this.localObservers.clear();
        }

        public static final /* synthetic */ Mutex access$getMutex$p(AbstractTransaction $this) {
            return $this.mutex;
        }

        public static final /* synthetic */ void access$setState$p(AbstractTransaction $this, TransactionStatus transactionStatus) {
            $this.state = transactionStatus;
        }

        public static final /* synthetic */ HashSet access$getActiveContexts$p(AbstractTransaction $this) {
            return $this.activeContexts;
        }

        public static final /* synthetic */ void access$setNumberOfSuccess$p(AbstractTransaction $this, int n) {
            $this.numberOfSuccess = n;
        }

        public static final /* synthetic */ void access$setNumberOfError$p(AbstractTransaction $this, int n) {
            $this.numberOfError = n;
        }

        public static final /* synthetic */ Map access$getTxns$p(AbstractTransaction $this) {
            return $this.txns;
        }

        public static final /* synthetic */ void access$notifyObservers(AbstractTransaction $this) {
            $this.notifyObservers();
        }

        public static final /* synthetic */ void access$performRollback(AbstractTransaction $this) {
            $this.performRollback();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$ExclusiveTransaction;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$AbstractTransaction;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "type", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "(Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;)V", "stamp", "", "xodusTx", "Ljetbrains/exodus/env/Transaction;", "Lorg/jetbrains/annotations/NotNull;", "getXodusTx", "()Ljetbrains/exodus/env/Transaction;", "finalizeTransaction", "", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionManager.kt\norg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$ExclusiveTransaction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,469:1\n1#2:470\n*E\n"})
    private final class ExclusiveTransaction
    extends AbstractTransaction {
        private final long stamp;
        @NotNull
        private final jetbrains.exodus.env.Transaction xodusTx;

        public ExclusiveTransaction(TransactionType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            super(type);
            if (!type.getExclusive()) {
                boolean bl = false;
                String string = "Unsupported transaction type " + type + " for read-only transaction.";
                throw new IllegalArgumentException(string.toString());
            }
            this.stamp = TransactionManager.this.exclusiveLock.tryWriteLock(TransactionManager.this.getConfig().getExecution().getTransactionTimeoutMs(), TimeUnit.MILLISECONDS);
            if (this.stamp == -1L) {
                throw new TransactionException.Timeout(this.getTransactionId());
            }
            jetbrains.exodus.env.Transaction transaction = TransactionManager.this.getEnvironment$cottontaildb_dbms().beginExclusiveTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"beginExclusiveTransaction(...)");
            this.xodusTx = transaction;
        }

        @Override
        @NotNull
        public jetbrains.exodus.env.Transaction getXodusTx() {
            return this.xodusTx;
        }

        @Override
        protected void finalizeTransaction() {
            TransactionManager.this.exclusiveLock.unlock(this.stamp);
            super.finalizeTransaction();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$ReadonlyTransaction;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$AbstractTransaction;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "type", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "(Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;)V", "xodusTx", "Ljetbrains/exodus/env/Transaction;", "Lorg/jetbrains/annotations/NotNull;", "getXodusTx", "()Ljetbrains/exodus/env/Transaction;", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionManager.kt\norg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$ReadonlyTransaction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,469:1\n1#2:470\n*E\n"})
    private final class ReadonlyTransaction
    extends AbstractTransaction {
        @NotNull
        private final jetbrains.exodus.env.Transaction xodusTx;

        public ReadonlyTransaction(TransactionType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            super(type);
            if (!type.getReadonly()) {
                boolean bl = false;
                String string = "Unsupported transaction type " + type + " for read-only transaction.";
                throw new IllegalArgumentException(string.toString());
            }
            jetbrains.exodus.env.Transaction transaction = TransactionManager.this.getEnvironment$cottontaildb_dbms().beginReadonlyTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"beginReadonlyTransaction(...)");
            this.xodusTx = transaction;
        }

        @Override
        @NotNull
        public jetbrains.exodus.env.Transaction getXodusTx() {
            return this.xodusTx;
        }
    }
}

