/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.basic.rebuilder;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.execution.transactions.Transaction;
import org.vitrivr.cottontail.dbms.index.basic.Index;
import org.vitrivr.cottontail.dbms.index.basic.IndexMetadata;
import org.vitrivr.cottontail.dbms.index.basic.IndexState;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.IndexRebuilder;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u0017*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0017B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH$J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0004J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AbstractIndexRebuilder;", "T", "Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/IndexRebuilder;", "index", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/index/basic/Index;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "getContext", "()Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "getIndex", "()Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "rebuild", "", "rebuildInternal", "tryClearAndOpenStore", "Ljetbrains/exodus/env/Store;", "updateState", "state", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexState;", "tx", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "Companion", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nAbstractIndexRebuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractIndexRebuilder.kt\norg/vitrivr/cottontail/dbms/index/basic/rebuilder/AbstractIndexRebuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public abstract class AbstractIndexRebuilder<T extends Index>
implements IndexRebuilder<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T index;
    @NotNull
    private final QueryContext context;
    @NotNull
    private static final Logger LOGGER;

    public AbstractIndexRebuilder(@NotNull T index, @NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter(index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.index = index;
        this.context = context2;
    }

    @Override
    @NotNull
    public final T getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public final QueryContext getContext() {
        return this.context;
    }

    @Override
    public synchronized boolean rebuild() {
        if (!this.context.getTxn().getXodusTx().isExclusive()) {
            boolean bl = false;
            String string = "Failed to rebuild index " + this.index.getName() + " (" + this.index.getType() + "); rebuild operation requires exclusive transaction.";
            throw new IllegalArgumentException(string.toString());
        }
        LOGGER.debug("Rebuilding index {} ({}).", (Object)this.index.getName(), (Object)this.index.getType());
        if (!this.updateState(IndexState.DIRTY, this.context.getTxn())) {
            LOGGER.error("Rebuilding index " + this.index.getName() + " (" + this.index.getType() + ") failed because index state could not be changed to CLEAN!");
            return false;
        }
        if (!this.rebuildInternal()) {
            LOGGER.error("Rebuilding index " + this.index.getName() + " (" + this.index.getType() + ") failed!");
            return false;
        }
        if (!this.updateState(IndexState.CLEAN, this.context.getTxn())) {
            LOGGER.error("Rebuilding index " + this.index.getName() + " (" + this.index.getType() + ") failed because index state could not be changed to CLEAN!");
            return false;
        }
        LOGGER.debug("Rebuilding index {} ({}) completed!", (Object)this.index.getName(), (Object)this.index.getType());
        return true;
    }

    protected abstract boolean rebuildInternal();

    @Nullable
    protected final Store tryClearAndOpenStore() {
        String storeName = ExtensionsKt.storeName(this.index.getName());
        if (this.index.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().storeExists(storeName, this.context.getTxn().getXodusTx())) {
            this.index.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().truncateStore(storeName, this.context.getTxn().getXodusTx());
            return this.index.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(storeName, StoreConfig.USE_EXISTING, this.context.getTxn().getXodusTx(), false);
        }
        return null;
    }

    private final boolean updateState(IndexState state, Transaction tx) {
        ByteIterable name = NameBinding.Index.INSTANCE.toEntry(this.index.getName());
        Catalogue catalogue = this.index.getCatalogue();
        Intrinsics.checkNotNull((Object)catalogue, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue");
        Store store = IndexMetadata.Companion.store$cottontaildb_dbms((DefaultCatalogue)catalogue, tx.getXodusTx());
        ByteIterable byteIterable = store.get(tx.getXodusTx(), name);
        if (byteIterable == null) {
            throw new DatabaseException.DataCorruptionException("Failed to rebuild index transaction for index " + this.index.getName() + ": Could not read catalogue entry for index.");
        }
        ByteIterable oldEntryRaw = byteIterable;
        IndexMetadata oldEntry = IndexMetadata.Companion.fromEntry(oldEntryRaw);
        if (oldEntry.getState() != state) {
            return store.put(tx.getXodusTx(), name, IndexMetadata.Companion.toEntry(IndexMetadata.copy$default(oldEntry, null, state, null, null, 13, null)));
        }
        return true;
    }

    static {
        Logger logger = LoggerFactory.getLogger(AbstractIndexRebuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AbstractIndexRebuilder$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER$cottontaildb_dbms", "()Lorg/slf4j/Logger;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER$cottontaildb_dbms() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

