/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.hash;

import java.util.LinkedList;
import java.util.List;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.queries.predicates.ComparisonOperator;
import org.vitrivr.cottontail.core.tuple.StandaloneTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.dbms.index.hash.BTreeIndex;
import org.vitrivr.cottontail.storage.serializers.values.ValueSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0006\u0018\u0019\u001a\u001b\u001c\u001dB\u0013\b\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0006\u001e\u001f !\"#\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor;", "T", "Lorg/vitrivr/cottontail/core/queries/predicates/ComparisonOperator;", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "index", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "(Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;)V", "cursor", "Ljetbrains/exodus/env/Cursor;", "getCursor", "()Ljetbrains/exodus/env/Cursor;", "getIndex", "()Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;", "subTransaction", "Ljetbrains/exodus/env/Transaction;", "kotlin.jvm.PlatformType", "close", "", "key", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "value", "Equals", "Greater", "GreaterEqual", "In", "Less", "LessEqual", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor$Equals;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor$Greater;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor$GreaterEqual;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor$In;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor$Less;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor$LessEqual;", "cottontaildb-dbms"})
public abstract class BTreeIndexCursor<T extends ComparisonOperator>
implements org.vitrivr.cottontail.core.basics.Cursor<Tuple> {
    @NotNull
    private final BTreeIndex.Tx index;
    private final Transaction subTransaction;
    @NotNull
    private final Cursor cursor;

    private BTreeIndexCursor(BTreeIndex.Tx index) {
        this.index = index;
        this.subTransaction = this.index.getContext().getTxn().getXodusTx().getReadonlySnapshot();
        Cursor cursor = this.index.getDataStore$cottontaildb_dbms().openCursor(this.subTransaction);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"openCursor(...)");
        this.cursor = cursor;
    }

    @NotNull
    public final BTreeIndex.Tx getIndex() {
        return this.index;
    }

    @NotNull
    protected final Cursor getCursor() {
        return this.cursor;
    }

    public long key() {
        return LongBinding.compressedEntryToLong((ByteIterable)this.cursor.getValue());
    }

    @NotNull
    public Tuple value() {
        long l = this.key();
        ColumnDef<?>[] columnDefArray = this.index.getColumns();
        Value[] valueArray = new Value[1];
        ValueSerializer<Value> valueSerializer = this.index.getBinding$cottontaildb_dbms();
        ByteIterable byteIterable = this.cursor.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getKey(...)");
        valueArray[0] = valueSerializer.fromEntry(byteIterable);
        return (Tuple)new StandaloneTuple(l, columnDefArray, valueArray);
    }

    public void close() {
        this.cursor.close();
        this.subTransaction.abort();
    }

    public boolean hasNext() {
        return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public boolean movePrevious() {
        return Cursor.DefaultImpls.movePrevious((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public boolean moveTo(long tupleId) {
        return Cursor.DefaultImpls.moveTo((org.vitrivr.cottontail.core.basics.Cursor)this, (long)tupleId);
    }

    @NotNull
    public Tuple next() {
        return (Tuple)Cursor.DefaultImpls.next((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public /* synthetic */ BTreeIndexCursor(BTreeIndex.Tx index, DefaultConstructorMarker $constructor_marker) {
        this(index);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor$Equals;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor;", "Lorg/vitrivr/cottontail/core/queries/predicates/ComparisonOperator$Equal;", "value", "Lorg/vitrivr/cottontail/core/types/Value;", "index", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "(Lorg/vitrivr/cottontail/core/types/Value;Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;)V", "moveNext", "", "cottontaildb-dbms"})
    public static final class Equals
    extends BTreeIndexCursor<ComparisonOperator.Equal> {
        @NotNull
        private final Value value;

        public Equals(@NotNull Value value, @NotNull BTreeIndex.Tx index) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(index, null);
            this.value = value;
        }

        public boolean moveNext() {
            boolean bl;
            try {
                bl = this.getCursor().getNextDup();
            }
            catch (IllegalStateException e) {
                bl = this.getCursor().getSearchKey(this.getIndex().getBinding$cottontaildb_dbms().toEntry(this.value)) != null;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor$Greater;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor;", "Lorg/vitrivr/cottontail/core/queries/predicates/ComparisonOperator$Greater;", "value", "Lorg/vitrivr/cottontail/core/types/Value;", "index", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "(Lorg/vitrivr/cottontail/core/types/Value;Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;)V", "moveNext", "", "cottontaildb-dbms"})
    public static final class Greater
    extends BTreeIndexCursor<ComparisonOperator.Greater> {
        @NotNull
        private final Value value;

        public Greater(@NotNull Value value, @NotNull BTreeIndex.Tx index) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(index, null);
            this.value = value;
            ByteIterable entry = this.getIndex().getBinding$cottontaildb_dbms().toEntry(this.value);
            if (this.getCursor().getSearchKeyRange(entry) != null) {
                while (Intrinsics.areEqual((Object)this.getCursor().getKey(), (Object)entry)) {
                    if (this.getCursor().getNext()) continue;
                    break;
                }
            }
        }

        public boolean moveNext() {
            return this.getCursor().getNext();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor$GreaterEqual;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor;", "Lorg/vitrivr/cottontail/core/queries/predicates/ComparisonOperator$GreaterEqual;", "value", "Lorg/vitrivr/cottontail/core/types/Value;", "index", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "(Lorg/vitrivr/cottontail/core/types/Value;Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;)V", "moveNext", "", "cottontaildb-dbms"})
    public static final class GreaterEqual
    extends BTreeIndexCursor<ComparisonOperator.GreaterEqual> {
        @NotNull
        private final Value value;

        public GreaterEqual(@NotNull Value value, @NotNull BTreeIndex.Tx index) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(index, null);
            this.value = value;
            this.getCursor().getSearchKeyRange(this.getIndex().getBinding$cottontaildb_dbms().toEntry(this.value));
        }

        public boolean moveNext() {
            return this.getCursor().getNext();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor$In;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor;", "Lorg/vitrivr/cottontail/core/queries/predicates/ComparisonOperator$In;", "values", "", "Lorg/vitrivr/cottontail/core/types/Value;", "index", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "(Ljava/util/List;Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;)V", "Ljava/util/LinkedList;", "Ljetbrains/exodus/ByteIterable;", "moveNext", "", "cottontaildb-dbms"})
    public static final class In
    extends BTreeIndexCursor<ComparisonOperator.In> {
        @NotNull
        private final LinkedList<ByteIterable> values;

        public In(@NotNull List<? extends Value> values, @NotNull BTreeIndex.Tx index) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(index, null);
            this.values = new LinkedList();
            for (Value value : values) {
                if (value == null) continue;
                this.values.add(this.getIndex().getBinding$cottontaildb_dbms().toEntry(value));
            }
            CollectionsKt.sort((List)this.values);
        }

        public boolean moveNext() {
            try {
                if (this.getCursor().getNextDup()) {
                    return true;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            while (this.values.size() > 0) {
                if (this.getCursor().getSearchKey(this.values.poll()) == null) continue;
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor$Less;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor;", "Lorg/vitrivr/cottontail/core/queries/predicates/ComparisonOperator$Less;", "value", "Lorg/vitrivr/cottontail/core/types/Value;", "index", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "(Lorg/vitrivr/cottontail/core/types/Value;Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;)V", "moveNext", "", "cottontaildb-dbms"})
    public static final class Less
    extends BTreeIndexCursor<ComparisonOperator.Less> {
        @NotNull
        private final Value value;

        public Less(@NotNull Value value, @NotNull BTreeIndex.Tx index) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(index, null);
            this.value = value;
            ByteIterable entry = this.getIndex().getBinding$cottontaildb_dbms().toEntry(this.value);
            if (this.getCursor().getSearchKeyRange(entry) != null) {
                while (Intrinsics.areEqual((Object)this.getCursor().getKey(), (Object)entry)) {
                    if (this.getCursor().getPrev()) continue;
                    break;
                }
            }
        }

        public boolean moveNext() {
            return this.getCursor().getPrev();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor$LessEqual;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor;", "Lorg/vitrivr/cottontail/core/queries/predicates/ComparisonOperator$LessEqual;", "value", "Lorg/vitrivr/cottontail/core/types/Value;", "index", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "(Lorg/vitrivr/cottontail/core/types/Value;Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;)V", "moveNext", "", "cottontaildb-dbms"})
    public static final class LessEqual
    extends BTreeIndexCursor<ComparisonOperator.LessEqual> {
        @NotNull
        private final Value value;

        public LessEqual(@NotNull Value value, @NotNull BTreeIndex.Tx index) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(index, null);
            this.value = value;
            this.getCursor().getSearchKeyRange(this.getIndex().getBinding$cottontaildb_dbms().toEntry(this.value));
        }

        public boolean moveNext() {
            return this.getCursor().getPrev();
        }
    }
}

