/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.hash;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Store;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.index.basic.Index;
import org.vitrivr.cottontail.dbms.index.basic.IndexMetadata;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.AbstractIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.hash.BTreeIndex;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;
import org.vitrivr.cottontail.storage.serializers.SerializerFactory;
import org.vitrivr.cottontail.storage.serializers.values.ValueSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexRebuilder;", "Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AbstractIndexRebuilder;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "index", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "rebuildInternal", "", "cottontaildb-dbms"})
public final class BTreeIndexRebuilder
extends AbstractIndexRebuilder<BTreeIndex> {
    public BTreeIndexRebuilder(@NotNull BTreeIndex index, @NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((Index)index, context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean rebuildInternal() {
        Store indexMetadataStore = IndexMetadata.Companion.store$cottontaildb_dbms(((BTreeIndex)this.getIndex()).getCatalogue(), this.getContext().getTxn().getXodusTx());
        ByteIterable byteIterable = indexMetadataStore.get(this.getContext().getTxn().getXodusTx(), NameBinding.Index.INSTANCE.toEntry(((BTreeIndex)this.getIndex()).getName()));
        if (byteIterable == null) {
            throw new DatabaseException.DataCorruptionException("Failed to rebuild index " + ((BTreeIndex)this.getIndex()).getName() + ": Could not read catalogue entry for index.");
        }
        ByteIterable indexEntryRaw = byteIterable;
        IndexMetadata indexEntry = IndexMetadata.Companion.fromEntry(indexEntryRaw);
        Name.ColumnName column = ((BTreeIndex)this.getIndex()).getName().entity().column(indexEntry.getColumns().get(0));
        EntityTx entityTx = ((BTreeIndex)this.getIndex()).getParent().newTx(this.getContext());
        ColumnTx<?> columnTx = entityTx.columnForName(column).newTx(this.getContext());
        ValueSerializer<Value> valueSerializer = SerializerFactory.INSTANCE.value(columnTx.getColumnDef().getType());
        Intrinsics.checkNotNull(valueSerializer, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.storage.serializers.values.ValueSerializer<org.vitrivr.cottontail.core.types.Value>");
        ValueSerializer<Value> binding = valueSerializer;
        Store store = this.tryClearAndOpenStore();
        if (store == null) {
            return false;
        }
        Store dataStore = store;
        AutoCloseable autoCloseable = (AutoCloseable)columnTx.cursor();
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)autoCloseable;
            boolean bl = false;
            while (cursor.moveNext()) {
                Value value = (Value)cursor.value();
                if (value == null) continue;
                ByteIterable keyRaw = binding.toEntry(value);
                ArrayByteIterable tupleIdRaw = LongBinding.longToCompressedEntry((long)cursor.key());
                if (dataStore.put(this.getContext().getTxn().getXodusTx(), keyRaw, (ByteIterable)tupleIdRaw)) continue;
                boolean bl2 = false;
                return bl2;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return true;
    }
}

