/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.lsh;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Store;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.index.basic.Index;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.basic.IndexMetadata;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.AbstractIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.lsh.LSHDataStore;
import org.vitrivr.cottontail.dbms.index.lsh.LSHIndex;
import org.vitrivr.cottontail.dbms.index.lsh.LSHIndexConfig;
import org.vitrivr.cottontail.dbms.index.lsh.signature.LSHSignatureGenerator;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndexRebuilder;", "Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AbstractIndexRebuilder;", "Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex;", "index", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "rebuildInternal", "", "cottontaildb-dbms"})
public final class LSHIndexRebuilder
extends AbstractIndexRebuilder<LSHIndex> {
    public LSHIndexRebuilder(@NotNull LSHIndex index, @NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((Index)index, context2);
    }

    @Override
    protected boolean rebuildInternal() {
        Store indexMetadataStore = IndexMetadata.Companion.store$cottontaildb_dbms(((LSHIndex)this.getIndex()).getCatalogue(), this.getContext().getTxn().getXodusTx());
        ByteIterable byteIterable = indexMetadataStore.get(this.getContext().getTxn().getXodusTx(), NameBinding.Index.INSTANCE.toEntry(((LSHIndex)this.getIndex()).getName()));
        if (byteIterable == null) {
            throw new DatabaseException.DataCorruptionException("Failed to rebuild index " + ((LSHIndex)this.getIndex()).getName() + ": Could not read catalogue entry for index.");
        }
        ByteIterable indexEntryRaw = byteIterable;
        IndexMetadata indexEntry = IndexMetadata.Companion.fromEntry(indexEntryRaw);
        IndexConfig<?> indexConfig = indexEntry.getConfig();
        Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.lsh.LSHIndexConfig");
        LSHIndexConfig config = (LSHIndexConfig)indexConfig;
        Name.ColumnName column = ((LSHIndex)this.getIndex()).getName().entity().column(indexEntry.getColumns().get(0));
        EntityTx entityTx = ((LSHIndex)this.getIndex()).getParent().newTx(this.getContext());
        ColumnTx<?> columnTx = entityTx.columnForName(column).newTx(this.getContext());
        Store store = this.tryClearAndOpenStore();
        if (store == null) {
            return false;
        }
        Store dataStore = store;
        LSHSignatureGenerator generator = config.generator(columnTx.getColumnDef().getType().getLogicalSize());
        Cursor<?> cursor = columnTx.cursor();
        Store wrappedStore = LSHDataStore.constructor-impl(dataStore);
        while (cursor.moveNext()) {
            long tupleId = cursor.key();
            Value value = (Value)cursor.next();
            if (!(value instanceof VectorValue)) continue;
            LSHDataStore.addMapping-VIKXU4c(wrappedStore, this.getContext().getTxn().getXodusTx(), generator.generate-dna7En8((VectorValue)value), tupleId);
        }
        cursor.close();
        return true;
    }
}

