/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.lucene;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.bindings.ComparableBinding;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.SimilarityBase;
import org.apache.lucene.store.Directory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.binding.Binding;
import org.vitrivr.cottontail.core.queries.binding.BindingContext;
import org.vitrivr.cottontail.core.queries.binding.MissingTuple;
import org.vitrivr.cottontail.core.queries.nodes.traits.NotPartitionableTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.Trait;
import org.vitrivr.cottontail.core.queries.nodes.traits.TraitType;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.BooleanPredicate;
import org.vitrivr.cottontail.core.queries.predicates.ComparisonOperator;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.tuple.StandaloneTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.StringValue;
import org.vitrivr.cottontail.core.values.pattern.LikePatternValue;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.events.DataEvent;
import org.vitrivr.cottontail.dbms.exceptions.QueryException;
import org.vitrivr.cottontail.dbms.execution.transactions.Transaction;
import org.vitrivr.cottontail.dbms.general.Tx;
import org.vitrivr.cottontail.dbms.index.basic.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.basic.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.basic.IndexTx;
import org.vitrivr.cottontail.dbms.index.basic.IndexType;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.AbstractIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.AsyncIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.lucene.LuceneAnalyzerType;
import org.vitrivr.cottontail.dbms.index.lucene.LuceneIndexConfig;
import org.vitrivr.cottontail.dbms.index.lucene.LuceneIndexDataStore;
import org.vitrivr.cottontail.dbms.index.lucene.LuceneIndexRebuilder;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;
import org.vitrivr.cottontail.storage.lucene.XodusDirectory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndex;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "type", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "newAsyncRebuilder", "Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AsyncIndexRebuilder;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "newRebuilder", "Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AbstractIndexRebuilder;", "newTx", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexTx;", "Companion", "Tx", "cottontaildb-dbms"})
public final class LuceneIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexType type;
    @NotNull
    private static final Logger LOGGER;
    private static final boolean supportsIncrementalUpdate;
    private static final boolean supportsAsyncRebuild;
    private static final boolean supportsPartitioning;
    @NotNull
    public static final String TID_COLUMN = "_tid";

    public LuceneIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(name, parent);
        this.type = IndexType.LUCENE;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IndexTx indexTx = (IndexTx)context2.getTxn().getCachedTxForDBO(this);
        if (indexTx == null) {
            indexTx = new Tx(context2);
        }
        return indexTx;
    }

    @NotNull
    public AbstractIndexRebuilder<?> newRebuilder(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new LuceneIndexRebuilder(this, context2);
    }

    @NotNull
    public AsyncIndexRebuilder<LuceneIndex> newAsyncRebuilder(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        throw new UnsupportedOperationException("LuceneIndex does not support asynchronous index rebuilding.");
    }

    static {
        Logger logger = LoggerFactory.getLogger(LuceneIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        supportsIncrementalUpdate = true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndex$Companion;", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexDescriptor;", "Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndex;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "TID_COLUMN", "", "supportsAsyncRebuild", "", "getSupportsAsyncRebuild", "()Z", "supportsIncrementalUpdate", "getSupportsIncrementalUpdate", "supportsPartitioning", "getSupportsPartitioning", "buildConfig", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;", "parameters", "", "configBinding", "Ljetbrains/exodus/bindings/ComparableBinding;", "deinitialize", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "initialize", "open", "entity", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "cottontaildb-dbms"})
    public static final class Companion
    implements IndexDescriptor<LuceneIndex> {
        private Companion() {
        }

        @Override
        public boolean getSupportsIncrementalUpdate() {
            return supportsIncrementalUpdate;
        }

        @Override
        public boolean getSupportsAsyncRebuild() {
            return supportsAsyncRebuild;
        }

        @Override
        public boolean getSupportsPartitioning() {
            return supportsPartitioning;
        }

        @Override
        @NotNull
        public LuceneIndex open(@NotNull Name.IndexName name, @NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new LuceneIndex(name, (DefaultEntity)entity);
        }

        @Override
        public boolean initialize(@NotNull Name.IndexName name, @NotNull Catalogue catalogue, @NotNull Transaction context2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                XodusDirectory directory = new XodusDirectory(catalogue.getTransactionManager().getVfs$cottontaildb_dbms(), name.toString(), context2.getXodusTx(), null, 8, null);
                IndexWriterConfig config = new IndexWriterConfig().setOpenMode(IndexWriterConfig.OpenMode.CREATE).setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                IndexWriter writer = new IndexWriter((Directory)directory, config);
                writer.close();
                directory.close();
                bl = true;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to initialize Lucene Index " + name + " due to an exception: " + e.getMessage() + ".");
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean deinitialize(@NotNull Name.IndexName name, @NotNull Catalogue catalogue, @NotNull Transaction context2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                XodusDirectory directory = new XodusDirectory(catalogue.getTransactionManager().getVfs$cottontaildb_dbms(), name.toString(), context2.getXodusTx(), null, 8, null);
                for (String file : directory.listAll()) {
                    directory.deleteFile(file);
                }
                directory.close();
                bl = true;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to de-initialize Lucene Index " + name + " due to an exception: " + e.getMessage() + ".");
                bl = false;
            }
            return bl;
        }

        @Override
        @NotNull
        public IndexConfig<LuceneIndex> buildConfig(@NotNull Map<String, String> parameters) {
            LuceneAnalyzerType luceneAnalyzerType;
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            try {
                String string = parameters.get("analyzer_type");
                if (string == null) {
                    string = "";
                }
                luceneAnalyzerType = LuceneAnalyzerType.valueOf(string);
            }
            catch (IllegalArgumentException e) {
                luceneAnalyzerType = LuceneAnalyzerType.STANDARD;
            }
            LuceneAnalyzerType luceneAnalyzerType2 = luceneAnalyzerType;
            return new LuceneIndexConfig(luceneAnalyzerType2);
        }

        @Override
        @NotNull
        public ComparableBinding configBinding() {
            return LuceneIndexConfig.Binding.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\u0004\u0012\u00020\"0 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020&H\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020'H\u0016J\f\u0010(\u001a\u00020)*\u00020*H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006+"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "Lorg/vitrivr/cottontail/dbms/general/Tx$WithCommitFinalization;", "Lorg/vitrivr/cottontail/dbms/general/Tx$WithRollbackFinalization;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndex;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "store", "Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndexDataStore;", "beforeCommit", "", "beforeRollback", "canProcess", "", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "columnsFor", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "costFor", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "costFor-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "count", "", "filter", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "partition", "Lkotlin/ranges/LongRange;", "traitsFor", "", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/TraitType;", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/Trait;", "tryApply", "event", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Delete;", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Insert;", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Update;", "toLuceneQuery", "Lorg/apache/lucene/search/Query;", "Lorg/vitrivr/cottontail/core/queries/predicates/BooleanPredicate;", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nLuceneIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneIndex.kt\norg/vitrivr/cottontail/dbms/index/lucene/LuceneIndex$Tx\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,430:1\n1726#2,3:431\n1726#2,3:434\n1#3:437\n*S KotlinDebug\n*F\n+ 1 LuceneIndex.kt\norg/vitrivr/cottontail/dbms/index/lucene/LuceneIndex$Tx\n*L\n256#1:431,3\n257#1:434,3\n*E\n"})
    public final class Tx
    extends AbstractIndex.Tx
    implements Tx.WithCommitFinalization,
    Tx.WithRollbackFinalization {
        @NotNull
        private final LuceneIndexDataStore store;

        public Tx(QueryContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.store = new LuceneIndexDataStore(new XodusDirectory(LuceneIndex.this.getCatalogue().getTransactionManager().getVfs$cottontaildb_dbms(), LuceneIndex.this.getName().toString(), this.getContext().getTxn().getXodusTx(), null, 8, null), this.getColumns()[0].getName());
        }

        private final Query toLuceneQuery(BooleanPredicate $this$toLuceneQuery) {
            BooleanQuery.Builder builder;
            BooleanPredicate booleanPredicate = $this$toLuceneQuery;
            if (booleanPredicate instanceof BooleanPredicate.Comparison) {
                Query query2;
                Value value;
                ColumnDef columnDef2;
                ComparisonOperator op = ((BooleanPredicate.Comparison)$this$toLuceneQuery).getOperator();
                MissingTuple $this$toLuceneQuery_u24lambda_u241 = MissingTuple.INSTANCE;
                boolean bl = false;
                BindingContext $this$toLuceneQuery_u24lambda_u241_u24lambda_u240 = this.getContext().getBindings();
                boolean bl2 = false;
                Binding left = op.getLeft();
                Binding right = op.getRight();
                if (right instanceof Binding.Column && Intrinsics.areEqual((Object)((Binding.Column)right).getPhysical(), this.getColumns()[0])) {
                    columnDef2 = ((Binding.Column)right).getColumn();
                } else if (left instanceof Binding.Column && Intrinsics.areEqual((Object)((Binding.Column)left).getPhysical(), this.getColumns()[0])) {
                    columnDef2 = ((Binding.Column)left).getColumn();
                } else {
                    throw new QueryException("Conversion to Lucene query failed: One side of the comparison operator must be a column value!");
                }
                ColumnDef column = columnDef2;
                if (right instanceof Binding.Literal) {
                    value = right.getValue($this$toLuceneQuery_u24lambda_u241_u24lambda_u240, (Tuple)$this$toLuceneQuery_u24lambda_u241);
                    if (value == null) {
                        throw new QueryException("Conversion to Lucene query failed: Literal value cannot be null!");
                    }
                } else if (left instanceof Binding.Literal) {
                    value = right.getValue($this$toLuceneQuery_u24lambda_u241_u24lambda_u240, (Tuple)$this$toLuceneQuery_u24lambda_u241);
                    if (value == null) {
                        throw new QueryException("Conversion to Lucene query failed: Literal value cannot be null!");
                    }
                } else {
                    throw new QueryException("Conversion to Lucene query failed: One side of the comparison operator must be a literal value!");
                }
                Value literal = value;
                ComparisonOperator comparisonOperator = op;
                if (comparisonOperator instanceof ComparisonOperator.Equal) {
                    if (!(literal instanceof StringValue)) {
                        throw new QueryException("Conversion to Lucene query failed: EQUAL queries strictly require a StringValue as second operand!");
                    }
                    query2 = (Query)new TermQuery(new Term(column.getName().getColumn() + "_str", ((StringValue)literal).unbox-impl()));
                } else if (comparisonOperator instanceof ComparisonOperator.Like) {
                    Query query3;
                    String[] stringArray;
                    Value value2 = literal;
                    if (value2 instanceof StringValue) {
                        stringArray = new String[]{((StringValue)literal).unbox-impl()};
                        String[] stringArray2 = stringArray;
                        stringArray = new String[]{column.getName().getColumn() + "_txt"};
                        query3 = QueryParserUtil.parse((String[])stringArray2, (String[])stringArray, (Analyzer)((Analyzer)new StandardAnalyzer()));
                    } else if (value2 instanceof LikePatternValue) {
                        stringArray = new String[]{((LikePatternValue)literal).toLucene().getValue()};
                        String[] stringArray3 = stringArray;
                        stringArray = new String[]{column.getName().getColumn() + "_txt"};
                        query3 = QueryParserUtil.parse((String[])stringArray3, (String[])stringArray, (Analyzer)((Analyzer)new StandardAnalyzer()));
                    } else {
                        throw new QueryException("Conversion to Lucene query failed: LIKE queries require a StringValue OR LikePatternValue as second operand!");
                    }
                    Query query4 = query3;
                    Intrinsics.checkNotNull((Object)query4);
                    query2 = query4;
                } else if (comparisonOperator instanceof ComparisonOperator.Match) {
                    if (!(literal instanceof StringValue)) {
                        throw new QueryException("Conversion to Lucene query failed: MATCH queries strictly require a StringValue as second operand!");
                    }
                    String[] stringArray = new String[]{((StringValue)literal).unbox-impl()};
                    String[] stringArray4 = stringArray;
                    stringArray = new String[]{column.getName().getColumn() + "_txt"};
                    Query query5 = QueryParserUtil.parse((String[])stringArray4, (String[])stringArray, (Analyzer)((Analyzer)new StandardAnalyzer()));
                    Intrinsics.checkNotNull((Object)query5);
                    query2 = query5;
                } else {
                    throw new QueryException("Lucene Query Conversion failed: Only EQUAL, MATCH and LIKE queries can be mapped to a Apache Lucene!");
                }
                return query2;
            }
            if (booleanPredicate instanceof BooleanPredicate.And) {
                builder = new BooleanQuery.Builder().add(this.toLuceneQuery(((BooleanPredicate.And)$this$toLuceneQuery).getP1()), BooleanClause.Occur.MUST).add(this.toLuceneQuery(((BooleanPredicate.And)$this$toLuceneQuery).getP2()), BooleanClause.Occur.MUST);
            } else if (booleanPredicate instanceof BooleanPredicate.Or) {
                builder = new BooleanQuery.Builder().add(this.toLuceneQuery(((BooleanPredicate.Or)$this$toLuceneQuery).getP1()), BooleanClause.Occur.SHOULD).add(this.toLuceneQuery(((BooleanPredicate.Or)$this$toLuceneQuery).getP2()), BooleanClause.Occur.SHOULD);
            } else {
                throw new IllegalArgumentException("LuceneIndex can only process AND and OR predicates.");
            }
            BooleanQuery booleanQuery = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)booleanQuery, (String)"build(...)");
            return (Query)booleanQuery;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canProcess(@NotNull Predicate predicate) {
            boolean bl;
            Binding.Column it;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof BooleanPredicate)) return false;
            Iterable $this$all$iv = predicate.getColumns();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (Binding.Column)element$iv;
                    boolean bl3 = false;
                    if (ArraysKt.contains((Object[])this.getColumns(), (Object)it.getPhysical())) continue;
                    return false;
                }
                bl2 = true;
            }
            if (!bl2) return false;
            $this$all$iv = ((BooleanPredicate)predicate).getAtomics();
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                Object element$iv;
                if (!iterator2.hasNext()) return true;
                element$iv = iterator2.next();
                it = (BooleanPredicate)element$iv;
                boolean bl4 = false;
                if (!(it instanceof BooleanPredicate.Comparison)) return false;
                if (!(((BooleanPredicate.Comparison)it).getOperator() instanceof ComparisonOperator.Like) && !(((BooleanPredicate.Comparison)it).getOperator() instanceof ComparisonOperator.Equal)) {
                    if (!(((BooleanPredicate.Comparison)it).getOperator() instanceof ComparisonOperator.Match)) return false;
                }
                bl = true;
            } while (bl);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<ColumnDef<?>> columnsFor(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            LuceneIndex luceneIndex = LuceneIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                if (!(predicate instanceof BooleanPredicate)) {
                    boolean bl2 = false;
                    String string = "Lucene can only process boolean predicates.";
                    throw new IllegalArgumentException(string.toString());
                }
                List list = CollectionsKt.listOf((Object)new ColumnDef(luceneIndex.getParent().getName().column("score"), (Types)Types.Double.INSTANCE, false, false, false, 28, null));
                return list;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Map<TraitType<?>, Trait> traitsFor(@NotNull Predicate predicate) {
            Map map2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                if (!(predicate instanceof BooleanPredicate)) {
                    boolean bl2 = false;
                    String string = "Lucene Index can only process Boolean predicates.";
                    throw new IllegalArgumentException(string.toString());
                }
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)NotPartitionableTrait.INSTANCE, (Object)NotPartitionableTrait.INSTANCE));
            }
            finally {
                lock2.unlock();
            }
            return map2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public float[] costFor-7eHliGg(@NotNull Predicate predicate) {
            float[] fArray;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (this.canProcess(predicate)) {
                void var2_2;
                float[] cost2 = null;
                cost2 = Cost.Companion.getZERO-7CRCzCo();
                int n = predicate.getColumns().size();
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    cost2 = Cost.plus-wQ19W7k((float[])cost2, (float[])Cost.times-7eHliGg((float[])Cost.plus-wQ19W7k((float[])Cost.Companion.getDISK_ACCESS_READ_SEQUENTIAL-7CRCzCo(), (float[])Cost.Companion.getMEMORY_ACCESS-7CRCzCo()), (Number)SimilarityBase.log2((double)this.store.getIndexReader().numDocs())));
                }
                fArray = var2_2;
            } else {
                fArray = Cost.Companion.getINVALID-7CRCzCo();
            }
            return fArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                long l = this.store.getIndexReader().numDocs();
                return l;
            }
            finally {
                lock2.unlock();
            }
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Insert event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Value value = event.getData().get(this.getColumns()[0]);
            if (value == null) {
                return true;
            }
            Value newValue = value;
            this.store.addDocument-2g0_blE(event.getTupleId(), ((StringValue)newValue).unbox-impl());
            return true;
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Update event) {
            Value newValue;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Pair<Value, Value> pair = event.getData().get(this.getColumns()[0]);
            Object object = newValue = pair != null ? (Value)pair.getSecond() : null;
            if (newValue == null) {
                this.store.deleteDocument(event.getTupleId());
            } else {
                this.store.updateDocument-2g0_blE(event.getTupleId(), ((StringValue)newValue).unbox-impl());
            }
            return true;
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Delete event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.store.deleteDocument(event.getTupleId());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Cursor<Tuple> filter(@NotNull Predicate predicate) {
            Cursor<Tuple> cursor;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            LuceneIndex luceneIndex = LuceneIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                cursor = new Cursor<Tuple>(predicate, luceneIndex, this){
                    @NotNull
                    private final BooleanPredicate predicate;
                    @NotNull
                    private final ColumnDef<?>[] columns;
                    private volatile int returned;
                    @NotNull
                    private final Query query;
                    @NotNull
                    private final IndexSearcher searcher;
                    private final TopDocs results;
                    {
                        if (!($predicate instanceof BooleanPredicate)) {
                            throw new QueryException.UnsupportedPredicateException("Index '" + $receiver.getName() + "' (lucene index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($predicate.getClass()).getSimpleName() + "'.");
                        }
                        this.predicate = (BooleanPredicate)$predicate;
                        Collection $this$toTypedArray$iv = $receiver2.columnsFor($predicate);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        this.columns = thisCollection$iv.toArray(new ColumnDef[0]);
                        this.query = Tx.access$toLuceneQuery($receiver2, this.predicate);
                        this.searcher = new IndexSearcher(Tx.access$getStore$p($receiver2).getIndexReader());
                        this.results = this.searcher.search(this.query, Integer.MAX_VALUE);
                    }

                    public boolean moveNext() {
                        return (long)this.returned < this.results.totalHits.value;
                    }

                    public long key() {
                        ScoreDoc scores = this.results.scoreDocs[this.returned];
                        Document doc = this.searcher.doc(scores.doc);
                        String string = doc.get("_tid");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                        return Long.parseLong(string);
                    }

                    @NotNull
                    public Tuple value() {
                        int n = this.returned;
                        this.returned = n + 1;
                        ScoreDoc scores = this.results.scoreDocs[n];
                        Document doc = this.searcher.doc(scores.doc);
                        String string = doc.get("_tid");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                        Value[] valueArray = new Value[]{DoubleValue.box-impl((double)DoubleValue.constructor-impl((float)scores.score))};
                        return (Tuple)new StandaloneTuple(Long.parseLong(string), this.columns, valueArray);
                    }

                    public void close() {
                    }

                    public boolean hasNext() {
                        return Cursor.DefaultImpls.hasNext((Cursor)this);
                    }

                    public boolean movePrevious() {
                        return Cursor.DefaultImpls.movePrevious((Cursor)this);
                    }

                    public boolean moveTo(long tupleId) {
                        return Cursor.DefaultImpls.moveTo((Cursor)this, (long)tupleId);
                    }

                    @NotNull
                    public Tuple next() {
                        return (Tuple)Cursor.DefaultImpls.next((Cursor)this);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
            finally {
                lock2.unlock();
            }
            return (Cursor)cursor;
        }

        @Override
        @NotNull
        public Cursor<Tuple> filter(@NotNull Predicate predicate, @NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            throw new UnsupportedOperationException("The LuceneIndex does not support ranged filtering!");
        }

        @Override
        public void beforeCommit() {
            this.store.close();
        }

        @Override
        public void beforeRollback() {
            this.store.close();
        }

        public static final /* synthetic */ Query access$toLuceneQuery(Tx $this, BooleanPredicate $receiver) {
            return $this.toLuceneQuery($receiver);
        }

        public static final /* synthetic */ LuceneIndexDataStore access$getStore$p(Tx $this) {
            return $this.store;
        }
    }
}

