/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq;

import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.CosineDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.EuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.ManhattanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.SquaredEuclideanDistance;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.IVFPQIndex;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndexConfig;", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;", "Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndex;", "distance", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "numCoarseCentroids", "", "numCentroids", "numSubspace", "seed", "(Lorg/vitrivr/cottontail/core/database/Name$FunctionName;IIII)V", "getDistance", "()Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getNumCentroids", "()I", "getNumCoarseCentroids", "getNumSubspace", "getSeed", "numberOfSubspaces", "d", "toMap", "", "", "Binding", "Companion", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nIVFPQIndexConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IVFPQIndexConfig.kt\norg/vitrivr/cottontail/dbms/index/pq/IVFPQIndexConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class IVFPQIndexConfig
implements IndexConfig<IVFPQIndex> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.FunctionName distance;
    private final int numCoarseCentroids;
    private final int numCentroids;
    private final int numSubspace;
    private final int seed;
    private static final int MAXIMUM_NUMBER_OF_SUBSPACES = 32;
    public static final int DEFAULT_CENTROIDS = 512;
    public static final int DEFAULT_SUBSPACES = 8;
    public static final int DEFAULT_COARSE_CENTROIDS = 1024;
    @NotNull
    public static final String KEY_DISTANCE = "ivfpq.distance";
    @NotNull
    public static final String KEY_NUM_CENTROIDS = "ivfpq.centroids";
    @NotNull
    public static final String KEY_NUM_COARSE_CENTROIDS = "ivfpq.coarse_centroids";
    @NotNull
    public static final String KEY_SEED = "ivfpq.seed";
    @NotNull
    private static final Set<Name.FunctionName> SUPPORTED_DISTANCES;

    public IVFPQIndexConfig(@NotNull Name.FunctionName distance, int numCoarseCentroids, int numCentroids, int numSubspace, int seed) {
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        this.distance = distance;
        this.numCoarseCentroids = numCoarseCentroids;
        this.numCentroids = numCentroids;
        this.numSubspace = numSubspace;
        this.seed = seed;
        if (!(this.numCentroids > 0)) {
            boolean $i$a$-require-IVFPQIndexConfig$62 = false;
            String $i$a$-require-IVFPQIndexConfig$62 = "IVFPQIndex requires at least one centroid.";
            throw new IllegalArgumentException($i$a$-require-IVFPQIndexConfig$62.toString());
        }
        if (!(this.numCoarseCentroids > 0)) {
            boolean $i$a$-require-IVFPQIndexConfig$72 = false;
            String $i$a$-require-IVFPQIndexConfig$72 = "IVFPQIndex requires at least one centroid.";
            throw new IllegalArgumentException($i$a$-require-IVFPQIndexConfig$72.toString());
        }
        if (!(this.numCentroids <= Short.MAX_VALUE)) {
            boolean $i$a$-require-IVFPQIndexConfig$82 = false;
            String $i$a$-require-IVFPQIndexConfig$82 = "IVFPQIndex supports a maximum number of 32767 coarse centroids.";
            throw new IllegalArgumentException($i$a$-require-IVFPQIndexConfig$82.toString());
        }
        if (!(this.numCoarseCentroids <= Short.MAX_VALUE)) {
            boolean $i$a$-require-IVFPQIndexConfig$92 = false;
            String $i$a$-require-IVFPQIndexConfig$92 = "IVFPQIndex supports a maximum number of 32767 coarse centroids.";
            throw new IllegalArgumentException($i$a$-require-IVFPQIndexConfig$92.toString());
        }
        if (!SUPPORTED_DISTANCES.contains(this.distance)) {
            boolean bl = false;
            String string = "PQIndex only support L1, L2, L2SQUARED, COSINE and INNERPRODUCT distance.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ IVFPQIndexConfig(Name.FunctionName functionName, int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x10) != 0) {
            n4 = (int)System.currentTimeMillis();
        }
        this(functionName, n, n2, n3, n4);
    }

    @NotNull
    public final Name.FunctionName getDistance() {
        return this.distance;
    }

    public final int getNumCoarseCentroids() {
        return this.numCoarseCentroids;
    }

    public final int getNumCentroids() {
        return this.numCentroids;
    }

    public final int getNumSubspace() {
        return this.numSubspace;
    }

    public final int getSeed() {
        return this.seed;
    }

    public final int numberOfSubspaces(int d) {
        int subspaces = this.numSubspace;
        do {
            if (d % subspaces != 0) continue;
            return subspaces;
        } while (++subspaces <= 32);
        subspaces = this.numSubspace;
        while (subspaces-- > 1) {
            if (d % subspaces != 0) continue;
            return subspaces;
        }
        return 1;
    }

    @Override
    @NotNull
    public Map<String, String> toMap() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)KEY_DISTANCE, (Object)this.distance.getSimple()), TuplesKt.to((Object)KEY_NUM_CENTROIDS, (Object)String.valueOf(this.numCentroids)), TuplesKt.to((Object)KEY_NUM_COARSE_CENTROIDS, (Object)String.valueOf(this.numCoarseCentroids)), TuplesKt.to((Object)KEY_SEED, (Object)String.valueOf(this.seed))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public int compareTo(@NotNull IndexConfig<IVFPQIndex> other) {
        return IndexConfig.DefaultImpls.compareTo(this, other);
    }

    static {
        Object[] objectArray = new Name.FunctionName[]{ManhattanDistance.Companion.getFUNCTION_NAME(), EuclideanDistance.Companion.getFUNCTION_NAME(), SquaredEuclideanDistance.Companion.getFUNCTION_NAME(), CosineDistance.Companion.getFUNCTION_NAME()};
        SUPPORTED_DISTANCES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndexConfig$Binding;", "Ljetbrains/exodus/bindings/ComparableBinding;", "()V", "readObject", "Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndexConfig;", "stream", "Ljava/io/ByteArrayInputStream;", "writeObject", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "object", "", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nIVFPQIndexConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IVFPQIndexConfig.kt\norg/vitrivr/cottontail/dbms/index/pq/IVFPQIndexConfig$Binding\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
    public static final class Binding
    extends ComparableBinding {
        @NotNull
        public static final Binding INSTANCE = new Binding();

        private Binding() {
        }

        @NotNull
        public IVFPQIndexConfig readObject(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            String string = StringBinding.BINDING.readObject(stream);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readObject(...)");
            return new IVFPQIndexConfig(Name.FunctionName.Companion.create(string), IntegerBinding.readCompressed((ByteArrayInputStream)stream), IntegerBinding.readCompressed((ByteArrayInputStream)stream), IntegerBinding.readCompressed((ByteArrayInputStream)stream), IntegerBinding.readCompressed((ByteArrayInputStream)stream));
        }

        public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable<? super IVFPQIndexConfig> object) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(object, (String)"object");
            if (!(object instanceof IVFPQIndexConfig)) {
                boolean bl = false;
                String string = "IVFPQIndexConfig.Binding can only be used to serialize instances of IVFPQIndexConfig.";
                throw new IllegalArgumentException(string.toString());
            }
            StringBinding.BINDING.writeObject(output, (Comparable)((Object)((IVFPQIndexConfig)object).getDistance().getSimple()));
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((IVFPQIndexConfig)object).getNumCoarseCentroids());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((IVFPQIndexConfig)object).getNumCentroids());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((IVFPQIndexConfig)object).getNumSubspace());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((IVFPQIndexConfig)object).getSeed());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndexConfig$Companion;", "", "()V", "DEFAULT_CENTROIDS", "", "DEFAULT_COARSE_CENTROIDS", "DEFAULT_SUBSPACES", "KEY_DISTANCE", "", "KEY_NUM_CENTROIDS", "KEY_NUM_COARSE_CENTROIDS", "KEY_SEED", "MAXIMUM_NUMBER_OF_SUBSPACES", "SUPPORTED_DISTANCES", "", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getSUPPORTED_DISTANCES", "()Ljava/util/Set;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Name.FunctionName> getSUPPORTED_DISTANCES() {
            return SUPPORTED_DISTANCES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

