/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.Function;
import org.vitrivr.cottontail.core.queries.functions.Signature;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.EuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.queries.nodes.traits.Trait;
import org.vitrivr.cottontail.core.queries.nodes.traits.TraitType;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.RealVectorValue;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.catalogue.entries.IndexStructCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.events.DataEvent;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.index.basic.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.basic.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.basic.IndexTx;
import org.vitrivr.cottontail.dbms.index.basic.IndexType;
import org.vitrivr.cottontail.dbms.index.pq.PQIndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.PQIndexCursor;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.SerializableSingleStageProductQuantizer;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.SingleStageQuantizer;
import org.vitrivr.cottontail.dbms.index.pq.rebuilder.AsyncPQIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.pq.rebuilder.PQIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.pq.signature.SPQSignature;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "type", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "newAsyncRebuilder", "Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "newRebuilder", "Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/PQIndexRebuilder;", "newTx", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexTx;", "Companion", "Tx", "cottontaildb-dbms"})
public final class PQIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexType type;
    @NotNull
    private static final Logger LOGGER;
    private static final boolean supportsIncrementalUpdate;
    private static final boolean supportsAsyncRebuild;
    private static final boolean supportsPartitioning;

    public PQIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(name, parent);
        this.type = IndexType.PQ;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IndexTx indexTx = (IndexTx)context2.getTxn().getCachedTxForDBO(this);
        if (indexTx == null) {
            indexTx = new Tx(context2);
        }
        return indexTx;
    }

    @NotNull
    public PQIndexRebuilder newRebuilder(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new PQIndexRebuilder(this, context2);
    }

    @NotNull
    public AsyncPQIndexRebuilder newAsyncRebuilder(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new AsyncPQIndexRebuilder(this, context2);
    }

    static {
        Logger logger = LoggerFactory.getLogger(PQIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        supportsIncrementalUpdate = true;
        supportsAsyncRebuild = true;
        supportsPartitioning = true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex$Companion;", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexDescriptor;", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "supportsAsyncRebuild", "", "getSupportsAsyncRebuild", "()Z", "supportsIncrementalUpdate", "getSupportsIncrementalUpdate", "supportsPartitioning", "getSupportsPartitioning", "buildConfig", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;", "parameters", "", "", "configBinding", "Ljetbrains/exodus/bindings/ComparableBinding;", "deinitialize", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "initialize", "open", "entity", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nPQIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PQIndex.kt\norg/vitrivr/cottontail/dbms/index/pq/PQIndex$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,317:1\n1#2:318\n*E\n"})
    public static final class Companion
    implements IndexDescriptor<PQIndex> {
        private Companion() {
        }

        @Override
        public boolean getSupportsIncrementalUpdate() {
            return supportsIncrementalUpdate;
        }

        @Override
        public boolean getSupportsAsyncRebuild() {
            return supportsAsyncRebuild;
        }

        @Override
        public boolean getSupportsPartitioning() {
            return supportsPartitioning;
        }

        @Override
        @NotNull
        public PQIndex open(@NotNull Name.IndexName name, @NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new PQIndex(name, (DefaultEntity)entity);
        }

        @Override
        public boolean initialize(@NotNull Name.IndexName name, @NotNull Catalogue catalogue, @NotNull org.vitrivr.cottontail.dbms.execution.transactions.Transaction context2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                Store store = catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(name), StoreConfig.WITHOUT_DUPLICATES, context2.getXodusTx(), true);
                bl = store != null;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to initialize PQ index " + name + " due to an exception: " + e.getMessage() + ".");
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean deinitialize(@NotNull Name.IndexName name, @NotNull Catalogue catalogue, @NotNull org.vitrivr.cottontail.dbms.execution.transactions.Transaction context2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().removeStore(ExtensionsKt.storeName(name), context2.getXodusTx());
                bl = true;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to de-initialize PQ index " + name + " due to an exception: " + e.getMessage() + ".");
                bl = false;
            }
            return bl;
        }

        @Override
        @NotNull
        public IndexConfig<PQIndex> buildConfig(@NotNull Map<String, String> parameters) {
            String string;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                    string = parameters.get("pq.distance");
                    if (string == null) break block2;
                    String it = string;
                    boolean bl = false;
                    Name.FunctionName functionName = Name.FunctionName.Companion.create(it);
                    string = functionName;
                    if (functionName != null) break block3;
                }
                string = EuclideanDistance.Companion.getFUNCTION_NAME();
            }
            String string2 = parameters.get("pq.centroids");
            String string3 = parameters.get("pq.subspaces");
            String string4 = parameters.get("pq.seed");
            int n = string4 != null ? Integer.parseInt(string4) : (int)System.currentTimeMillis();
            int n2 = string3 != null ? Integer.parseInt(string3) : 8;
            int n3 = string2 != null ? Integer.parseInt(string2) : 256;
            String string5 = string;
            return new PQIndexConfig((Name.FunctionName)string5, n3, n2, n);
        }

        @Override
        @NotNull
        public ComparableBinding configBinding() {
            return PQIndexConfig.Binding.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001d\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0016J \u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0012\u0004\u0012\u00020*0(2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020.H\u0016J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020/H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001f\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00060"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "dataStore", "Ljetbrains/exodus/env/Store;", "getDataStore$cottontaildb_dbms", "()Ljetbrains/exodus/env/Store;", "distanceFunction", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "getDistanceFunction$cottontaildb_dbms", "()Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "distanceFunction$delegate", "Lkotlin/Lazy;", "quantizer", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SingleStageQuantizer;", "getQuantizer$cottontaildb_dbms", "()Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SingleStageQuantizer;", "quantizer$delegate", "canProcess", "", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "columnsFor", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "costFor", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "costFor-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "count", "", "filter", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "partition", "Lkotlin/ranges/LongRange;", "traitsFor", "", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/TraitType;", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/Trait;", "tryApply", "event", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Delete;", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Insert;", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Update;", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nPQIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PQIndex.kt\norg/vitrivr/cottontail/dbms/index/pq/PQIndex$Tx\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,317:1\n1#2:318\n*E\n"})
    public final class Tx
    extends AbstractIndex.Tx {
        @NotNull
        private final Lazy distanceFunction$delegate;
        @NotNull
        private final Lazy quantizer$delegate;
        @NotNull
        private final Store dataStore;

        public Tx(QueryContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(PQIndex.this, context2);
            this.distanceFunction$delegate = LazyKt.lazy((Function0)new Function0<VectorDistance<?>>(this, PQIndex.this){
                final /* synthetic */ Tx this$0;
                final /* synthetic */ PQIndex this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                @NotNull
                public final VectorDistance<?> invoke() {
                    IndexConfig<?> indexConfig = this.this$0.getConfig();
                    Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.pq.PQIndexConfig");
                    Types[] typesArray = new Types[]{this.this$0.getColumns()[0].getType(), this.this$0.getColumns()[0].getType()};
                    Signature.Closed signature = new Signature.Closed(((PQIndexConfig)indexConfig).getDistance(), typesArray, (Types)Types.Double.INSTANCE);
                    Function function = this.this$1.getCatalogue().getFunctions().obtain(signature);
                    Intrinsics.checkNotNull((Object)function, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance<*>");
                    return (VectorDistance)function;
                }
            });
            this.quantizer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SingleStageQuantizer>(PQIndex.this, this){
                final /* synthetic */ PQIndex this$0;
                final /* synthetic */ Tx this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @NotNull
                public final SingleStageQuantizer invoke() {
                    IndexStructCatalogueEntry indexStructCatalogueEntry;
                    void name$iv;
                    void transaction$iv;
                    void catalogue$iv;
                    void this_$iv;
                    IndexStructCatalogueEntry.Companion companion = IndexStructCatalogueEntry.Companion;
                    Name.IndexName indexName = this.this$0.getName();
                    DefaultCatalogue defaultCatalogue = this.this$0.getCatalogue();
                    Transaction transaction = this.this$1.getContext().getTxn().getXodusTx();
                    ComparableBinding binding$iv = SerializableSingleStageProductQuantizer.Binding.INSTANCE;
                    boolean $i$f$read$cottontaildb_dbms = false;
                    ByteIterable rawEntry$iv = this_$iv.store$cottontaildb_dbms((DefaultCatalogue)catalogue$iv, (Transaction)transaction$iv).get((Transaction)transaction$iv, NameBinding.Index.INSTANCE.toEntry((Name.IndexName)name$iv));
                    if (rawEntry$iv != null) {
                        Comparable value$iv = binding$iv.entryToObject(rawEntry$iv);
                        if (!(value$iv instanceof SerializableSingleStageProductQuantizer)) throw new IllegalArgumentException("");
                        indexStructCatalogueEntry = (IndexStructCatalogueEntry)value$iv;
                    } else {
                        indexStructCatalogueEntry = null;
                    }
                    SerializableSingleStageProductQuantizer serializableSingleStageProductQuantizer = (SerializableSingleStageProductQuantizer)indexStructCatalogueEntry;
                    if (serializableSingleStageProductQuantizer == null) {
                        throw new DatabaseException.DataCorruptionException("ProductQuantizer for PQ index " + this.this$0.getName() + " is missing.");
                    }
                    SerializableSingleStageProductQuantizer serializable = serializableSingleStageProductQuantizer;
                    return serializable.toProductQuantizer(this.this$1.getDistanceFunction$cottontaildb_dbms());
                }
            }));
            Store store = PQIndex.this.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(PQIndex.this.getName()), StoreConfig.USE_EXISTING, this.getContext().getTxn().getXodusTx(), false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Data store for index " + PQIndex.this.getName() + " is missing.");
            }
            this.dataStore = store;
        }

        @NotNull
        public final VectorDistance<?> getDistanceFunction$cottontaildb_dbms() {
            Lazy lazy = this.distanceFunction$delegate;
            return (VectorDistance)lazy.getValue();
        }

        @NotNull
        public final SingleStageQuantizer getQuantizer$cottontaildb_dbms() {
            Lazy lazy = this.quantizer$delegate;
            return (SingleStageQuantizer)lazy.getValue();
        }

        @NotNull
        public final Store getDataStore$cottontaildb_dbms() {
            return this.dataStore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<ColumnDef<?>> columnsFor(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                if (!(predicate instanceof ProximityPredicate.Scan)) {
                    boolean bl2 = false;
                    String string = "PQIndex can only process proximity search.";
                    throw new IllegalArgumentException(string.toString());
                }
                List list = CollectionsKt.listOf((Object)((ProximityPredicate.Scan)predicate).getDistanceColumn().getColumn());
                return list;
            }
            finally {
                lock2.unlock();
            }
        }

        public boolean canProcess(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return predicate instanceof ProximityPredicate.Scan && Intrinsics.areEqual((Object)((ProximityPredicate.Scan)predicate).getColumn().getPhysical(), this.getColumns()[0]) && ((ProximityPredicate.Scan)predicate).getDistance().getClass() == this.getDistanceFunction$cottontaildb_dbms().getClass();
        }

        @Override
        @NotNull
        public Map<TraitType<?>, Trait> traitsFor(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof ProximityPredicate.Scan)) {
                throw new IllegalArgumentException("Unsupported predicate for high-dimensional index. This is a programmer's error!");
            }
            return new LinkedHashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public float[] costFor-7eHliGg(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                if (!(predicate instanceof ProximityPredicate.Scan)) {
                    float[] fArray = Cost.Companion.getINVALID-7CRCzCo();
                    return fArray;
                }
                if (!Intrinsics.areEqual((Object)((ProximityPredicate.Scan)predicate).getColumn().getPhysical(), this.getColumns()[0])) {
                    float[] fArray = Cost.Companion.getINVALID-7CRCzCo();
                    return fArray;
                }
                Name.FunctionName functionName = ((ProximityPredicate.Scan)predicate).getDistance().getName();
                IndexConfig<?> indexConfig = this.getConfig();
                Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.pq.PQIndexConfig");
                if (!Intrinsics.areEqual((Object)functionName, (Object)((PQIndexConfig)indexConfig).getDistance())) {
                    float[] fArray = Cost.Companion.getINVALID-7CRCzCo();
                    return fArray;
                }
                long count = this.count();
                float[] fArray = Cost.times-7eHliGg((float[])Cost.times-7eHliGg((float[])Cost.constructor-impl$default((float)(Cost.getIo-impl((float[])Cost.Companion.getDISK_ACCESS_READ_SEQUENTIAL-7CRCzCo()) * (float)2), (float)((float)4 * Cost.getCpu-impl((float[])Cost.Companion.getMEMORY_ACCESS-7CRCzCo()) + Cost.getCpu-impl((float[])Cost.Companion.getFLOP-7CRCzCo())), (float)0.0f, (float)0.2f, (int)4, null), (Number)this.getQuantizer$cottontaildb_dbms().getCodebooks().length), (Number)count);
                return fArray;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                l = this.dataStore.count(this.getContext().getTxn().getXodusTx());
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Insert event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Value value = event.getData().get(this.getColumns()[0]);
            if (value == null) {
                return true;
            }
            Value value2 = value;
            short[] sig = this.getQuantizer$cottontaildb_dbms().quantize-54_lylY((VectorValue)((RealVectorValue)value2));
            return this.dataStore.put(this.getContext().getTxn().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(event.getTupleId()), SPQSignature.toEntry-impl(sig));
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Update event) {
            boolean bl;
            Value newValue;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Pair<Value, Value> pair = event.getData().get(this.getColumns()[0]);
            Value oldValue = pair != null ? (Value)pair.getFirst() : null;
            Pair<Value, Value> pair2 = event.getData().get(this.getColumns()[0]);
            Object object = newValue = pair2 != null ? (Value)pair2.getSecond() : null;
            if (newValue instanceof RealVectorValue) {
                short[] newSig = this.getQuantizer$cottontaildb_dbms().quantize-54_lylY((VectorValue)newValue);
                bl = this.dataStore.put(this.getContext().getTxn().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(event.getTupleId()), SPQSignature.toEntry-impl(newSig));
            } else {
                bl = oldValue instanceof RealVectorValue ? this.dataStore.delete(this.getContext().getTxn().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(event.getTupleId())) : true;
            }
            return bl;
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Delete event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return event.getData().get(this.getColumns()[0]) == null || this.dataStore.delete(this.getContext().getTxn().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(event.getTupleId()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Cursor<Tuple> filter(@NotNull Predicate predicate) {
            Cursor<Tuple> cursor;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            PQIndex pQIndex = PQIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                EntityTx entityTx = pQIndex.getParent().newTx(this.getContext());
                cursor = this.filter(predicate, new LongRange(entityTx.smallestTupleId(), entityTx.largestTupleId()));
            }
            finally {
                lock2.unlock();
            }
            return cursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Cursor<Tuple> filter(@NotNull Predicate predicate, @NotNull LongRange partition) {
            PQIndexCursor pQIndexCursor;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                if (!(predicate instanceof ProximityPredicate.Scan)) {
                    boolean bl2 = false;
                    String string = "PQIndex can only be used with a SCAN type proximity predicate. This is a programmer's error!";
                    throw new IllegalArgumentException(string.toString());
                }
                pQIndexCursor = new PQIndexCursor(partition, (ProximityPredicate.Scan)predicate, this);
            }
            finally {
                lock2.unlock();
            }
            return pQIndexCursor;
        }
    }
}

