/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.queries.binding.BindingContext;
import org.vitrivr.cottontail.core.queries.binding.MissingTuple;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.tuple.StandaloneTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.index.pq.PQIndex;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.SingleStageQuantizer;
import org.vitrivr.cottontail.dbms.index.pq.signature.PQLookupTable;
import org.vitrivr.cottontail.dbms.index.pq.signature.SPQSignature;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\bR\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001f\u001a\u00020 H\u0016J\f\u0010!\u001a\u00060\"j\u0002`#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0002H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00060\bR\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u000f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexCursor;", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "partition", "Lkotlin/ranges/LongRange;", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$Scan;", "index", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;", "(Lkotlin/ranges/LongRange;Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$Scan;Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex$Tx;)V", "boc", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cursor", "Ljetbrains/exodus/env/Cursor;", "kotlin.jvm.PlatformType", "endKey", "Ljetbrains/exodus/ArrayByteIterable;", "getIndex", "()Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex$Tx;", "lookupTable", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable;", "getPredicate", "()Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$Scan;", "produces", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "startKey", "subTx", "Ljetbrains/exodus/env/Transaction;", "close", "", "key", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "moveNext", "", "value", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nPQIndexCursor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PQIndexCursor.kt\norg/vitrivr/cottontail/dbms/index/pq/PQIndexCursor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,89:1\n37#2,2:90\n*S KotlinDebug\n*F\n+ 1 PQIndexCursor.kt\norg/vitrivr/cottontail/dbms/index/pq/PQIndexCursor\n*L\n41#1:90,2\n*E\n"})
public final class PQIndexCursor
implements org.vitrivr.cottontail.core.basics.Cursor<Tuple> {
    @NotNull
    private final ProximityPredicate.Scan predicate;
    @NotNull
    private final PQIndex.Tx index;
    @NotNull
    private final PQLookupTable lookupTable;
    private final Transaction subTx;
    private final Cursor cursor;
    @NotNull
    private final ArrayByteIterable startKey;
    @NotNull
    private final ArrayByteIterable endKey;
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final AtomicBoolean boc;

    public PQIndexCursor(@NotNull LongRange partition, @NotNull ProximityPredicate.Scan predicate, @NotNull PQIndex.Tx index) {
        Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        this.predicate = predicate;
        this.index = index;
        this.subTx = this.index.getContext().getTxn().getXodusTx().getReadonlySnapshot();
        this.cursor = this.index.getDataStore$cottontaildb_dbms().openCursor(this.subTx);
        this.startKey = ExtensionsKt.toKey(partition.getFirst());
        this.endKey = ExtensionsKt.toKey(partition.getLast());
        Collection $this$toTypedArray$iv = this.index.columnsFor((Predicate)this.predicate);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.produces = thisCollection$iv.toArray(new ColumnDef[0]);
        this.boc = new AtomicBoolean(true);
        MissingTuple $this$_init__u24lambda_u241 = MissingTuple.INSTANCE;
        boolean bl = false;
        BindingContext $this$lambda_u241_u24lambda_u240 = this.index.getContext().getBindings();
        boolean bl2 = false;
        SingleStageQuantizer singleStageQuantizer = this.index.getQuantizer$cottontaildb_dbms();
        Value value = this.predicate.getQuery().getValue($this$lambda_u241_u24lambda_u240, (Tuple)$this$_init__u24lambda_u241);
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.types.VectorValue<*>");
        this.lookupTable = singleStageQuantizer.createLookupTable((VectorValue)value);
        if (this.cursor.getSearchKeyRange((ByteIterable)this.startKey) == null) {
            this.boc.set(false);
        }
    }

    @NotNull
    public final ProximityPredicate.Scan getPredicate() {
        return this.predicate;
    }

    @NotNull
    public final PQIndex.Tx getIndex() {
        return this.index;
    }

    public boolean moveNext() {
        return this.boc.compareAndExchange(true, false) || this.cursor.getNext() && this.cursor.getKey().compareTo((Object)this.endKey) <= 0;
    }

    public long key() {
        return LongBinding.compressedEntryToLong((ByteIterable)this.cursor.getKey());
    }

    @NotNull
    public Tuple value() {
        ByteIterable byteIterable = this.cursor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getValue(...)");
        short[] signature = SPQSignature.Companion.fromEntry-54_lylY(byteIterable);
        double approximation = DoubleValue.constructor-impl((double)this.lookupTable.approximateDistance(SPQSignature.box-impl(signature)));
        Value[] valueArray = new Value[]{DoubleValue.box-impl((double)approximation)};
        return (Tuple)new StandaloneTuple(LongBinding.compressedEntryToLong((ByteIterable)this.cursor.getKey()), this.produces, valueArray);
    }

    public void close() {
        this.subTx.abort();
        this.cursor.close();
    }

    public boolean hasNext() {
        return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public boolean movePrevious() {
        return Cursor.DefaultImpls.movePrevious((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public boolean moveTo(long tupleId) {
        return Cursor.DefaultImpls.moveTo((org.vitrivr.cottontail.core.basics.Cursor)this, (long)tupleId);
    }

    @NotNull
    public Tuple next() {
        return (Tuple)Cursor.DefaultImpls.next((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

