/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq.quantizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.EuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.ManhattanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.SquaredEuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.dbms.index.pq.IVFPQIndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.PQCodebook;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.SerializableMultiStageProductQuantizer;
import org.vitrivr.cottontail.dbms.index.pq.signature.IVFPQSignature;
import org.vitrivr.cottontail.dbms.index.pq.signature.PQLookupTable;
import org.vitrivr.cottontail.utilities.math.clustering.Cluster;
import org.vitrivr.cottontail.utilities.math.clustering.KMeansClusterer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ(\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\rH\u0016J*\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d2\n\u0010 \u001a\u00060!j\u0002`\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0017J\u0006\u0010$\u001a\u00020%J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006)"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/MultiStageQuantizer;", "", "coarse", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "fine", "", "(Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;[Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;)V", "getCoarse", "()Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "getFine", "()[Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "[Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "numberOfSubspaces", "", "getNumberOfSubspaces", "()I", "component1", "component2", "copy", "(Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;[Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;)Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/MultiStageQuantizer;", "createLookupTable", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable;", "query", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "equals", "", "other", "hashCode", "quantize", "Lkotlin/Pair;", "", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/IVFPQSignature;", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "vector", "toSerializableProductQuantizer", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SerializableMultiStageProductQuantizer;", "toString", "", "Companion", "cottontaildb-dbms"})
public final class MultiStageQuantizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PQCodebook coarse;
    @NotNull
    private final PQCodebook[] fine;

    public MultiStageQuantizer(@NotNull PQCodebook coarse, @NotNull PQCodebook[] fine) {
        Intrinsics.checkNotNullParameter((Object)coarse, (String)"coarse");
        Intrinsics.checkNotNullParameter((Object)fine, (String)"fine");
        this.coarse = coarse;
        this.fine = fine;
    }

    @NotNull
    public final PQCodebook getCoarse() {
        return this.coarse;
    }

    @NotNull
    public final PQCodebook[] getFine() {
        return this.fine;
    }

    private final int getNumberOfSubspaces() {
        return this.fine.length;
    }

    @NotNull
    public final Pair<Short, IVFPQSignature> quantize(long tupleId, @NotNull VectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        short bucket = (short)this.coarse.quantize(vector);
        int n = 0;
        int n2 = this.getNumberOfSubspaces();
        short[] sArray = new short[n2];
        long l = tupleId;
        while (n < n2) {
            int n3 = n++;
            PQCodebook codebook = this.fine[n3];
            sArray[n3] = (short)codebook.quantize(vector.slice(n3 * codebook.getSubspaceSize(), codebook.getSubspaceSize()));
        }
        short[] sArray2 = sArray;
        long l2 = l;
        IVFPQSignature signature = new IVFPQSignature(l2, sArray2);
        return TuplesKt.to((Object)bucket, (Object)signature);
    }

    @NotNull
    public final PQLookupTable createLookupTable(@NotNull VectorValue<?> query2) {
        PQLookupTable pQLookupTable;
        Intrinsics.checkNotNullParameter(query2, (String)"query");
        VectorDistance<?> value = ((PQCodebook)ArraysKt.first((Object[])this.fine)).getDistance();
        if (value instanceof ManhattanDistance) {
            pQLookupTable = new PQLookupTable.Manhattan(query2, this.fine);
        } else if (value instanceof EuclideanDistance) {
            pQLookupTable = new PQLookupTable.Euclidean(query2, this.fine);
        } else if (value instanceof SquaredEuclideanDistance) {
            pQLookupTable = new PQLookupTable.SquaredEuclidean(query2, this.fine);
        } else {
            throw new IllegalStateException("The distance function " + value.getSignature() + " us not supported for product quantization.");
        }
        return pQLookupTable;
    }

    @NotNull
    public final SerializableMultiStageProductQuantizer toSerializableProductQuantizer() {
        int n;
        double[][] dArrayArray;
        Object object;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.coarse.getNumberOfCentroids();
        Object object2 = new double[n6][];
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = n5;
            n3 = 0;
            n2 = this.coarse.getSubspaceSize();
            object = new double[n2];
            int n7 = n4;
            dArrayArray = object2;
            while (n3 < n2) {
                n = n3++;
                object[n] = this.coarse.getCentroids()[n4].get(n).getValue().doubleValue();
            }
            dArrayArray[n7] = object;
        }
        double[][] dArrayArray2 = object2;
        n6 = this.getNumberOfSubspaces();
        object2 = new double[n6][][];
        dArrayArray = dArrayArray2;
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = n5;
            n2 = this.fine[n4].getNumberOfCentroids();
            object = new double[n2][];
            int n8 = n4;
            Object object3 = object2;
            for (n3 = 0; n3 < n2; ++n3) {
                n = n3;
                int n9 = 0;
                int n10 = this.fine[n4].getSubspaceSize();
                double[] dArray = new double[n10];
                int n11 = n;
                Object object4 = object;
                while (n9 < n10) {
                    int n12 = n9++;
                    dArray[n12] = this.fine[n4].getCentroids()[n].get(n12).getValue().doubleValue();
                }
                object4[n11] = (double)dArray;
            }
            object3[n8] = object;
        }
        Object object5 = object2;
        double[][] dArrayArray3 = dArrayArray;
        return new SerializableMultiStageProductQuantizer(dArrayArray3, (double[][][])object5);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MultiStageQuantizer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.coarse, (Object)((MultiStageQuantizer)other).coarse)) {
            return false;
        }
        return Arrays.equals(this.fine, ((MultiStageQuantizer)other).fine);
    }

    public int hashCode() {
        int result = this.coarse.hashCode();
        result = 31 * result + Arrays.hashCode(this.fine);
        return result;
    }

    @NotNull
    public final PQCodebook component1() {
        return this.coarse;
    }

    @NotNull
    public final PQCodebook[] component2() {
        return this.fine;
    }

    @NotNull
    public final MultiStageQuantizer copy(@NotNull PQCodebook coarse, @NotNull PQCodebook[] fine) {
        Intrinsics.checkNotNullParameter((Object)coarse, (String)"coarse");
        Intrinsics.checkNotNullParameter((Object)fine, (String)"fine");
        return new MultiStageQuantizer(coarse, fine);
    }

    public static /* synthetic */ MultiStageQuantizer copy$default(MultiStageQuantizer multiStageQuantizer, PQCodebook pQCodebook, PQCodebook[] pQCodebookArray, int n, Object object) {
        if ((n & 1) != 0) {
            pQCodebook = multiStageQuantizer.coarse;
        }
        if ((n & 2) != 0) {
            pQCodebookArray = multiStageQuantizer.fine;
        }
        return multiStageQuantizer.copy(pQCodebook, pQCodebookArray);
    }

    @NotNull
    public String toString() {
        return "MultiStageQuantizer(coarse=" + this.coarse + ", fine=" + Arrays.toString(this.fine) + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/MultiStageQuantizer$Companion;", "", "()V", "learnFromData", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/MultiStageQuantizer;", "distance", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "data", "", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "config", "Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndexConfig;", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nMultiStageQuantizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiStageQuantizer.kt\norg/vitrivr/cottontail/dbms/index/pq/quantizer/MultiStageQuantizer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,131:1\n1726#2,3:132\n1549#2:136\n1620#2,3:137\n1549#2:142\n1620#2,3:143\n1549#2:146\n1620#2,3:147\n1#3:135\n37#4,2:140\n37#4,2:150\n*S KotlinDebug\n*F\n+ 1 MultiStageQuantizer.kt\norg/vitrivr/cottontail/dbms/index/pq/quantizer/MultiStageQuantizer$Companion\n*L\n39#1:132,3\n50#1:136\n50#1:137,3\n52#1:142\n52#1:143,3\n53#1:146\n53#1:147,3\n50#1:140,2\n53#1:150,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MultiStageQuantizer learnFromData(@NotNull VectorDistance<?> distance, @NotNull List<? extends VectorValue<?>> data, @NotNull IVFPQIndexConfig config) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            boolean bl;
            int dimensionsPerSubspace;
            int subspaces;
            int logicalSize;
            block10: {
                Intrinsics.checkNotNullParameter(distance, (String)"distance");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                logicalSize = distance.getType().getLogicalSize();
                subspaces = config.numberOfSubspaces(logicalSize);
                dimensionsPerSubspace = logicalSize / subspaces;
                Iterable $this$all$iv = data;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        VectorValue it = (VectorValue)element$iv;
                        boolean bl2 = false;
                        if (it.getLogicalSize() == logicalSize) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                boolean $i$a$-require-MultiStageQuantizer$Companion$learnFromData$52 = false;
                String $i$a$-require-MultiStageQuantizer$Companion$learnFromData$52 = "Training of product quantizer not possible; dimensionality of training data and distance function don't match.";
                throw new IllegalArgumentException($i$a$-require-MultiStageQuantizer$Companion$learnFromData$52.toString());
            }
            if (!(logicalSize >= subspaces)) {
                boolean $i$a$-require-MultiStageQuantizer$Companion$learnFromData$62 = false;
                String $i$a$-require-MultiStageQuantizer$Companion$learnFromData$62 = "Training of product quantizer not possible; logical size of data must be greater or equal to number of subspaces.";
                throw new IllegalArgumentException($i$a$-require-MultiStageQuantizer$Companion$learnFromData$62.toString());
            }
            if (!(dimensionsPerSubspace * subspaces == logicalSize)) {
                boolean $i$a$-require-MultiStageQuantizer$Companion$learnFromData$72 = false;
                String $i$a$-require-MultiStageQuantizer$Companion$learnFromData$72 = "Training of product quantizer not possible; vector size of " + logicalSize + " does not allow for equally spaced subspaces.";
                throw new IllegalArgumentException($i$a$-require-MultiStageQuantizer$Companion$learnFromData$72.toString());
            }
            VectorDistance reshape = distance.copy(dimensionsPerSubspace);
            SplittableRandom random = new SplittableRandom(System.currentTimeMillis());
            KMeansClusterer coarseClusterer = new KMeansClusterer(config.getNumCoarseCentroids(), distance, (RandomGenerator)random, 0, 8, null);
            KMeansClusterer fineClusterer = new KMeansClusterer(config.getNumCentroids(), reshape, (RandomGenerator)random, 0, 8, null);
            Iterable bl2 = coarseClusterer.cluster(data);
            Object object = distance;
            boolean $i$f$map = false;
            PQCodebook[] pQCodebookArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Cluster cluster = (Cluster)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getCenter());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            VectorValue[] vectorValueArray = thisCollection$iv.toArray(new VectorValue[0]);
            VectorDistance<?> vectorDistance = object;
            PQCodebook coarse = new PQCodebook(vectorDistance, vectorValueArray);
            pQCodebookArray = new PQCodebook[subspaces];
            for (int j = 0; j < subspaces; ++j) {
                void $this$toTypedArray$iv2;
                void $this$mapTo$iv$iv2;
                Collection $this$map$iv2;
                void $this$mapTo$iv$iv3;
                void $this$map$iv3;
                int n = j;
                Iterable iterable = data;
                int n2 = n;
                PQCodebook[] pQCodebookArray2 = pQCodebookArray;
                boolean $i$f$map22 = false;
                void it = $this$map$iv3;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void v;
                    VectorValue vectorValue = (VectorValue)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl4 = false;
                    object.add((VectorValue)v.slice(n * dimensionsPerSubspace, dimensionsPerSubspace));
                }
                object = (List)destination$iv$iv2;
                Object subspaceData = object;
                Iterable $i$f$map22 = fineClusterer.cluster(subspaceData);
                boolean $i$f$map3 = false;
                destination$iv$iv2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it2;
                    Cluster bl4 = (Cluster)item$iv$iv;
                    object = destination$iv$iv3;
                    boolean bl5 = false;
                    object.add(it2.getCenter());
                }
                object = (List)destination$iv$iv3;
                $this$map$iv2 = (Collection)object;
                boolean $i$f$toTypedArray2 = false;
                void thisCollection$iv2 = $this$toTypedArray$iv2;
                VectorValue[] clusters = thisCollection$iv2.toArray(new VectorValue[0]);
                pQCodebookArray2[n2] = new PQCodebook(reshape, clusters);
            }
            PQCodebook[] fine = pQCodebookArray;
            return new MultiStageQuantizer(coarse, fine);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

