/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq.quantizer;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.core.values.DoubleVectorValue;
import org.vitrivr.cottontail.core.values.FloatVectorValue;
import org.vitrivr.cottontail.core.values.IntVectorValue;
import org.vitrivr.cottontail.core.values.LongVectorValue;
import org.vitrivr.cottontail.dbms.catalogue.entries.IndexStructCatalogueEntry;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.MultiStageQuantizer;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.PQCodebook;
import org.xerial.snappy.Snappy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0001H\u0096\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001f\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0013\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\u0015\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SerializableMultiStageProductQuantizer;", "Lorg/vitrivr/cottontail/dbms/catalogue/entries/IndexStructCatalogueEntry;", "coarse", "", "", "fine", "([[D[[[D)V", "getCoarse", "()[[D", "[[D", "dimensionsPerSubspace", "", "getDimensionsPerSubspace", "()I", "getFine", "()[[[D", "[[[D", "numberOfCoarseCentroids", "getNumberOfCoarseCentroids", "numberOfFineCentroids", "getNumberOfFineCentroids", "numberOfFineSubspaces", "getNumberOfFineSubspaces", "compareTo", "other", "toProductQuantizer", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/MultiStageQuantizer;", "distance", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "Binding", "cottontaildb-dbms"})
public final class SerializableMultiStageProductQuantizer
extends IndexStructCatalogueEntry {
    @NotNull
    private final double[][] coarse;
    @NotNull
    private final double[][][] fine;

    public SerializableMultiStageProductQuantizer(@NotNull double[][] coarse, @NotNull double[][][] fine) {
        Intrinsics.checkNotNullParameter((Object)coarse, (String)"coarse");
        Intrinsics.checkNotNullParameter((Object)fine, (String)"fine");
        this.coarse = coarse;
        this.fine = fine;
    }

    @NotNull
    public final double[][] getCoarse() {
        return this.coarse;
    }

    @NotNull
    public final double[][][] getFine() {
        return this.fine;
    }

    public final int getNumberOfCoarseCentroids() {
        return ((Object[])this.coarse).length;
    }

    public final int getNumberOfFineSubspaces() {
        return ((Object[])this.fine).length;
    }

    public final int getNumberOfFineCentroids() {
        return ((Object[])this.fine[0]).length;
    }

    public final int getDimensionsPerSubspace() {
        return this.fine[0][0].length;
    }

    @NotNull
    public final MultiStageQuantizer toProductQuantizer(@NotNull VectorDistance<?> distance) {
        PQCodebook[] pQCodebookArray;
        int n;
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        int n2 = this.getNumberOfCoarseCentroids();
        VectorValue[] vectorValueArray = new VectorValue[n2];
        VectorDistance<?> vectorDistance = distance;
        for (int j = 0; j < n2; ++j) {
            DoubleVectorValue doubleVectorValue;
            n = j;
            pQCodebookArray = distance.getType();
            if (pQCodebookArray instanceof Types.DoubleVector) {
                doubleVectorValue = DoubleVectorValue.box-impl((double[])DoubleVectorValue.constructor-impl((double[])this.coarse[n]));
            } else if (pQCodebookArray instanceof Types.FloatVector) {
                doubleVectorValue = FloatVectorValue.box-impl((float[])FloatVectorValue.constructor-impl((double[])this.coarse[n]));
            } else if (pQCodebookArray instanceof Types.LongVector) {
                doubleVectorValue = LongVectorValue.box-impl((long[])LongVectorValue.constructor-impl((double[])this.coarse[n]));
            } else if (pQCodebookArray instanceof Types.IntVector) {
                doubleVectorValue = IntVectorValue.box-impl((int[])IntVectorValue.constructor-impl((double[])this.coarse[n]));
            } else {
                throw new IllegalArgumentException("Reconstruction of product quantizer not possible; type " + distance.getType() + " not supported.");
            }
            vectorValueArray[n] = doubleVectorValue;
        }
        VectorValue[] vectorValueArray2 = vectorValueArray;
        VectorDistance<?> vectorDistance2 = vectorDistance;
        PQCodebook coarse = new PQCodebook(vectorDistance2, vectorValueArray2);
        VectorDistance reshaped = distance.copy(this.getDimensionsPerSubspace());
        n = this.getNumberOfFineSubspaces();
        pQCodebookArray = new PQCodebook[n];
        for (int j = 0; j < n; ++j) {
            int n3 = j;
            int n4 = this.getNumberOfFineCentroids();
            VectorValue[] vectorValueArray3 = new VectorValue[n4];
            VectorDistance vectorDistance3 = reshaped;
            int n5 = n3;
            PQCodebook[] pQCodebookArray2 = pQCodebookArray;
            for (int k = 0; k < n4; ++k) {
                DoubleVectorValue doubleVectorValue;
                int n6 = k;
                Types.Vector vector = distance.getType();
                if (vector instanceof Types.DoubleVector) {
                    doubleVectorValue = DoubleVectorValue.box-impl((double[])DoubleVectorValue.constructor-impl((double[])this.fine[n3][n6]));
                } else if (vector instanceof Types.FloatVector) {
                    doubleVectorValue = FloatVectorValue.box-impl((float[])FloatVectorValue.constructor-impl((double[])this.fine[n3][n6]));
                } else if (vector instanceof Types.LongVector) {
                    doubleVectorValue = LongVectorValue.box-impl((long[])LongVectorValue.constructor-impl((double[])this.fine[n3][n6]));
                } else if (vector instanceof Types.IntVector) {
                    doubleVectorValue = IntVectorValue.box-impl((int[])IntVectorValue.constructor-impl((double[])this.fine[n3][n6]));
                } else {
                    throw new IllegalArgumentException("Reconstruction of product quantizer not possible; type " + distance.getType() + " not supported.");
                }
                vectorValueArray3[n6] = doubleVectorValue;
            }
            VectorValue[] vectorValueArray4 = vectorValueArray3;
            VectorDistance vectorDistance4 = vectorDistance3;
            pQCodebookArray2[n5] = new PQCodebook(vectorDistance4, vectorValueArray4);
        }
        PQCodebook[] fine = pQCodebookArray;
        return new MultiStageQuantizer(coarse, fine);
    }

    @Override
    public int compareTo(@NotNull IndexStructCatalogueEntry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof SerializableMultiStageProductQuantizer)) {
            return -1;
        }
        double[][] dArray = this.coarse;
        int n = ((Object[])dArray).length;
        for (int j = 0; j < n; ++j) {
            int i2 = j;
            double[] cb = dArray[j];
            int n2 = cb.length;
            for (int k = 0; k < n2; ++k) {
                double d = cb[k];
                int j2 = k;
                int compare = Double.compare(d, ((SerializableMultiStageProductQuantizer)other).coarse[i2][j2]);
                if (compare == 0) continue;
                return compare;
            }
        }
        return 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SerializableMultiStageProductQuantizer$Binding;", "Ljetbrains/exodus/bindings/ComparableBinding;", "()V", "readObject", "", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SerializableMultiStageProductQuantizer;", "stream", "Ljava/io/ByteArrayInputStream;", "writeObject", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "object", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nSerializableMultiStageProductQuantizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializableMultiStageProductQuantizer.kt\norg/vitrivr/cottontail/dbms/index/pq/quantizer/SerializableMultiStageProductQuantizer$Binding\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
    public static final class Binding
    extends ComparableBinding {
        @NotNull
        public static final Binding INSTANCE = new Binding();

        private Binding() {
        }

        @NotNull
        public Comparable<SerializableMultiStageProductQuantizer> readObject(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int numberOfCoarseCentroids = IntegerBinding.readCompressed((ByteArrayInputStream)stream);
            int numberOfFineSubspaces = IntegerBinding.readCompressed((ByteArrayInputStream)stream);
            int numberOfFineCentroids = IntegerBinding.readCompressed((ByteArrayInputStream)stream);
            int n = 0;
            double[][] dArrayArray = new double[numberOfCoarseCentroids][];
            while (n < numberOfCoarseCentroids) {
                int n2 = n++;
                byte[] bytes = stream.readNBytes(IntegerBinding.readCompressed((ByteArrayInputStream)stream));
                dArrayArray[n2] = Snappy.uncompressDoubleArray((byte[])bytes);
            }
            double[][] coarse = dArrayArray;
            double[][][] dArrayArray2 = new double[numberOfFineSubspaces][][];
            for (int j = 0; j < numberOfFineSubspaces; ++j) {
                int n3 = j;
                int n4 = 0;
                double[][] dArrayArray3 = new double[numberOfFineCentroids][];
                int n5 = n3;
                double[][][] dArrayArray4 = dArrayArray2;
                while (n4 < numberOfFineCentroids) {
                    int n6 = n4++;
                    byte[] bytes = stream.readNBytes(IntegerBinding.readCompressed((ByteArrayInputStream)stream));
                    dArrayArray3[n6] = Snappy.uncompressDoubleArray((byte[])bytes);
                }
                dArrayArray4[n5] = dArrayArray3;
            }
            double[][][] fine = dArrayArray2;
            return new SerializableMultiStageProductQuantizer(coarse, fine);
        }

        public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable<? super SerializableMultiStageProductQuantizer> object) {
            int n;
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(object, (String)"object");
            if (!(object instanceof SerializableMultiStageProductQuantizer)) {
                boolean bl = false;
                String string = "SerializableProductQuantizer.Binding can only be used to serialize instances of SerializableProductQuantizer.";
                throw new IllegalArgumentException(string.toString());
            }
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((SerializableMultiStageProductQuantizer)object).getNumberOfCoarseCentroids());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((SerializableMultiStageProductQuantizer)object).getNumberOfFineSubspaces());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((SerializableMultiStageProductQuantizer)object).getNumberOfFineCentroids());
            Object object2 = ((SerializableMultiStageProductQuantizer)object).getCoarse();
            int n2 = ((Object[])object2).length;
            for (n = 0; n < n2; ++n) {
                double[] co = object2[n];
                byte[] compressed = Snappy.compress((double[])co);
                IntegerBinding.writeCompressed((LightOutputStream)output, (int)compressed.length);
                output.write(compressed);
            }
            object2 = ((SerializableMultiStageProductQuantizer)object).getFine();
            n2 = ((Object[])object2).length;
            for (n = 0; n < n2; ++n) {
                double[] cb = object2[n];
                int n3 = ((Object[])cb).length;
                for (int j = 0; j < n3; ++j) {
                    double co = cb[j];
                    byte[] compressed = Snappy.compress((double[])co);
                    IntegerBinding.writeCompressed((LightOutputStream)output, (int)compressed.length);
                    output.write(compressed);
                }
            }
        }
    }
}

