/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq.quantizer;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.core.values.DoubleVectorValue;
import org.vitrivr.cottontail.core.values.FloatVectorValue;
import org.vitrivr.cottontail.core.values.IntVectorValue;
import org.vitrivr.cottontail.core.values.LongVectorValue;
import org.vitrivr.cottontail.dbms.catalogue.entries.IndexStructCatalogueEntry;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.PQCodebook;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.SingleStageQuantizer;
import org.xerial.snappy.Snappy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001 B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0001H\u0096\u0002J\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J$\u0010\u0014\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\nH\u0016J\u0012\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dJ\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u001f\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SerializableSingleStageProductQuantizer;", "Lorg/vitrivr/cottontail/dbms/catalogue/entries/IndexStructCatalogueEntry;", "codebooks", "", "", "([[[D)V", "getCodebooks", "()[[[D", "[[[D", "dimensionsPerSubspace", "", "getDimensionsPerSubspace", "()I", "numberOfCentroids", "getNumberOfCentroids", "numberOfSubspaces", "getNumberOfSubspaces", "compareTo", "other", "component1", "copy", "([[[D)Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SerializableSingleStageProductQuantizer;", "equals", "", "", "hashCode", "toProductQuantizer", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SingleStageQuantizer;", "distance", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "toString", "", "Binding", "cottontaildb-dbms"})
public final class SerializableSingleStageProductQuantizer
extends IndexStructCatalogueEntry {
    @NotNull
    private final double[][][] codebooks;

    public SerializableSingleStageProductQuantizer(@NotNull double[][][] codebooks) {
        Intrinsics.checkNotNullParameter((Object)codebooks, (String)"codebooks");
        this.codebooks = codebooks;
    }

    @NotNull
    public final double[][][] getCodebooks() {
        return this.codebooks;
    }

    public final int getNumberOfSubspaces() {
        return ((Object[])this.codebooks).length;
    }

    public final int getNumberOfCentroids() {
        return ((Object[])this.codebooks[0]).length;
    }

    public final int getDimensionsPerSubspace() {
        return this.codebooks[0][0].length;
    }

    @NotNull
    public final SingleStageQuantizer toProductQuantizer(@NotNull VectorDistance<?> distance) {
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        VectorDistance reshaped = distance.copy(this.getDimensionsPerSubspace());
        int n = this.getNumberOfSubspaces();
        PQCodebook[] pQCodebookArray = new PQCodebook[n];
        for (int j = 0; j < n; ++j) {
            int n2 = j;
            int n3 = this.getNumberOfCentroids();
            VectorValue[] vectorValueArray = new VectorValue[n3];
            VectorDistance vectorDistance = reshaped;
            int n4 = n2;
            PQCodebook[] pQCodebookArray2 = pQCodebookArray;
            for (int k = 0; k < n3; ++k) {
                DoubleVectorValue doubleVectorValue;
                int n5 = k;
                Types.Vector vector = distance.getType();
                if (vector instanceof Types.DoubleVector) {
                    doubleVectorValue = DoubleVectorValue.box-impl((double[])DoubleVectorValue.constructor-impl((double[])this.codebooks[n2][n5]));
                } else if (vector instanceof Types.FloatVector) {
                    doubleVectorValue = FloatVectorValue.box-impl((float[])FloatVectorValue.constructor-impl((double[])this.codebooks[n2][n5]));
                } else if (vector instanceof Types.LongVector) {
                    doubleVectorValue = LongVectorValue.box-impl((long[])LongVectorValue.constructor-impl((double[])this.codebooks[n2][n5]));
                } else if (vector instanceof Types.IntVector) {
                    doubleVectorValue = IntVectorValue.box-impl((int[])IntVectorValue.constructor-impl((double[])this.codebooks[n2][n5]));
                } else {
                    throw new IllegalArgumentException("Reconstruction of product quantizer not possible; type " + distance.getType() + " not supported.");
                }
                vectorValueArray[n5] = doubleVectorValue;
            }
            VectorValue[] vectorValueArray2 = vectorValueArray;
            VectorDistance vectorDistance2 = vectorDistance;
            pQCodebookArray2[n4] = new PQCodebook(vectorDistance2, vectorValueArray2);
        }
        PQCodebook[] codebooks = pQCodebookArray;
        return new SingleStageQuantizer(codebooks);
    }

    @Override
    public int compareTo(@NotNull IndexStructCatalogueEntry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof SerializableSingleStageProductQuantizer)) {
            return -1;
        }
        double[][][] dArray = this.codebooks;
        int n = ((Object[])dArray).length;
        for (int j = 0; j < n; ++j) {
            int i2 = j;
            double[][] cb = dArray[j];
            int n2 = ((Object[])cb).length;
            for (int k = 0; k < n2; ++k) {
                int j2 = k;
                double[] ce = cb[k];
                int n3 = ce.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    double d = ce[i3];
                    int k2 = i3;
                    int compare = Double.compare(d, ((SerializableSingleStageProductQuantizer)other).codebooks[i2][j2][k2]);
                    if (compare == 0) continue;
                    return compare;
                }
            }
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SerializableSingleStageProductQuantizer)) {
            return false;
        }
        Object[] objectArray = (Object[])this.codebooks;
        Object[] objectArray2 = (Object[])((SerializableSingleStageProductQuantizer)other).codebooks;
        return ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])objectArray2);
    }

    public int hashCode() {
        Object[] objectArray = (Object[])this.codebooks;
        return ArraysKt.contentDeepHashCode((Object[])objectArray);
    }

    @NotNull
    public final double[][][] component1() {
        return this.codebooks;
    }

    @NotNull
    public final SerializableSingleStageProductQuantizer copy(@NotNull double[][][] codebooks) {
        Intrinsics.checkNotNullParameter((Object)codebooks, (String)"codebooks");
        return new SerializableSingleStageProductQuantizer(codebooks);
    }

    public static /* synthetic */ SerializableSingleStageProductQuantizer copy$default(SerializableSingleStageProductQuantizer serializableSingleStageProductQuantizer, double[][][] dArray, int n, Object object) {
        if ((n & 1) != 0) {
            dArray = serializableSingleStageProductQuantizer.codebooks;
        }
        return serializableSingleStageProductQuantizer.copy(dArray);
    }

    @NotNull
    public String toString() {
        return "SerializableSingleStageProductQuantizer(codebooks=" + Arrays.toString((Object[])this.codebooks) + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SerializableSingleStageProductQuantizer$Binding;", "Ljetbrains/exodus/bindings/ComparableBinding;", "()V", "readObject", "", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SerializableSingleStageProductQuantizer;", "stream", "Ljava/io/ByteArrayInputStream;", "writeObject", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "object", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nSerializableSingleStageProductQuantizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializableSingleStageProductQuantizer.kt\norg/vitrivr/cottontail/dbms/index/pq/quantizer/SerializableSingleStageProductQuantizer$Binding\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
    public static final class Binding
    extends ComparableBinding {
        @NotNull
        public static final Binding INSTANCE = new Binding();

        private Binding() {
        }

        @NotNull
        public Comparable<SerializableSingleStageProductQuantizer> readObject(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int numberOfSubspaces = IntegerBinding.readCompressed((ByteArrayInputStream)stream);
            int numberOfCentroids = IntegerBinding.readCompressed((ByteArrayInputStream)stream);
            double[][][] dArrayArray = new double[numberOfSubspaces][][];
            for (int j = 0; j < numberOfSubspaces; ++j) {
                int n = j;
                int n2 = 0;
                double[][] dArrayArray2 = new double[numberOfCentroids][];
                int n3 = n;
                double[][][] dArrayArray3 = dArrayArray;
                while (n2 < numberOfCentroids) {
                    int n4 = n2++;
                    byte[] bytes = stream.readNBytes(IntegerBinding.readCompressed((ByteArrayInputStream)stream));
                    Intrinsics.checkNotNullExpressionValue((Object)Snappy.uncompressDoubleArray((byte[])bytes), (String)"uncompressDoubleArray(...)");
                }
                dArrayArray3[n3] = dArrayArray2;
            }
            double[][][] dArrayArray4 = dArrayArray;
            return new SerializableSingleStageProductQuantizer(dArrayArray4);
        }

        public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable<? super SerializableSingleStageProductQuantizer> object) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(object, (String)"object");
            if (!(object instanceof SerializableSingleStageProductQuantizer)) {
                boolean bl = false;
                String string = "SerializableProductQuantizer.Binding can only be used to serialize instances of SerializableProductQuantizer.";
                throw new IllegalArgumentException(string.toString());
            }
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((SerializableSingleStageProductQuantizer)object).getNumberOfSubspaces());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((SerializableSingleStageProductQuantizer)object).getNumberOfCentroids());
            double[][][] dArray = ((SerializableSingleStageProductQuantizer)object).getCodebooks();
            int n = ((Object[])dArray).length;
            for (int j = 0; j < n; ++j) {
                double[][] cb = dArray[j];
                int n2 = ((Object[])cb).length;
                for (int k = 0; k < n2; ++k) {
                    double[] co = cb[k];
                    byte[] compressed = Snappy.compress((double[])co);
                    IntegerBinding.writeCompressed((LightOutputStream)output, (int)compressed.length);
                    output.write(compressed);
                }
            }
        }
    }
}

