/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq.rebuilder;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.Function;
import org.vitrivr.cottontail.core.queries.functions.Signature;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.catalogue.entries.IndexStructCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.events.DataEvent;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.index.basic.Index;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.basic.IndexMetadata;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.AbstractAsyncIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.IndexRebuilderState;
import org.vitrivr.cottontail.dbms.index.pq.PQIndex;
import org.vitrivr.cottontail.dbms.index.pq.PQIndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.SerializableSingleStageProductQuantizer;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.SingleStageQuantizer;
import org.vitrivr.cottontail.dbms.index.pq.rebuilder.DataCollectionUtilities;
import org.vitrivr.cottontail.dbms.index.pq.signature.SPQSignature;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder;", "Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AbstractAsyncIndexRebuilder;", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;", "index", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "indexedColumn", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "log", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder$PQIndexingEvent;", "newQuantizer", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SingleStageQuantizer;", "tmpDataStore", "Ljetbrains/exodus/env/Store;", "drainAndMergeLog", "", "internalBuild", "internalReplace", "store", "processSideChannelEvent", "event", "Lorg/vitrivr/cottontail/dbms/events/DataEvent;", "PQIndexingEvent", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nAsyncPQIndexRebuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncPQIndexRebuilder.kt\norg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder\n+ 2 IndexStructCatalogueEntry.kt\norg/vitrivr/cottontail/dbms/catalogue/entries/IndexStructCatalogueEntry$Companion\n*L\n1#1,220:1\n88#2:221\n*S KotlinDebug\n*F\n+ 1 AsyncPQIndexRebuilder.kt\norg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder\n*L\n139#1:221\n*E\n"})
public final class AsyncPQIndexRebuilder
extends AbstractAsyncIndexRebuilder<PQIndex> {
    @NotNull
    private final Store tmpDataStore;
    @NotNull
    private final SingleStageQuantizer newQuantizer;
    @NotNull
    private final ColumnDef<?> indexedColumn;
    @NotNull
    private final ConcurrentLinkedQueue<PQIndexingEvent> log;

    public AsyncPQIndexRebuilder(@NotNull PQIndex index, @NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((Index)index, context2.getCatalogue(), context2.getTxn().getManager());
        Store store = this.getTmpEnvironment().openStore(ExtensionsKt.storeName(((PQIndex)this.getIndex()).getName()), StoreConfig.WITHOUT_DUPLICATES, this.getTmpTx(), true);
        if (store == null) {
            throw new DatabaseException.DataCorruptionException("Temporary data store for index " + ((PQIndex)this.getIndex()).getName() + " could not be created.");
        }
        this.tmpDataStore = store;
        this.log = new ConcurrentLinkedQueue();
        Store indexMetadataStore = IndexMetadata.Companion.store$cottontaildb_dbms(((PQIndex)this.getIndex()).getCatalogue(), context2.getTxn().getXodusTx());
        ByteIterable byteIterable = indexMetadataStore.get(context2.getTxn().getXodusTx(), NameBinding.Index.INSTANCE.toEntry(((PQIndex)this.getIndex()).getName()));
        if (byteIterable == null) {
            throw new DatabaseException.DataCorruptionException("Failed to rebuild index " + ((PQIndex)this.getIndex()).getName() + ": Could not read catalogue entry for index.");
        }
        ByteIterable indexEntryRaw = byteIterable;
        IndexMetadata indexEntry = IndexMetadata.Companion.fromEntry(indexEntryRaw);
        IndexConfig<?> indexConfig = indexEntry.getConfig();
        Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.pq.PQIndexConfig");
        PQIndexConfig config = (PQIndexConfig)indexConfig;
        Name.ColumnName column = ((PQIndex)this.getIndex()).getName().entity().column(indexEntry.getColumns().get(0));
        EntityTx entityTx = ((PQIndex)this.getIndex()).getParent().newTx(context2);
        ColumnTx<?> columnTx = entityTx.columnForName(column).newTx(context2);
        long count = entityTx.count();
        this.indexedColumn = columnTx.getColumnDef();
        Types[] typesArray = new Types[]{this.indexedColumn.getType(), this.indexedColumn.getType()};
        Signature.Closed signature = new Signature.Closed(config.getDistance(), typesArray, (Types)Types.Double.INSTANCE);
        Function function = ((PQIndex)this.getIndex()).getCatalogue().getFunctions().obtain(signature);
        Intrinsics.checkNotNull((Object)function, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance<*>");
        VectorDistance distanceFunction2 = (VectorDistance)function;
        float fraction = 3.0f * (float)config.getNumCentroids() / (float)count;
        long seed = System.currentTimeMillis();
        List<VectorValue<?>> learningData = DataCollectionUtilities.INSTANCE.acquireLearningData(columnTx, fraction, seed);
        this.newQuantizer = SingleStageQuantizer.Companion.learnFromData(distanceFunction2, learningData, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean internalBuild(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        EntityTx entityTx = ((PQIndex)this.getIndex()).getParent().newTx(context2);
        ColumnTx<?> columnTx = entityTx.columnForName(this.indexedColumn.getName()).newTx(context2);
        long count = entityTx.count();
        int counter = 0;
        AutoCloseable autoCloseable = (AutoCloseable)columnTx.cursor();
        Throwable throwable = null;
        try {
            org.vitrivr.cottontail.core.basics.Cursor cursor = (org.vitrivr.cottontail.core.basics.Cursor)autoCloseable;
            boolean bl = false;
            while (cursor.hasNext()) {
                if (this.getState() != IndexRebuilderState.REBUILDING) {
                    boolean bl2 = false;
                    return bl2;
                }
                Value value = (Value)cursor.value();
                if (!(value instanceof VectorValue)) continue;
                if (!this.tmpDataStore.add(this.getTmpTx(), (ByteIterable)ExtensionsKt.toKey(cursor.key()), SPQSignature.toEntry-impl(this.newQuantizer.quantize-54_lylY((VectorValue)value)))) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (++counter % 1000000 != 0) continue;
                Object[] objectArray = new Object[]{((PQIndex)this.getIndex()).getName(), ((PQIndex)this.getIndex()).getType(), counter, count};
                AbstractAsyncIndexRebuilder.Companion.getLOGGER$cottontaildb_dbms().debug("Rebuilding index (SCAN) {} ({}) still running ({} / {})...", objectArray);
                if (this.getTmpTx().flush()) continue;
                boolean bl4 = false;
                return bl4;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean internalReplace(@NotNull QueryContext context2, @NotNull Store store) {
        void entry$iv;
        void name$iv;
        void transaction$iv;
        void catalogue$iv;
        void this_$iv;
        Object cursor;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        long count = this.tmpDataStore.count(this.getTmpTx());
        Object object = (Closeable)this.tmpDataStore.openCursor(this.getTmpTx());
        Throwable throwable = null;
        try {
            cursor = (Cursor)object;
            boolean bl = false;
            int counter = 0;
            while (cursor.getNext()) {
                if (this.getState() != IndexRebuilderState.REPLACING) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (!store.add(context2.getTxn().getXodusTx(), cursor.getKey(), cursor.getValue())) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (++counter % 1000000 != 0) continue;
                Object[] objectArray = new Object[]{((PQIndex)this.getIndex()).getName(), ((PQIndex)this.getIndex()).getType(), counter, count};
                AbstractAsyncIndexRebuilder.Companion.getLOGGER$cottontaildb_dbms().debug("Rebuilding index (MERGE) {} ({}) still running ({} / {})...", objectArray);
                if (context2.getTxn().getXodusTx().flush()) continue;
                boolean bl4 = false;
                return bl4;
            }
            cursor = Unit.INSTANCE;
        }
        catch (Throwable cursor2) {
            throwable = cursor2;
            throw cursor2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = IndexStructCatalogueEntry.Companion;
        throwable = ((PQIndex)this.getIndex()).getName();
        cursor = this.newQuantizer.toSerializableProductQuantizer();
        DefaultCatalogue defaultCatalogue = ((PQIndex)this.getIndex()).getCatalogue();
        Transaction counter = context2.getTxn().getXodusTx();
        ComparableBinding binding$iv = SerializableSingleStageProductQuantizer.Binding.INSTANCE;
        boolean $i$f$write$cottontaildb_dbms = false;
        this_$iv.store$cottontaildb_dbms((DefaultCatalogue)catalogue$iv, (Transaction)transaction$iv).put((Transaction)transaction$iv, NameBinding.Index.INSTANCE.toEntry((Name.IndexName)name$iv), (ByteIterable)binding$iv.objectToEntry((Comparable)entry$iv));
        return true;
    }

    @Override
    public boolean processSideChannelEvent(@NotNull DataEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataEvent dataEvent = event;
        if (dataEvent instanceof DataEvent.Insert) {
            Value value = ((DataEvent.Insert)event).getData().get(this.indexedColumn);
            if (value instanceof VectorValue) {
                this.log.offer(new PQIndexingEvent.Set(event.getTupleId(), this.newQuantizer.quantize-54_lylY((VectorValue)value), null));
            }
            bl = true;
        } else if (dataEvent instanceof DataEvent.Delete) {
            Value value = ((DataEvent.Delete)event).getData().get(this.indexedColumn);
            if (value != null) {
                this.log.offer(new PQIndexingEvent.Unset(event.getTupleId()));
            }
            bl = true;
        } else if (dataEvent instanceof DataEvent.Update) {
            Value newValue;
            Pair<Value, Value> pair = ((DataEvent.Update)event).getData().get(this.indexedColumn);
            Value oldValue = pair != null ? (Value)pair.getFirst() : null;
            Pair<Value, Value> pair2 = ((DataEvent.Update)event).getData().get(this.indexedColumn);
            Object object = newValue = pair2 != null ? (Value)pair2.getSecond() : null;
            if (newValue instanceof VectorValue) {
                this.log.offer(new PQIndexingEvent.Set(event.getTupleId(), this.newQuantizer.quantize-54_lylY((VectorValue)newValue), null));
            } else if (oldValue instanceof VectorValue) {
                this.log.offer(new PQIndexingEvent.Unset(event.getTupleId()));
            }
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public boolean drainAndMergeLog() {
        PQIndexingEvent next = this.log.poll();
        while (next != null) {
            boolean bl;
            PQIndexingEvent pQIndexingEvent = next;
            if (pQIndexingEvent instanceof PQIndexingEvent.Set) {
                bl = this.tmpDataStore.put(this.getTmpTx(), (ByteIterable)ExtensionsKt.toKey(next.getTupleId()), SPQSignature.toEntry-impl(((PQIndexingEvent.Set)next).getSignature-PdeZFdE()));
            } else if (pQIndexingEvent instanceof PQIndexingEvent.Unset) {
                bl = this.tmpDataStore.delete(this.getTmpTx(), (ByteIterable)ExtensionsKt.toKey(next.getTupleId()));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            boolean success = bl;
            if (!success) {
                return false;
            }
            next = this.log.poll();
        }
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0007\bR\u0016\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder$PQIndexingEvent;", "", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "getTupleId", "()J", "Set", "Unset", "Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder$PQIndexingEvent$Set;", "Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder$PQIndexingEvent$Unset;", "cottontaildb-dbms"})
    private static interface PQIndexingEvent {
        public long getTupleId();

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\r\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0016\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\tJ+\u0010\u0010\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0019\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder$PQIndexingEvent$Set;", "Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder$PQIndexingEvent;", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "signature", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/SPQSignature;", "(J[SLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getSignature-PdeZFdE", "()[S", "[S", "getTupleId", "()J", "component1", "component2", "component2-PdeZFdE", "copy", "copy-dELIAYY", "(J[S)Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder$PQIndexingEvent$Set;", "equals", "", "other", "", "hashCode", "", "toString", "", "cottontaildb-dbms"})
        public static final class Set
        implements PQIndexingEvent {
            private final long tupleId;
            @NotNull
            private final short[] signature;

            private Set(long tupleId, short[] signature) {
                Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                this.tupleId = tupleId;
                this.signature = signature;
            }

            @Override
            public long getTupleId() {
                return this.tupleId;
            }

            @NotNull
            public final short[] getSignature-PdeZFdE() {
                return this.signature;
            }

            public final long component1() {
                return this.tupleId;
            }

            @NotNull
            public final short[] component2-PdeZFdE() {
                return this.signature;
            }

            @NotNull
            public final Set copy-dELIAYY(long tupleId, @NotNull short[] signature) {
                Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                return new Set(tupleId, signature, null);
            }

            public static /* synthetic */ Set copy-dELIAYY$default(Set set, long l, short[] sArray, int n, Object object) {
                if ((n & 1) != 0) {
                    l = set.tupleId;
                }
                if ((n & 2) != 0) {
                    sArray = set.signature;
                }
                return set.copy-dELIAYY(l, sArray);
            }

            @NotNull
            public String toString() {
                return "Set(tupleId=" + this.tupleId + ", signature=" + SPQSignature.toString-impl(this.signature) + ")";
            }

            public int hashCode() {
                int result = Long.hashCode(this.tupleId);
                result = result * 31 + SPQSignature.hashCode-impl(this.signature);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Set)) {
                    return false;
                }
                Set set = (Set)other;
                if (this.tupleId != set.tupleId) {
                    return false;
                }
                return SPQSignature.equals-impl0(this.signature, set.signature);
            }

            public /* synthetic */ Set(long tupleId, short[] signature, DefaultConstructorMarker $constructor_marker) {
                this(tupleId, signature);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\b\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\t\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder$PQIndexingEvent$Unset;", "Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/AsyncPQIndexRebuilder$PQIndexingEvent;", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "(J)V", "getTupleId", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cottontaildb-dbms"})
        public static final class Unset
        implements PQIndexingEvent {
            private final long tupleId;

            public Unset(long tupleId) {
                this.tupleId = tupleId;
            }

            @Override
            public long getTupleId() {
                return this.tupleId;
            }

            public final long component1() {
                return this.tupleId;
            }

            @NotNull
            public final Unset copy(long tupleId) {
                return new Unset(tupleId);
            }

            public static /* synthetic */ Unset copy$default(Unset unset, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = unset.tupleId;
                }
                return unset.copy(l);
            }

            @NotNull
            public String toString() {
                return "Unset(tupleId=" + this.tupleId + ")";
            }

            public int hashCode() {
                return Long.hashCode(this.tupleId);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unset)) {
                    return false;
                }
                Unset unset = (Unset)other;
                return this.tupleId == unset.tupleId;
            }
        }
    }
}

