/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq.rebuilder;

import java.util.List;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ShortBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.Argument;
import org.vitrivr.cottontail.core.queries.functions.Function;
import org.vitrivr.cottontail.core.queries.functions.Signature;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.entries.IndexStructCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.index.basic.Index;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.basic.IndexMetadata;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.AbstractIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.pq.IVFPQIndex;
import org.vitrivr.cottontail.dbms.index.pq.IVFPQIndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.MultiStageQuantizer;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.SerializableMultiStageProductQuantizer;
import org.vitrivr.cottontail.dbms.index.pq.rebuilder.DataCollectionUtilities;
import org.vitrivr.cottontail.dbms.index.pq.signature.IVFPQSignature;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/IVFPQIndexRebuilder;", "Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AbstractIndexRebuilder;", "Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndex;", "index", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndex;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "rebuildInternal", "", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nIVFPQIndexRebuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IVFPQIndexRebuilder.kt\norg/vitrivr/cottontail/dbms/index/pq/rebuilder/IVFPQIndexRebuilder\n+ 2 IndexStructCatalogueEntry.kt\norg/vitrivr/cottontail/dbms/catalogue/entries/IndexStructCatalogueEntry$Companion\n*L\n1#1,81:1\n88#2:82\n*S KotlinDebug\n*F\n+ 1 IVFPQIndexRebuilder.kt\norg/vitrivr/cottontail/dbms/index/pq/rebuilder/IVFPQIndexRebuilder\n*L\n78#1:82\n*E\n"})
public final class IVFPQIndexRebuilder
extends AbstractIndexRebuilder<IVFPQIndex> {
    public IVFPQIndexRebuilder(@NotNull IVFPQIndex index, @NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((Index)index, context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected boolean rebuildInternal() {
        void entry$iv;
        void name$iv;
        void transaction$iv;
        void catalogue$iv;
        void this_$iv;
        Value value;
        Object cursor;
        Store indexMetadataStore = IndexMetadata.Companion.store$cottontaildb_dbms(((IVFPQIndex)this.getIndex()).getCatalogue(), this.getContext().getTxn().getXodusTx());
        ByteIterable byteIterable = indexMetadataStore.get(this.getContext().getTxn().getXodusTx(), NameBinding.Index.INSTANCE.toEntry(((IVFPQIndex)this.getIndex()).getName()));
        if (byteIterable == null) {
            throw new DatabaseException.DataCorruptionException("Failed to rebuild index " + ((IVFPQIndex)this.getIndex()).getName() + ": Could not read catalogue entry for index.");
        }
        ByteIterable indexEntryRaw = byteIterable;
        IndexMetadata indexEntry = IndexMetadata.Companion.fromEntry(indexEntryRaw);
        IndexConfig<?> indexConfig = indexEntry.getConfig();
        Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.pq.IVFPQIndexConfig");
        IVFPQIndexConfig config = (IVFPQIndexConfig)indexConfig;
        Name.ColumnName column = ((IVFPQIndex)this.getIndex()).getName().entity().column(indexEntry.getColumns().get(0));
        EntityTx entityTx = ((IVFPQIndex)this.getIndex()).getParent().newTx(this.getContext());
        ColumnTx<?> columnTx = entityTx.columnForName(column).newTx(this.getContext());
        Store store = this.tryClearAndOpenStore();
        if (store == null) {
            return false;
        }
        Store dataStore = store;
        long count = entityTx.count();
        Types types = columnTx.getColumnDef().getType();
        Intrinsics.checkNotNull((Object)types, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.types.Types.Vector<*, *>");
        Types.Vector type = (Types.Vector)types;
        Argument.Typed[] typedArray = new Argument.Typed[]{new Argument.Typed((Types)type), new Argument.Typed((Types)type)};
        Function function = ((IVFPQIndex)this.getIndex()).getCatalogue().getFunctions().obtain(new Signature.SemiClosed(config.getDistance(), typedArray));
        Intrinsics.checkNotNull((Object)function, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance<*>");
        VectorDistance distanceFunction2 = (VectorDistance)function;
        float fraction = 3.0f * (float)config.getNumCentroids() / (float)count;
        long seed = System.currentTimeMillis();
        List<VectorValue<?>> learningData = DataCollectionUtilities.INSTANCE.acquireLearningData(columnTx, fraction, seed);
        MultiStageQuantizer quantizer2 = MultiStageQuantizer.Companion.learnFromData(distanceFunction2, learningData, config);
        int counter = 0;
        Object object = (AutoCloseable)columnTx.cursor();
        Throwable throwable = null;
        try {
            cursor = (Cursor)object;
            boolean bl = false;
            while (cursor.moveNext()) {
                value = (Value)cursor.value();
                if (!(value instanceof VectorValue)) continue;
                Pair<Short, IVFPQSignature> signature = quantizer2.quantize(cursor.key(), (VectorValue)value);
                if (!dataStore.put(this.getContext().getTxn().getXodusTx(), (ByteIterable)ShortBinding.shortToEntry((short)((Number)signature.getFirst()).shortValue()), ((IVFPQSignature)signature.getSecond()).toEntry())) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (++counter % 1000000 != 0) continue;
                Object[] objectArray = new Object[]{((IVFPQIndex)this.getIndex()).getName(), ((IVFPQIndex)this.getIndex()).getType(), counter, count};
                AbstractIndexRebuilder.Companion.getLOGGER$cottontaildb_dbms().debug("Rebuilding index {} ({}) still running ({} / {})...", objectArray);
                if (this.getContext().getTxn().getXodusTx().flush()) continue;
                boolean bl3 = false;
                return bl3;
            }
            cursor = Unit.INSTANCE;
        }
        catch (Throwable cursor2) {
            throwable = cursor2;
            throw cursor2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        object = IndexStructCatalogueEntry.Companion;
        throwable = ((IVFPQIndex)this.getIndex()).getName();
        cursor = quantizer2.toSerializableProductQuantizer();
        DefaultCatalogue defaultCatalogue = ((IVFPQIndex)this.getIndex()).getCatalogue();
        value = this.getContext().getTxn().getXodusTx();
        ComparableBinding binding$iv = SerializableMultiStageProductQuantizer.Binding.INSTANCE;
        boolean $i$f$write$cottontaildb_dbms = false;
        this_$iv.store$cottontaildb_dbms((DefaultCatalogue)catalogue$iv, (Transaction)transaction$iv).put((Transaction)transaction$iv, NameBinding.Index.INSTANCE.toEntry((Name.IndexName)name$iv), (ByteIterable)binding$iv.objectToEntry((Comparable)entry$iv));
        return true;
    }
}

