/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.va;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.MinkowskiDistance;
import org.vitrivr.cottontail.core.queries.nodes.traits.LimitTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.OrderTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.Trait;
import org.vitrivr.cottontail.core.queries.nodes.traits.TraitType;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.queries.sort.SortOrder;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.RealVectorValue;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.catalogue.entries.IndexStructCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.events.DataEvent;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.index.basic.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.basic.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.basic.IndexTx;
import org.vitrivr.cottontail.dbms.index.basic.IndexType;
import org.vitrivr.cottontail.dbms.index.va.VAFCursor;
import org.vitrivr.cottontail.dbms.index.va.VAFIndexConfig;
import org.vitrivr.cottontail.dbms.index.va.rebuilder.AsyncVAFIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.va.rebuilder.VAFIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.va.signature.EquidistantVAFMarks;
import org.vitrivr.cottontail.dbms.index.va.signature.VAFSignature;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;
import org.vitrivr.cottontail.dbms.statistics.index.IndexStatistic;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "type", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "newAsyncRebuilder", "Lorg/vitrivr/cottontail/dbms/index/va/rebuilder/AsyncVAFIndexRebuilder;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "newRebuilder", "Lorg/vitrivr/cottontail/dbms/index/va/rebuilder/VAFIndexRebuilder;", "newTx", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexTx;", "Companion", "Tx", "cottontaildb-dbms"})
public final class VAFIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexType type;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    public static final String FILTER_EFFICIENCY_CACHE_KEY = "vaf.efficiency";
    public static final float DEFAULT_FILTER_EFFICIENCY = 0.9f;
    private static final boolean supportsIncrementalUpdate;
    private static final boolean supportsAsyncRebuild;
    private static final boolean supportsPartitioning;

    public VAFIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(name, parent);
        this.type = IndexType.VAF;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @NotNull
    public VAFIndexRebuilder newRebuilder(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new VAFIndexRebuilder(this, context2);
    }

    @NotNull
    public AsyncVAFIndexRebuilder newAsyncRebuilder(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new AsyncVAFIndexRebuilder(this, context2);
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IndexTx indexTx = (IndexTx)context2.getTxn().getCachedTxForDBO(this);
        if (indexTx == null) {
            indexTx = new Tx(context2);
        }
        return indexTx;
    }

    static {
        Logger logger = LoggerFactory.getLogger(VAFIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        supportsIncrementalUpdate = true;
        supportsAsyncRebuild = true;
        supportsPartitioning = true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010!\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006%"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Companion;", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexDescriptor;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "()V", "DEFAULT_FILTER_EFFICIENCY", "", "FILTER_EFFICIENCY_CACHE_KEY", "", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER$cottontaildb_dbms", "()Lorg/slf4j/Logger;", "supportsAsyncRebuild", "", "getSupportsAsyncRebuild", "()Z", "supportsIncrementalUpdate", "getSupportsIncrementalUpdate", "supportsPartitioning", "getSupportsPartitioning", "buildConfig", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;", "parameters", "", "configBinding", "Ljetbrains/exodus/bindings/ComparableBinding;", "deinitialize", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "initialize", "open", "entity", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "cottontaildb-dbms"})
    public static final class Companion
    implements IndexDescriptor<VAFIndex> {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER$cottontaildb_dbms() {
            return LOGGER;
        }

        @Override
        public boolean getSupportsIncrementalUpdate() {
            return supportsIncrementalUpdate;
        }

        @Override
        public boolean getSupportsAsyncRebuild() {
            return supportsAsyncRebuild;
        }

        @Override
        public boolean getSupportsPartitioning() {
            return supportsPartitioning;
        }

        @Override
        @NotNull
        public VAFIndex open(@NotNull Name.IndexName name, @NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new VAFIndex(name, (DefaultEntity)entity);
        }

        @Override
        public boolean initialize(@NotNull Name.IndexName name, @NotNull Catalogue catalogue, @NotNull org.vitrivr.cottontail.dbms.execution.transactions.Transaction context2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                Store store = catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(name), StoreConfig.WITHOUT_DUPLICATES, context2.getXodusTx(), true);
                bl = store != null;
            }
            catch (Throwable e) {
                this.getLOGGER$cottontaildb_dbms().error("Failed to initialize VAF index " + name + " due to an exception: " + e.getMessage() + ".");
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean deinitialize(@NotNull Name.IndexName name, @NotNull Catalogue catalogue, @NotNull org.vitrivr.cottontail.dbms.execution.transactions.Transaction context2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().removeStore(ExtensionsKt.storeName(name), context2.getXodusTx());
                bl = true;
            }
            catch (Throwable e) {
                this.getLOGGER$cottontaildb_dbms().error("Failed to de-initialize VAF index " + name + " due to an exception: " + e.getMessage() + ".");
                bl = false;
            }
            return bl;
        }

        @Override
        @NotNull
        public IndexConfig<VAFIndex> buildConfig(@NotNull Map<String, String> parameters) {
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Object object = parameters.get("vaf.marks_per_dimension");
            return new VAFIndexConfig(object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 5);
        }

        @Override
        @NotNull
        public ComparableBinding configBinding() {
            return VAFIndexConfig.Binding.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016J\r\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J \u0010%\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030'\u0012\u0004\u0012\u00020(0&2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020,H\u0016J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020-H\u0016J\u0015\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020#H\u0000\u00a2\u0006\u0002\b1R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00062"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "dataStore", "Ljetbrains/exodus/env/Store;", "getDataStore$cottontaildb_dbms", "()Ljetbrains/exodus/env/Store;", "marks", "Lorg/vitrivr/cottontail/dbms/index/va/signature/EquidistantVAFMarks;", "getMarks$cottontaildb_dbms", "()Lorg/vitrivr/cottontail/dbms/index/va/signature/EquidistantVAFMarks;", "marks$delegate", "Lkotlin/Lazy;", "canProcess", "", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "columnsFor", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "costFor", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "costFor-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "count", "", "filter", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "partition", "Lkotlin/ranges/LongRange;", "getEfficiency", "", "getEfficiency$cottontaildb_dbms", "traitsFor", "", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/TraitType;", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/Trait;", "tryApply", "event", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Delete;", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Insert;", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Update;", "updateEfficiency", "", "float", "updateEfficiency$cottontaildb_dbms", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nVAFIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VAFIndex.kt\norg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1#2:361\n*E\n"})
    public final class Tx
    extends AbstractIndex.Tx {
        @NotNull
        private final Lazy marks$delegate;
        @NotNull
        private final Store dataStore;

        public Tx(QueryContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(VAFIndex.this, context2);
            this.marks$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EquidistantVAFMarks>(VAFIndex.this, this){
                final /* synthetic */ VAFIndex this$0;
                final /* synthetic */ Tx this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @NotNull
                public final EquidistantVAFMarks invoke() {
                    IndexStructCatalogueEntry indexStructCatalogueEntry;
                    void name$iv;
                    void transaction$iv;
                    void catalogue$iv;
                    void this_$iv;
                    IndexStructCatalogueEntry.Companion companion = IndexStructCatalogueEntry.Companion;
                    Name.IndexName indexName = this.this$0.getName();
                    DefaultCatalogue defaultCatalogue = this.this$0.getCatalogue();
                    Transaction transaction = this.this$1.getContext().getTxn().getXodusTx();
                    ComparableBinding binding$iv = EquidistantVAFMarks.Binding.INSTANCE;
                    boolean $i$f$read$cottontaildb_dbms = false;
                    ByteIterable rawEntry$iv = this_$iv.store$cottontaildb_dbms((DefaultCatalogue)catalogue$iv, (Transaction)transaction$iv).get((Transaction)transaction$iv, NameBinding.Index.INSTANCE.toEntry((Name.IndexName)name$iv));
                    if (rawEntry$iv != null) {
                        Comparable value$iv = binding$iv.entryToObject(rawEntry$iv);
                        if (!(value$iv instanceof EquidistantVAFMarks)) throw new IllegalArgumentException("");
                        indexStructCatalogueEntry = (IndexStructCatalogueEntry)value$iv;
                    } else {
                        indexStructCatalogueEntry = null;
                    }
                    EquidistantVAFMarks equidistantVAFMarks = (EquidistantVAFMarks)indexStructCatalogueEntry;
                    if (equidistantVAFMarks != null) return equidistantVAFMarks;
                    throw new DatabaseException.DataCorruptionException("Marks for VAF index " + this.this$0.getName() + " are missing.");
                }
            }));
            Store store = VAFIndex.this.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(VAFIndex.this.getName()), StoreConfig.USE_EXISTING, this.getContext().getTxn().getXodusTx(), false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Store for VAF index " + VAFIndex.this.getName() + " is missing.");
            }
            this.dataStore = store;
        }

        @NotNull
        public final EquidistantVAFMarks getMarks$cottontaildb_dbms() {
            Lazy lazy = this.marks$delegate;
            return (EquidistantVAFMarks)lazy.getValue();
        }

        @NotNull
        public final Store getDataStore$cottontaildb_dbms() {
            return this.dataStore;
        }

        public final float getEfficiency$cottontaildb_dbms() {
            IndexStatistic key;
            IndexStatistic indexStatistic = key = VAFIndex.this.getCatalogue().getIndexStatistics().get(VAFIndex.this.getName(), VAFIndex.FILTER_EFFICIENCY_CACHE_KEY);
            return indexStatistic != null ? indexStatistic.asFloat() : 0.9f;
        }

        public final void updateEfficiency$cottontaildb_dbms(float f) {
            IndexStatistic key = VAFIndex.this.getCatalogue().getIndexStatistics().get(VAFIndex.this.getName(), VAFIndex.FILTER_EFFICIENCY_CACHE_KEY);
            if (key == null) {
                VAFIndex.this.getCatalogue().getIndexStatistics().update(VAFIndex.this.getName(), new IndexStatistic(VAFIndex.FILTER_EFFICIENCY_CACHE_KEY, String.valueOf(f), 0L, 4, null));
            } else {
                float avg = (key.asFloat() + f) / (float)2;
                VAFIndex.this.getCatalogue().getIndexStatistics().update(VAFIndex.this.getName(), new IndexStatistic(VAFIndex.FILTER_EFFICIENCY_CACHE_KEY, String.valueOf(avg), 0L, 4, null));
            }
        }

        @Override
        @NotNull
        public float[] costFor-7eHliGg(@NotNull Predicate predicate) {
            float[] fArray;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof ProximityPredicate)) {
                return Cost.Companion.getINVALID-7CRCzCo();
            }
            if (!Intrinsics.areEqual((Object)((ProximityPredicate)predicate).getColumn().getPhysical(), this.getColumns()[0])) {
                return Cost.Companion.getINVALID-7CRCzCo();
            }
            if (!(((ProximityPredicate)predicate).getDistance() instanceof MinkowskiDistance)) {
                return Cost.Companion.getINVALID-7CRCzCo();
            }
            float efficiency = this.getEfficiency$cottontaildb_dbms();
            long signatureRead = this.count();
            float fullRead = (1.0f - efficiency) * (float)signatureRead;
            ProximityPredicate proximityPredicate = (ProximityPredicate)predicate;
            if (proximityPredicate instanceof ProximityPredicate.Scan) {
                fArray = Cost.Companion.getINVALID-7CRCzCo();
            } else if (proximityPredicate instanceof ProximityPredicate.ENN) {
                fArray = Cost.constructor-impl$default((float)(Cost.getIo-impl((float[])Cost.Companion.getDISK_ACCESS_READ_SEQUENTIAL-7CRCzCo()) * (float)this.getColumns()[0].getType().getLogicalSize() * (float)signatureRead + Cost.getIo-impl((float[])Cost.Companion.getDISK_ACCESS_READ_SEQUENTIAL-7CRCzCo()) * (float)this.getColumns()[0].getType().getPhysicalSize() * fullRead), (float)((Cost.getMemory-impl((float[])Cost.Companion.getMEMORY_ACCESS-7CRCzCo()) * 2.0f + Cost.getCpu-impl((float[])Cost.Companion.getFLOP-7CRCzCo())) * (float)this.getColumns()[0].getType().getLogicalSize() * (float)signatureRead + Cost.getCpu-impl((float[])predicate.getCost-7CRCzCo()) * fullRead), (float)0.0f, (float)0.0f, (int)12, null);
            } else if (proximityPredicate instanceof ProximityPredicate.KLimitedSearch) {
                fArray = Cost.constructor-impl$default((float)(Cost.getIo-impl((float[])Cost.Companion.getDISK_ACCESS_READ_SEQUENTIAL-7CRCzCo()) * (float)this.getColumns()[0].getType().getLogicalSize() * (float)signatureRead + Cost.getIo-impl((float[])Cost.Companion.getDISK_ACCESS_READ_SEQUENTIAL-7CRCzCo()) * (float)this.getColumns()[0].getType().getPhysicalSize() * fullRead), (float)((Cost.getMemory-impl((float[])Cost.Companion.getMEMORY_ACCESS-7CRCzCo()) * 2.0f + Cost.getCpu-impl((float[])Cost.Companion.getFLOP-7CRCzCo())) * (float)this.getColumns()[0].getType().getLogicalSize() * (float)signatureRead + Cost.getCpu-impl((float[])predicate.getCost-7CRCzCo()) * fullRead), (float)((float)(16 + this.getColumns()[0].getType().getPhysicalSize()) * (float)((ProximityPredicate.KLimitedSearch)predicate).getK()), (float)0.0f, (int)8, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return fArray;
        }

        @Override
        @NotNull
        public List<ColumnDef<?>> columnsFor(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof ProximityPredicate)) {
                boolean bl = false;
                String string = "VAFIndex can only process proximity predicates.";
                throw new IllegalArgumentException(string.toString());
            }
            Object[] objectArray = new ColumnDef[]{((ProximityPredicate)predicate).getDistanceColumn().getColumn(), this.getColumns()[0]};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public boolean canProcess(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof ProximityPredicate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((ProximityPredicate)predicate).getColumn().getPhysical(), this.getColumns()[0])) {
                return false;
            }
            if (!(((ProximityPredicate)predicate).getDistance() instanceof MinkowskiDistance)) {
                return false;
            }
            return predicate instanceof ProximityPredicate.KLimitedSearch || predicate instanceof ProximityPredicate.ENN;
        }

        @Override
        @NotNull
        public Map<TraitType<?>, Trait> traitsFor(@NotNull Predicate predicate) {
            Map map2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Predicate predicate2 = predicate;
            if (predicate2 instanceof ProximityPredicate.ENN) {
                map2 = MapsKt.emptyMap();
            } else if (predicate2 instanceof ProximityPredicate.NNS) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)OrderTrait.Companion, (Object)new OrderTrait(CollectionsKt.listOf((Object)TuplesKt.to((Object)((ProximityPredicate.NNS)predicate).getDistanceColumn(), (Object)SortOrder.ASCENDING)))), TuplesKt.to((Object)LimitTrait.Companion, (Object)new LimitTrait(((ProximityPredicate.NNS)predicate).getK()))};
                map2 = MapsKt.mutableMapOf((Pair[])pairArray);
            } else if (predicate2 instanceof ProximityPredicate.FNS) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)OrderTrait.Companion, (Object)new OrderTrait(CollectionsKt.listOf((Object)TuplesKt.to((Object)((ProximityPredicate.FNS)predicate).getDistanceColumn(), (Object)SortOrder.DESCENDING)))), TuplesKt.to((Object)LimitTrait.Companion, (Object)new LimitTrait(((ProximityPredicate.FNS)predicate).getK()))};
                map2 = MapsKt.mutableMapOf((Pair[])pairArray);
            } else {
                throw new IllegalArgumentException("Unsupported predicate for high-dimensional index. This is a programmer's error!");
            }
            return map2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                l = this.dataStore.count(this.getContext().getTxn().getXodusTx());
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Insert event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Value value = event.getData().get(this.getColumns()[0]);
            if (value == null) {
                return true;
            }
            Value value2 = value;
            byte[] sig = this.getMarks$cottontaildb_dbms().getSignature-lsqBzE4((RealVectorValue)value2);
            return this.dataStore.add(this.getContext().getTxn().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(event.getTupleId()), VAFSignature.toEntry-impl(sig));
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Update event) {
            boolean bl;
            Value newValue;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Pair<Value, Value> pair = event.getData().get(this.getColumns()[0]);
            Value oldValue = pair != null ? (Value)pair.getFirst() : null;
            Pair<Value, Value> pair2 = event.getData().get(this.getColumns()[0]);
            Object object = newValue = pair2 != null ? (Value)pair2.getSecond() : null;
            if (newValue instanceof RealVectorValue) {
                byte[] newSig = this.getMarks$cottontaildb_dbms().getSignature-lsqBzE4((RealVectorValue)newValue);
                bl = this.dataStore.put(this.getContext().getTxn().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(event.getTupleId()), VAFSignature.toEntry-impl(newSig));
            } else {
                bl = oldValue instanceof RealVectorValue ? this.dataStore.delete(this.getContext().getTxn().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(event.getTupleId())) : true;
            }
            return bl;
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Delete event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return event.getData().get(this.getColumns()[0]) == null || this.dataStore.delete(this.getContext().getTxn().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(event.getTupleId()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Cursor<Tuple> filter(@NotNull Predicate predicate) {
            Cursor<Tuple> cursor;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            VAFIndex vAFIndex = VAFIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                EntityTx entityTx = vAFIndex.getParent().newTx(this.getContext());
                cursor = this.filter(predicate, new LongRange(entityTx.smallestTupleId(), entityTx.largestTupleId()));
            }
            finally {
                lock2.unlock();
            }
            return cursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Cursor<Tuple> filter(@NotNull Predicate predicate, @NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                Cursor cursor;
                boolean bl = false;
                Predicate predicate2 = predicate;
                if (predicate2 instanceof ProximityPredicate.ENN) {
                    cursor = new VAFCursor.ENN(partition, (ProximityPredicate.ENN)predicate, this);
                } else if (predicate2 instanceof ProximityPredicate.FNS) {
                    cursor = new VAFCursor.FNS(partition, (ProximityPredicate.FNS)predicate, this);
                } else if (predicate2 instanceof ProximityPredicate.NNS) {
                    cursor = new VAFCursor.NNS(partition, (ProximityPredicate.NNS)predicate, this);
                } else {
                    throw new IllegalArgumentException(" VAFIndex can only be used with a NNS, FNS or ENS type proximity predicate. This is a programmer's error!");
                }
                Cursor cursor2 = cursor;
                return cursor2;
            }
            finally {
                lock2.unlock();
            }
        }
    }
}

