/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.queries;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.queries.planning.cost.CostPolicy;
import org.vitrivr.cottontail.dbms.index.basic.Index;
import org.vitrivr.cottontail.dbms.index.basic.IndexType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/QueryHint;", "", "CostPolicy", "IndexHint", "NoOptimisation", "Parallelism", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint$CostPolicy;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint$NoOptimisation;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint$Parallelism;", "cottontaildb-dbms"})
public interface QueryHint {

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003JE\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0014\u0010\t\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\b\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/QueryHint$CostPolicy;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint;", "Lorg/vitrivr/cottontail/core/queries/planning/cost/CostPolicy;", "wio", "", "wcpu", "wmemory", "waccuracy", "speedupPerWorker", "parallelisableIO", "(FFFFFF)V", "getParallelisableIO", "()F", "getSpeedupPerWorker", "getWaccuracy", "getWcpu", "getWio", "getWmemory", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nQueryHint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryHint.kt\norg/vitrivr/cottontail/dbms/queries/QueryHint$CostPolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
    public static final class CostPolicy
    implements QueryHint,
    org.vitrivr.cottontail.core.queries.planning.cost.CostPolicy {
        private final float wio;
        private final float wcpu;
        private final float wmemory;
        private final float waccuracy;
        private final float speedupPerWorker;
        private final float parallelisableIO;

        public CostPolicy(float wio, float wcpu, float wmemory, float waccuracy, float speedupPerWorker, float parallelisableIO) {
            this.wio = wio;
            this.wcpu = wcpu;
            this.wmemory = wmemory;
            this.waccuracy = waccuracy;
            this.speedupPerWorker = speedupPerWorker;
            this.parallelisableIO = parallelisableIO;
            float f = this.getWio();
            if (!(0.0f <= f ? f <= 1.0f : false)) {
                boolean $i$a$-require-QueryHint$CostPolicy$72 = false;
                String $i$a$-require-QueryHint$CostPolicy$72 = "The IO weight must lie between 0.0 and 1.0 bit is " + this.getSpeedupPerWorker() + ".";
                throw new IllegalArgumentException($i$a$-require-QueryHint$CostPolicy$72.toString());
            }
            f = this.getWcpu();
            if (!(0.0f <= f ? f <= 1.0f : false)) {
                boolean $i$a$-require-QueryHint$CostPolicy$82 = false;
                String $i$a$-require-QueryHint$CostPolicy$82 = "The CPU weight must lie between 0.0 and 1.0 bit is " + this.getSpeedupPerWorker() + ".";
                throw new IllegalArgumentException($i$a$-require-QueryHint$CostPolicy$82.toString());
            }
            f = this.getWmemory();
            if (!(0.0f <= f ? f <= 1.0f : false)) {
                boolean $i$a$-require-QueryHint$CostPolicy$92 = false;
                String $i$a$-require-QueryHint$CostPolicy$92 = "The Memory weight must lie between 0.0 and 1.0 bit is " + this.getSpeedupPerWorker() + ".";
                throw new IllegalArgumentException($i$a$-require-QueryHint$CostPolicy$92.toString());
            }
            f = this.getWaccuracy();
            if (!(0.0f <= f ? f <= 1.0f : false)) {
                boolean $i$a$-require-QueryHint$CostPolicy$102 = false;
                String $i$a$-require-QueryHint$CostPolicy$102 = "The quality weight must lie between 0.0 and 1.0 bit is " + this.getSpeedupPerWorker() + ".";
                throw new IllegalArgumentException($i$a$-require-QueryHint$CostPolicy$102.toString());
            }
            f = this.getSpeedupPerWorker();
            if (!(0.0f <= f ? f <= 1.0f : false)) {
                boolean $i$a$-require-QueryHint$CostPolicy$112 = false;
                String $i$a$-require-QueryHint$CostPolicy$112 = "The speedup per worker must lie between 0.0 and 1.0 bit is " + this.getSpeedupPerWorker() + ".";
                throw new IllegalArgumentException($i$a$-require-QueryHint$CostPolicy$112.toString());
            }
            f = this.getParallelisableIO();
            if (!(0.0f <= f ? f <= 1.0f : false)) {
                boolean bl = false;
                String string = "The fraction of non-parallelisable IO must lie between 0.0 and 1.0 bit is " + this.getParallelisableIO() + ".";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public float getWio() {
            return this.wio;
        }

        public float getWcpu() {
            return this.wcpu;
        }

        public float getWmemory() {
            return this.wmemory;
        }

        public float getWaccuracy() {
            return this.waccuracy;
        }

        public float getSpeedupPerWorker() {
            return this.speedupPerWorker;
        }

        public float getParallelisableIO() {
            return this.parallelisableIO;
        }

        public int compare-YdeoP3g(@NotNull float[] o1, @NotNull float[] o2) {
            return CostPolicy.DefaultImpls.compare-YdeoP3g((org.vitrivr.cottontail.core.queries.planning.cost.CostPolicy)this, (float[])o1, (float[])o2);
        }

        public int parallelisation-PaPxd9I(@NotNull float[] parallelisableCost, @NotNull float[] totalCost, int pmax) {
            return CostPolicy.DefaultImpls.parallelisation-PaPxd9I((org.vitrivr.cottontail.core.queries.planning.cost.CostPolicy)this, (float[])parallelisableCost, (float[])totalCost, (int)pmax);
        }

        public float toScore-YO3HipE(@NotNull float[] cost2) {
            return CostPolicy.DefaultImpls.toScore-YO3HipE((org.vitrivr.cottontail.core.queries.planning.cost.CostPolicy)this, (float[])cost2);
        }

        public final float component1() {
            return this.wio;
        }

        public final float component2() {
            return this.wcpu;
        }

        public final float component3() {
            return this.wmemory;
        }

        public final float component4() {
            return this.waccuracy;
        }

        public final float component5() {
            return this.speedupPerWorker;
        }

        public final float component6() {
            return this.parallelisableIO;
        }

        @NotNull
        public final CostPolicy copy(float wio, float wcpu, float wmemory, float waccuracy, float speedupPerWorker, float parallelisableIO) {
            return new CostPolicy(wio, wcpu, wmemory, waccuracy, speedupPerWorker, parallelisableIO);
        }

        public static /* synthetic */ CostPolicy copy$default(CostPolicy costPolicy, float f, float f2, float f3, float f4, float f5, float f6, int n, Object object) {
            if ((n & 1) != 0) {
                f = costPolicy.wio;
            }
            if ((n & 2) != 0) {
                f2 = costPolicy.wcpu;
            }
            if ((n & 4) != 0) {
                f3 = costPolicy.wmemory;
            }
            if ((n & 8) != 0) {
                f4 = costPolicy.waccuracy;
            }
            if ((n & 0x10) != 0) {
                f5 = costPolicy.speedupPerWorker;
            }
            if ((n & 0x20) != 0) {
                f6 = costPolicy.parallelisableIO;
            }
            return costPolicy.copy(f, f2, f3, f4, f5, f6);
        }

        @NotNull
        public String toString() {
            return "CostPolicy(wio=" + this.wio + ", wcpu=" + this.wcpu + ", wmemory=" + this.wmemory + ", waccuracy=" + this.waccuracy + ", speedupPerWorker=" + this.speedupPerWorker + ", parallelisableIO=" + this.parallelisableIO + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.wio);
            result = result * 31 + Float.hashCode(this.wcpu);
            result = result * 31 + Float.hashCode(this.wmemory);
            result = result * 31 + Float.hashCode(this.waccuracy);
            result = result * 31 + Float.hashCode(this.speedupPerWorker);
            result = result * 31 + Float.hashCode(this.parallelisableIO);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CostPolicy)) {
                return false;
            }
            CostPolicy costPolicy = (CostPolicy)other;
            if (Float.compare(this.wio, costPolicy.wio) != 0) {
                return false;
            }
            if (Float.compare(this.wcpu, costPolicy.wcpu) != 0) {
                return false;
            }
            if (Float.compare(this.wmemory, costPolicy.wmemory) != 0) {
                return false;
            }
            if (Float.compare(this.waccuracy, costPolicy.waccuracy) != 0) {
                return false;
            }
            if (Float.compare(this.speedupPerWorker, costPolicy.speedupPerWorker) != 0) {
                return false;
            }
            return Float.compare(this.parallelisableIO, costPolicy.parallelisableIO) == 0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0006\u0007\b\tJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u0082\u0001\u0004\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint;", "matches", "", "index", "Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "All", "Name", "None", "Type", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint$All;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint$Name;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint$None;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint$Type;", "cottontaildb-dbms"})
    public static interface IndexHint
    extends QueryHint {
        public boolean matches(@NotNull Index var1);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint$All;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint;", "()V", "matches", "", "index", "Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "cottontaildb-dbms"})
        public static final class All
        implements IndexHint {
            @NotNull
            public static final All INSTANCE = new All();

            private All() {
            }

            @Override
            public boolean matches(@NotNull Index index) {
                Intrinsics.checkNotNullParameter((Object)index, (String)"index");
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint$Name;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "matches", "index", "Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "toString", "cottontaildb-dbms"})
        public static final class Name
        implements IndexHint {
            @NotNull
            private final String name;

            public Name(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.name = name;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Override
            public boolean matches(@NotNull Index index) {
                Intrinsics.checkNotNullParameter((Object)index, (String)"index");
                return Intrinsics.areEqual((Object)index.getName().getSimple(), (Object)this.name);
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final Name copy(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new Name(name);
            }

            public static /* synthetic */ Name copy$default(Name name, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = name.name;
                }
                return name.copy(string);
            }

            @NotNull
            public String toString() {
                return "Name(name=" + this.name + ")";
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Name)) {
                    return false;
                }
                Name name = (Name)other;
                return Intrinsics.areEqual((Object)this.name, (Object)name.name);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint$None;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint;", "()V", "matches", "", "index", "Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "cottontaildb-dbms"})
        public static final class None
        implements IndexHint {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
            }

            @Override
            public boolean matches(@NotNull Index index) {
                Intrinsics.checkNotNullParameter((Object)index, (String)"index");
                return false;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint$Type;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint$IndexHint;", "type", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "(Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;)V", "getType", "()Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "matches", "index", "Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "toString", "", "cottontaildb-dbms"})
        public static final class Type
        implements IndexHint {
            @NotNull
            private final IndexType type;

            public Type(@NotNull IndexType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                this.type = type;
            }

            @NotNull
            public final IndexType getType() {
                return this.type;
            }

            @Override
            public boolean matches(@NotNull Index index) {
                Intrinsics.checkNotNullParameter((Object)index, (String)"index");
                return index.getType() == this.type;
            }

            @NotNull
            public final IndexType component1() {
                return this.type;
            }

            @NotNull
            public final Type copy(@NotNull IndexType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return new Type(type);
            }

            public static /* synthetic */ Type copy$default(Type type, IndexType indexType, int n, Object object) {
                if ((n & 1) != 0) {
                    indexType = type.type;
                }
                return type.copy(indexType);
            }

            @NotNull
            public String toString() {
                return "Type(type=" + this.type + ")";
            }

            public int hashCode() {
                return this.type.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Type)) {
                    return false;
                }
                Type type = (Type)other;
                return this.type == type.type;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/QueryHint$NoOptimisation;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint;", "()V", "cottontaildb-dbms"})
    public static final class NoOptimisation
    implements QueryHint {
        @NotNull
        public static final NoOptimisation INSTANCE = new NoOptimisation();

        private NoOptimisation() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/QueryHint$Parallelism;", "Lorg/vitrivr/cottontail/dbms/queries/QueryHint;", "max", "", "(I)V", "getMax", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "cottontaildb-dbms"})
    public static final class Parallelism
    implements QueryHint {
        private final int max;

        public Parallelism(int max) {
            this.max = max;
        }

        public final int getMax() {
            return this.max;
        }

        public final int component1() {
            return this.max;
        }

        @NotNull
        public final Parallelism copy(int max) {
            return new Parallelism(max);
        }

        public static /* synthetic */ Parallelism copy$default(Parallelism parallelism, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = parallelism.max;
            }
            return parallelism.copy(n);
        }

        @NotNull
        public String toString() {
            return "Parallelism(max=" + this.max + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.max);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parallelism)) {
                return false;
            }
            Parallelism parallelism = (Parallelism)other;
            return this.max == parallelism.max;
        }
    }
}

