/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.dbms.statistics.values.AbstractValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.BooleanValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.BooleanVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ByteValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.Complex32ValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.Complex32VectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.Complex64ValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.Complex64VectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.DateValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.DoubleValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.DoubleVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.FloatValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.FloatVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.IntValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.IntVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.LongValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.LongVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ShortValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ShortVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.StringValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.UuidValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ValueStatistics;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u0006\u0012\u0002\b\u00030\u0004\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0007\u00a8\u0006\t"}, d2={"defaultStatistics", "Lorg/vitrivr/cottontail/dbms/statistics/values/ValueStatistics;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "Lorg/vitrivr/cottontail/core/types/Types;", "estimateTupleSize", "", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nStatisticsUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsUtilities.kt\norg/vitrivr/cottontail/dbms/statistics/StatisticsUtilitiesKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,52:1\n125#2:53\n152#2,3:54\n*S KotlinDebug\n*F\n+ 1 StatisticsUtilities.kt\norg/vitrivr/cottontail/dbms/statistics/StatisticsUtilitiesKt\n*L\n15#1:53\n15#1:54,3\n*E\n"})
public final class StatisticsUtilitiesKt {
    /*
     * WARNING - void declaration
     */
    public static final int estimateTupleSize(@NotNull Map<ColumnDef<?>, ? extends ValueStatistics<?>> $this$estimateTupleSize) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$estimateTupleSize, (String)"<this>");
        Map<ColumnDef<?>, ValueStatistics<?>> $this$map$iv = $this$estimateTupleSize;
        boolean $i$f$map = false;
        Map<ColumnDef<?>, ValueStatistics<?>> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Types type = ((ColumnDef)it.getKey()).getType();
            collection.add(Intrinsics.areEqual((Object)type, (Object)Types.String.INSTANCE) ? RangesKt.coerceAtLeast((int)((ValueStatistics)it.getValue()).getAvgWidth(), (int)1) * 2 : (Intrinsics.areEqual((Object)type, (Object)Types.ByteString.INSTANCE) ? RangesKt.coerceAtLeast((int)((ValueStatistics)it.getValue()).getAvgWidth(), (int)1) : type.getPhysicalSize()));
        }
        return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final <T extends Value> ValueStatistics<T> defaultStatistics(@NotNull Types<?> $this$defaultStatistics) {
        AbstractValueStatistics abstractValueStatistics;
        Intrinsics.checkNotNullParameter($this$defaultStatistics, (String)"<this>");
        Types<?> types = $this$defaultStatistics;
        if (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE)) {
            abstractValueStatistics = new BooleanValueStatistics(0L, 0L, 0L, 0L, 0L, 31, null);
        } else if (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
            abstractValueStatistics = new ByteValueStatistics(0L, 0L, 0L, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE)) {
            abstractValueStatistics = new ShortValueStatistics(0L, 0L, 0L, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE)) {
            abstractValueStatistics = new IntValueStatistics(0L, 0L, 0L, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) {
            abstractValueStatistics = new LongValueStatistics(0L, 0L, 0L, 0L, 0L, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE)) {
            abstractValueStatistics = new FloatValueStatistics(0L, 0L, 0L, 0.0f, 0.0f, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE)) {
            abstractValueStatistics = new DoubleValueStatistics(0L, 0L, 0L, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE)) {
            abstractValueStatistics = new Complex32ValueStatistics(0L, 0L, 0L, 7, null);
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE)) {
            abstractValueStatistics = new Complex64ValueStatistics(0L, 0L, 0L, 7, null);
        } else if (Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) {
            abstractValueStatistics = new DateValueStatistics(0L, 0L, 0L, 0L, 0L, 31, null);
        } else if (Intrinsics.areEqual(types, (Object)Types.ByteString.INSTANCE)) {
            abstractValueStatistics = new ByteValueStatistics(0L, 0L, 0L, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual(types, (Object)Types.String.INSTANCE)) {
            abstractValueStatistics = new StringValueStatistics(0L, 0L, 0L, 0, 0, 31, null);
        } else if (Intrinsics.areEqual(types, (Object)Types.Uuid.INSTANCE)) {
            abstractValueStatistics = new UuidValueStatistics(0L, 0L, 0L, 7, null);
        } else if (types instanceof Types.BooleanVector) {
            abstractValueStatistics = new BooleanVectorValueStatistics($this$defaultStatistics.getLogicalSize(), 0L, 0L, 0L, null, 30, null);
        } else if (types instanceof Types.IntVector) {
            abstractValueStatistics = new IntVectorValueStatistics($this$defaultStatistics.getLogicalSize(), 0L, 0L, 0L, null, null, null, 126, null);
        } else if (types instanceof Types.LongVector) {
            abstractValueStatistics = new LongVectorValueStatistics($this$defaultStatistics.getLogicalSize(), 0L, 0L, 0L, null, null, null, 126, null);
        } else if (types instanceof Types.HalfVector ? true : types instanceof Types.FloatVector) {
            abstractValueStatistics = new FloatVectorValueStatistics($this$defaultStatistics.getLogicalSize(), 0L, 0L, 0L, null, null, null, 126, null);
        } else if (types instanceof Types.DoubleVector) {
            abstractValueStatistics = new DoubleVectorValueStatistics($this$defaultStatistics.getLogicalSize(), 0L, 0L, 0L, null, null, null, 126, null);
        } else if (types instanceof Types.Complex32Vector) {
            abstractValueStatistics = new Complex32VectorValueStatistics($this$defaultStatistics.getLogicalSize(), 0L, 0L, 0L, 14, null);
        } else if (types instanceof Types.Complex64Vector) {
            abstractValueStatistics = new Complex64VectorValueStatistics($this$defaultStatistics.getLogicalSize(), 0L, 0L, 0L, 14, null);
        } else if (types instanceof Types.ShortVector) {
            abstractValueStatistics = new ShortVectorValueStatistics($this$defaultStatistics.getLogicalSize(), 0L, 0L, 0L, null, null, null, 126, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return abstractValueStatistics;
    }
}

