/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.collectors;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsConfig;
import org.vitrivr.cottontail.dbms.statistics.values.ValueStatistics;
import org.vitrivr.cottontail.utilities.hashing.ValueFunnel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\b\u0004\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH&J\u0017\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010#R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u0082\u0001\u0002$%\u00a8\u0006&"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/collectors/AbstractMetricsCollector;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsCollector;", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "config", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;", "(Lorg/vitrivr/cottontail/core/types/Types;Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;)V", "bloomFilter", "Lcom/google/common/hash/BloomFilter;", "getConfig", "()Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;", "expectedElements", "", "numberOfDistinctEntries", "getNumberOfDistinctEntries", "()J", "setNumberOfDistinctEntries", "(J)V", "numberOfNonNullEntries", "getNumberOfNonNullEntries", "setNumberOfNonNullEntries", "numberOfNullEntries", "getNumberOfNullEntries", "setNumberOfNullEntries", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "calculate", "Lorg/vitrivr/cottontail/dbms/statistics/values/ValueStatistics;", "probability", "", "receive", "", "value", "(Lorg/vitrivr/cottontail/core/types/Value;)V", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/AbstractScalarMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/AbstractVectorMetricsCollector;", "cottontaildb-dbms"})
public abstract class AbstractMetricsCollector<T extends Value>
implements MetricsCollector<T> {
    @NotNull
    private final Types<T> type;
    @NotNull
    private final MetricsConfig config;
    private final long expectedElements;
    @NotNull
    private final BloomFilter<Value> bloomFilter;
    private long numberOfDistinctEntries;
    private long numberOfNonNullEntries;
    private long numberOfNullEntries;

    private AbstractMetricsCollector(Types<T> type, MetricsConfig config) {
        this.type = type;
        this.config = config;
        this.expectedElements = Math.max(this.config.getExpectedNumElements(), 50000L);
        BloomFilter bloomFilter = BloomFilter.create((Funnel)((Funnel)ValueFunnel.INSTANCE), (long)this.expectedElements, (double)this.config.getStatisticsConfig().getFalsePositiveProbability());
        Intrinsics.checkNotNullExpressionValue((Object)bloomFilter, (String)"create(...)");
        this.bloomFilter = bloomFilter;
    }

    @Override
    @NotNull
    public final Types<T> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public final MetricsConfig getConfig() {
        return this.config;
    }

    @Override
    public long getNumberOfDistinctEntries() {
        return this.numberOfDistinctEntries;
    }

    @Override
    public void setNumberOfDistinctEntries(long l) {
        this.numberOfDistinctEntries = l;
    }

    @Override
    public long getNumberOfNonNullEntries() {
        return this.numberOfNonNullEntries;
    }

    @Override
    public void setNumberOfNonNullEntries(long l) {
        this.numberOfNonNullEntries = l;
    }

    @Override
    public long getNumberOfNullEntries() {
        return this.numberOfNullEntries;
    }

    @Override
    public void setNumberOfNullEntries(long l) {
        this.numberOfNullEntries = l;
    }

    @Override
    public void receive(@Nullable T value) {
        if (value != null) {
            this.setNumberOfNonNullEntries(this.getNumberOfNonNullEntries() + 1L);
            if (this.bloomFilter.put(value)) {
                this.setNumberOfDistinctEntries(this.getNumberOfDistinctEntries() + 1L);
            }
        } else {
            this.setNumberOfNullEntries(this.getNumberOfNullEntries() + 1L);
        }
    }

    @Override
    @NotNull
    public abstract ValueStatistics<T> calculate(float var1);

    public /* synthetic */ AbstractMetricsCollector(Types type, MetricsConfig config, DefaultConstructorMarker $constructor_marker) {
        this(type, config);
    }
}

