/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.collectors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.BooleanVectorValue;
import org.vitrivr.cottontail.dbms.statistics.collectors.AbstractVectorMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsConfig;
import org.vitrivr.cottontail.dbms.statistics.values.BooleanVectorValueStatistics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/collectors/BooleanVectorMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/AbstractVectorMetricsCollector;", "Lorg/vitrivr/cottontail/core/values/BooleanVectorValue;", "logicalSize", "", "config", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;", "(ILorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;)V", "getLogicalSize", "()I", "numberOfTrueEntries", "", "calculate", "Lorg/vitrivr/cottontail/dbms/statistics/values/BooleanVectorValueStatistics;", "probability", "", "receive", "", "value", "receive-cmzpXVc", "([Z)V", "cottontaildb-dbms"})
public final class BooleanVectorMetricsCollector
extends AbstractVectorMetricsCollector<BooleanVectorValue> {
    private final int logicalSize;
    @NotNull
    private long[] numberOfTrueEntries;

    public BooleanVectorMetricsCollector(int logicalSize, @NotNull MetricsConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super((Types)new Types.BooleanVector(logicalSize), config, null);
        this.logicalSize = logicalSize;
        this.numberOfTrueEntries = new long[this.logicalSize];
    }

    public final int getLogicalSize() {
        return this.logicalSize;
    }

    public void receive-cmzpXVc(@Nullable boolean[] value) {
        super.receive(value != null ? BooleanVectorValue.box-impl((boolean[])value) : null);
        if (value != null) {
            boolean[] blArray = value;
            int n = blArray.length;
            for (int j = 0; j < n; ++j) {
                int i2 = j;
                boolean d = blArray[j];
                if (!d) continue;
                this.numberOfTrueEntries[i2] = this.numberOfTrueEntries[i2] + 1L;
            }
        }
    }

    @NotNull
    public BooleanVectorValueStatistics calculate(float probability) {
        BooleanVectorValueStatistics sampleMetrics = new BooleanVectorValueStatistics(this.logicalSize, this.getNumberOfNullEntries(), this.getNumberOfNonNullEntries(), this.getNumberOfDistinctEntries(), this.numberOfTrueEntries);
        return new BooleanVectorValueStatistics(1.0f / probability, sampleMetrics);
    }
}

