/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.collectors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.ByteStringValue;
import org.vitrivr.cottontail.dbms.statistics.collectors.AbstractScalarMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsConfig;
import org.vitrivr.cottontail.dbms.statistics.values.ByteStringValueStatistics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/collectors/ByteStringMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/AbstractScalarMetricsCollector;", "Lorg/vitrivr/cottontail/core/values/ByteStringValue;", "config", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;", "(Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;)V", "maxWidth", "", "getMaxWidth", "()I", "setMaxWidth", "(I)V", "minWidth", "getMinWidth", "setMinWidth", "calculate", "Lorg/vitrivr/cottontail/dbms/statistics/values/ByteStringValueStatistics;", "probability", "", "receive", "", "value", "receive-OETQ4ME", "([B)V", "cottontaildb-dbms"})
public final class ByteStringMetricsCollector
extends AbstractScalarMetricsCollector<ByteStringValue> {
    private int minWidth;
    private int maxWidth;

    public ByteStringMetricsCollector(@NotNull MetricsConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super((Types)Types.ByteString.INSTANCE, config, null);
        this.minWidth = Integer.MAX_VALUE;
        this.maxWidth = Integer.MIN_VALUE;
    }

    public final int getMinWidth() {
        return this.minWidth;
    }

    public final void setMinWidth(int n) {
        this.minWidth = n;
    }

    public final int getMaxWidth() {
        return this.maxWidth;
    }

    public final void setMaxWidth(int n) {
        this.maxWidth = n;
    }

    public void receive-OETQ4ME(@Nullable byte[] value) {
        super.receive(value != null ? ByteStringValue.box-impl((byte[])value) : null);
        if (value != null) {
            this.minWidth = Integer.min(ByteStringValue.getLogicalSize-impl((byte[])value), this.minWidth);
            this.maxWidth = Integer.max(ByteStringValue.getLogicalSize-impl((byte[])value), this.maxWidth);
        }
    }

    @NotNull
    public ByteStringValueStatistics calculate(float probability) {
        ByteStringValueStatistics sampleMetrics = new ByteStringValueStatistics(this.getNumberOfNullEntries(), this.getNumberOfNonNullEntries(), this.getNumberOfDistinctEntries(), this.minWidth, this.maxWidth);
        return new ByteStringValueStatistics(1.0f / probability, sampleMetrics);
    }
}

