/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.collectors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.DateValue;
import org.vitrivr.cottontail.dbms.statistics.collectors.AbstractScalarMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsConfig;
import org.vitrivr.cottontail.dbms.statistics.values.DateValueStatistics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/collectors/DateMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/AbstractScalarMetricsCollector;", "Lorg/vitrivr/cottontail/core/values/DateValue;", "config", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;", "(Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;)V", "max", "", "getMax", "()J", "setMax", "(J)V", "min", "getMin", "setMin", "calculate", "Lorg/vitrivr/cottontail/dbms/statistics/values/DateValueStatistics;", "probability", "", "receive", "", "value", "receive-knXx6ss", "cottontaildb-dbms"})
public final class DateMetricsCollector
extends AbstractScalarMetricsCollector<DateValue> {
    private long min;
    private long max;

    public DateMetricsCollector(@NotNull MetricsConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super((Types)Types.Date.INSTANCE, config, null);
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
    }

    public final long getMin() {
        return this.min;
    }

    public final void setMin(long l) {
        this.min = l;
    }

    public final long getMax() {
        return this.max;
    }

    public final void setMax(long l) {
        this.max = l;
    }

    public void receive-knXx6ss(@Nullable DateValue value) {
        super.receive((Value)value);
        if (value != null) {
            this.min = Long.min(value.unbox-impl(), this.min);
            this.max = Long.max(value.unbox-impl(), this.max);
        }
    }

    @NotNull
    public DateValueStatistics calculate(float probability) {
        DateValueStatistics sampleMetrics = new DateValueStatistics(this.getNumberOfNullEntries(), this.getNumberOfNonNullEntries(), this.getNumberOfDistinctEntries(), DateValue.constructor-impl((long)this.min), DateValue.constructor-impl((long)this.max), null);
        return new DateValueStatistics(1.0f / probability, sampleMetrics);
    }
}

