/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.index;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.statistics.index.IndexStatistic;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\b\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000fJ\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005J$\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0010J\u001e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/index/IndexStatisticsManager;", "", "environment", "Ljetbrains/exodus/env/Environment;", "transaction", "Ljetbrains/exodus/env/Transaction;", "(Ljetbrains/exodus/env/Environment;Ljetbrains/exodus/env/Transaction;)V", "dirty", "", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "statistics", "Lit/unimi/dsi/fastutil/objects/Object2ObjectLinkedOpenHashMap;", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "", "", "Lorg/vitrivr/cottontail/dbms/statistics/index/IndexStatistic;", "store", "Ljetbrains/exodus/env/Store;", "deletePersistently", "", "index", "get", "key", "getAll", "", "isDirty", "persist", "persistInTransaction", "update", "item", "updatePersistently", "Companion", "cottontaildb-dbms"})
public final class IndexStatisticsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Environment environment;
    @NotNull
    private final Object2ObjectLinkedOpenHashMap<Name.IndexName, Map<String, IndexStatistic>> statistics;
    @NotNull
    private final Store store;
    @NotNull
    private final ReentrantReadWriteLock lock;
    private volatile boolean dirty;
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexStatisticsManager.class);
    @NotNull
    private static final String INDEX_STATISTICS_STORE_NAME = "org.vitrivr.cottontail.statistics.index";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexStatisticsManager(@NotNull Environment environment, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.environment = environment;
        this.statistics = new Object2ObjectLinkedOpenHashMap();
        Store store = this.environment.openStore(INDEX_STATISTICS_STORE_NAME, StoreConfig.WITH_DUPLICATES_WITH_PREFIXING, transaction);
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"openStore(...)");
        this.store = store;
        this.lock = new ReentrantReadWriteLock();
        Closeable closeable = (Closeable)this.store.openCursor(transaction);
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)closeable;
            boolean bl = false;
            while (cursor.getNextNoDup()) {
                ByteIterable byteIterable = cursor.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getKey(...)");
                Name.IndexName name = NameBinding.Index.INSTANCE.fromEntry(byteIterable);
                Object2ObjectLinkedOpenHashMap map2 = new Object2ObjectLinkedOpenHashMap();
                do {
                    Comparable comparable = IndexStatistic.Companion.entryToObject(cursor.getValue());
                    Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.statistics.index.IndexStatistic");
                    IndexStatistic item = (IndexStatistic)comparable;
                    ((Map)map2).put(item.getKey(), item);
                } while (cursor.getNextDup());
                ((Map)this.statistics).put(name, map2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, IndexStatistic> getAll(@NotNull Name.IndexName index) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Map map3;
            Map map4;
            boolean bl = false;
            Map map5 = map4 = (Map)this.statistics.get((Object)index);
            if (map5 == null) {
                map3 = MapsKt.emptyMap();
            } else {
                Intrinsics.checkNotNull((Object)map5);
                map3 = map4;
            }
            map2 = map3;
        }
        finally {
            readLock.unlock();
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IndexStatistic get(@NotNull Name.IndexName index, @NotNull String key) {
        IndexStatistic indexStatistic;
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Map map2 = (Map)this.statistics.get((Object)index);
            indexStatistic = map2 != null ? (IndexStatistic)map2.get(key) : null;
        }
        finally {
            readLock.unlock();
        }
        return indexStatistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Map<String, IndexStatistic> update(@NotNull Name.IndexName index, @NotNull IndexStatistic item) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.dirty = true;
            map2 = (Map)this.statistics.compute((Object)index, (arg_0, arg_1) -> IndexStatisticsManager.update$lambda$4$lambda$3((Function2)new Function2<Name.IndexName, Map<String, IndexStatistic>, Map<String, IndexStatistic>>(item){
                final /* synthetic */ IndexStatistic $item;
                {
                    this.$item = $item;
                    super(2);
                }

                @Nullable
                public final Map<String, IndexStatistic> invoke(Name.IndexName indexName, @Nullable Map<String, IndexStatistic> v) {
                    Map map2 = v;
                    if (map2 == null) {
                        map2 = (Map)new Object2ObjectLinkedOpenHashMap();
                    }
                    Map map3 = map2;
                    map3.put(this.$item.getKey(), this.$item);
                    return map3;
                }
            }, arg_0, arg_1));
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updatePersistently(@NotNull Name.IndexName index, @NotNull IndexStatistic item, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.dirty = true;
            this.statistics.compute((Object)index, (arg_0, arg_1) -> IndexStatisticsManager.updatePersistently$lambda$6$lambda$5((Function2)new Function2<Name.IndexName, Map<String, IndexStatistic>, Map<String, IndexStatistic>>(item){
                final /* synthetic */ IndexStatistic $item;
                {
                    this.$item = $item;
                    super(2);
                }

                @Nullable
                public final Map<String, IndexStatistic> invoke(Name.IndexName indexName, @Nullable Map<String, IndexStatistic> v) {
                    Map map2 = v;
                    if (map2 == null) {
                        map2 = (Map)new Object2ObjectLinkedOpenHashMap();
                    }
                    Map map3 = map2;
                    map3.put(this.$item.getKey(), this.$item);
                    return map3;
                }
            }, arg_0, arg_1));
            this.store.put(transaction, NameBinding.Index.INSTANCE.toEntry(index), (ByteIterable)IndexStatistic.Companion.objectToEntry(item));
            this.dirty = false;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public final void deletePersistently(@NotNull Name.IndexName index, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.dirty = true;
        this.statistics.remove((Object)index);
        this.store.delete(transaction, NameBinding.Index.INSTANCE.toEntry(index));
        this.dirty = false;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void persist() {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            this.environment.executeInExclusiveTransaction(arg_0 -> IndexStatisticsManager.persist$lambda$8$lambda$7(this, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void persistInTransaction(@NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            for (Map.Entry entry : ((Map)this.statistics).entrySet()) {
                Name.IndexName index = (Name.IndexName)entry.getKey();
                Map statistics2 = (Map)entry.getValue();
                for (IndexStatistic item : statistics2.values()) {
                    Intrinsics.checkNotNull((Object)index);
                    this.store.put(transaction, NameBinding.Index.INSTANCE.toEntry(index), (ByteIterable)IndexStatistic.Companion.objectToEntry(item));
                }
            }
            this.dirty = false;
            LOGGER.debug("Index statistics persisted successfully!");
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    private static final Map update$lambda$4$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0, p1);
    }

    private static final Map updatePersistently$lambda$6$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0, p1);
    }

    private static final void persist$lambda$8$lambda$7(IndexStatisticsManager this$0, Transaction tx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        this$0.persistInTransaction(tx);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/index/IndexStatisticsManager$Companion;", "", "()V", "INDEX_STATISTICS_STORE_NAME", "", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

