/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.storage;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.util.ByteArraySizedInputStream;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.dbms.statistics.values.AbstractValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.BooleanValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.BooleanVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ByteStringValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ByteValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.Complex32ValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.Complex32VectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.Complex64ValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.Complex64VectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.DateValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.DoubleValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.DoubleVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.FloatValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.FloatVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.IntValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.IntVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.LongValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.LongVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ShortValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ShortVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.StringValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.UuidValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.values.ValueStatistics;
import org.vitrivr.cottontail.storage.serializers.SerializerFactory;
import org.vitrivr.cottontail.storage.serializers.statistics.MetricsXodusBinding;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0013\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0006H\u00c6\u0003J\r\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\bH\u00c6\u0003J%\u0010\u0010\u001a\u00020\u00002\f\b\u0002\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\b\u0002\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0015\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/storage/ColumnStatistic;", "", "def", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "(Lorg/vitrivr/cottontail/core/database/ColumnDef;)V", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "statistics", "Lorg/vitrivr/cottontail/dbms/statistics/values/ValueStatistics;", "(Lorg/vitrivr/cottontail/core/types/Types;Lorg/vitrivr/cottontail/dbms/statistics/values/ValueStatistics;)V", "getStatistics", "()Lorg/vitrivr/cottontail/dbms/statistics/values/ValueStatistics;", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "cottontaildb-dbms"})
public final class ColumnStatistic {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Types<?> type;
    @NotNull
    private final ValueStatistics<?> statistics;

    public ColumnStatistic(@NotNull Types<?> type, @NotNull ValueStatistics<?> statistics2) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(statistics2, (String)"statistics");
        this.type = type;
        this.statistics = statistics2;
    }

    @NotNull
    public final Types<?> getType() {
        return this.type;
    }

    @NotNull
    public final ValueStatistics<?> getStatistics() {
        return this.statistics;
    }

    public ColumnStatistic(@NotNull ColumnDef<?> def) {
        AbstractValueStatistics abstractValueStatistics;
        Types types;
        Intrinsics.checkNotNullParameter(def, (String)"def");
        Types types2 = types = def.getType();
        if (Intrinsics.areEqual((Object)types, (Object)Types.Boolean.INSTANCE)) {
            abstractValueStatistics = new BooleanValueStatistics(0L, 0L, 0L, 0L, 0L, 31, null);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Byte.INSTANCE)) {
            abstractValueStatistics = new ByteValueStatistics(0L, 0L, 0L, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Short.INSTANCE)) {
            abstractValueStatistics = new ShortValueStatistics(0L, 0L, 0L, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Date.INSTANCE)) {
            abstractValueStatistics = new DateValueStatistics(0L, 0L, 0L, 0L, 0L, 31, null);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Double.INSTANCE)) {
            abstractValueStatistics = new DoubleValueStatistics(0L, 0L, 0L, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Float.INSTANCE)) {
            abstractValueStatistics = new FloatValueStatistics(0L, 0L, 0L, 0.0f, 0.0f, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Int.INSTANCE)) {
            abstractValueStatistics = new IntValueStatistics(0L, 0L, 0L, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Long.INSTANCE)) {
            abstractValueStatistics = new LongValueStatistics(0L, 0L, 0L, 0L, 0L, 0.0, 0.0, 0.0, 0.0, 0.0, 1023, null);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.String.INSTANCE)) {
            abstractValueStatistics = new StringValueStatistics(0L, 0L, 0L, 0, 0, 31, null);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.ByteString.INSTANCE)) {
            abstractValueStatistics = new ByteStringValueStatistics(0L, 0L, 0L, 0, 0, 31, null);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Complex32.INSTANCE)) {
            abstractValueStatistics = new Complex32ValueStatistics(0L, 0L, 0L, 7, null);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Complex64.INSTANCE)) {
            abstractValueStatistics = new Complex64ValueStatistics(0L, 0L, 0L, 7, null);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Uuid.INSTANCE)) {
            abstractValueStatistics = new UuidValueStatistics(0L, 0L, 0L, 7, null);
        } else if (types instanceof Types.BooleanVector) {
            abstractValueStatistics = new BooleanVectorValueStatistics(def.getType().getLogicalSize(), 0L, 0L, 0L, null, 30, null);
        } else if (types instanceof Types.DoubleVector) {
            abstractValueStatistics = new DoubleVectorValueStatistics(def.getType().getLogicalSize(), 0L, 0L, 0L, null, null, null, 126, null);
        } else if (types instanceof Types.HalfVector ? true : types instanceof Types.FloatVector) {
            abstractValueStatistics = new FloatVectorValueStatistics(def.getType().getLogicalSize(), 0L, 0L, 0L, null, null, null, 126, null);
        } else if (types instanceof Types.IntVector) {
            abstractValueStatistics = new IntVectorValueStatistics(def.getType().getLogicalSize(), 0L, 0L, 0L, null, null, null, 126, null);
        } else if (types instanceof Types.LongVector) {
            abstractValueStatistics = new LongVectorValueStatistics(def.getType().getLogicalSize(), 0L, 0L, 0L, null, null, null, 126, null);
        } else if (types instanceof Types.Complex32Vector) {
            abstractValueStatistics = new Complex32VectorValueStatistics(def.getType().getLogicalSize(), 0L, 0L, 0L, 14, null);
        } else if (types instanceof Types.Complex64Vector) {
            abstractValueStatistics = new Complex64VectorValueStatistics(def.getType().getLogicalSize(), 0L, 0L, 0L, 14, null);
        } else if (types instanceof Types.ShortVector) {
            abstractValueStatistics = new ShortVectorValueStatistics(def.getType().getLogicalSize(), 0L, 0L, 0L, null, null, null, 126, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this(types2, abstractValueStatistics);
    }

    @NotNull
    public final Types<?> component1() {
        return this.type;
    }

    @NotNull
    public final ValueStatistics<?> component2() {
        return this.statistics;
    }

    @NotNull
    public final ColumnStatistic copy(@NotNull Types<?> type, @NotNull ValueStatistics<?> statistics2) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(statistics2, (String)"statistics");
        return new ColumnStatistic(type, statistics2);
    }

    public static /* synthetic */ ColumnStatistic copy$default(ColumnStatistic columnStatistic, Types types, ValueStatistics valueStatistics, int n, Object object) {
        if ((n & 1) != 0) {
            types = columnStatistic.type;
        }
        if ((n & 2) != 0) {
            valueStatistics = columnStatistic.statistics;
        }
        return columnStatistic.copy(types, valueStatistics);
    }

    @NotNull
    public String toString() {
        return "ColumnStatistic(type=" + this.type + ", statistics=" + this.statistics + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.statistics.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColumnStatistic)) {
            return false;
        }
        ColumnStatistic columnStatistic = (ColumnStatistic)other;
        if (!Intrinsics.areEqual(this.type, columnStatistic.type)) {
            return false;
        }
        return Intrinsics.areEqual(this.statistics, columnStatistic.statistics);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/storage/ColumnStatistic$Companion;", "", "()V", "entryToObject", "Lorg/vitrivr/cottontail/dbms/statistics/storage/ColumnStatistic;", "entry", "Ljetbrains/exodus/ByteIterable;", "objectToEntry", "Ljetbrains/exodus/ArrayByteIterable;", "object", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColumnStatistic entryToObject(@NotNull ByteIterable entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            ByteArraySizedInputStream stream = new ByteArraySizedInputStream(entry.getBytesUnsafe(), 0, entry.getLength());
            Types type = Types.Companion.forOrdinal(IntegerBinding.readCompressed((ByteArrayInputStream)((ByteArrayInputStream)stream)), IntegerBinding.readCompressed((ByteArrayInputStream)((ByteArrayInputStream)stream)));
            MetricsXodusBinding serializer2 = SerializerFactory.INSTANCE.metrics(type);
            return new ColumnStatistic(type, serializer2.read((ByteArrayInputStream)stream));
        }

        @NotNull
        public final ArrayByteIterable objectToEntry(@NotNull ColumnStatistic object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"object");
            LightOutputStream output = new LightOutputStream();
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)object.getType().getOrdinal());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)object.getType().getLogicalSize());
            MetricsXodusBinding<ValueStatistics<?>> metricsXodusBinding = SerializerFactory.INSTANCE.metrics(object.getType());
            Intrinsics.checkNotNull(metricsXodusBinding, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.storage.serializers.statistics.MetricsXodusBinding<org.vitrivr.cottontail.dbms.statistics.values.ValueStatistics<*>>");
            MetricsXodusBinding<ValueStatistics<?>> serializer2 = metricsXodusBinding;
            serializer2.write(output, object.getStatistics());
            ArrayByteIterable arrayByteIterable = output.asArrayByteIterable();
            Intrinsics.checkNotNullExpressionValue((Object)arrayByteIterable, (String)"asArrayByteIterable(...)");
            return arrayByteIterable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

