/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.values;

import java.io.ByteArrayInputStream;
import java.util.Map;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.BooleanValue;
import org.vitrivr.cottontail.dbms.statistics.values.AbstractScalarStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.MetricsXodusBinding;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002*+B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B7\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J;\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\bH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u001cH\u00d6\u0001R\u001a\u0010\n\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\t\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\u000b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011\u00a8\u0006,"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/BooleanValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/values/AbstractScalarStatistics;", "Lorg/vitrivr/cottontail/core/values/BooleanValue;", "factor", "", "metrics", "(FLorg/vitrivr/cottontail/dbms/statistics/values/BooleanValueStatistics;)V", "numberOfNullEntries", "", "numberOfNonNullEntries", "numberOfDistinctEntries", "numberOfTrueEntries", "numberOfFalseEntries", "(JJJJJ)V", "getNumberOfDistinctEntries", "()J", "setNumberOfDistinctEntries", "(J)V", "getNumberOfFalseEntries", "setNumberOfFalseEntries", "getNumberOfNonNullEntries", "setNumberOfNonNullEntries", "getNumberOfNullEntries", "setNumberOfNullEntries", "getNumberOfTrueEntries", "setNumberOfTrueEntries", "about", "", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Binding", "Companion", "cottontaildb-dbms"})
public final class BooleanValueStatistics
extends AbstractScalarStatistics<BooleanValue> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long numberOfNullEntries;
    private long numberOfNonNullEntries;
    private long numberOfDistinctEntries;
    private long numberOfTrueEntries;
    private long numberOfFalseEntries;
    @NotNull
    public static final String TRUE_ENTRIES_KEY = "true";
    @NotNull
    public static final String FALSE_ENTRIES_KEY = "false";

    public BooleanValueStatistics(long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries, long numberOfTrueEntries, long numberOfFalseEntries) {
        super((Types)Types.Boolean.INSTANCE, null);
        this.numberOfNullEntries = numberOfNullEntries;
        this.numberOfNonNullEntries = numberOfNonNullEntries;
        this.numberOfDistinctEntries = numberOfDistinctEntries;
        this.numberOfTrueEntries = numberOfTrueEntries;
        this.numberOfFalseEntries = numberOfFalseEntries;
    }

    public /* synthetic */ BooleanValueStatistics(long l, long l2, long l3, long l4, long l5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            l2 = 0L;
        }
        if ((n & 4) != 0) {
            l3 = 0L;
        }
        if ((n & 8) != 0) {
            l4 = 0L;
        }
        if ((n & 0x10) != 0) {
            l5 = 0L;
        }
        this(l, l2, l3, l4, l5);
    }

    @Override
    public long getNumberOfNullEntries() {
        return this.numberOfNullEntries;
    }

    @Override
    public void setNumberOfNullEntries(long l) {
        this.numberOfNullEntries = l;
    }

    @Override
    public long getNumberOfNonNullEntries() {
        return this.numberOfNonNullEntries;
    }

    @Override
    public void setNumberOfNonNullEntries(long l) {
        this.numberOfNonNullEntries = l;
    }

    @Override
    public long getNumberOfDistinctEntries() {
        return this.numberOfDistinctEntries;
    }

    @Override
    public void setNumberOfDistinctEntries(long l) {
        this.numberOfDistinctEntries = l;
    }

    public final long getNumberOfTrueEntries() {
        return this.numberOfTrueEntries;
    }

    public final void setNumberOfTrueEntries(long l) {
        this.numberOfTrueEntries = l;
    }

    public final long getNumberOfFalseEntries() {
        return this.numberOfFalseEntries;
    }

    public final void setNumberOfFalseEntries(long l) {
        this.numberOfFalseEntries = l;
    }

    public BooleanValueStatistics(float factor, @NotNull BooleanValueStatistics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this((long)((float)metrics.getNumberOfNullEntries() * factor), (long)((float)metrics.getNumberOfNonNullEntries() * factor), Math.min((double)metrics.getNumberOfDistinctEntries() / (double)metrics.getNumberOfEntries() >= (double)metrics.getDistinctEntriesScalingThreshold() ? (long)((float)metrics.getNumberOfDistinctEntries() * factor) : metrics.getNumberOfDistinctEntries(), 2L), (long)((float)metrics.numberOfTrueEntries * factor), (long)((float)metrics.numberOfFalseEntries * factor));
    }

    @Override
    @NotNull
    public Map<String, String> about() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TRUE_ENTRIES_KEY, (Object)String.valueOf(this.numberOfTrueEntries)), TuplesKt.to((Object)FALSE_ENTRIES_KEY, (Object)String.valueOf(this.numberOfFalseEntries))};
        return MapsKt.plus(super.about(), (Map)MapsKt.mapOf((Pair[])pairArray));
    }

    public final long component1() {
        return this.numberOfNullEntries;
    }

    public final long component2() {
        return this.numberOfNonNullEntries;
    }

    public final long component3() {
        return this.numberOfDistinctEntries;
    }

    public final long component4() {
        return this.numberOfTrueEntries;
    }

    public final long component5() {
        return this.numberOfFalseEntries;
    }

    @NotNull
    public final BooleanValueStatistics copy(long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries, long numberOfTrueEntries, long numberOfFalseEntries) {
        return new BooleanValueStatistics(numberOfNullEntries, numberOfNonNullEntries, numberOfDistinctEntries, numberOfTrueEntries, numberOfFalseEntries);
    }

    public static /* synthetic */ BooleanValueStatistics copy$default(BooleanValueStatistics booleanValueStatistics, long l, long l2, long l3, long l4, long l5, int n, Object object) {
        if ((n & 1) != 0) {
            l = booleanValueStatistics.numberOfNullEntries;
        }
        if ((n & 2) != 0) {
            l2 = booleanValueStatistics.numberOfNonNullEntries;
        }
        if ((n & 4) != 0) {
            l3 = booleanValueStatistics.numberOfDistinctEntries;
        }
        if ((n & 8) != 0) {
            l4 = booleanValueStatistics.numberOfTrueEntries;
        }
        if ((n & 0x10) != 0) {
            l5 = booleanValueStatistics.numberOfFalseEntries;
        }
        return booleanValueStatistics.copy(l, l2, l3, l4, l5);
    }

    @NotNull
    public String toString() {
        return "BooleanValueStatistics(numberOfNullEntries=" + this.numberOfNullEntries + ", numberOfNonNullEntries=" + this.numberOfNonNullEntries + ", numberOfDistinctEntries=" + this.numberOfDistinctEntries + ", numberOfTrueEntries=" + this.numberOfTrueEntries + ", numberOfFalseEntries=" + this.numberOfFalseEntries + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.numberOfNullEntries);
        result = result * 31 + Long.hashCode(this.numberOfNonNullEntries);
        result = result * 31 + Long.hashCode(this.numberOfDistinctEntries);
        result = result * 31 + Long.hashCode(this.numberOfTrueEntries);
        result = result * 31 + Long.hashCode(this.numberOfFalseEntries);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BooleanValueStatistics)) {
            return false;
        }
        BooleanValueStatistics booleanValueStatistics = (BooleanValueStatistics)other;
        if (this.numberOfNullEntries != booleanValueStatistics.numberOfNullEntries) {
            return false;
        }
        if (this.numberOfNonNullEntries != booleanValueStatistics.numberOfNonNullEntries) {
            return false;
        }
        if (this.numberOfDistinctEntries != booleanValueStatistics.numberOfDistinctEntries) {
            return false;
        }
        if (this.numberOfTrueEntries != booleanValueStatistics.numberOfTrueEntries) {
            return false;
        }
        return this.numberOfFalseEntries == booleanValueStatistics.numberOfFalseEntries;
    }

    public BooleanValueStatistics() {
        this(0L, 0L, 0L, 0L, 0L, 31, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/BooleanValueStatistics$Binding;", "Lorg/vitrivr/cottontail/storage/serializers/statistics/MetricsXodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/values/BooleanValueStatistics;", "()V", "read", "stream", "Ljava/io/ByteArrayInputStream;", "write", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "statistics", "cottontaildb-dbms"})
    public static final class Binding
    implements MetricsXodusBinding<BooleanValueStatistics> {
        @NotNull
        public static final Binding INSTANCE = new Binding();

        private Binding() {
        }

        @Override
        @NotNull
        public BooleanValueStatistics read(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            long numberOfNullEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            long numberOfNonNullEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            long numberOfDistinctEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            long numberOfTrueEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            long numberOfFalseEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            return new BooleanValueStatistics(numberOfNullEntries, numberOfNonNullEntries, numberOfDistinctEntries, numberOfTrueEntries, numberOfFalseEntries);
        }

        @Override
        public void write(@NotNull LightOutputStream output, @NotNull BooleanValueStatistics statistics2) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)statistics2, (String)"statistics");
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNonNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfDistinctEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfTrueEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfFalseEntries());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/BooleanValueStatistics$Companion;", "", "()V", "FALSE_ENTRIES_KEY", "", "TRUE_ENTRIES_KEY", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

