/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.values;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.BooleanVectorValue;
import org.vitrivr.cottontail.dbms.statistics.values.AbstractVectorStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.MetricsXodusBinding;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001-B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B5\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\nH\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003J\t\u0010$\u001a\u00020\u000eH\u00c6\u0003J;\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020\bH\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\f\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u000b\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0013\"\u0004\b\u001a\u0010\u0015R\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0013\"\u0004\b\u001c\u0010\u0015R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/BooleanVectorValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/values/AbstractVectorStatistics;", "Lorg/vitrivr/cottontail/core/values/BooleanVectorValue;", "factor", "", "metrics", "(FLorg/vitrivr/cottontail/dbms/statistics/values/BooleanVectorValueStatistics;)V", "logicalSize", "", "numberOfNullEntries", "", "numberOfNonNullEntries", "numberOfDistinctEntries", "numberOfTrueEntries", "", "(IJJJ[J)V", "getLogicalSize", "()I", "getNumberOfDistinctEntries", "()J", "setNumberOfDistinctEntries", "(J)V", "numberOfFalseEntries", "getNumberOfFalseEntries", "()[J", "getNumberOfNonNullEntries", "setNumberOfNonNullEntries", "getNumberOfNullEntries", "setNumberOfNullEntries", "getNumberOfTrueEntries", "setNumberOfTrueEntries", "([J)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Binding", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nBooleanVectorValueStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanVectorValueStatistics.kt\norg/vitrivr/cottontail/dbms/statistics/values/BooleanVectorValueStatistics\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,70:1\n11105#2:71\n11440#2,3:72\n*S KotlinDebug\n*F\n+ 1 BooleanVectorValueStatistics.kt\norg/vitrivr/cottontail/dbms/statistics/values/BooleanVectorValueStatistics\n*L\n32#1:71\n32#1:72,3\n*E\n"})
public final class BooleanVectorValueStatistics
extends AbstractVectorStatistics<BooleanVectorValue> {
    private final int logicalSize;
    private long numberOfNullEntries;
    private long numberOfNonNullEntries;
    private long numberOfDistinctEntries;
    @NotNull
    private long[] numberOfTrueEntries;

    public BooleanVectorValueStatistics(int logicalSize, long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries, @NotNull long[] numberOfTrueEntries) {
        Intrinsics.checkNotNullParameter((Object)numberOfTrueEntries, (String)"numberOfTrueEntries");
        super((Types)new Types.BooleanVector(logicalSize), null);
        this.logicalSize = logicalSize;
        this.numberOfNullEntries = numberOfNullEntries;
        this.numberOfNonNullEntries = numberOfNonNullEntries;
        this.numberOfDistinctEntries = numberOfDistinctEntries;
        this.numberOfTrueEntries = numberOfTrueEntries;
    }

    public /* synthetic */ BooleanVectorValueStatistics(int n, long l, long l2, long l3, long[] lArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        if ((n2 & 4) != 0) {
            l2 = 0L;
        }
        if ((n2 & 8) != 0) {
            l3 = 0L;
        }
        if ((n2 & 0x10) != 0) {
            lArray = new long[n];
        }
        this(n, l, l2, l3, lArray);
    }

    public final int getLogicalSize() {
        return this.logicalSize;
    }

    @Override
    public long getNumberOfNullEntries() {
        return this.numberOfNullEntries;
    }

    @Override
    public void setNumberOfNullEntries(long l) {
        this.numberOfNullEntries = l;
    }

    @Override
    public long getNumberOfNonNullEntries() {
        return this.numberOfNonNullEntries;
    }

    @Override
    public void setNumberOfNonNullEntries(long l) {
        this.numberOfNonNullEntries = l;
    }

    @Override
    public long getNumberOfDistinctEntries() {
        return this.numberOfDistinctEntries;
    }

    @Override
    public void setNumberOfDistinctEntries(long l) {
        this.numberOfDistinctEntries = l;
    }

    @NotNull
    public final long[] getNumberOfTrueEntries() {
        return this.numberOfTrueEntries;
    }

    public final void setNumberOfTrueEntries(@NotNull long[] lArray) {
        Intrinsics.checkNotNullParameter((Object)lArray, (String)"<set-?>");
        this.numberOfTrueEntries = lArray;
    }

    /*
     * WARNING - void declaration
     */
    public BooleanVectorValueStatistics(float factor, @NotNull BooleanVectorValueStatistics metrics) {
        Collection<Long> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        long[] lArray = metrics.numberOfTrueEntries;
        long l = (double)metrics.getNumberOfDistinctEntries() / (double)metrics.getNumberOfEntries() >= (double)metrics.getDistinctEntriesScalingThreshold() ? (long)((float)metrics.getNumberOfDistinctEntries() * factor) : metrics.getNumberOfDistinctEntries();
        long l2 = (long)((float)metrics.getNumberOfNonNullEntries() * factor);
        long l3 = (long)((float)metrics.getNumberOfNullEntries() * factor);
        int n = metrics.logicalSize;
        BooleanVectorValueStatistics booleanVectorValueStatistics = this;
        boolean $i$f$map = false;
        void var5_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n2; ++j) {
            void element;
            void item$iv$iv;
            void var12_16 = item$iv$iv = $this$mapTo$iv$iv[j];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((long)((float)element * factor));
        }
        collection = (List)destination$iv$iv;
        booleanVectorValueStatistics(n, l3, l2, l, CollectionsKt.toLongArray((Collection)collection));
    }

    @NotNull
    public final long[] getNumberOfFalseEntries() {
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        long[] lArray = new long[n2];
        while (n < n2) {
            int n3 = n++;
            lArray[n3] = this.getNumberOfNonNullEntries() - this.numberOfTrueEntries[n3];
        }
        return lArray;
    }

    public final int component1() {
        return this.logicalSize;
    }

    public final long component2() {
        return this.numberOfNullEntries;
    }

    public final long component3() {
        return this.numberOfNonNullEntries;
    }

    public final long component4() {
        return this.numberOfDistinctEntries;
    }

    @NotNull
    public final long[] component5() {
        return this.numberOfTrueEntries;
    }

    @NotNull
    public final BooleanVectorValueStatistics copy(int logicalSize, long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries, @NotNull long[] numberOfTrueEntries) {
        Intrinsics.checkNotNullParameter((Object)numberOfTrueEntries, (String)"numberOfTrueEntries");
        return new BooleanVectorValueStatistics(logicalSize, numberOfNullEntries, numberOfNonNullEntries, numberOfDistinctEntries, numberOfTrueEntries);
    }

    public static /* synthetic */ BooleanVectorValueStatistics copy$default(BooleanVectorValueStatistics booleanVectorValueStatistics, int n, long l, long l2, long l3, long[] lArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = booleanVectorValueStatistics.logicalSize;
        }
        if ((n2 & 2) != 0) {
            l = booleanVectorValueStatistics.numberOfNullEntries;
        }
        if ((n2 & 4) != 0) {
            l2 = booleanVectorValueStatistics.numberOfNonNullEntries;
        }
        if ((n2 & 8) != 0) {
            l3 = booleanVectorValueStatistics.numberOfDistinctEntries;
        }
        if ((n2 & 0x10) != 0) {
            lArray = booleanVectorValueStatistics.numberOfTrueEntries;
        }
        return booleanVectorValueStatistics.copy(n, l, l2, l3, lArray);
    }

    @NotNull
    public String toString() {
        return "BooleanVectorValueStatistics(logicalSize=" + this.logicalSize + ", numberOfNullEntries=" + this.numberOfNullEntries + ", numberOfNonNullEntries=" + this.numberOfNonNullEntries + ", numberOfDistinctEntries=" + this.numberOfDistinctEntries + ", numberOfTrueEntries=" + Arrays.toString(this.numberOfTrueEntries) + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.logicalSize);
        result = result * 31 + Long.hashCode(this.numberOfNullEntries);
        result = result * 31 + Long.hashCode(this.numberOfNonNullEntries);
        result = result * 31 + Long.hashCode(this.numberOfDistinctEntries);
        result = result * 31 + Arrays.hashCode(this.numberOfTrueEntries);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BooleanVectorValueStatistics)) {
            return false;
        }
        BooleanVectorValueStatistics booleanVectorValueStatistics = (BooleanVectorValueStatistics)other;
        if (this.logicalSize != booleanVectorValueStatistics.logicalSize) {
            return false;
        }
        if (this.numberOfNullEntries != booleanVectorValueStatistics.numberOfNullEntries) {
            return false;
        }
        if (this.numberOfNonNullEntries != booleanVectorValueStatistics.numberOfNonNullEntries) {
            return false;
        }
        if (this.numberOfDistinctEntries != booleanVectorValueStatistics.numberOfDistinctEntries) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.numberOfTrueEntries, (Object)booleanVectorValueStatistics.numberOfTrueEntries);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/BooleanVectorValueStatistics$Binding;", "Lorg/vitrivr/cottontail/storage/serializers/statistics/MetricsXodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/values/BooleanVectorValueStatistics;", "logicalSize", "", "(I)V", "getLogicalSize", "()I", "read", "stream", "Ljava/io/ByteArrayInputStream;", "write", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "statistics", "cottontaildb-dbms"})
    public static final class Binding
    implements MetricsXodusBinding<BooleanVectorValueStatistics> {
        private final int logicalSize;

        public Binding(int logicalSize) {
            this.logicalSize = logicalSize;
        }

        public final int getLogicalSize() {
            return this.logicalSize;
        }

        @Override
        @NotNull
        public BooleanVectorValueStatistics read(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            BooleanVectorValueStatistics stat = new BooleanVectorValueStatistics(this.logicalSize, 0L, 0L, 0L, null, 30, null);
            stat.setNumberOfNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            stat.setNumberOfNonNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            stat.setNumberOfDistinctEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            int n = this.logicalSize;
            for (int i2 = 0; i2 < n; ++i2) {
                stat.getNumberOfTrueEntries()[i2] = LongBinding.readCompressed((ByteArrayInputStream)stream);
            }
            return stat;
        }

        @Override
        public void write(@NotNull LightOutputStream output, @NotNull BooleanVectorValueStatistics statistics2) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)statistics2, (String)"statistics");
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNonNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfDistinctEntries());
            int n = statistics2.getType().getLogicalSize();
            for (int i2 = 0; i2 < n; ++i2) {
                LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfTrueEntries()[i2]);
            }
        }
    }
}

