/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.values;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.SignedDoubleBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.DoubleVectorValue;
import org.vitrivr.cottontail.dbms.statistics.values.RealVectorValueStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.MetricsXodusBinding;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00016B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006BI\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0010J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003J\t\u0010$\u001a\u00020\nH\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003J\u0016\u0010&\u001a\u00020\u0002H\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b'\u0010\u0014J\u0016\u0010(\u001a\u00020\u0002H\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b)\u0010\u0014J\u0016\u0010*\u001a\u00020\u0002H\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010\u0014JY\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u0002H\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b-\u0010.J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u00d6\u0003J\t\u00103\u001a\u00020\bH\u00d6\u0001J\t\u00104\u001a\u000205H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u000e\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\u00028VX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u001c\u0010\r\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0018\u0010\u0014R\u001a\u0010\f\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u000b\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001a\"\u0004\b\u001e\u0010\u001cR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001a\"\u0004\b \u0010\u001cR\u001c\u0010\u000f\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b!\u0010\u0014\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00067"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/DoubleVectorValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/values/RealVectorValueStatistics;", "Lorg/vitrivr/cottontail/core/values/DoubleVectorValue;", "factor", "", "metrics", "(FLorg/vitrivr/cottontail/dbms/statistics/values/DoubleVectorValueStatistics;)V", "logicalSize", "", "numberOfNullEntries", "", "numberOfNonNullEntries", "numberOfDistinctEntries", "min", "max", "sum", "(IJJJ[D[D[DLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getLogicalSize", "()I", "getMax-aM0kQ94", "()[D", "[D", "mean", "getMean-aM0kQ94", "getMin-aM0kQ94", "getNumberOfDistinctEntries", "()J", "setNumberOfDistinctEntries", "(J)V", "getNumberOfNonNullEntries", "setNumberOfNonNullEntries", "getNumberOfNullEntries", "setNumberOfNullEntries", "getSum-aM0kQ94", "component1", "component2", "component3", "component4", "component5", "component5-aM0kQ94", "component6", "component6-aM0kQ94", "component7", "component7-aM0kQ94", "copy", "copy-oiyyUeU", "(IJJJ[D[D[D)Lorg/vitrivr/cottontail/dbms/statistics/values/DoubleVectorValueStatistics;", "equals", "", "other", "", "hashCode", "toString", "", "Binding", "cottontaildb-dbms"})
public final class DoubleVectorValueStatistics
extends RealVectorValueStatistics<DoubleVectorValue> {
    private final int logicalSize;
    private long numberOfNullEntries;
    private long numberOfNonNullEntries;
    private long numberOfDistinctEntries;
    @NotNull
    private final double[] min;
    @NotNull
    private final double[] max;
    @NotNull
    private final double[] sum;

    private DoubleVectorValueStatistics(int logicalSize, long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries, double[] min, double[] max, double[] sum) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Intrinsics.checkNotNullParameter((Object)sum, (String)"sum");
        super((Types)new Types.DoubleVector(logicalSize), null);
        this.logicalSize = logicalSize;
        this.numberOfNullEntries = numberOfNullEntries;
        this.numberOfNonNullEntries = numberOfNonNullEntries;
        this.numberOfDistinctEntries = numberOfDistinctEntries;
        this.min = min;
        this.max = max;
        this.sum = sum;
    }

    public /* synthetic */ DoubleVectorValueStatistics(int n, long l, long l2, long l3, double[] dArray, double[] dArray2, double[] dArray3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        int n3;
        double[] dArray4;
        int n4;
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        if ((n2 & 4) != 0) {
            l2 = 0L;
        }
        if ((n2 & 8) != 0) {
            l3 = 0L;
        }
        if ((n2 & 0x10) != 0) {
            n4 = 0;
            dArray4 = new double[n];
            while (n4 < n) {
                n3 = n4++;
                dArray4[n3] = Double.MAX_VALUE;
            }
            dArray = DoubleVectorValue.constructor-impl((double[])dArray4);
        }
        if ((n2 & 0x20) != 0) {
            n4 = 0;
            dArray4 = new double[n];
            while (n4 < n) {
                n3 = n4++;
                dArray4[n3] = Double.MIN_VALUE;
            }
            dArray2 = DoubleVectorValue.constructor-impl((double[])dArray4);
        }
        if ((n2 & 0x40) != 0) {
            dArray3 = DoubleVectorValue.constructor-impl((double[])new double[n]);
        }
        this(n, l, l2, l3, dArray, dArray2, dArray3, null);
    }

    public final int getLogicalSize() {
        return this.logicalSize;
    }

    @Override
    public long getNumberOfNullEntries() {
        return this.numberOfNullEntries;
    }

    @Override
    public void setNumberOfNullEntries(long l) {
        this.numberOfNullEntries = l;
    }

    @Override
    public long getNumberOfNonNullEntries() {
        return this.numberOfNonNullEntries;
    }

    @Override
    public void setNumberOfNonNullEntries(long l) {
        this.numberOfNonNullEntries = l;
    }

    @Override
    public long getNumberOfDistinctEntries() {
        return this.numberOfDistinctEntries;
    }

    @Override
    public void setNumberOfDistinctEntries(long l) {
        this.numberOfDistinctEntries = l;
    }

    @NotNull
    public double[] getMin-aM0kQ94() {
        return this.min;
    }

    @NotNull
    public double[] getMax-aM0kQ94() {
        return this.max;
    }

    @NotNull
    public double[] getSum-aM0kQ94() {
        return this.sum;
    }

    public DoubleVectorValueStatistics(float factor, @NotNull DoubleVectorValueStatistics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        int n = 0;
        int n2 = metrics.logicalSize;
        double[] dArray = new double[n2];
        double[] dArray2 = metrics.getMax-aM0kQ94();
        double[] dArray3 = metrics.getMin-aM0kQ94();
        long l = (double)metrics.getNumberOfDistinctEntries() / (double)metrics.getNumberOfEntries() >= (double)metrics.getDistinctEntriesScalingThreshold() ? (long)((float)metrics.getNumberOfDistinctEntries() * factor) : metrics.getNumberOfDistinctEntries();
        long l2 = (long)((float)metrics.getNumberOfNonNullEntries() * factor);
        long l3 = (long)((float)metrics.getNumberOfNullEntries() * factor);
        int n3 = metrics.logicalSize;
        DoubleVectorValueStatistics doubleVectorValueStatistics = this;
        while (n < n2) {
            int n4 = n++;
            dArray[n4] = metrics.getSum-aM0kQ94()[n4] * (double)factor;
        }
        doubleVectorValueStatistics(n3, l3, l2, l, dArray3, dArray2, DoubleVectorValue.constructor-impl((double[])dArray), null);
    }

    @NotNull
    public double[] getMean-aM0kQ94() {
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = DoubleVectorValue.get-iEH02FE((double[])this.getSum-aM0kQ94(), (int)n3) / (double)this.getNumberOfNonNullEntries();
        }
        return DoubleVectorValue.constructor-impl((double[])dArray);
    }

    public final int component1() {
        return this.logicalSize;
    }

    public final long component2() {
        return this.numberOfNullEntries;
    }

    public final long component3() {
        return this.numberOfNonNullEntries;
    }

    public final long component4() {
        return this.numberOfDistinctEntries;
    }

    @NotNull
    public final double[] component5-aM0kQ94() {
        return this.min;
    }

    @NotNull
    public final double[] component6-aM0kQ94() {
        return this.max;
    }

    @NotNull
    public final double[] component7-aM0kQ94() {
        return this.sum;
    }

    @NotNull
    public final DoubleVectorValueStatistics copy-oiyyUeU(int logicalSize, long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries, @NotNull double[] min, @NotNull double[] max, @NotNull double[] sum) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Intrinsics.checkNotNullParameter((Object)sum, (String)"sum");
        return new DoubleVectorValueStatistics(logicalSize, numberOfNullEntries, numberOfNonNullEntries, numberOfDistinctEntries, min, max, sum, null);
    }

    public static /* synthetic */ DoubleVectorValueStatistics copy-oiyyUeU$default(DoubleVectorValueStatistics doubleVectorValueStatistics, int n, long l, long l2, long l3, double[] dArray, double[] dArray2, double[] dArray3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = doubleVectorValueStatistics.logicalSize;
        }
        if ((n2 & 2) != 0) {
            l = doubleVectorValueStatistics.numberOfNullEntries;
        }
        if ((n2 & 4) != 0) {
            l2 = doubleVectorValueStatistics.numberOfNonNullEntries;
        }
        if ((n2 & 8) != 0) {
            l3 = doubleVectorValueStatistics.numberOfDistinctEntries;
        }
        if ((n2 & 0x10) != 0) {
            dArray = doubleVectorValueStatistics.min;
        }
        if ((n2 & 0x20) != 0) {
            dArray2 = doubleVectorValueStatistics.max;
        }
        if ((n2 & 0x40) != 0) {
            dArray3 = doubleVectorValueStatistics.sum;
        }
        return doubleVectorValueStatistics.copy-oiyyUeU(n, l, l2, l3, dArray, dArray2, dArray3);
    }

    @NotNull
    public String toString() {
        return "DoubleVectorValueStatistics(logicalSize=" + this.logicalSize + ", numberOfNullEntries=" + this.numberOfNullEntries + ", numberOfNonNullEntries=" + this.numberOfNonNullEntries + ", numberOfDistinctEntries=" + this.numberOfDistinctEntries + ", min=" + DoubleVectorValue.toString-impl((double[])this.min) + ", max=" + DoubleVectorValue.toString-impl((double[])this.max) + ", sum=" + DoubleVectorValue.toString-impl((double[])this.sum) + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.logicalSize);
        result = result * 31 + Long.hashCode(this.numberOfNullEntries);
        result = result * 31 + Long.hashCode(this.numberOfNonNullEntries);
        result = result * 31 + Long.hashCode(this.numberOfDistinctEntries);
        result = result * 31 + DoubleVectorValue.hashCode-impl((double[])this.min);
        result = result * 31 + DoubleVectorValue.hashCode-impl((double[])this.max);
        result = result * 31 + DoubleVectorValue.hashCode-impl((double[])this.sum);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DoubleVectorValueStatistics)) {
            return false;
        }
        DoubleVectorValueStatistics doubleVectorValueStatistics = (DoubleVectorValueStatistics)other;
        if (this.logicalSize != doubleVectorValueStatistics.logicalSize) {
            return false;
        }
        if (this.numberOfNullEntries != doubleVectorValueStatistics.numberOfNullEntries) {
            return false;
        }
        if (this.numberOfNonNullEntries != doubleVectorValueStatistics.numberOfNonNullEntries) {
            return false;
        }
        if (this.numberOfDistinctEntries != doubleVectorValueStatistics.numberOfDistinctEntries) {
            return false;
        }
        if (!DoubleVectorValue.equals-impl0((double[])this.min, (double[])doubleVectorValueStatistics.min)) {
            return false;
        }
        if (!DoubleVectorValue.equals-impl0((double[])this.max, (double[])doubleVectorValueStatistics.max)) {
            return false;
        }
        return DoubleVectorValue.equals-impl0((double[])this.sum, (double[])doubleVectorValueStatistics.sum);
    }

    public /* synthetic */ DoubleVectorValueStatistics(int logicalSize, long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries, double[] min, double[] max, double[] sum, DefaultConstructorMarker $constructor_marker) {
        this(logicalSize, numberOfNullEntries, numberOfNonNullEntries, numberOfDistinctEntries, min, max, sum);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/DoubleVectorValueStatistics$Binding;", "Lorg/vitrivr/cottontail/storage/serializers/statistics/MetricsXodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/values/DoubleVectorValueStatistics;", "logicalSize", "", "(I)V", "getLogicalSize", "()I", "read", "stream", "Ljava/io/ByteArrayInputStream;", "write", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "statistics", "cottontaildb-dbms"})
    public static final class Binding
    implements MetricsXodusBinding<DoubleVectorValueStatistics> {
        private final int logicalSize;

        public Binding(int logicalSize) {
            this.logicalSize = logicalSize;
        }

        public final int getLogicalSize() {
            return this.logicalSize;
        }

        @Override
        @NotNull
        public DoubleVectorValueStatistics read(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            DoubleVectorValueStatistics stat = new DoubleVectorValueStatistics(this.logicalSize, 0L, 0L, 0L, null, null, null, 126, null);
            stat.setNumberOfNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            stat.setNumberOfNonNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            stat.setNumberOfDistinctEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            int n = this.logicalSize;
            for (int i2 = 0; i2 < n; ++i2) {
                double[] dArray = stat.getMin-aM0kQ94();
                Double d = SignedDoubleBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"readObject(...)");
                dArray[i2] = ((Number)d).doubleValue();
                double[] dArray2 = stat.getMax-aM0kQ94();
                Double d2 = SignedDoubleBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"readObject(...)");
                dArray2[i2] = ((Number)d2).doubleValue();
                double[] dArray3 = stat.getSum-aM0kQ94();
                Double d3 = SignedDoubleBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"readObject(...)");
                dArray3[i2] = ((Number)d3).doubleValue();
            }
            return stat;
        }

        @Override
        public void write(@NotNull LightOutputStream output, @NotNull DoubleVectorValueStatistics statistics2) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)statistics2, (String)"statistics");
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNonNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfDistinctEntries());
            int n = statistics2.getType().getLogicalSize();
            for (int i2 = 0; i2 < n; ++i2) {
                SignedDoubleBinding.BINDING.writeObject(output, (Comparable)Double.valueOf(statistics2.getMin-aM0kQ94()[i2]));
                SignedDoubleBinding.BINDING.writeObject(output, (Comparable)Double.valueOf(statistics2.getMax-aM0kQ94()[i2]));
                SignedDoubleBinding.BINDING.writeObject(output, (Comparable)Double.valueOf(statistics2.getSum-aM0kQ94()[i2]));
            }
        }
    }
}

