/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.values;

import java.io.ByteArrayInputStream;
import java.util.Map;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.StringValue;
import org.vitrivr.cottontail.dbms.statistics.values.AbstractScalarStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.MetricsXodusBinding;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B7\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\t\u0010$\u001a\u00020\fH\u00c6\u0003J;\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020\fH\u00d6\u0001J\t\u0010+\u001a\u00020\u001fH\u00d6\u0001R\u001a\u0010\r\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001a\u0010\n\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\t\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018\u00a8\u0006-"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/StringValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/values/AbstractScalarStatistics;", "Lorg/vitrivr/cottontail/core/values/StringValue;", "factor", "", "metrics", "(FLorg/vitrivr/cottontail/dbms/statistics/values/StringValueStatistics;)V", "numberOfNullEntries", "", "numberOfNonNullEntries", "numberOfDistinctEntries", "minWidth", "", "maxWidth", "(JJJII)V", "getMaxWidth", "()I", "setMaxWidth", "(I)V", "getMinWidth", "setMinWidth", "getNumberOfDistinctEntries", "()J", "setNumberOfDistinctEntries", "(J)V", "getNumberOfNonNullEntries", "setNumberOfNonNullEntries", "getNumberOfNullEntries", "setNumberOfNullEntries", "about", "", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "Binding", "cottontaildb-dbms"})
public final class StringValueStatistics
extends AbstractScalarStatistics<StringValue> {
    private long numberOfNullEntries;
    private long numberOfNonNullEntries;
    private long numberOfDistinctEntries;
    private int minWidth;
    private int maxWidth;

    public StringValueStatistics(long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries, int minWidth, int maxWidth) {
        super((Types)Types.String.INSTANCE, null);
        this.numberOfNullEntries = numberOfNullEntries;
        this.numberOfNonNullEntries = numberOfNonNullEntries;
        this.numberOfDistinctEntries = numberOfDistinctEntries;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
    }

    public /* synthetic */ StringValueStatistics(long l, long l2, long l3, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            l = 0L;
        }
        if ((n3 & 2) != 0) {
            l2 = 0L;
        }
        if ((n3 & 4) != 0) {
            l3 = 0L;
        }
        if ((n3 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 0x10) != 0) {
            n2 = Integer.MIN_VALUE;
        }
        this(l, l2, l3, n, n2);
    }

    @Override
    public long getNumberOfNullEntries() {
        return this.numberOfNullEntries;
    }

    @Override
    public void setNumberOfNullEntries(long l) {
        this.numberOfNullEntries = l;
    }

    @Override
    public long getNumberOfNonNullEntries() {
        return this.numberOfNonNullEntries;
    }

    @Override
    public void setNumberOfNonNullEntries(long l) {
        this.numberOfNonNullEntries = l;
    }

    @Override
    public long getNumberOfDistinctEntries() {
        return this.numberOfDistinctEntries;
    }

    @Override
    public void setNumberOfDistinctEntries(long l) {
        this.numberOfDistinctEntries = l;
    }

    @Override
    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int n) {
        this.minWidth = n;
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int n) {
        this.maxWidth = n;
    }

    public StringValueStatistics(float factor, @NotNull StringValueStatistics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this((long)((float)metrics.getNumberOfNullEntries() * factor), (long)((float)metrics.getNumberOfNonNullEntries() * factor), (double)metrics.getNumberOfDistinctEntries() / (double)metrics.getNumberOfEntries() >= (double)metrics.getDistinctEntriesScalingThreshold() ? (long)((float)metrics.getNumberOfDistinctEntries() * factor) : metrics.getNumberOfDistinctEntries(), metrics.getMinWidth(), metrics.getMaxWidth());
    }

    @Override
    @NotNull
    public Map<String, String> about() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"min_width", (Object)String.valueOf(this.getMinWidth())), TuplesKt.to((Object)"max_width", (Object)String.valueOf(this.getMaxWidth()))};
        return MapsKt.plus(super.about(), (Map)MapsKt.mapOf((Pair[])pairArray));
    }

    public final long component1() {
        return this.numberOfNullEntries;
    }

    public final long component2() {
        return this.numberOfNonNullEntries;
    }

    public final long component3() {
        return this.numberOfDistinctEntries;
    }

    public final int component4() {
        return this.minWidth;
    }

    public final int component5() {
        return this.maxWidth;
    }

    @NotNull
    public final StringValueStatistics copy(long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries, int minWidth, int maxWidth) {
        return new StringValueStatistics(numberOfNullEntries, numberOfNonNullEntries, numberOfDistinctEntries, minWidth, maxWidth);
    }

    public static /* synthetic */ StringValueStatistics copy$default(StringValueStatistics stringValueStatistics, long l, long l2, long l3, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            l = stringValueStatistics.numberOfNullEntries;
        }
        if ((n3 & 2) != 0) {
            l2 = stringValueStatistics.numberOfNonNullEntries;
        }
        if ((n3 & 4) != 0) {
            l3 = stringValueStatistics.numberOfDistinctEntries;
        }
        if ((n3 & 8) != 0) {
            n = stringValueStatistics.minWidth;
        }
        if ((n3 & 0x10) != 0) {
            n2 = stringValueStatistics.maxWidth;
        }
        return stringValueStatistics.copy(l, l2, l3, n, n2);
    }

    @NotNull
    public String toString() {
        return "StringValueStatistics(numberOfNullEntries=" + this.numberOfNullEntries + ", numberOfNonNullEntries=" + this.numberOfNonNullEntries + ", numberOfDistinctEntries=" + this.numberOfDistinctEntries + ", minWidth=" + this.minWidth + ", maxWidth=" + this.maxWidth + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.numberOfNullEntries);
        result = result * 31 + Long.hashCode(this.numberOfNonNullEntries);
        result = result * 31 + Long.hashCode(this.numberOfDistinctEntries);
        result = result * 31 + Integer.hashCode(this.minWidth);
        result = result * 31 + Integer.hashCode(this.maxWidth);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringValueStatistics)) {
            return false;
        }
        StringValueStatistics stringValueStatistics = (StringValueStatistics)other;
        if (this.numberOfNullEntries != stringValueStatistics.numberOfNullEntries) {
            return false;
        }
        if (this.numberOfNonNullEntries != stringValueStatistics.numberOfNonNullEntries) {
            return false;
        }
        if (this.numberOfDistinctEntries != stringValueStatistics.numberOfDistinctEntries) {
            return false;
        }
        if (this.minWidth != stringValueStatistics.minWidth) {
            return false;
        }
        return this.maxWidth == stringValueStatistics.maxWidth;
    }

    public StringValueStatistics() {
        this(0L, 0L, 0L, 0, 0, 31, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/StringValueStatistics$Binding;", "Lorg/vitrivr/cottontail/storage/serializers/statistics/MetricsXodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/values/StringValueStatistics;", "()V", "read", "stream", "Ljava/io/ByteArrayInputStream;", "write", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "statistics", "cottontaildb-dbms"})
    public static final class Binding
    implements MetricsXodusBinding<StringValueStatistics> {
        @NotNull
        public static final Binding INSTANCE = new Binding();

        private Binding() {
        }

        @Override
        @NotNull
        public StringValueStatistics read(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            long numberOfNullEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            long numberOfNonNullEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            long numberOfDistinctEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            int minWidth = IntegerBinding.readCompressed((ByteArrayInputStream)stream);
            int maxWidth = IntegerBinding.readCompressed((ByteArrayInputStream)stream);
            return new StringValueStatistics(numberOfNullEntries, numberOfNonNullEntries, numberOfDistinctEntries, minWidth, maxWidth);
        }

        @Override
        public void write(@NotNull LightOutputStream output, @NotNull StringValueStatistics statistics2) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)statistics2, (String)"statistics");
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNonNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfDistinctEntries());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)statistics2.getMinWidth());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)statistics2.getMaxWidth());
        }
    }
}

