/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.values;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.UuidValue;
import org.vitrivr.cottontail.dbms.statistics.values.AbstractScalarStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.MetricsXodusBinding;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\r\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B#\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\n\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\t\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/UuidValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/values/AbstractScalarStatistics;", "Lorg/vitrivr/cottontail/core/values/UuidValue;", "factor", "", "metrics", "(FLorg/vitrivr/cottontail/dbms/statistics/values/UuidValueStatistics;)V", "numberOfNullEntries", "", "numberOfNonNullEntries", "numberOfDistinctEntries", "(JJJ)V", "getNumberOfDistinctEntries", "()J", "setNumberOfDistinctEntries", "(J)V", "getNumberOfNonNullEntries", "setNumberOfNonNullEntries", "getNumberOfNullEntries", "setNumberOfNullEntries", "Binding", "cottontaildb-dbms"})
public final class UuidValueStatistics
extends AbstractScalarStatistics<UuidValue> {
    private long numberOfNullEntries;
    private long numberOfNonNullEntries;
    private long numberOfDistinctEntries;

    public UuidValueStatistics(long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries) {
        super((Types)Types.Uuid.INSTANCE, null);
        this.numberOfNullEntries = numberOfNullEntries;
        this.numberOfNonNullEntries = numberOfNonNullEntries;
        this.numberOfDistinctEntries = numberOfDistinctEntries;
    }

    public /* synthetic */ UuidValueStatistics(long l, long l2, long l3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            l2 = 0L;
        }
        if ((n & 4) != 0) {
            l3 = 0L;
        }
        this(l, l2, l3);
    }

    @Override
    public long getNumberOfNullEntries() {
        return this.numberOfNullEntries;
    }

    @Override
    public void setNumberOfNullEntries(long l) {
        this.numberOfNullEntries = l;
    }

    @Override
    public long getNumberOfNonNullEntries() {
        return this.numberOfNonNullEntries;
    }

    @Override
    public void setNumberOfNonNullEntries(long l) {
        this.numberOfNonNullEntries = l;
    }

    @Override
    public long getNumberOfDistinctEntries() {
        return this.numberOfDistinctEntries;
    }

    @Override
    public void setNumberOfDistinctEntries(long l) {
        this.numberOfDistinctEntries = l;
    }

    public UuidValueStatistics(float factor, @NotNull UuidValueStatistics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this((long)((float)metrics.getNumberOfNullEntries() * factor), (long)((float)metrics.getNumberOfNonNullEntries() * factor), (double)metrics.getNumberOfDistinctEntries() / (double)metrics.getNumberOfEntries() >= (double)metrics.getDistinctEntriesScalingThreshold() ? (long)((float)metrics.getNumberOfDistinctEntries() * factor) : metrics.getNumberOfDistinctEntries());
    }

    public UuidValueStatistics() {
        this(0L, 0L, 0L, 7, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/UuidValueStatistics$Binding;", "Lorg/vitrivr/cottontail/storage/serializers/statistics/MetricsXodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/values/UuidValueStatistics;", "()V", "read", "stream", "Ljava/io/ByteArrayInputStream;", "write", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "statistics", "cottontaildb-dbms"})
    public static final class Binding
    implements MetricsXodusBinding<UuidValueStatistics> {
        @NotNull
        public static final Binding INSTANCE = new Binding();

        private Binding() {
        }

        @Override
        @NotNull
        public UuidValueStatistics read(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            long numberOfNullEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            long numberOfNonNullEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            long numberOfDistinctEntries = LongBinding.readCompressed((ByteArrayInputStream)stream);
            return new UuidValueStatistics(numberOfNullEntries, numberOfNonNullEntries, numberOfDistinctEntries);
        }

        @Override
        public void write(@NotNull LightOutputStream output, @NotNull UuidValueStatistics statistics2) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)statistics2, (String)"statistics");
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNonNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfDistinctEntries());
        }
    }
}

