/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.io.BufferedWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeSource;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.basics.Scanable;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.CatalogueTx;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.column.ColumnMetadata;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.events.Event;
import org.vitrivr.cottontail.dbms.execution.operators.basics.Operator;
import org.vitrivr.cottontail.dbms.execution.operators.sources.PartitionCalculatorKt;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionManager;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionMetadata;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionStatus;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionType;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.Tx;
import org.vitrivr.cottontail.dbms.index.basic.Index;
import org.vitrivr.cottontail.dbms.index.basic.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.basic.IndexTx;
import org.vitrivr.cottontail.dbms.index.basic.IndexType;
import org.vitrivr.cottontail.dbms.queries.context.DefaultQueryContext;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.dbms.schema.SchemaTx;
import org.vitrivr.cottontail.legacy.MigrationManager;
import org.vitrivr.cottontail.storage.serializers.tablets.Compression;
import org.vitrivr.cottontail.utilities.io.TxFileUtilities;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u0013H&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager;", "Lorg/vitrivr/cottontail/legacy/MigrationManager;", "batchSize", "", "logFile", "Ljava/nio/file/Path;", "(ILjava/nio/file/Path;)V", "transactionIdCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "writer", "Ljava/io/BufferedWriter;", "close", "", "log", "message", "", "logStdout", "migrate", "config", "Lorg/vitrivr/cottontail/config/Config;", "migrateDBOs", "source", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "destination", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "migrateData", "openDestinationCatalogue", "openSourceCatalogue", "LegacyMigrationContext", "MigrationContext", "cottontaildb-dbms"})
@ExperimentalTime
@SourceDebugExtension(value={"SMAP\nAbstractMigrationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractMigrationManager.kt\norg/vitrivr/cottontail/legacy/AbstractMigrationManager\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,502:1\n18#2,4:503\n50#2,7:507\n1549#3:514\n1620#3,3:515\n11065#4:518\n11400#4,3:519\n37#5,2:522\n32#6,2:524\n*S KotlinDebug\n*F\n+ 1 AbstractMigrationManager.kt\norg/vitrivr/cottontail/legacy/AbstractMigrationManager\n*L\n74#1:503,4\n74#1:507,7\n163#1:514\n163#1:515,3\n171#1:518\n171#1:519,3\n208#1:522,2\n216#1:524,2\n*E\n"})
public abstract class AbstractMigrationManager
implements MigrationManager {
    private final int batchSize;
    @NotNull
    private final AtomicLong transactionIdCounter;
    @NotNull
    private final BufferedWriter writer;

    public AbstractMigrationManager(int batchSize, @NotNull Path logFile) {
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        this.batchSize = batchSize;
        this.transactionIdCounter = new AtomicLong(0L);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.CREATE};
        BufferedWriter bufferedWriter = Files.newBufferedWriter(logFile.resolve("cottontaildb_migration_" + System.currentTimeMillis() + ".log"), openOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"newBufferedWriter(...)");
        this.writer = bufferedWriter;
    }

    @Nullable
    public abstract Catalogue openSourceCatalogue(@NotNull Config var1);

    @Nullable
    public abstract DefaultCatalogue openDestinationCatalogue(@NotNull Config var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        this.log("Starting catalogue migration from " + this.getFrom() + " for " + config.getRoot() + ".\n");
        Catalogue srcCatalogue = this.openSourceCatalogue(config);
        if (srcCatalogue == null) {
            this.log("Failed to open source catalogue.\n");
            return;
        }
        this.log("Source catalogue " + srcCatalogue.getConfig().getRoot() + " loaded successfully.\n");
        Path migratedDatabaseRoot = config.getRoot().getParent().resolve(config.getRoot().getFileName() + "~migrated");
        if (!Files.exists(migratedDatabaseRoot, new LinkOption[0])) {
            Files.createDirectories(migratedDatabaseRoot, new FileAttribute[0]);
        }
        Intrinsics.checkNotNull((Object)migratedDatabaseRoot);
        DefaultCatalogue dstCatalogue = this.openDestinationCatalogue(Config.copy$default(config, migratedDatabaseRoot, null, null, null, null, null, null, null, null, 510, null));
        if (dstCatalogue == null) {
            this.log("Failed to open destination catalogue.\n");
            srcCatalogue.close();
            return;
        }
        this.log("Destination catalogue " + dstCatalogue.getConfig().getRoot() + " loaded successfully.\n");
        boolean isWindows = false;
        try {
            this.migrateDBOs(srcCatalogue, dstCatalogue);
            this.migrateData(srcCatalogue, dstCatalogue);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(config.getRoot(), config.getRoot().getParent().resolve(config.getRoot().getFileName() + "~old"), copyOptionArray);
            copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(migratedDatabaseRoot, config.getRoot(), copyOptionArray);
        }
        catch (Throwable e) {
            this.log("Error during data migration: " + e.getMessage() + "\n");
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            isWindows = StringsKt.contains$default((CharSequence)string2, (CharSequence)"windows", (boolean)false, (int)2, null);
            TxFileUtilities.INSTANCE.delete(dstCatalogue.getPath());
        }
        finally {
            srcCatalogue.close();
            dstCatalogue.close();
        }
        if (isWindows) {
            this.log(StringsKt.trimIndent((String)("\n                            Windows detected. Finish the migration before a restart manually:\n                              1. Move " + config.getRoot() + " -> " + config.getRoot().getParent().resolve(config.getRoot().getFileName() + "~old") + "\n                              2. Move " + migratedDatabaseRoot + " -> " + config.getRoot() + "\n                              3. Delete " + dstCatalogue.getPath() + "\n                        ")));
        }
        long duration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        this.log("Data migration completed. Took " + Duration.toString-impl((long)duration) + ".\n");
    }

    /*
     * WARNING - void declaration
     */
    protected void migrateDBOs(@NotNull Catalogue source, @NotNull DefaultCatalogue destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        DefaultQueryContext sourceContext = new DefaultQueryContext("migration", source, new LegacyMigrationContext(), null, 8, null);
        Catalogue catalogue = destination;
        Transaction transaction = destination.getTransactionManager().getEnvironment$cottontaildb_dbms().beginExclusiveTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"beginExclusiveTransaction(...)");
        DefaultQueryContext destinationContext = new DefaultQueryContext("migration", catalogue, new MigrationContext(transaction), null, 8, null);
        CatalogueTx srcCatalogueTx = source.newTx(sourceContext);
        CatalogueTx dstCatalogueTx = destination.newTx(destinationContext);
        List<Name.SchemaName> schemas = srcCatalogueTx.listSchemas();
        Iterator<Name.SchemaName> iterator2 = schemas.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int s = n++;
            Name.SchemaName srcSchemaName = iterator2.next();
            this.log("+ Migrating schema " + srcSchemaName + " (" + (s + 1) + " / " + schemas.size() + "):\n");
            Schema schema = dstCatalogueTx.createSchema(srcSchemaName);
            SchemaTx srcSchemaTx = srcCatalogueTx.schemaForName(srcSchemaName).newTx(sourceContext);
            SchemaTx dstSchemaTx = schema.newTx(destinationContext);
            List<Name.EntityName> entities = srcSchemaTx.listEntities();
            Iterator<Name.EntityName> iterator3 = entities.iterator();
            int n2 = 0;
            while (iterator3.hasNext()) {
                void it;
                Object object;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                int i2 = n2++;
                Name.EntityName srcEntityName = iterator3.next();
                this.log("-- Migrating entity " + srcEntityName + " (" + (i2 + 1) + " / " + entities.size() + "):\n");
                EntityTx srcEntityTx = srcSchemaTx.entityForName(srcEntityName).newTx(sourceContext);
                Iterable iterable = srcEntityTx.listColumns();
                Name.EntityName entityName = srcEntityName;
                Tx tx = dstSchemaTx;
                boolean $i$f$map = false;
                void var24_25 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ColumnDef columnDef2 = (ColumnDef)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add(TuplesKt.to((Object)it.getName(), (Object)new ColumnMetadata(it.getType(), Compression.LZ4, it.getNullable(), it.getPrimary(), it.getAutoIncrement())));
                }
                object = (List)destination$iv$iv;
                Entity entity = tx.createEntity(entityName, (List<Pair<Name.ColumnName, ColumnMetadata>>)object);
                for (Name.IndexName indexName : srcEntityTx.listIndexes()) {
                    Collection<Name.ColumnName> collection;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    this.log("---- Migrating index " + indexName + "...\n");
                    Index index = srcEntityTx.indexForName(indexName);
                    IndexTx indexTx = index.newTx(sourceContext);
                    EntityTx destEntityTx = entity.newTx(destinationContext);
                    ColumnDef<?>[] columnDefArray = indexTx.getColumns();
                    object = index.getType();
                    entityName = index.getName();
                    tx = destEntityTx;
                    boolean $i$f$map2 = false;
                    it = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv2).length);
                    boolean $i$f$mapTo2 = false;
                    int n3 = ((void)$this$mapTo$iv$iv2).length;
                    for (int j = 0; j < n3; ++j) {
                        void it2;
                        void item$iv$iv;
                        void var35_39 = item$iv$iv = $this$mapTo$iv$iv2[j];
                        collection = destination$iv$iv2;
                        boolean bl = false;
                        collection.add(it2.getName());
                    }
                    collection = (List)destination$iv$iv2;
                    tx.createIndex((Name.IndexName)entityName, (IndexType)((Object)object), (List<Name.ColumnName>)collection, IndexDescriptor.DefaultImpls.buildConfig$default(index.getType().getDescriptor(), null, 1, null));
                }
            }
        }
        sourceContext.getTxn().commit();
        destinationContext.getTxn().commit();
    }

    protected void migrateData(@NotNull Catalogue source, @NotNull DefaultCatalogue destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        DefaultQueryContext sourceContext = new DefaultQueryContext("migration", source, new LegacyMigrationContext(), null, 8, null);
        CatalogueTx srcCatalogueTx = source.newTx(sourceContext);
        List<Name.SchemaName> schemas = srcCatalogueTx.listSchemas();
        Iterator<Name.SchemaName> iterator2 = schemas.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int s = n++;
            Name.SchemaName srcSchemaName = iterator2.next();
            SchemaTx srcSchemaTx = srcCatalogueTx.schemaForName(srcSchemaName).newTx(sourceContext);
            List<Name.EntityName> entities = srcSchemaTx.listEntities();
            this.logStdout("+ Migrating data for schema " + srcSchemaName + " (" + (s + 1) + " / " + schemas.size() + ")...\n");
            for (Name.EntityName srcEntityName : entities) {
                EntityTx srcEntityTx = srcSchemaTx.entityForName(srcEntityName).newTx(sourceContext);
                long count = srcEntityTx.count();
                if (count > 0L) {
                    long size = srcEntityTx.largestTupleId() - srcEntityTx.smallestTupleId();
                    int partitions = (int)Math.floorDiv(size, this.batchSize) + 1;
                    Collection $this$toTypedArray$iv = srcEntityTx.listColumns();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    ColumnDef[] columns2 = thisCollection$iv.toArray(new ColumnDef[0]);
                    long i2 = 0L;
                    for (int p = 0; p < partitions; ++p) {
                        Catalogue catalogue = destination;
                        Transaction transaction = destination.getTransactionManager().getEnvironment$cottontaildb_dbms().beginExclusiveTransaction();
                        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"beginExclusiveTransaction(...)");
                        DefaultQueryContext destinationContext = new DefaultQueryContext("migration", catalogue, new MigrationContext(transaction), null, 8, null);
                        CatalogueTx destCatalogueTx = destination.newTx(destinationContext);
                        SchemaTx destSchemaTx = destCatalogueTx.schemaForName(srcSchemaName).newTx(destinationContext);
                        EntityTx destEntityTx = destSchemaTx.entityForName(srcEntityName).newTx(destinationContext);
                        Cursor cursor = Scanable.DefaultImpls.cursor$default((Scanable)srcEntityTx, (ColumnDef[])columns2, (LongRange)PartitionCalculatorKt.partitionFor(srcEntityTx, p, partitions), null, (int)4, null);
                        Iterator $this$forEach$iv = (Iterator)cursor;
                        boolean $i$f$forEach = false;
                        Iterator iterator3 = $this$forEach$iv;
                        while (iterator3.hasNext()) {
                            Object element$iv = iterator3.next();
                            Tuple r = (Tuple)element$iv;
                            boolean bl = false;
                            this.logStdout("-- Migrating data for " + srcEntityName + "... (" + ++i2 + " / " + count + ")\r");
                            destEntityTx.insert(r);
                        }
                        cursor.close();
                        this.log("-- Migrating data for " + srcEntityName + "; committing... (" + i2 + " / " + count + ")\r");
                        destinationContext.getTxn().commit();
                    }
                    this.log("-- Data migration for " + srcEntityName + " completed (" + i2 + " / " + count + ").\n");
                    continue;
                }
                this.log("-- Data migration for " + srcEntityName + " skipped (no data).\n");
            }
        }
        sourceContext.getTxn().rollback();
    }

    private final void logStdout(String message) {
        System.out.print((Object)message);
    }

    protected final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        System.out.print((Object)message);
        this.writer.append(message);
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020&H\u0016J\b\u00102\u001a\u000203H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u000208H\u0016J\u001f\u00109\u001a\u0002H:\"\b\b\u0000\u0010:*\u00020&2\u0006\u0010;\u001a\u00020%H\u0016\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u000203H\u0016J\b\u0010>\u001a\u000203H\u0016J\u0010\u0010?\u001a\u0002032\u0006\u0010@\u001a\u00020AH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\n@RX\u0096\u000e\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0006R\u0014\u0010\u0018\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0006R\u0014\u0010\u001a\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0006R\u001e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u001c@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u00060\nj\u0002`!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\fR\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006B"}, d2={"Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager$LegacyMigrationContext;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "(Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager;)V", "availableIntraQueryWorkers", "", "getAvailableIntraQueryWorkers", "()I", "availableQueryWorkers", "getAvailableQueryWorkers", "created", "", "getCreated", "()J", "<set-?>", "ended", "getEnded", "()Ljava/lang/Long;", "Ljava/lang/Long;", "manager", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "getManager", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "numberOfError", "getNumberOfError", "numberOfOngoing", "getNumberOfOngoing", "numberOfSuccess", "getNumberOfSuccess", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionStatus;", "state", "getState", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionStatus;", "transactionId", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "getTransactionId", "txns", "", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "Lorg/vitrivr/cottontail/dbms/general/Tx;", "type", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "getType", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "xodusTx", "Ljetbrains/exodus/env/Transaction;", "getXodusTx", "()Ljetbrains/exodus/env/Transaction;", "cacheTx", "", "tx", "commit", "", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "operator", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "getCachedTxForDBO", "T", "dbo", "(Lorg/vitrivr/cottontail/dbms/general/DBO;)Lorg/vitrivr/cottontail/dbms/general/Tx;", "kill", "rollback", "signalEvent", "event", "Lorg/vitrivr/cottontail/dbms/events/Event;", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nAbstractMigrationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractMigrationManager.kt\norg/vitrivr/cottontail/legacy/AbstractMigrationManager$LegacyMigrationContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,502:1\n1#2:503\n*E\n"})
    public final class LegacyMigrationContext
    implements org.vitrivr.cottontail.dbms.execution.transactions.Transaction {
        private final long transactionId;
        @NotNull
        private final TransactionType type;
        private final int availableQueryWorkers;
        private final int availableIntraQueryWorkers;
        @NotNull
        private volatile TransactionStatus state;
        private final long created;
        @Nullable
        private Long ended;
        private final int numberOfSuccess;
        private final int numberOfError;
        private final int numberOfOngoing;
        @NotNull
        private final Map<DBO, Tx> txns;

        public LegacyMigrationContext() {
            this.transactionId = AbstractMigrationManager.this.transactionIdCounter.getAndIncrement();
            this.type = TransactionType.SYSTEM_EXCLUSIVE;
            this.state = TransactionStatus.IDLE;
            this.created = System.currentTimeMillis();
            Object2ObjectMap object2ObjectMap = Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)new Object2ObjectLinkedOpenHashMap()));
            Intrinsics.checkNotNullExpressionValue((Object)object2ObjectMap, (String)"synchronize(...)");
            this.txns = (Map)object2ObjectMap;
        }

        @Override
        public long getTransactionId() {
            return this.transactionId;
        }

        @Override
        @NotNull
        public Transaction getXodusTx() {
            throw new UnsupportedOperationException("Xodus transaction not available for LegacyMigrationContext.");
        }

        @Override
        @NotNull
        public TransactionManager getManager() {
            throw new UnsupportedOperationException("Xodus transaction not available for LegacyMigrationContext.");
        }

        @Override
        @NotNull
        public TransactionType getType() {
            return this.type;
        }

        @Override
        public int getAvailableQueryWorkers() {
            return this.availableQueryWorkers;
        }

        @Override
        public int getAvailableIntraQueryWorkers() {
            return this.availableIntraQueryWorkers;
        }

        @Override
        @NotNull
        public TransactionStatus getState() {
            return this.state;
        }

        @Override
        public long getCreated() {
            return this.created;
        }

        @Override
        @Nullable
        public Long getEnded() {
            return this.ended;
        }

        @Override
        public int getNumberOfSuccess() {
            return this.numberOfSuccess;
        }

        @Override
        public int getNumberOfError() {
            return this.numberOfError;
        }

        @Override
        public int getNumberOfOngoing() {
            return this.numberOfOngoing;
        }

        @Override
        public boolean cacheTx(@NotNull Tx tx) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            return this.txns.putIfAbsent(tx.getDbo(), tx) != null;
        }

        @Override
        @NotNull
        public <T extends Tx> T getCachedTxForDBO(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Tx tx = this.txns.get(dbo);
            Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type T of org.vitrivr.cottontail.legacy.AbstractMigrationManager.LegacyMigrationContext.getCachedTxForDBO");
            return (T)tx;
        }

        @Override
        public void signalEvent(@NotNull Event event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            throw new UnsupportedOperationException("Operation signalEvent() not supported for LegacyMigrationContext.");
        }

        @Override
        @NotNull
        public Flow<Tuple> execute(@NotNull Operator operator) {
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            throw new UnsupportedOperationException("Operation execute() not supported for LegacyMigrationContext.");
        }

        @Override
        public void commit() {
            if (!(this.getState() == TransactionStatus.IDLE)) {
                boolean bl = false;
                String string = "Cannot commit transaction " + this.getTransactionId() + " because it is in wrong state (s = " + this.getState() + ").";
                throw new IllegalStateException(string.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            this.txns.clear();
            this.ended = System.currentTimeMillis();
            this.state = TransactionStatus.COMMIT;
        }

        @Override
        public void rollback() {
            if (!(this.getState() == TransactionStatus.IDLE || this.getState() == TransactionStatus.ERROR)) {
                boolean bl = false;
                String string = "Cannot rollback transaction " + this.getTransactionId() + " because it is in wrong state (s = " + this.getState() + ").";
                throw new IllegalStateException(string.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            this.txns.clear();
            this.ended = System.currentTimeMillis();
            this.state = TransactionStatus.ROLLBACK;
        }

        @Override
        public void kill() {
            throw new UnsupportedOperationException("Operation kill() not supported for LegacyMigrationContext.");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020.H\u0016J\b\u00108\u001a\u000209H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\u0006\u0010=\u001a\u00020>H\u0016J!\u0010?\u001a\u0004\u0018\u0001H@\"\b\b\u0000\u0010@*\u00020.2\u0006\u0010A\u001a\u00020-H\u0016\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u000209H\u0016J\b\u0010D\u001a\u000209H\u0016J\u0010\u0010E\u001a\u0002092\u0006\u0010F\u001a\u00020GH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\r@RX\u0096\u000e\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\tR\u0014\u0010 \u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\tR\u0014\u0010\"\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\tR\u001e\u0010%\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020$@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0018\u0010(\u001a\u00060\rj\u0002`)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u000fR\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u000200X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006H"}, d2={"Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager$MigrationContext;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionMetadata;", "xodusTx", "Ljetbrains/exodus/env/Transaction;", "(Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager;Ljetbrains/exodus/env/Transaction;)V", "availableIntraQueryWorkers", "", "getAvailableIntraQueryWorkers", "()I", "availableQueryWorkers", "getAvailableQueryWorkers", "created", "", "getCreated", "()J", "<set-?>", "ended", "getEnded", "()Ljava/lang/Long;", "Ljava/lang/Long;", "manager", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "getManager", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "notifyOnCommit", "", "Lorg/vitrivr/cottontail/dbms/general/Tx$WithCommitFinalization;", "notifyOnRollback", "Lorg/vitrivr/cottontail/dbms/general/Tx$WithRollbackFinalization;", "numberOfError", "getNumberOfError", "numberOfOngoing", "getNumberOfOngoing", "numberOfSuccess", "getNumberOfSuccess", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionStatus;", "state", "getState", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionStatus;", "transactionId", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "getTransactionId", "txns", "", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "Lorg/vitrivr/cottontail/dbms/general/Tx;", "type", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "getType", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "getXodusTx", "()Ljetbrains/exodus/env/Transaction;", "cacheTx", "", "tx", "commit", "", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "operator", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "getCachedTxForDBO", "T", "dbo", "(Lorg/vitrivr/cottontail/dbms/general/DBO;)Lorg/vitrivr/cottontail/dbms/general/Tx;", "kill", "rollback", "signalEvent", "event", "Lorg/vitrivr/cottontail/dbms/events/Event;", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nAbstractMigrationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractMigrationManager.kt\norg/vitrivr/cottontail/legacy/AbstractMigrationManager$MigrationContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,502:1\n1#2:503\n*E\n"})
    public final class MigrationContext
    implements org.vitrivr.cottontail.dbms.execution.transactions.Transaction,
    TransactionMetadata {
        @NotNull
        private final Transaction xodusTx;
        private final long transactionId;
        @NotNull
        private final TransactionType type;
        @NotNull
        private volatile TransactionStatus state;
        private final long created;
        @Nullable
        private Long ended;
        private final int numberOfSuccess;
        private final int numberOfError;
        private final int numberOfOngoing;
        private final int availableQueryWorkers;
        private final int availableIntraQueryWorkers;
        @NotNull
        private final Map<DBO, Tx> txns;
        @NotNull
        private final List<Tx.WithCommitFinalization> notifyOnCommit;
        @NotNull
        private final List<Tx.WithRollbackFinalization> notifyOnRollback;

        public MigrationContext(Transaction xodusTx) {
            Intrinsics.checkNotNullParameter((Object)xodusTx, (String)"xodusTx");
            this.xodusTx = xodusTx;
            this.transactionId = AbstractMigrationManager.this.transactionIdCounter.getAndIncrement();
            this.type = TransactionType.SYSTEM_EXCLUSIVE;
            this.state = TransactionStatus.IDLE;
            this.created = System.currentTimeMillis();
            Object2ObjectMap object2ObjectMap = Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)new Object2ObjectLinkedOpenHashMap()));
            Intrinsics.checkNotNullExpressionValue((Object)object2ObjectMap, (String)"synchronize(...)");
            this.txns = (Map)object2ObjectMap;
            List list = Collections.synchronizedList(new LinkedList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
            this.notifyOnCommit = list;
            List list2 = Collections.synchronizedList(new LinkedList());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"synchronizedList(...)");
            this.notifyOnRollback = list2;
        }

        @Override
        @NotNull
        public Transaction getXodusTx() {
            return this.xodusTx;
        }

        @Override
        public long getTransactionId() {
            return this.transactionId;
        }

        @Override
        @NotNull
        public TransactionType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public TransactionStatus getState() {
            return this.state;
        }

        @Override
        public long getCreated() {
            return this.created;
        }

        @Override
        @Nullable
        public Long getEnded() {
            return this.ended;
        }

        @Override
        public int getNumberOfSuccess() {
            return this.numberOfSuccess;
        }

        @Override
        public int getNumberOfError() {
            return this.numberOfError;
        }

        @Override
        public int getNumberOfOngoing() {
            return this.numberOfOngoing;
        }

        @Override
        @NotNull
        public TransactionManager getManager() {
            throw new UnsupportedOperationException("Xodus transaction not available for LegacyMigrationContext.");
        }

        @Override
        public int getAvailableQueryWorkers() {
            return this.availableQueryWorkers;
        }

        @Override
        public int getAvailableIntraQueryWorkers() {
            return this.availableIntraQueryWorkers;
        }

        @Override
        public boolean cacheTx(@NotNull Tx tx) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            return this.txns.putIfAbsent(tx.getDbo(), tx) != null;
        }

        @Override
        @Nullable
        public <T extends Tx> T getCachedTxForDBO(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            return (T)this.txns.get(dbo);
        }

        @Override
        public void signalEvent(@NotNull Event event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        @Override
        @NotNull
        public Flow<Tuple> execute(@NotNull Operator operator) {
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            throw new UnsupportedOperationException("Operation execute() not supported for MigrationContext.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() {
            if (!(this.getState() == TransactionStatus.IDLE)) {
                boolean $i$a$-check-AbstractMigrationManager$MigrationContext$commit$22 = false;
                String $i$a$-check-AbstractMigrationManager$MigrationContext$commit$22 = "Cannot commit transaction " + this.getTransactionId() + " because it is in wrong state (s = " + this.getState() + ").";
                throw new IllegalStateException($i$a$-check-AbstractMigrationManager$MigrationContext$commit$22.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            try {
                for (Tx.WithCommitFinalization txn : this.notifyOnCommit) {
                    txn.beforeCommit();
                }
                this.getXodusTx().commit();
            }
            catch (Throwable e) {
                this.getXodusTx().abort();
                throw e;
            }
            finally {
                this.txns.clear();
                this.notifyOnCommit.clear();
                this.notifyOnRollback.clear();
                this.ended = System.currentTimeMillis();
                this.state = TransactionStatus.COMMIT;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() {
            if (!(this.getState() == TransactionStatus.IDLE || this.getState() == TransactionStatus.ERROR)) {
                boolean $i$a$-check-AbstractMigrationManager$MigrationContext$rollback$22 = false;
                String $i$a$-check-AbstractMigrationManager$MigrationContext$rollback$22 = "Cannot rollback transaction " + this.getTransactionId() + " because it is in wrong state (s = " + this.getState() + ").";
                throw new IllegalStateException($i$a$-check-AbstractMigrationManager$MigrationContext$rollback$22.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            try {
                try {
                    for (Tx.WithRollbackFinalization txn : this.notifyOnRollback) {
                        txn.beforeRollback();
                    }
                }
                finally {
                    this.getXodusTx().abort();
                }
            }
            finally {
                this.txns.clear();
                this.notifyOnCommit.clear();
                this.notifyOnRollback.clear();
                this.ended = System.currentTimeMillis();
                this.state = TransactionStatus.ROLLBACK;
            }
        }

        @Override
        public void kill() {
            throw new UnsupportedOperationException("Operation kill() not supported for MigrationContext.");
        }
    }
}

