/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.serializers.tablets;

import java.nio.ByteBuffer;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.tablets.Tablet;
import org.vitrivr.cottontail.storage.serializers.tablets.TabletSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/tablets/LZ4TabletSerializer;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "Lorg/vitrivr/cottontail/storage/serializers/tablets/TabletSerializer;", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "size", "", "(Lorg/vitrivr/cottontail/core/types/Types;I)V", "compressBuffer", "Ljava/nio/ByteBuffer;", "compressor", "Lnet/jpountz/lz4/LZ4Compressor;", "decompressor", "Lnet/jpountz/lz4/LZ4FastDecompressor;", "kotlin.jvm.PlatformType", "getSize", "()I", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "fromEntry", "Lorg/vitrivr/cottontail/core/values/tablets/Tablet;", "entry", "Ljetbrains/exodus/ByteIterable;", "toEntry", "tablet", "cottontaildb-dbms"})
public final class LZ4TabletSerializer<T extends Value>
implements TabletSerializer<T> {
    @NotNull
    private final Types<T> type;
    private final int size;
    @NotNull
    private final LZ4Compressor compressor;
    private final LZ4FastDecompressor decompressor;
    @NotNull
    private final ByteBuffer compressBuffer;

    public LZ4TabletSerializer(@NotNull Types<T> type, int size) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.type = type;
        this.size = size;
        LZ4Compressor lZ4Compressor = TabletSerializer.Companion.getFACTORY().highCompressor();
        Intrinsics.checkNotNullExpressionValue((Object)lZ4Compressor, (String)"highCompressor(...)");
        this.compressor = lZ4Compressor;
        this.decompressor = TabletSerializer.Companion.getFACTORY().fastDecompressor();
        Types<T> types = this.getType();
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.compressor.maxCompressedLength((this.size >> 3) + (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE) ? this.size << 3 : (types instanceof Types.BooleanVector ? this.size * (this.getType().getLogicalSize() >> 3) + 4 : this.size * this.getType().getPhysicalSize()))));
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(...)");
        this.compressBuffer = byteBuffer;
    }

    @Override
    @NotNull
    public Types<T> getType() {
        return this.type;
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Tablet<T> fromEntry(@NotNull ByteIterable entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.compressBuffer.clear();
        for (byte b : entry) {
            this.compressBuffer.put(b);
        }
        Tablet tablet = Tablet.Companion.of$default((Tablet.Companion)Tablet.Companion, (int)this.size, this.getType(), (boolean)false, (int)4, null);
        this.decompressor.decompress(this.compressBuffer.flip(), tablet.getBuffer().clear());
        tablet.getBuffer().clear();
        return tablet;
    }

    @Override
    @NotNull
    public ByteIterable toEntry(@NotNull Tablet<T> tablet) {
        Intrinsics.checkNotNullParameter(tablet, (String)"tablet");
        this.compressor.compress(tablet.getBuffer().clear(), this.compressBuffer.clear());
        tablet.getBuffer().clear();
        int n = 0;
        int n2 = this.compressBuffer.flip().limit();
        byte[] byArray = new byte[n2];
        while (n < n2) {
            int n3 = n++;
            byArray[n3] = this.compressBuffer.get();
        }
        byte[] byArray2 = byArray;
        return (ByteIterable)new ArrayByteIterable(byArray2);
    }
}

