/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.serializers.tablets;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.tablets.Tablet;
import org.vitrivr.cottontail.storage.serializers.tablets.TabletSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/tablets/NoneTabletSerializer;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "Lorg/vitrivr/cottontail/storage/serializers/tablets/TabletSerializer;", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "size", "", "(Lorg/vitrivr/cottontail/core/types/Types;I)V", "getSize", "()I", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "fromEntry", "Lorg/vitrivr/cottontail/core/values/tablets/Tablet;", "entry", "Ljetbrains/exodus/ByteIterable;", "toEntry", "tablet", "cottontaildb-dbms"})
public final class NoneTabletSerializer<T extends Value>
implements TabletSerializer<T> {
    @NotNull
    private final Types<T> type;
    private final int size;

    public NoneTabletSerializer(@NotNull Types<T> type, int size) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.type = type;
        this.size = size;
    }

    @Override
    @NotNull
    public Types<T> getType() {
        return this.type;
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Tablet<T> fromEntry(@NotNull ByteIterable entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Tablet tablet = Tablet.Companion.of$default((Tablet.Companion)Tablet.Companion, (int)this.size, this.getType(), (boolean)false, (int)4, null);
        for (byte b : entry) {
            tablet.getBuffer().put(b);
        }
        return tablet;
    }

    @Override
    @NotNull
    public ByteIterable toEntry(@NotNull Tablet<T> tablet) {
        Intrinsics.checkNotNullParameter(tablet, (String)"tablet");
        int n = 0;
        int n2 = tablet.getBuffer().clear().limit();
        byte[] byArray = new byte[n2];
        while (n < n2) {
            int n3 = n++;
            byArray[n3] = tablet.getBuffer().get();
        }
        byte[] byArray2 = byArray;
        return (ByteIterable)new ArrayByteIterable(byArray2);
    }
}

