/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.serializers.tablets;

import java.nio.ByteBuffer;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.tablets.Tablet;
import org.vitrivr.cottontail.storage.serializers.tablets.TabletSerializer;
import org.xerial.snappy.BitShuffle;
import org.xerial.snappy.BitShuffleType;
import org.xerial.snappy.Snappy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/tablets/SnappyTabletSerializer;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "Lorg/vitrivr/cottontail/storage/serializers/tablets/TabletSerializer;", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "size", "", "(Lorg/vitrivr/cottontail/core/types/Types;I)V", "bitShuffleType", "Lorg/xerial/snappy/BitShuffleType;", "compressBuffer", "Ljava/nio/ByteBuffer;", "shuffleBuffer", "getSize", "()I", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "fromEntry", "Lorg/vitrivr/cottontail/core/values/tablets/Tablet;", "entry", "Ljetbrains/exodus/ByteIterable;", "toEntry", "tablet", "cottontaildb-dbms"})
public final class SnappyTabletSerializer<T extends Value>
implements TabletSerializer<T> {
    @NotNull
    private final Types<T> type;
    private final int size;
    @NotNull
    private final ByteBuffer shuffleBuffer;
    @NotNull
    private final ByteBuffer compressBuffer;
    @NotNull
    private final BitShuffleType bitShuffleType;

    public SnappyTabletSerializer(@NotNull Types<T> type, int size) {
        BitShuffleType bitShuffleType;
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.type = type;
        this.size = size;
        Types<T> types = this.getType();
        if (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE)) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.size >> 3);
            byteBuffer = byteBuffer2;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocateDirect(...)");
        } else if (types instanceof Types.BooleanVector) {
            ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect((this.size * this.getType().getLogicalSize() >> 3) + 4);
            byteBuffer = byteBuffer3;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"allocateDirect(...)");
        } else {
            ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(this.size * this.getType().getPhysicalSize());
            byteBuffer = byteBuffer4;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer4, (String)"allocateDirect(...)");
        }
        this.shuffleBuffer = byteBuffer;
        ByteBuffer byteBuffer5 = ByteBuffer.allocateDirect((this.size >> 3) + Snappy.maxCompressedLength((int)this.shuffleBuffer.capacity()));
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer5, (String)"allocateDirect(...)");
        this.compressBuffer = byteBuffer5;
        types = this.getType();
        if (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
            bitShuffleType = BitShuffleType.BYTE;
        } else if ((((Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE) ? true : Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) ? true : Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) ? true : Intrinsics.areEqual(types, (Object)Types.Uuid.INSTANCE)) ? true : types instanceof Types.LongVector) {
            bitShuffleType = BitShuffleType.LONG;
        } else if ((((Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE) ? true : Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE)) ? true : types instanceof Types.HalfVector) ? true : types instanceof Types.FloatVector) ? true : types instanceof Types.Complex32Vector) {
            bitShuffleType = BitShuffleType.FLOAT;
        } else if ((Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE) ? true : types instanceof Types.IntVector) ? true : types instanceof Types.BooleanVector) {
            bitShuffleType = BitShuffleType.INT;
        } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE)) {
            bitShuffleType = BitShuffleType.SHORT;
        } else if (((Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE) ? true : Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE)) ? true : types instanceof Types.DoubleVector) ? true : types instanceof Types.Complex64Vector) {
            bitShuffleType = BitShuffleType.DOUBLE;
        } else {
            throw new IllegalArgumentException("Type " + this.getType() + " is not supported for tablet serialization.");
        }
        this.bitShuffleType = bitShuffleType;
    }

    @Override
    @NotNull
    public Types<T> getType() {
        return this.type;
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Tablet<T> fromEntry(@NotNull ByteIterable entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.compressBuffer.clear();
        for (byte b : entry) {
            this.compressBuffer.put(b);
        }
        Tablet tablet = Tablet.Companion.of(this.size, this.getType(), true);
        tablet.getBuffer().put(0, this.compressBuffer.flip(), 0, this.size >> 3);
        Snappy.uncompress((ByteBuffer)this.compressBuffer.position(this.size >> 3), (ByteBuffer)this.shuffleBuffer.clear());
        BitShuffle.unshuffle((ByteBuffer)this.shuffleBuffer, (BitShuffleType)this.bitShuffleType, (ByteBuffer)tablet.getBuffer().slice(this.size >> 3, this.shuffleBuffer.capacity()));
        tablet.getBuffer().clear();
        return tablet;
    }

    @Override
    @NotNull
    public ByteIterable toEntry(@NotNull Tablet<T> tablet) {
        Intrinsics.checkNotNullParameter(tablet, (String)"tablet");
        this.compressBuffer.clear().put(0, tablet.getBuffer().clear(), 0, this.size >> 3);
        BitShuffle.shuffle((ByteBuffer)tablet.getBuffer().position(this.size >> 3), (BitShuffleType)this.bitShuffleType, (ByteBuffer)this.shuffleBuffer.clear());
        Snappy.compress((ByteBuffer)this.shuffleBuffer, (ByteBuffer)this.compressBuffer.position(this.size >> 3));
        tablet.getBuffer().clear();
        int n = 0;
        int n2 = this.compressBuffer.position(0).limit();
        byte[] byArray = new byte[n2];
        while (n < n2) {
            int n3 = n++;
            byArray[n3] = this.compressBuffer.get();
        }
        byte[] byArray2 = byArray;
        return (ByteIterable)new ArrayByteIterable(byArray2);
    }
}

