/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.serializers.tuples;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.UShort;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.BooleanExtensionKt;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.tuple.StandaloneTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.BooleanValue;
import org.vitrivr.cottontail.core.values.BooleanVectorValue;
import org.vitrivr.cottontail.core.values.ByteStringValue;
import org.vitrivr.cottontail.core.values.ByteValue;
import org.vitrivr.cottontail.core.values.Complex32Value;
import org.vitrivr.cottontail.core.values.Complex32VectorValue;
import org.vitrivr.cottontail.core.values.Complex64Value;
import org.vitrivr.cottontail.core.values.Complex64VectorValue;
import org.vitrivr.cottontail.core.values.DateValue;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.DoubleVectorValue;
import org.vitrivr.cottontail.core.values.FloatValue;
import org.vitrivr.cottontail.core.values.FloatVectorValue;
import org.vitrivr.cottontail.core.values.HalfVectorValue;
import org.vitrivr.cottontail.core.values.IntValue;
import org.vitrivr.cottontail.core.values.IntVectorValue;
import org.vitrivr.cottontail.core.values.LongValue;
import org.vitrivr.cottontail.core.values.LongVectorValue;
import org.vitrivr.cottontail.core.values.PublicValue;
import org.vitrivr.cottontail.core.values.ShortValue;
import org.vitrivr.cottontail.core.values.ShortVectorValue;
import org.vitrivr.cottontail.core.values.StringValue;
import org.vitrivr.cottontail.core.values.UuidValue;
import org.vitrivr.cottontail.utilities.math.Half;
import org.vitrivr.cottontail.utilities.math.HalfKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nJ\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001d\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/tuples/TupleSerializer;", "", "schema", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;)V", "getSchema", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "fromByteBuffer", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "buffer", "Ljava/nio/ByteBuffer;", "readNonNullableValue", "Lorg/vitrivr/cottontail/core/types/Value;", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "readNullableValue", "sizeOf", "", "tuple", "toByteBuffer", "writeValue", "", "value", "Lorg/vitrivr/cottontail/core/values/PublicValue;", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nTupleSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TupleSerializer.kt\norg/vitrivr/cottontail/storage/serializers/tuples/TupleSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,398:1\n1#2:399\n13344#3,2:400\n13351#3,2:402\n13351#3,2:404\n13344#3,2:406\n13344#3,2:408\n13330#3,2:410\n13337#3,2:412\n13323#3,2:414\n*S KotlinDebug\n*F\n+ 1 TupleSerializer.kt\norg/vitrivr/cottontail/storage/serializers/tuples/TupleSerializer\n*L\n168#1:400,2\n169#1:402,2\n171#1:404,2\n172#1:406,2\n173#1:408,2\n174#1:410,2\n175#1:412,2\n176#1:414,2\n*E\n"})
public final class TupleSerializer {
    @NotNull
    private final ColumnDef<?>[] schema;

    public TupleSerializer(@NotNull ColumnDef<?>[] schema) {
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        this.schema = schema;
    }

    @NotNull
    public final ColumnDef<?>[] getSchema() {
        return this.schema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int sizeOf(@NotNull Tuple tuple) {
        Intrinsics.checkNotNullParameter((Object)tuple, (String)"tuple");
        int size = 8;
        int n = this.schema.length;
        for (int i2 = 0; i2 < n; ++i2) {
            int n2;
            Value value = tuple.get(i2);
            PublicValue value2 = value instanceof PublicValue ? (PublicValue)value : null;
            if (value2 instanceof BooleanValue ? true : value2 instanceof ByteValue) {
                n2 = 1;
            } else {
                if (value2 instanceof BooleanVectorValue) {
                    throw new NotImplementedError(null, 1, null);
                }
                if (value2 instanceof Complex32Value) {
                    n2 = 8;
                } else if (value2 instanceof Complex32VectorValue) {
                    n2 = 2 * ((Complex32VectorValue)value2).getLogicalSize() * 4;
                } else if (value2 instanceof Complex64Value) {
                    n2 = 16;
                } else if (value2 instanceof Complex64VectorValue) {
                    n2 = 2 * ((Complex64VectorValue)value2).getLogicalSize() * 8;
                } else if (value2 instanceof DateValue) {
                    n2 = 8;
                } else if (value2 instanceof DoubleValue) {
                    n2 = 8;
                } else if (value2 instanceof DoubleVectorValue) {
                    n2 = ((DoubleVectorValue)value2).getLogicalSize() * 4;
                } else if (value2 instanceof FloatValue) {
                    n2 = 4;
                } else if (value2 instanceof FloatVectorValue) {
                    n2 = ((FloatVectorValue)value2).getLogicalSize() * 4;
                } else if (value2 instanceof HalfVectorValue) {
                    n2 = ((HalfVectorValue)value2).getLogicalSize() * 2;
                } else if (value2 instanceof IntValue) {
                    n2 = 4;
                } else if (value2 instanceof IntVectorValue) {
                    n2 = ((IntVectorValue)value2).getLogicalSize() * 4;
                } else if (value2 instanceof LongValue) {
                    n2 = 8;
                } else if (value2 instanceof LongVectorValue) {
                    n2 = ((LongVectorValue)value2).getLogicalSize() * 8;
                } else if (value2 instanceof ShortValue) {
                    n2 = 2;
                } else if (value2 instanceof ShortVectorValue) {
                    n2 = ((ShortVectorValue)value2).getLogicalSize() * 2;
                } else if (value2 instanceof ByteStringValue) {
                    n2 = ((ByteStringValue)value2).getLogicalSize();
                } else if (value2 instanceof StringValue) {
                    n2 = ((StringValue)value2).unbox-impl().length() * 2;
                } else if (value2 instanceof UuidValue) {
                    n2 = 16;
                } else {
                    if (value2 != null) throw new NoWhenBranchMatchedException();
                    value = this.schema[i2].getType();
                    if (Intrinsics.areEqual((Object)value, (Object)Types.Boolean.INSTANCE) ? true : Intrinsics.areEqual((Object)value, (Object)Types.Byte.INSTANCE)) {
                        n2 = 1;
                    } else if (Intrinsics.areEqual((Object)value, (Object)Types.Complex32.INSTANCE) ? true : value instanceof Types.Complex32Vector) {
                        n2 = 8;
                    } else if (Intrinsics.areEqual((Object)value, (Object)Types.Complex64.INSTANCE) ? true : value instanceof Types.Complex64Vector) {
                        n2 = 16;
                    } else if (Intrinsics.areEqual((Object)value, (Object)Types.Double.INSTANCE) ? true : value instanceof Types.DoubleVector) {
                        n2 = 8;
                    } else if (Intrinsics.areEqual((Object)value, (Object)Types.Float.INSTANCE) ? true : value instanceof Types.FloatVector) {
                        n2 = 4;
                    } else if ((Intrinsics.areEqual((Object)value, (Object)Types.Long.INSTANCE) ? true : Intrinsics.areEqual((Object)value, (Object)Types.Date.INSTANCE)) ? true : value instanceof Types.LongVector) {
                        n2 = 8;
                    } else if (Intrinsics.areEqual((Object)value, (Object)Types.Short.INSTANCE)) {
                        n2 = 2;
                    } else if ((((Intrinsics.areEqual((Object)value, (Object)Types.ByteString.INSTANCE) ? true : Intrinsics.areEqual((Object)value, (Object)Types.String.INSTANCE)) ? true : Intrinsics.areEqual((Object)value, (Object)Types.Uuid.INSTANCE)) ? true : Intrinsics.areEqual((Object)value, (Object)Types.Int.INSTANCE)) ? true : value instanceof Types.IntVector) {
                        n2 = 4;
                    } else if (value instanceof Types.ShortVector) {
                        n2 = 2;
                    } else if (value instanceof Types.HalfVector) {
                        n2 = 2;
                    } else {
                        if (!(value instanceof Types.BooleanVector)) throw new NoWhenBranchMatchedException();
                        throw new NotImplementedError(null, 1, null);
                    }
                }
            }
            size += n2;
        }
        return size;
    }

    @NotNull
    public final ByteBuffer toByteBuffer(@NotNull Tuple tuple) {
        Intrinsics.checkNotNullParameter((Object)tuple, (String)"tuple");
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.sizeOf(tuple));
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(...)");
        return this.toByteBuffer(tuple, byteBuffer);
    }

    @NotNull
    public final ByteBuffer toByteBuffer(@NotNull Tuple tuple, @NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)tuple, (String)"tuple");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.mark();
        Object[] objectArray = this.schema;
        Object[] objectArray2 = tuple.getColumns();
        if (!ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])objectArray2)) {
            boolean bl = false;
            String string = "Tuple is not compatible with provided schema.";
            throw new IllegalArgumentException(string.toString());
        }
        buffer.putLong(tuple.getTupleId());
        int n = this.schema.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Value value = tuple.get(i2);
            PublicValue value2 = value instanceof PublicValue ? (PublicValue)value : null;
            this.writeValue(value2, this.schema[i2].getType(), buffer);
        }
        ByteBuffer byteBuffer = buffer.reset();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"reset(...)");
        return byteBuffer;
    }

    @NotNull
    public final Tuple fromByteBuffer(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long tupleId = buffer.getLong();
        int n = this.schema.length;
        Value[] valueArray = new Value[n];
        for (int j = 0; j < n; ++j) {
            int n2 = j;
            ColumnDef<?> column = this.schema[n2];
            valueArray[n2] = column.getNullable() ? this.readNullableValue(column.getType(), buffer) : this.readNonNullableValue(column.getType(), buffer);
        }
        Value[] values = valueArray;
        return (Tuple)new StandaloneTuple(tupleId, this.schema, values);
    }

    private final void writeValue(PublicValue value, Types<?> type, ByteBuffer buffer) {
        PublicValue publicValue = value;
        if (publicValue instanceof BooleanValue) {
            buffer.put(BooleanExtensionKt.toByte((boolean)((BooleanValue)value).unbox-impl()));
        } else if (publicValue instanceof ByteValue) {
            buffer.put(((ByteValue)value).unbox-impl());
        } else if (publicValue instanceof ShortValue) {
            buffer.putShort(((ShortValue)value).unbox-impl());
        } else if (publicValue instanceof IntValue) {
            buffer.putInt(((IntValue)value).unbox-impl());
        } else if (publicValue instanceof LongValue) {
            buffer.putLong(((LongValue)value).unbox-impl());
        } else if (publicValue instanceof FloatValue) {
            buffer.putFloat(((FloatValue)value).unbox-impl());
        } else if (publicValue instanceof DoubleValue) {
            buffer.putDouble(((DoubleValue)value).unbox-impl());
        } else if (publicValue instanceof DateValue) {
            buffer.putLong(((DateValue)value).unbox-impl());
        } else if (publicValue instanceof Complex32Value) {
            buffer.putFloat(((Complex32Value)value).unbox-impl()[0]);
            buffer.putFloat(((Complex32Value)value).unbox-impl()[1]);
        } else if (publicValue instanceof Complex64Value) {
            buffer.putDouble(((Complex64Value)value).unbox-impl()[0]);
            buffer.putDouble(((Complex64Value)value).unbox-impl()[0]);
        } else if (publicValue instanceof ByteStringValue) {
            buffer.putInt(((ByteStringValue)value).unbox-impl().length);
            buffer.put(((ByteStringValue)value).unbox-impl());
        } else if (publicValue instanceof StringValue) {
            String string = ((StringValue)value).unbox-impl();
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] bytes = byArray;
            buffer.putInt(bytes.length);
            buffer.put(bytes);
        } else if (publicValue instanceof UuidValue) {
            buffer.putLong(((UuidValue)value).unbox-impl().getLeastSignificantBits());
            buffer.putLong(((UuidValue)value).unbox-impl().getMostSignificantBits());
        } else if (publicValue instanceof Complex32VectorValue) {
            float[] $this$forEach$iv = ((Complex32VectorValue)value).unbox-impl();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                float element$iv;
                float it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                buffer.putFloat(it);
            }
        } else if (publicValue instanceof Complex64VectorValue) {
            double[] $this$forEach$iv = ((Complex64VectorValue)value).unbox-impl();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                double element$iv;
                double it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                buffer.putDouble(it);
            }
        } else {
            if (publicValue instanceof BooleanVectorValue) {
                throw new NotImplementedError(null, 1, null);
            }
            if (publicValue instanceof DoubleVectorValue) {
                double[] $this$forEach$iv = ((DoubleVectorValue)value).unbox-impl();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    double element$iv;
                    double it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    buffer.putDouble(it);
                }
            } else if (publicValue instanceof FloatVectorValue) {
                float[] $this$forEach$iv = ((FloatVectorValue)value).unbox-impl();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    float element$iv;
                    float it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    buffer.putFloat(it);
                }
            } else if (publicValue instanceof HalfVectorValue) {
                float[] $this$forEach$iv = ((HalfVectorValue)value).unbox-impl();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    float element$iv;
                    float it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    buffer.putShort(Half.toShort-impl((short)HalfKt.Half((float)it)));
                }
            } else if (publicValue instanceof IntVectorValue) {
                int[] $this$forEach$iv = ((IntVectorValue)value).unbox-impl();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    int element$iv;
                    int it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    buffer.putInt(it);
                }
            } else if (publicValue instanceof LongVectorValue) {
                long[] $this$forEach$iv = ((LongVectorValue)value).unbox-impl();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    long element$iv;
                    long it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    buffer.putLong(it);
                }
            } else if (publicValue instanceof ShortVectorValue) {
                short[] $this$forEach$iv = ((ShortVectorValue)value).unbox-impl();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    short element$iv;
                    short it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    buffer.putShort(it);
                }
            } else if (publicValue == null) {
                Types<?> types = type;
                if ((Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE) ? true : types instanceof Types.BooleanVector) ? true : Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
                    buffer.put((byte)-128);
                } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE) ? true : types instanceof Types.ShortVector) {
                    buffer.putShort((short)Short.MIN_VALUE);
                } else if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE) ? true : types instanceof Types.IntVector) {
                    buffer.putInt(Integer.MIN_VALUE);
                } else if ((Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE) ? true : Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) ? true : types instanceof Types.LongVector) {
                    buffer.putLong(Long.MIN_VALUE);
                } else if (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE) ? true : types instanceof Types.DoubleVector) {
                    buffer.putDouble(Double.MIN_VALUE);
                } else if (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE) ? true : types instanceof Types.FloatVector) {
                    buffer.putFloat(Float.MIN_VALUE);
                } else if (Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE) ? true : types instanceof Types.Complex32Vector) {
                    buffer.putFloat(Float.MIN_VALUE);
                    buffer.putFloat(Float.MIN_VALUE);
                } else if (Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE) ? true : types instanceof Types.Complex64Vector) {
                    buffer.putDouble(Double.MIN_VALUE);
                    buffer.putDouble(Double.MIN_VALUE);
                } else if (types instanceof Types.HalfVector) {
                    buffer.putShort(Half.toShort-impl((short)Half.Companion.getMIN_VALUE-ErBQNuc()));
                } else if ((Intrinsics.areEqual(types, (Object)Types.ByteString.INSTANCE) ? true : Intrinsics.areEqual(types, (Object)Types.String.INSTANCE)) ? true : Intrinsics.areEqual(types, (Object)Types.Uuid.INSTANCE)) {
                    buffer.putInt(-1);
                }
            }
        }
    }

    private final Value readNullableValue(Types<?> type, ByteBuffer buffer) {
        Object object;
        Types<?> types = type;
        if (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE)) {
            byte value = buffer.get();
            object = (Value)(value == -128 ? null : BooleanValue.box-impl((boolean)BooleanValue.constructor-impl((value == 0 ? 1 : 0) != 0)));
        } else if (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
            byte value = buffer.get();
            object = (Value)(value == -128 ? null : ByteValue.box-impl((byte)ByteValue.constructor-impl((byte)value)));
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE)) {
            float real = buffer.getFloat();
            float imaginary = buffer.getFloat();
            Object object2 = real == Float.MIN_VALUE && imaginary == Float.MIN_VALUE ? null : Complex32Value.constructor-impl((float)real, (float)imaginary);
            object = object2 != null ? Complex32Value.box-impl((float[])object2) : null;
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE)) {
            double real = buffer.getDouble();
            double imaginary = buffer.getDouble();
            Object object3 = real == Double.MIN_VALUE && imaginary == Double.MIN_VALUE ? null : Complex64Value.constructor-impl((double)real, (double)imaginary);
            object = object3 != null ? Complex64Value.box-impl((double[])object3) : null;
        } else if (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE)) {
            double value = buffer.getDouble();
            object = (Value)(value == Double.MIN_VALUE ? null : DoubleValue.box-impl((double)DoubleValue.constructor-impl((double)value)));
        } else if (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE)) {
            float value = buffer.getFloat();
            object = (Value)(value == Float.MIN_VALUE ? null : FloatValue.box-impl((float)FloatValue.constructor-impl((float)value)));
        } else if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE)) {
            int value = buffer.getInt();
            object = (Value)(value == Integer.MIN_VALUE ? null : IntValue.box-impl((int)IntValue.constructor-impl((int)value)));
        } else if (Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) {
            long value = buffer.getLong();
            object = (Value)(value == Long.MIN_VALUE ? null : LongValue.box-impl((long)LongValue.constructor-impl((long)value)));
        } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE)) {
            short value = buffer.getShort();
            object = (Value)(value == Short.MIN_VALUE ? null : ShortValue.box-impl((short)ShortValue.constructor-impl((short)value)));
        } else if (Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) {
            long value = buffer.getLong();
            object = (Value)(value == Long.MIN_VALUE ? null : DateValue.box-impl((long)DateValue.constructor-impl((long)value)));
        } else if (Intrinsics.areEqual(types, (Object)Types.ByteString.INSTANCE)) {
            byte[] byArray;
            int length = buffer.getInt();
            if (length == -1) {
                byArray = null;
            } else {
                int n = 0;
                byte[] imaginary = new byte[length];
                while (n < length) {
                    int n2 = n++;
                    imaginary[n2] = buffer.get();
                }
                byArray = ByteStringValue.constructor-impl((byte[])imaginary);
            }
            object = byArray != null ? ByteStringValue.box-impl(byArray) : null;
        } else if (Intrinsics.areEqual(types, (Object)Types.String.INSTANCE)) {
            String string;
            int length = buffer.getInt();
            if (length == -1) {
                string = null;
            } else {
                int n = 0;
                Object imaginary = new byte[length];
                while (n < length) {
                    int n3 = n++;
                    imaginary[n3] = buffer.get();
                }
                byte[] byArray = imaginary;
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
                imaginary = charset;
                string = StringValue.constructor-impl((String)new String(byArray, (Charset)imaginary));
            }
            object = string != null ? StringValue.box-impl(string) : null;
        } else if (Intrinsics.areEqual(types, (Object)Types.Uuid.INSTANCE)) {
            long leastSignificant = buffer.getLong();
            long mostSignificant = buffer.getLong();
            object = UuidValue.box-impl((UUID)UuidValue.constructor-impl((long)leastSignificant, (long)mostSignificant));
        } else {
            if (types instanceof Types.BooleanVector) {
                throw new NotImplementedError(null, 1, null);
            }
            if (types instanceof Types.Complex32Vector) {
                float[] fArray;
                buffer.mark();
                if (buffer.getDouble() == Double.MIN_VALUE) {
                    fArray = null;
                } else {
                    buffer.reset();
                    int n = 0;
                    int n4 = 2 * type.getLogicalSize();
                    float[] fArray2 = new float[n4];
                    while (n < n4) {
                        int n5 = n++;
                        fArray2[n5] = buffer.getFloat();
                    }
                    fArray = Complex32VectorValue.constructor-impl((float[])fArray2);
                }
                object = fArray != null ? Complex32VectorValue.box-impl(fArray) : null;
            } else if (types instanceof Types.Complex64Vector) {
                double[] dArray;
                buffer.mark();
                if (buffer.getDouble() == Double.MIN_VALUE) {
                    dArray = null;
                } else {
                    buffer.reset();
                    int n = 0;
                    int n6 = 2 * type.getLogicalSize();
                    double[] dArray2 = new double[n6];
                    while (n < n6) {
                        int n7 = n++;
                        dArray2[n7] = buffer.getDouble();
                    }
                    dArray = Complex64VectorValue.constructor-impl((double[])dArray2);
                }
                object = dArray != null ? Complex64VectorValue.box-impl(dArray) : null;
            } else if (types instanceof Types.DoubleVector) {
                double[] dArray;
                buffer.mark();
                if (buffer.getDouble() == Double.MIN_VALUE) {
                    dArray = null;
                } else {
                    buffer.reset();
                    int n = 0;
                    int n8 = type.getLogicalSize();
                    double[] dArray3 = new double[n8];
                    while (n < n8) {
                        int n9 = n++;
                        dArray3[n9] = buffer.getDouble();
                    }
                    dArray = DoubleVectorValue.constructor-impl((double[])dArray3);
                }
                object = dArray != null ? DoubleVectorValue.box-impl(dArray) : null;
            } else if (types instanceof Types.FloatVector) {
                float[] fArray;
                buffer.mark();
                if (buffer.getFloat() == Float.MIN_VALUE) {
                    fArray = null;
                } else {
                    buffer.reset();
                    int n = 0;
                    int n10 = type.getLogicalSize();
                    float[] fArray3 = new float[n10];
                    while (n < n10) {
                        int n11 = n++;
                        fArray3[n11] = buffer.getFloat();
                    }
                    fArray = FloatVectorValue.constructor-impl((float[])fArray3);
                }
                object = fArray != null ? FloatVectorValue.box-impl(fArray) : null;
            } else if (types instanceof Types.IntVector) {
                int[] nArray;
                buffer.mark();
                if (buffer.getInt() == Integer.MIN_VALUE) {
                    nArray = null;
                } else {
                    buffer.reset();
                    int n = 0;
                    int n12 = type.getLogicalSize();
                    int[] nArray2 = new int[n12];
                    while (n < n12) {
                        int n13 = n++;
                        nArray2[n13] = buffer.getInt();
                    }
                    nArray = IntVectorValue.constructor-impl((int[])nArray2);
                }
                object = nArray != null ? IntVectorValue.box-impl(nArray) : null;
            } else if (types instanceof Types.LongVector) {
                long[] lArray;
                buffer.mark();
                if (buffer.getLong() == Long.MIN_VALUE) {
                    lArray = null;
                } else {
                    buffer.reset();
                    int n = 0;
                    int n14 = type.getLogicalSize();
                    long[] lArray2 = new long[n14];
                    while (n < n14) {
                        int n15 = n++;
                        lArray2[n15] = buffer.getLong();
                    }
                    lArray = LongVectorValue.constructor-impl((long[])lArray2);
                }
                object = lArray != null ? LongVectorValue.box-impl(lArray) : null;
            } else if (types instanceof Types.ShortVector) {
                short[] sArray;
                buffer.mark();
                if (buffer.getShort() == Short.MIN_VALUE) {
                    sArray = null;
                } else {
                    buffer.reset();
                    int n = 0;
                    int n16 = type.getLogicalSize();
                    short[] sArray2 = new short[n16];
                    while (n < n16) {
                        int n17 = n++;
                        sArray2[n17] = buffer.getShort();
                    }
                    sArray = ShortVectorValue.constructor-impl((short[])sArray2);
                }
                object = sArray != null ? ShortVectorValue.box-impl(sArray) : null;
            } else if (types instanceof Types.HalfVector) {
                float[] fArray;
                buffer.mark();
                if (buffer.getShort() == Half.toShort-impl((short)Half.Companion.getMIN_VALUE-ErBQNuc())) {
                    fArray = null;
                } else {
                    buffer.reset();
                    int n = 0;
                    int n18 = type.getLogicalSize();
                    float[] fArray4 = new float[n18];
                    while (n < n18) {
                        int n19 = n++;
                        fArray4[n19] = Half.toFloat-impl((short)Half.constructor-impl((short)UShort.constructor-impl((short)buffer.getShort())));
                    }
                    fArray = FloatVectorValue.constructor-impl((float[])fArray4);
                }
                object = fArray != null ? FloatVectorValue.box-impl(fArray) : null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    private final Value readNonNullableValue(Types<?> type, ByteBuffer buffer) {
        BooleanValue booleanValue;
        Types<?> types = type;
        if (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE)) {
            booleanValue = BooleanValue.box-impl((boolean)BooleanValue.constructor-impl((buffer.get() == 0 ? 1 : 0) != 0));
        } else if (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
            booleanValue = ByteValue.box-impl((byte)ByteValue.constructor-impl((byte)buffer.get()));
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE)) {
            booleanValue = Complex32Value.box-impl((float[])Complex32Value.constructor-impl((float)buffer.getFloat(), (float)buffer.getFloat()));
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE)) {
            booleanValue = Complex64Value.box-impl((double[])Complex64Value.constructor-impl((double)buffer.getDouble(), (double)buffer.getDouble()));
        } else if (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE)) {
            booleanValue = DoubleValue.box-impl((double)DoubleValue.constructor-impl((double)buffer.getDouble()));
        } else if (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE)) {
            booleanValue = FloatValue.box-impl((float)FloatValue.constructor-impl((float)buffer.getFloat()));
        } else if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE)) {
            booleanValue = IntValue.box-impl((int)IntValue.constructor-impl((int)buffer.getInt()));
        } else if (Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) {
            booleanValue = LongValue.box-impl((long)LongValue.constructor-impl((long)buffer.getLong()));
        } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE)) {
            booleanValue = ShortValue.box-impl((short)ShortValue.constructor-impl((short)buffer.getShort()));
        } else if (Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) {
            booleanValue = DateValue.box-impl((long)DateValue.constructor-impl((long)buffer.getLong()));
        } else if (Intrinsics.areEqual(types, (Object)Types.ByteString.INSTANCE)) {
            int length = buffer.getInt();
            int n = 0;
            byte[] byArray = new byte[length];
            while (n < length) {
                int n2 = n++;
                byArray[n2] = buffer.get();
            }
            booleanValue = ByteStringValue.box-impl((byte[])ByteStringValue.constructor-impl((byte[])byArray));
        } else if (Intrinsics.areEqual(types, (Object)Types.String.INSTANCE)) {
            int length = buffer.getInt();
            int n = 0;
            Object object = new byte[length];
            while (n < length) {
                int n3 = n++;
                object[n3] = buffer.get();
            }
            byte[] byArray = object;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            object = charset;
            booleanValue = StringValue.box-impl((String)StringValue.constructor-impl((String)new String(byArray, (Charset)object)));
        } else if (Intrinsics.areEqual(types, (Object)Types.Uuid.INSTANCE)) {
            booleanValue = UuidValue.box-impl((UUID)UuidValue.constructor-impl((long)buffer.getLong(), (long)buffer.getLong()));
        } else {
            if (types instanceof Types.BooleanVector) {
                throw new NotImplementedError(null, 1, null);
            }
            if (types instanceof Types.Complex32Vector) {
                int n = 0;
                int n4 = 2 * type.getLogicalSize();
                float[] fArray = new float[n4];
                while (n < n4) {
                    int n5 = n++;
                    fArray[n5] = buffer.getFloat();
                }
                booleanValue = Complex32VectorValue.box-impl((float[])Complex32VectorValue.constructor-impl((float[])fArray));
            } else if (types instanceof Types.Complex64Vector) {
                int n = 0;
                int n6 = 2 * type.getLogicalSize();
                double[] dArray = new double[n6];
                while (n < n6) {
                    int n7 = n++;
                    dArray[n7] = buffer.getDouble();
                }
                booleanValue = Complex64VectorValue.box-impl((double[])Complex64VectorValue.constructor-impl((double[])dArray));
            } else if (types instanceof Types.DoubleVector) {
                int n = 0;
                int n8 = type.getLogicalSize();
                double[] dArray = new double[n8];
                while (n < n8) {
                    int n9 = n++;
                    dArray[n9] = buffer.getDouble();
                }
                booleanValue = DoubleVectorValue.box-impl((double[])DoubleVectorValue.constructor-impl((double[])dArray));
            } else if (types instanceof Types.FloatVector) {
                int n = 0;
                int n10 = type.getLogicalSize();
                float[] fArray = new float[n10];
                while (n < n10) {
                    int n11 = n++;
                    fArray[n11] = buffer.getFloat();
                }
                booleanValue = FloatVectorValue.box-impl((float[])FloatVectorValue.constructor-impl((float[])fArray));
            } else if (types instanceof Types.IntVector) {
                int n = 0;
                int n12 = type.getLogicalSize();
                int[] nArray = new int[n12];
                while (n < n12) {
                    int n13 = n++;
                    nArray[n13] = buffer.getInt();
                }
                booleanValue = IntVectorValue.box-impl((int[])IntVectorValue.constructor-impl((int[])nArray));
            } else if (types instanceof Types.LongVector) {
                int n = 0;
                int n14 = type.getLogicalSize();
                long[] lArray = new long[n14];
                while (n < n14) {
                    int n15 = n++;
                    lArray[n15] = buffer.getLong();
                }
                booleanValue = LongVectorValue.box-impl((long[])LongVectorValue.constructor-impl((long[])lArray));
            } else if (types instanceof Types.ShortVector) {
                int n = 0;
                int n16 = type.getLogicalSize();
                short[] sArray = new short[n16];
                while (n < n16) {
                    int n17 = n++;
                    sArray[n17] = buffer.getShort();
                }
                booleanValue = ShortVectorValue.box-impl((short[])ShortVectorValue.constructor-impl((short[])sArray));
            } else if (types instanceof Types.HalfVector) {
                int n = 0;
                int n18 = type.getLogicalSize();
                float[] fArray = new float[n18];
                while (n < n18) {
                    int n19 = n++;
                    fArray[n19] = Half.toFloat-impl((short)Half.constructor-impl((short)UShort.constructor-impl((short)buffer.getShort())));
                }
                booleanValue = FloatVectorValue.box-impl((float[])FloatVectorValue.constructor-impl((float[])fArray));
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return booleanValue;
    }
}

