/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.selection;

import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020\u0017J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0096\u0002J\u0013\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0000\u00a2\u0006\u0002\u0010%J\r\u0010&\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0002J\b\u0010*\u001a\u00020\u001fH\u0002R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006+"}, d2={"Lorg/vitrivr/cottontail/utilities/selection/HeapSelection;", "T", "", "k", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(ILjava/util/Comparator;)V", "<set-?>", "", "added", "getAdded", "()J", "getComparator", "()Ljava/util/Comparator;", "heap", "", "[Ljava/lang/Object;", "getK", "()I", "size", "getSize", "", "sorted", "getSorted", "()Z", "get", "i", "(I)Ljava/lang/Object;", "heapify", "", "isEmpty", "iterator", "", "offer", "element", "(Ljava/lang/Object;)Ljava/lang/Object;", "peek", "()Ljava/lang/Object;", "siftDown", "n", "sort", "cottontaildb-dbms"})
public final class HeapSelection<T>
implements Iterable<T>,
KMappedMarker {
    private final int k;
    @NotNull
    private final Comparator<T> comparator;
    @NotNull
    private final T[] heap;
    private long added;
    private volatile boolean sorted;
    private volatile int size;

    public HeapSelection(int k, @NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.k = k;
        this.comparator = comparator;
        this.heap = new Object[this.k];
        this.sorted = true;
    }

    public final int getK() {
        return this.k;
    }

    @NotNull
    public final Comparator<T> getComparator() {
        return this.comparator;
    }

    public final long getAdded() {
        return this.added;
    }

    public final boolean getSorted() {
        return this.sorted;
    }

    public final int getSize() {
        return this.size;
    }

    public final T offer(T element) {
        if (this.size < this.heap.length) {
            this.sorted = false;
            int n = this.size;
            this.size = n + 1;
            this.heap[n] = element;
            if (this.size == this.k) {
                this.heapify();
            }
        } else if (this.comparator.compare(element, this.heap[0]) < 0) {
            this.heap[0] = element;
            this.siftDown(0, this.heap.length - 1);
        }
        ++this.added;
        T t = this.heap[0];
        Intrinsics.checkNotNull(t);
        return t;
    }

    @Nullable
    public final T peek() {
        return (T)ArraysKt.firstOrNull((Object[])this.heap);
    }

    public final T get(int i2) {
        int maxId = this.heap.length - 1;
        if (i2 == maxId) {
            T t = this.heap[0];
            if (t == null) {
                throw new NoSuchElementException("Element at index " + i2 + " does not exist in HeapSelection.");
            }
            return t;
        }
        if (!this.sorted) {
            this.sort();
        }
        T t = this.heap[maxId - i2];
        if (t == null) {
            throw new NoSuchElementException("Element at index " + i2 + " does not exist in HeapSelection.");
        }
        return t;
    }

    private final void sort() {
        int n = Integer.min(this.heap.length, this.size);
        int inc = 1;
        do {
            inc *= 3;
        } while (++inc <= n);
        do {
            for (int i2 = inc /= 3; i2 < n; ++i2) {
                T v = this.heap[i2];
                int j = i2;
                while (this.comparator.compare(this.heap[j - inc], v) < 0) {
                    this.heap[j] = this.heap[j - inc];
                    if ((j -= inc) >= inc) continue;
                }
                this.heap[j] = v;
            }
        } while (inc > 1);
        this.sorted = true;
    }

    private final void siftDown(int i2, int n) {
        int k = i2;
        while (2 * k <= n) {
            int j = 2 * k;
            if (j < n && this.comparator.compare(this.heap[j], this.heap[j + 1]) < 0) {
                ++j;
            }
            if (this.comparator.compare(this.heap[k], this.heap[j]) >= 0) break;
            T a = this.heap[k];
            this.heap[k] = this.heap[j];
            this.heap[j] = a;
            k = j;
        }
    }

    private final void heapify() {
        for (int i2 = Math.floorDiv(this.heap.length, 2); -1 < i2; --i2) {
            this.siftDown(i2, this.heap.length - 1);
        }
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        if (!this.sorted) {
            this.sort();
        }
        return new Iterator<T>(this){
            private final long expectedAdded;
            private int index;
            final /* synthetic */ HeapSelection<T> this$0;
            {
                this.this$0 = $receiver;
                this.expectedAdded = $receiver.getAdded();
                this.index = $receiver.getSize() - 1;
            }

            public boolean hasNext() {
                return this.index >= 0;
            }

            public T next() {
                if (this.expectedAdded != this.this$0.getAdded()) {
                    throw new ConcurrentModificationException("HeapSelection was modified while iterating over it.");
                }
                int n = this.index;
                this.index = n + -1;
                Object object = HeapSelection.access$getHeap$p(this.this$0)[n];
                if (object == null) {
                    throw new NoSuchElementException("Iterator for HeapSelection has no more elements left.");
                }
                return (T)object;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public static final /* synthetic */ Object[] access$getHeap$p(HeapSelection $this) {
        return $this.heap;
    }
}

