/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.catalogue;

import java.io.Closeable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.FunctionRegistry;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.CatalogueTx;
import org.vitrivr.cottontail.dbms.catalogue.entries.IndexStructCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.MetadataEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.column.ColumnMetadata;
import org.vitrivr.cottontail.dbms.entity.EntityMetadata;
import org.vitrivr.cottontail.dbms.events.SchemaEvent;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.execution.ExecutionManager;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionManager;
import org.vitrivr.cottontail.dbms.functions.InitializeKt;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.index.basic.IndexMetadata;
import org.vitrivr.cottontail.dbms.index.cache.InMemoryIndexCache;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;
import org.vitrivr.cottontail.dbms.schema.DefaultSchema;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.dbms.schema.SchemaMetadata;
import org.vitrivr.cottontail.dbms.schema.SchemaTx;
import org.vitrivr.cottontail.dbms.sequence.DefaultSequence;
import org.vitrivr.cottontail.dbms.statistics.StatisticsManager;
import org.vitrivr.cottontail.dbms.statistics.index.IndexStatisticsManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0002<=B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00100\u001a\u000201H\u0016J\u0013\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u000105H\u0096\u0002J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006>"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "config", "Lorg/vitrivr/cottontail/config/Config;", "executor", "Lorg/vitrivr/cottontail/dbms/execution/ExecutionManager;", "(Lorg/vitrivr/cottontail/config/Config;Lorg/vitrivr/cottontail/dbms/execution/ExecutionManager;)V", "cache", "Lorg/vitrivr/cottontail/dbms/index/cache/InMemoryIndexCache;", "getCache", "()Lorg/vitrivr/cottontail/dbms/index/cache/InMemoryIndexCache;", "catalogue", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "functions", "Lorg/vitrivr/cottontail/core/queries/functions/FunctionRegistry;", "getFunctions", "()Lorg/vitrivr/cottontail/core/queries/functions/FunctionRegistry;", "indexStatistics", "Lorg/vitrivr/cottontail/dbms/statistics/index/IndexStatisticsManager;", "getIndexStatistics", "()Lorg/vitrivr/cottontail/dbms/statistics/index/IndexStatisticsManager;", "name", "Lorg/vitrivr/cottontail/core/database/Name$RootName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$RootName;", "parent", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "getParent", "()Lorg/vitrivr/cottontail/dbms/general/DBO;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "statisticsManager", "Lorg/vitrivr/cottontail/dbms/statistics/StatisticsManager;", "getStatisticsManager", "()Lorg/vitrivr/cottontail/dbms/statistics/StatisticsManager;", "transactionManager", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "getTransactionManager", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "equals", "", "other", "", "hashCode", "", "newTx", "Lorg/vitrivr/cottontail/dbms/catalogue/CatalogueTx;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "Companion", "Tx", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nDefaultCatalogue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCatalogue.kt\norg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1#2:274\n*E\n"})
public final class DefaultCatalogue
implements Catalogue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @NotNull
    private final Path path;
    @Nullable
    private final DBO parent;
    @NotNull
    private final FunctionRegistry functions;
    @NotNull
    private final IndexStatisticsManager indexStatistics;
    @NotNull
    private final TransactionManager transactionManager;
    @NotNull
    private final StatisticsManager statisticsManager;
    @NotNull
    private final InMemoryIndexCache cache;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    public static final String ENTITY_STORE_PREFIX = "org.vitrivr.cottontail.store.entity";
    @NotNull
    public static final String COLUMN_STORE_PREFIX = "org.vitrivr.cottontail.store.column";
    @NotNull
    public static final String INDEX_STORE_PREFIX = "org.vitrivr.cottontail.store.index";

    public DefaultCatalogue(@NotNull Config config, @NotNull ExecutionManager executor) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.config = config;
        this.path = this.getConfig().getRoot();
        this.functions = new FunctionRegistry();
        this.transactionManager = new TransactionManager(executor, this.getConfig());
        this.statisticsManager = new StatisticsManager(this, this.getTransactionManager());
        this.cache = new InMemoryIndexCache();
        this.getTransactionManager().register(this.getStatisticsManager());
        Transaction transaction = this.getTransactionManager().getEnvironment$cottontaildb_dbms().beginExclusiveTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"beginExclusiveTransaction(...)");
        Transaction tx = transaction;
        try {
            Object version;
            Object object;
            block10: {
                block9: {
                    if (this.getTransactionManager().getEnvironment$cottontaildb_dbms().getAllStoreNames(tx).size() < 7) {
                        MetadataEntry.Companion.init$cottontaildb_dbms(this, tx);
                        MetadataEntry.Companion.write$cottontaildb_dbms(new MetadataEntry("db_version", this.getVersion().toString()), this, tx);
                        SchemaMetadata.Companion.init$cottontaildb_dbms(this, tx);
                        EntityMetadata.Companion.init(this, tx);
                        ColumnMetadata.Companion.init$cottontaildb_dbms(this, tx);
                        IndexMetadata.Companion.init$cottontaildb_dbms(this, tx);
                        DefaultSequence.Companion.init(this, tx);
                        IndexStructCatalogueEntry.Companion.init$cottontaildb_dbms(this, tx);
                    }
                    this.indexStatistics = new IndexStatisticsManager(this.getTransactionManager().getEnvironment$cottontaildb_dbms(), tx);
                    object = MetadataEntry.Companion.read$cottontaildb_dbms("db_version", this, tx);
                    if (object == null) break block9;
                    MetadataEntry it = object;
                    boolean bl = false;
                    DBOVersion dBOVersion = DBOVersion.valueOf(it.getValue());
                    object = dBOVersion;
                    if (dBOVersion != null) break block10;
                }
                object = DBOVersion.UNDEFINED;
            }
            if ((version = object) != this.getVersion()) {
                throw new DatabaseException.VersionMismatchException(this.getVersion(), (DBOVersion)((Object)version));
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.abort();
            throw e;
        }
        if (!Files.exists(this.getConfig().temporaryDataFolder(), new LinkOption[0])) {
            Files.createDirectories(this.getConfig().temporaryDataFolder(), new FileAttribute[0]);
        } else {
            Files.walk(this.getConfig().temporaryDataFolder(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(arg_0 -> DefaultCatalogue._init_$lambda$1(1.INSTANCE, arg_0));
        }
        InitializeKt.initialize(this.getFunctions());
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Name.RootName getName() {
        return Name.RootName.INSTANCE;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V3_0;
    }

    @Override
    @Nullable
    public DBO getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this;
    }

    @Override
    @NotNull
    public FunctionRegistry getFunctions() {
        return this.functions;
    }

    @NotNull
    public final IndexStatisticsManager getIndexStatistics() {
        return this.indexStatistics;
    }

    @Override
    @NotNull
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    @NotNull
    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    @NotNull
    public final InMemoryIndexCache getCache() {
        return this.cache;
    }

    @Override
    @NotNull
    public CatalogueTx newTx(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        CatalogueTx catalogueTx = (CatalogueTx)context2.getTxn().getCachedTxForDBO(this);
        if (catalogueTx == null) {
            catalogueTx = new Tx(context2);
        }
        return catalogueTx;
    }

    @Override
    public void close() {
        try {
            this.indexStatistics.persist();
        }
        catch (Throwable e) {
            LOGGER.error("Failed to persist index statistics.", e);
        }
        try {
            this.getStatisticsManager().close();
        }
        catch (Throwable e) {
            LOGGER.error("Failed to close statistics manager.", e);
        }
        try {
            this.getTransactionManager().shutdown();
        }
        catch (Throwable e) {
            LOGGER.error("Failed to shutdown transaction manager.", e);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DefaultCatalogue)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.path, (Object)((DefaultCatalogue)other).path);
    }

    public int hashCode() {
        return ((Object)this.path).hashCode();
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultCatalogue.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue$Companion;", "", "()V", "COLUMN_STORE_PREFIX", "", "ENTITY_STORE_PREFIX", "INDEX_STORE_PREFIX", "LOGGER", "Lorg/slf4j/Logger;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/catalogue/CatalogueTx;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "dbo", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "createSchema", "Lorg/vitrivr/cottontail/dbms/schema/Schema;", "name", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "dropSchema", "", "listSchemas", "", "schemaForName", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nDefaultCatalogue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCatalogue.kt\norg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue$Tx\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,273:1\n1855#2,2:274\n*S KotlinDebug\n*F\n+ 1 DefaultCatalogue.kt\norg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue$Tx\n*L\n266#1:274,2\n*E\n"})
    public final class Tx
    extends AbstractTx
    implements CatalogueTx {
        public Tx(QueryContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            context2.getTxn().cacheTx(this);
        }

        @Override
        @NotNull
        public DefaultCatalogue getDbo() {
            return DefaultCatalogue.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<Name.SchemaName> listSchemas() {
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                Store store = SchemaMetadata.Companion.store$cottontaildb_dbms(this.getDbo(), this.getContext().getTxn().getXodusTx());
                List list = new ArrayList();
                Closeable closeable = (Closeable)store.openCursor(this.getContext().getTxn().getXodusTx());
                Throwable throwable = null;
                try {
                    Cursor cursor = (Cursor)closeable;
                    boolean bl2 = false;
                    while (cursor.getNext()) {
                        ByteIterable byteIterable = cursor.getKey();
                        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getKey(...)");
                        list.add(NameBinding.Schema.INSTANCE.fromEntry(byteIterable));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                List list2 = list;
                return list2;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Schema schemaForName(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultCatalogue defaultCatalogue = DefaultCatalogue.this;
            lock2.lock();
            try {
                boolean bl = false;
                Store store = SchemaMetadata.Companion.store$cottontaildb_dbms(this.getDbo(), this.getContext().getTxn().getXodusTx());
                if (store.get(this.getContext().getTxn().getXodusTx(), NameBinding.Schema.INSTANCE.toEntry(name)) == null) {
                    throw new DatabaseException.SchemaDoesNotExistException(name);
                }
                Schema schema = new DefaultSchema(name, defaultCatalogue);
                return schema;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Schema createSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultCatalogue defaultCatalogue = DefaultCatalogue.this;
            lock2.lock();
            try {
                boolean bl = false;
                Store store = SchemaMetadata.Companion.store$cottontaildb_dbms(defaultCatalogue, this.getContext().getTxn().getXodusTx());
                SchemaMetadata metadata = new SchemaMetadata(System.currentTimeMillis(), System.currentTimeMillis());
                if (!store.add(this.getContext().getTxn().getXodusTx(), NameBinding.Schema.INSTANCE.toEntry(name), SchemaMetadata.Companion.toEntry(metadata))) {
                    throw new DatabaseException.SchemaAlreadyExistsException(name);
                }
                SchemaEvent.Create event = new SchemaEvent.Create(name);
                this.getContext().getTxn().signalEvent(event);
                Schema schema = new DefaultSchema(name, defaultCatalogue);
                return schema;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dropSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultCatalogue defaultCatalogue = DefaultCatalogue.this;
            lock2.lock();
            try {
                boolean bl = false;
                Store store = SchemaMetadata.Companion.store$cottontaildb_dbms(defaultCatalogue, this.getContext().getTxn().getXodusTx());
                if (!store.delete(this.getContext().getTxn().getXodusTx(), NameBinding.Schema.INSTANCE.toEntry(name))) {
                    throw new DatabaseException.SchemaDoesNotExistException(name);
                }
                SchemaTx schemaTx = new DefaultSchema(name, defaultCatalogue).newTx(this.getContext());
                Iterable $this$forEach$iv = schemaTx.listEntities();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Name.EntityName it = (Name.EntityName)element$iv;
                    boolean bl2 = false;
                    schemaTx.dropEntity(it);
                }
                SchemaEvent.Drop event = new SchemaEvent.Drop(name);
                this.getContext().getTxn().signalEvent(event);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }
    }
}

