/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.column;

import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.column.Column;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.column.EmptyColumnCursor;
import org.vitrivr.cottontail.dbms.column.VariableLengthCursor;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;
import org.vitrivr.cottontail.dbms.statistics.StatisticsUtilitiesKt;
import org.vitrivr.cottontail.dbms.statistics.storage.ColumnStatistic;
import org.vitrivr.cottontail.dbms.statistics.values.ValueStatistics;
import org.vitrivr.cottontail.storage.serializers.SerializerFactory;
import org.vitrivr.cottontail.storage.serializers.values.ValueSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001fB\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/dbms/column/VariableLengthColumn;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "Lorg/vitrivr/cottontail/dbms/column/Column;", "columnDef", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/ColumnDef;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getColumnDef", "()Lorg/vitrivr/cottontail/core/database/ColumnDef;", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "getParent", "()Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "equals", "", "other", "", "hashCode", "", "newTx", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "Tx", "cottontaildb-dbms"})
public final class VariableLengthColumn<T extends Value>
implements Column<T> {
    @NotNull
    private final ColumnDef<T> columnDef;
    @NotNull
    private final DefaultEntity parent;

    public VariableLengthColumn(@NotNull ColumnDef<T> columnDef2, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter(columnDef2, (String)"columnDef");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.columnDef = columnDef2;
        this.parent = parent;
    }

    @Override
    @NotNull
    public ColumnDef<T> getColumnDef() {
        return this.columnDef;
    }

    @Override
    @NotNull
    public DefaultEntity getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Name.ColumnName getName() {
        return this.getColumnDef().getName();
    }

    @Override
    @NotNull
    public DefaultCatalogue getCatalogue() {
        return this.getParent().getCatalogue();
    }

    @Override
    @NotNull
    public ColumnTx<T> newTx(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ColumnTx columnTx = (ColumnTx)context2.getTxn().getCachedTxForDBO(this);
        if (columnTx == null) {
            columnTx = new Tx(context2);
        }
        return columnTx;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof VariableLengthColumn)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((VariableLengthColumn)other).getCatalogue(), (Object)this.getCatalogue())) {
            return false;
        }
        return Intrinsics.areEqual((Object)((VariableLengthColumn)other).getName(), (Object)this.getName());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getParent().hashCode();
        return result;
    }

    @Override
    @NotNull
    public Types<T> getType() {
        return Column.DefaultImpls.getType(this);
    }

    @Override
    public int getSize() {
        return Column.DefaultImpls.getSize(this);
    }

    @Override
    public boolean getNullable() {
        return Column.DefaultImpls.getNullable(this);
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return Column.DefaultImpls.getVersion(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0011H\u0016J\u001b\u0010\u0012\u001a\u0004\u0018\u00018\u00002\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\u0004\u0018\u00018\u00002\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J#\u0010\u001a\u001a\u0004\u0018\u00018\u00002\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/dbms/column/VariableLengthColumn$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/column/VariableLengthColumn;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "binding", "Lorg/vitrivr/cottontail/storage/serializers/values/ValueSerializer;", "getBinding$cottontaildb_dbms", "()Lorg/vitrivr/cottontail/storage/serializers/values/ValueSerializer;", "dataStore", "Ljetbrains/exodus/env/Store;", "dbo", "Lorg/vitrivr/cottontail/dbms/column/VariableLengthColumn;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/column/VariableLengthColumn;", "cursor", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "delete", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "(J)Lorg/vitrivr/cottontail/core/types/Value;", "read", "statistics", "Lorg/vitrivr/cottontail/dbms/statistics/values/ValueStatistics;", "write", "value", "(JLorg/vitrivr/cottontail/core/types/Value;)Lorg/vitrivr/cottontail/core/types/Value;", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements ColumnTx<T> {
        @NotNull
        private final Store dataStore;
        @NotNull
        private final ValueSerializer<T> binding;

        public Tx(QueryContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            context2.getTxn().cacheTx(this);
            Store store = VariableLengthColumn.this.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(VariableLengthColumn.this.getName()), StoreConfig.USE_EXISTING, this.getContext().getTxn().getXodusTx(), false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Data store for column " + VariableLengthColumn.this.getName() + " is missing.");
            }
            this.dataStore = store;
            this.binding = SerializerFactory.INSTANCE.value(VariableLengthColumn.this.getColumnDef().getType());
        }

        @NotNull
        public final ValueSerializer<T> getBinding$cottontaildb_dbms() {
            return this.binding;
        }

        @Override
        @NotNull
        public VariableLengthColumn<T> getDbo() {
            return VariableLengthColumn.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public ValueStatistics<T> statistics() {
            Lock lock2 = this.getTxLatch();
            VariableLengthColumn variableLengthColumn = VariableLengthColumn.this;
            lock2.lock();
            try {
                ValueStatistics<?> statistics2;
                boolean bl = false;
                ColumnStatistic columnStatistic = variableLengthColumn.getCatalogue().getStatisticsManager().get(variableLengthColumn.getName());
                ValueStatistics<?> valueStatistics = columnStatistic != null ? columnStatistic.getStatistics() : null;
                ValueStatistics<?> valueStatistics2 = statistics2 = valueStatistics instanceof ValueStatistics ? valueStatistics : null;
                if (valueStatistics2 != null) {
                    ValueStatistics<?> valueStatistics3 = valueStatistics2;
                    return valueStatistics3;
                }
                ValueStatistics valueStatistics4 = StatisticsUtilitiesKt.defaultStatistics(variableLengthColumn.getType());
                return valueStatistics4;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T read(long tupleId) {
            Object t;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                ByteIterable byteIterable = this.dataStore.get(this.getContext().getTxn().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(tupleId));
                if (byteIterable != null) {
                    ByteIterable byteIterable2 = byteIterable;
                    Intrinsics.checkNotNull((Object)byteIterable2);
                    ByteIterable ret = byteIterable2;
                    Object t2 = this.binding.fromEntry(ret);
                    return t2;
                }
                t = null;
            }
            finally {
                lock2.unlock();
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T write(long tupleId, @NotNull T value) {
            Object t;
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                ArrayByteIterable rawTuple = ExtensionsKt.toKey(tupleId);
                ByteIterable valueRaw = this.binding.toEntry(value);
                ByteIterable oldRaw = this.dataStore.get(this.getContext().getTxn().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(tupleId));
                this.dataStore.put(this.getContext().getTxn().getXodusTx(), (ByteIterable)rawTuple, valueRaw);
                t = oldRaw != null ? (Object)this.binding.fromEntry(oldRaw) : null;
            }
            finally {
                lock2.unlock();
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T delete(long tupleId) {
            Object t;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                ArrayByteIterable rawTupleId = ExtensionsKt.toKey(tupleId);
                ByteIterable oldRaw = this.dataStore.get(this.getContext().getTxn().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(tupleId));
                this.dataStore.delete(this.getContext().getTxn().getXodusTx(), (ByteIterable)rawTupleId);
                t = oldRaw != null ? (Object)this.binding.fromEntry(oldRaw) : null;
            }
            finally {
                lock2.unlock();
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Cursor<T> cursor() {
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                long count = this.dataStore.count(this.getContext().getTxn().getXodusTx());
                if (count == 0L) {
                    EmptyColumnCursor emptyColumnCursor = EmptyColumnCursor.INSTANCE;
                    Intrinsics.checkNotNull((Object)emptyColumnCursor, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.basics.Cursor<T of org.vitrivr.cottontail.dbms.column.VariableLengthColumn.Tx.cursor$lambda$4?>");
                    Cursor cursor = emptyColumnCursor;
                    return cursor;
                }
                Cursor cursor = new VariableLengthCursor(this);
                return cursor;
            }
            finally {
                lock2.unlock();
            }
        }

        @Override
        @NotNull
        public ColumnDef<T> getColumnDef() {
            return ColumnTx.DefaultImpls.getColumnDef(this);
        }
    }
}

