/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.column;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.column.VariableLengthColumn;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.storage.serializers.SerializerFactory;
import org.vitrivr.cottontail.storage.serializers.values.ValueSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0003B\u0017\u0012\u0010\u0010\u0004\u001a\f0\u0005R\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00060\u0010j\u0002`\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0014\u0010\u001c\u001a\u00020\u001a2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J\u000f\u0010\u001d\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \f*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/vitrivr/cottontail/dbms/column/VariableLengthCursor;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "column", "Lorg/vitrivr/cottontail/dbms/column/VariableLengthColumn$Tx;", "Lorg/vitrivr/cottontail/dbms/column/VariableLengthColumn;", "(Lorg/vitrivr/cottontail/dbms/column/VariableLengthColumn$Tx;)V", "binding", "Lorg/vitrivr/cottontail/storage/serializers/values/ValueSerializer;", "cursor", "Ljetbrains/exodus/env/Cursor;", "kotlin.jvm.PlatformType", "store", "Ljetbrains/exodus/env/Store;", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "valueRaw", "Ljetbrains/exodus/ByteIterable;", "xodusTx", "Ljetbrains/exodus/env/Transaction;", "close", "", "key", "moveNext", "", "movePrevious", "moveTo", "value", "()Lorg/vitrivr/cottontail/core/types/Value;", "cottontaildb-dbms"})
public final class VariableLengthCursor<T extends Value>
implements org.vitrivr.cottontail.core.basics.Cursor<T> {
    private final Transaction xodusTx;
    @NotNull
    private final Store store;
    @NotNull
    private final ValueSerializer<T> binding;
    private final Cursor cursor;
    private long tupleId;
    @Nullable
    private ByteIterable valueRaw;

    public VariableLengthCursor(@NotNull VariableLengthColumn.Tx column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        this.xodusTx = column.getContext().getTxn().getXodusTx().getReadonlySnapshot();
        Store store = this.xodusTx.getEnvironment().openStore(ExtensionsKt.storeName(((VariableLengthColumn)column.getDbo()).getName()), StoreConfig.USE_EXISTING, this.xodusTx, false);
        if (store == null) {
            throw new DatabaseException.DataCorruptionException("Data store for column " + ((VariableLengthColumn)column.getDbo()).getName() + " is missing.");
        }
        this.store = store;
        this.binding = SerializerFactory.INSTANCE.value(column.getColumnDef().getType());
        this.cursor = this.store.openCursor(this.xodusTx);
        this.tupleId = -1L;
    }

    public boolean moveNext() {
        return this.moveTo(this.tupleId + 1L);
    }

    public boolean movePrevious() {
        return this.moveTo(this.tupleId - 1L);
    }

    public boolean moveTo(long tupleId) {
        boolean bl;
        if (tupleId < 0L) {
            return false;
        }
        long l = tupleId;
        if (l == this.tupleId) {
            bl = true;
        } else if (l == this.tupleId + 1L) {
            if (this.cursor.getNext()) {
                this.tupleId = tupleId;
                this.valueRaw = this.cursor.getValue();
                bl = true;
            } else {
                bl = false;
            }
        } else if (l == this.tupleId - 1L) {
            if (this.cursor.getPrev()) {
                this.tupleId = tupleId;
                this.valueRaw = this.cursor.getValue();
                bl = true;
            } else {
                bl = false;
            }
        } else {
            this.valueRaw = this.cursor.getSearchKey((ByteIterable)LongBinding.longToCompressedEntry((long)tupleId));
            return this.valueRaw != null;
        }
        return bl;
    }

    public long key() {
        return this.tupleId;
    }

    @Nullable
    public T value() {
        ByteIterable byteIterable = this.valueRaw;
        if (byteIterable == null) {
            throw new IllegalStateException("Cursor not pointing to a valid tuple. Please call moveTo() prior to calling value().");
        }
        return this.binding.fromEntry(byteIterable);
    }

    public void close() {
        this.cursor.close();
        this.xodusTx.abort();
    }

    public boolean hasNext() {
        return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    @Nullable
    public T next() {
        return (T)((Value)Cursor.DefaultImpls.next((org.vitrivr.cottontail.core.basics.Cursor)this));
    }

    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

