/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Store;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.column.ColumnMetadata;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.events.DataEvent;
import org.vitrivr.cottontail.dbms.events.IndexEvent;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.index.basic.Index;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.basic.IndexMetadata;
import org.vitrivr.cottontail.dbms.index.basic.IndexState;
import org.vitrivr.cottontail.dbms.index.basic.IndexTx;
import org.vitrivr.cottontail.dbms.index.basic.IndexType;
import org.vitrivr.cottontail.dbms.index.basic.WriteModel;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u001b\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "getParent", "()Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "supportsAsyncRebuild", "", "getSupportsAsyncRebuild", "()Z", "supportsIncrementalUpdate", "getSupportsIncrementalUpdate", "supportsPartitioning", "getSupportsPartitioning", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "equals", "other", "", "hashCode", "", "Tx", "cottontaildb-dbms"})
public abstract class AbstractIndex
implements Index {
    @NotNull
    private final Name.IndexName name;
    @NotNull
    private final DefaultEntity parent;
    @NotNull
    private final DefaultCatalogue catalogue;
    @NotNull
    private final DBOVersion version;

    public AbstractIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        this.catalogue = this.parent.getCatalogue();
        this.version = DBOVersion.V3_0;
    }

    @Override
    @NotNull
    public final Name.IndexName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public final DefaultEntity getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public final DefaultCatalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    public final boolean getSupportsIncrementalUpdate() {
        return this.getType().getDescriptor().getSupportsIncrementalUpdate();
    }

    @Override
    public final boolean getSupportsAsyncRebuild() {
        return this.getType().getDescriptor().getSupportsAsyncRebuild();
    }

    @Override
    public final boolean getSupportsPartitioning() {
        return this.getType().getDescriptor().getSupportsPartitioning();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AbstractIndex)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((AbstractIndex)other).catalogue, (Object)this.catalogue)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((AbstractIndex)other).name, (Object)this.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.parent.hashCode();
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a6\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020'J\u000e\u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020)J\u0010\u0010*\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u001d\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001d\u00a8\u0006+"}, d2={"Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexTx;", "Lorg/vitrivr/cottontail/dbms/index/basic/WriteModel;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "config", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;", "dbo", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "<set-?>", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexState;", "state", "getState", "()Lorg/vitrivr/cottontail/dbms/index/basic/IndexState;", "supportsAsyncRebuild", "", "getSupportsAsyncRebuild", "()Z", "supportsIncrementalUpdate", "getSupportsIncrementalUpdate", "supportsPartitioning", "getSupportsPartitioning", "delete", "", "event", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Delete;", "insert", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Insert;", "update", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Update;", "updateState", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nAbstractIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractIndex.kt\norg/vitrivr/cottontail/dbms/index/basic/AbstractIndex$Tx\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,181:1\n1549#2:182\n1620#2,3:183\n37#3,2:186\n11065#4:188\n11400#4,3:189\n*S KotlinDebug\n*F\n+ 1 AbstractIndex.kt\norg/vitrivr/cottontail/dbms/index/basic/AbstractIndex$Tx\n*L\n106#1:182\n106#1:183,3\n111#1:186,2\n172#1:188\n172#1:189,3\n*E\n"})
    public abstract class Tx
    extends AbstractTx
    implements IndexTx,
    WriteModel {
        @NotNull
        private final IndexConfig<?> config;
        @NotNull
        private final ColumnDef<?>[] columns;
        @NotNull
        private IndexState state;

        /*
         * WARNING - void declaration
         */
        public Tx(QueryContext context2) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            context2.getTxn().cacheTx(this);
            Store indexMetadataStore = IndexMetadata.Companion.store$cottontaildb_dbms(AbstractIndex.this.getCatalogue(), this.getContext().getTxn().getXodusTx());
            ByteIterable byteIterable = indexMetadataStore.get(this.getContext().getTxn().getXodusTx(), NameBinding.Index.INSTANCE.toEntry(AbstractIndex.this.getName()));
            if (byteIterable == null) {
                throw new DatabaseException.DataCorruptionException("Failed to initialize transaction for index " + AbstractIndex.this.getName() + ": Could not read catalogue entry for index.");
            }
            ByteIterable indexEntryRaw = byteIterable;
            IndexMetadata indexEntry = IndexMetadata.Companion.fromEntry(indexEntryRaw);
            this.state = indexEntry.getState();
            Store columnMetadataStore = ColumnMetadata.Companion.store$cottontaildb_dbms(AbstractIndex.this.getCatalogue(), this.getContext().getTxn().getXodusTx());
            Iterable iterable = indexEntry.getColumns();
            AbstractIndex abstractIndex = AbstractIndex.this;
            Tx tx = this;
            boolean $i$f$map = false;
            void var10_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ByteIterable byteIterable2;
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Name.ColumnName columnName = abstractIndex.getName().entity().column((String)it);
                if (columnMetadataStore.get(this.getContext().getTxn().getXodusTx(), NameBinding.Column.INSTANCE.toEntry(columnName)) == null) {
                    throw new DatabaseException.DataCorruptionException("Failed to initialize transaction for index " + abstractIndex.getName() + " because catalogue entry for column could not be read " + (String)it + ".");
                }
                Intrinsics.checkNotNull((Object)byteIterable2);
                ByteIterable columnEntryRaw = byteIterable2;
                ColumnMetadata columnEntity = ColumnMetadata.Companion.fromEntry(columnEntryRaw);
                collection.add(new ColumnDef(columnName, columnEntity.getType(), columnEntity.getNullable(), columnEntity.getPrimary(), columnEntity.getAutoIncrement()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            tx.columns = thisCollection$iv.toArray(new ColumnDef[0]);
            this.config = indexEntry.getConfig();
        }

        @Override
        @NotNull
        public final AbstractIndex getDbo() {
            return AbstractIndex.this;
        }

        @Override
        public boolean getSupportsIncrementalUpdate() {
            return AbstractIndex.this.getSupportsIncrementalUpdate();
        }

        @Override
        public boolean getSupportsAsyncRebuild() {
            return AbstractIndex.this.getSupportsAsyncRebuild();
        }

        @Override
        public boolean getSupportsPartitioning() {
            return AbstractIndex.this.getSupportsPartitioning();
        }

        @Override
        @NotNull
        public final IndexConfig<?> getConfig() {
            return this.config;
        }

        @Override
        @NotNull
        public final ColumnDef<?>[] getColumns() {
            return this.columns;
        }

        @Override
        @NotNull
        public final IndexState getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void insert(@NotNull DataEvent.Insert event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                if (this.state != IndexState.STALE && !this.tryApply(event)) {
                    this.updateState(IndexState.STALE);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void update(@NotNull DataEvent.Update event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                if (this.state != IndexState.STALE && !this.tryApply(event)) {
                    this.updateState(IndexState.STALE);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void delete(@NotNull DataEvent.Delete event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                if (this.state != IndexState.STALE && !this.tryApply(event)) {
                    this.updateState(IndexState.STALE);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void updateState(IndexState state) {
            if (state != this.state) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ByteIterable name = NameBinding.Index.INSTANCE.toEntry(AbstractIndex.this.getName());
                Store store = IndexMetadata.Companion.store$cottontaildb_dbms(AbstractIndex.this.getCatalogue(), this.getContext().getTxn().getXodusTx());
                ColumnDef<?>[] columnDefArray = this.columns;
                IndexState indexState = state;
                IndexType indexType = AbstractIndex.this.getType();
                boolean $i$f$map = false;
                void var7_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    void item$iv$iv;
                    void var13_14 = item$iv$iv = $this$mapTo$iv$iv[j];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName().getColumn());
                }
                collection = (List)destination$iv$iv;
                IndexConfig<?> indexConfig = this.config;
                List list = collection;
                IndexState indexState2 = indexState;
                IndexType indexType2 = indexType;
                IndexMetadata entry = new IndexMetadata(indexType2, indexState2, list, indexConfig);
                if (store.put(this.getContext().getTxn().getXodusTx(), name, IndexMetadata.Companion.toEntry(entry))) {
                    this.state = state;
                    this.getContext().getTxn().signalEvent(new IndexEvent.State(AbstractIndex.this.getName(), AbstractIndex.this.getType(), state));
                }
            }
        }
    }
}

