/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.basic.rebuilder;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.events.DataEvent;
import org.vitrivr.cottontail.dbms.events.Event;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionManager;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionType;
import org.vitrivr.cottontail.dbms.index.basic.Index;
import org.vitrivr.cottontail.dbms.index.basic.IndexMetadata;
import org.vitrivr.cottontail.dbms.index.basic.IndexState;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.AbstractAsyncIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.AsyncIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.IndexRebuilderState;
import org.vitrivr.cottontail.dbms.queries.context.DefaultQueryContext;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 ?*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001?B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020$H\u0016J\b\u0010*\u001a\u00020+H&J\u0010\u0010,\u001a\u00020+2\u0006\u0010'\u001a\u00020-H&J\u0018\u0010.\u001a\u00020+2\u0006\u0010'\u001a\u00020-2\u0006\u0010/\u001a\u00020&H&J\u0010\u00100\u001a\u00020+2\u0006\u00101\u001a\u000202H\u0016J \u00103\u001a\u00020$2\n\u00104\u001a\u00060\u0012j\u0002`52\f\u00106\u001a\b\u0012\u0004\u0012\u00020207J\u0012\u00108\u001a\u00020$2\n\u00104\u001a\u00060\u0012j\u0002`5J\u0010\u00109\u001a\u00020+2\u0006\u00101\u001a\u00020:H&J\b\u0010;\u001a\u00020$H\u0016J\u0018\u0010<\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020=2\u0006\u0010>\u001a\u00020(H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006@"}, d2={"Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AbstractAsyncIndexRebuilder;", "T", "Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AsyncIndexRebuilder;", "index", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "manager", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "(Lorg/vitrivr/cottontail/dbms/index/basic/Index;Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;)V", "entityName", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "getEntityName", "()Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "getIndex", "()Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "sequenceNumber", "", "<set-?>", "Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/IndexRebuilderState;", "state", "getState", "()Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/IndexRebuilderState;", "tmpEnvironment", "Ljetbrains/exodus/env/Environment;", "getTmpEnvironment", "()Ljetbrains/exodus/env/Environment;", "tmpPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "tmpTx", "Ljetbrains/exodus/env/Transaction;", "getTmpTx", "()Ljetbrains/exodus/env/Transaction;", "build", "", "clearAndOpenStore", "Ljetbrains/exodus/env/Store;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "close", "drainAndMergeLog", "", "internalBuild", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "internalReplace", "store", "isRelevant", "event", "Lorg/vitrivr/cottontail/dbms/events/Event;", "onCommit", "txId", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "events", "", "onDeliveryFailure", "processSideChannelEvent", "Lorg/vitrivr/cottontail/dbms/events/DataEvent;", "replace", "updateState", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexState;", "tx", "Companion", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nAbstractAsyncIndexRebuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAsyncIndexRebuilder.kt\norg/vitrivr/cottontail/dbms/index/basic/rebuilder/AbstractAsyncIndexRebuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,304:1\n1#2:305\n*E\n"})
public abstract class AbstractAsyncIndexRebuilder<T extends Index>
implements AsyncIndexRebuilder<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T index;
    @NotNull
    private final Catalogue catalogue;
    @NotNull
    private final TransactionManager manager;
    @NotNull
    private volatile IndexRebuilderState state;
    private final Path tmpPath;
    @NotNull
    private final Environment tmpEnvironment;
    @NotNull
    private final Transaction tmpTx;
    @NotNull
    private final Name.EntityName entityName;
    private final long sequenceNumber;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final AtomicLong COUNTER;

    public AbstractAsyncIndexRebuilder(@NotNull T index, @NotNull Catalogue catalogue, @NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter(index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.index = index;
        this.catalogue = catalogue;
        this.manager = manager;
        this.state = IndexRebuilderState.INITIALIZED;
        Path path = this.index.getCatalogue().getConfig().temporaryDataFolder();
        String string = this.index.getType().toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.tmpPath = path.resolve(string + "-rebuild-" + UUID.randomUUID());
        File file = this.tmpPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        EnvironmentConfig environmentConfig = this.index.getCatalogue().getConfig().getXodus().toEnvironmentConfig().setGcUtilizationFromScratch(false).setGcEnabled(false);
        Intrinsics.checkNotNullExpressionValue((Object)environmentConfig, (String)"setGcEnabled(...)");
        this.tmpEnvironment = Environments.newInstance((File)file, (EnvironmentConfig)environmentConfig);
        Transaction transaction = this.tmpEnvironment.beginExclusiveTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"beginExclusiveTransaction(...)");
        this.tmpTx = transaction;
        this.entityName = this.index.getName().entity();
        this.sequenceNumber = COUNTER.incrementAndGet();
    }

    @Override
    @NotNull
    public final T getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public final IndexRebuilderState getState() {
        return this.state;
    }

    @NotNull
    protected final Environment getTmpEnvironment() {
        return this.tmpEnvironment;
    }

    @NotNull
    protected final Transaction getTmpTx() {
        return this.tmpTx;
    }

    @NotNull
    protected final Name.EntityName getEntityName() {
        return this.entityName;
    }

    @Override
    public boolean isRelevant(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return event instanceof DataEvent && Intrinsics.areEqual((Object)((DataEvent)event).getEntity(), (Object)this.entityName);
    }

    @Override
    public synchronized void build() {
        if (!(this.state == IndexRebuilderState.INITIALIZED)) {
            boolean $i$a$-require-AbstractAsyncIndexRebuilder$build$22 = false;
            String $i$a$-require-AbstractAsyncIndexRebuilder$build$22 = "Cannot perform SCAN with index builder because it is in the wrong state.";
            throw new IllegalArgumentException($i$a$-require-AbstractAsyncIndexRebuilder$build$22.toString());
        }
        LOGGER.debug("Scanning index {} ({}).", (Object)this.index.getName(), (Object)this.index.getType());
        DefaultQueryContext context2 = (DefaultQueryContext)this.manager.computeExclusively((Function0)new Function0<DefaultQueryContext>(this){
            final /* synthetic */ AbstractAsyncIndexRebuilder<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DefaultQueryContext invoke() {
                org.vitrivr.cottontail.dbms.execution.transactions.Transaction transaction = AbstractAsyncIndexRebuilder.access$getManager$p(this.this$0).startTransaction(TransactionType.SYSTEM_READONLY);
                DefaultQueryContext context2 = new DefaultQueryContext("auto-rebuild-scan-" + AbstractAsyncIndexRebuilder.access$getSequenceNumber$p(this.this$0), AbstractAsyncIndexRebuilder.access$getCatalogue$p(this.this$0), transaction, null, 8, null);
                AbstractAsyncIndexRebuilder.access$getManager$p(this.this$0).register(this.this$0);
                AbstractAsyncIndexRebuilder.access$setState$p(this.this$0, IndexRebuilderState.REBUILDING);
                return context2;
            }
        });
        try {
            if (!this.internalBuild(context2)) {
                this.state = IndexRebuilderState.ABORTED;
                LOGGER.error("Scanning index " + this.index.getName() + " (" + this.index.getType() + ") failed.");
                context2.getTxn().rollback();
                return;
            }
            context2.getTxn().commit();
            this.state = IndexRebuilderState.REBUILT;
            LOGGER.debug("Scanning index {} ({}) completed!", (Object)this.index.getName(), (Object)this.index.getType());
        }
        catch (Throwable e) {
            context2.getTxn().rollback();
            LOGGER.error("Scanning index " + this.index.getName() + " (" + this.index.getType() + ") failed due to exception: " + e.getMessage());
        }
    }

    @Override
    public synchronized void replace() {
        if (!(this.state == IndexRebuilderState.REBUILT)) {
            boolean $i$a$-require-AbstractAsyncIndexRebuilder$replace$22 = false;
            String $i$a$-require-AbstractAsyncIndexRebuilder$replace$22 = "Cannot perform MERGE with index builder because it is in the wrong state.";
            throw new IllegalArgumentException($i$a$-require-AbstractAsyncIndexRebuilder$replace$22.toString());
        }
        LOGGER.debug("Merging index {} ({}).", (Object)this.index.getName(), (Object)this.index.getType());
        org.vitrivr.cottontail.dbms.execution.transactions.Transaction transaction = this.manager.startTransaction(TransactionType.SYSTEM_EXCLUSIVE);
        DefaultQueryContext context2 = new DefaultQueryContext("auto-rebuild-replace-" + this.sequenceNumber, this.catalogue, transaction, null, 8, null);
        this.manager.deregister(this);
        try {
            if (!this.updateState(IndexState.DIRTY, context2.getTxn())) {
                this.state = IndexRebuilderState.ABORTED;
                LOGGER.error("Merging index " + this.index.getName() + " (" + this.index.getType() + ") failed because index state could not be changed to DIRTY!");
                context2.getTxn().rollback();
                return;
            }
            if (!this.drainAndMergeLog()) {
                this.state = IndexRebuilderState.ABORTED;
                LOGGER.error("Merging index " + this.index.getName() + " (" + this.index.getType() + ") failed because not all side-channel could be processed.");
                context2.getTxn().rollback();
                return;
            }
            this.tmpTx.flush();
            this.state = IndexRebuilderState.REPLACING;
            Store dataStore = this.clearAndOpenStore(context2.getTxn());
            if (!this.internalReplace(context2, dataStore)) {
                this.state = IndexRebuilderState.ABORTED;
                LOGGER.error("Merging index " + this.index.getName() + " (" + this.index.getType() + ") failed.");
                context2.getTxn().rollback();
                return;
            }
            if (!this.updateState(IndexState.CLEAN, context2.getTxn())) {
                this.state = IndexRebuilderState.ABORTED;
                LOGGER.error("Merging index " + this.index.getName() + " (" + this.index.getType() + ") failed because index state could not be changed to CLEAN!");
                context2.getTxn().rollback();
                return;
            }
            context2.getTxn().commit();
            this.state = IndexRebuilderState.FINISHED;
            LOGGER.debug("Merging index {} ({}) completed!", (Object)this.index.getName(), (Object)this.index.getType());
        }
        catch (Throwable e) {
            LOGGER.error("Merging index " + this.index.getName() + " (" + this.index.getType() + ") failed because of exception: " + e.getMessage());
            context2.getTxn().rollback();
            this.state = IndexRebuilderState.ABORTED;
        }
    }

    @Override
    public final void onCommit(long txId, @NotNull List<? extends Event> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (Event event : events) {
            if (!(event instanceof DataEvent)) {
                boolean $i$a$-require-AbstractAsyncIndexRebuilder$onCommit$332 = false;
                String $i$a$-require-AbstractAsyncIndexRebuilder$onCommit$332 = "Event " + event + " is not a DataEvent.";
                throw new IllegalArgumentException($i$a$-require-AbstractAsyncIndexRebuilder$onCommit$332.toString());
            }
            if (!Intrinsics.areEqual((Object)((DataEvent)event).getEntity(), (Object)this.index.getName().entity())) {
                boolean bl = false;
                String string = "DataEvent " + event + " received that does not concern this index. This is a programmer's error!";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.processSideChannelEvent((DataEvent)event)) continue;
            this.state = IndexRebuilderState.ABORTED;
            LOGGER.error("Index rebuild failed due to side-channel message processing failure: " + event);
            break;
        }
    }

    @Override
    public final void onDeliveryFailure(long txId) {
        this.state = IndexRebuilderState.ABORTED;
        LOGGER.error("Index rebuild failed due to side-channel message delivery failure.");
    }

    @Override
    public synchronized void close() {
        try {
            if (this.state != IndexRebuilderState.FINISHED) {
                this.state = IndexRebuilderState.FINISHED;
                this.manager.deregister(this);
                this.tmpTx.abort();
                this.tmpEnvironment.clear();
                Files.walk(this.tmpPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(arg_0 -> AbstractAsyncIndexRebuilder.close$lambda$4(close.1.INSTANCE, arg_0));
                LOGGER.debug("Asynchronous index re-builder index {} ({}) discarded!", (Object)this.index.getName(), (Object)this.index.getType());
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Asynchronous index re-builder for index " + this.index.getName() + " (" + this.index.getType() + ") could not be discarded: " + e.getMessage());
        }
    }

    public abstract boolean internalBuild(@NotNull QueryContext var1);

    public abstract boolean internalReplace(@NotNull QueryContext var1, @NotNull Store var2);

    public abstract boolean processSideChannelEvent(@NotNull DataEvent var1);

    public abstract boolean drainAndMergeLog();

    private final boolean updateState(IndexState state, org.vitrivr.cottontail.dbms.execution.transactions.Transaction tx) {
        ByteIterable name = NameBinding.Index.INSTANCE.toEntry(this.index.getName());
        Catalogue catalogue = this.index.getCatalogue();
        Intrinsics.checkNotNull((Object)catalogue, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue");
        Store store = IndexMetadata.Companion.store$cottontaildb_dbms((DefaultCatalogue)catalogue, tx.getXodusTx());
        ByteIterable byteIterable = store.get(tx.getXodusTx(), name);
        if (byteIterable == null) {
            throw new DatabaseException.DataCorruptionException("Failed to rebuild index transaction for index " + this.index.getName() + ": Could not read catalogue entry for index.");
        }
        ByteIterable oldEntryRaw = byteIterable;
        IndexMetadata oldEntry = IndexMetadata.Companion.fromEntry(oldEntryRaw);
        return oldEntry.getState() != state ? store.put(tx.getXodusTx(), name, IndexMetadata.Companion.toEntry(IndexMetadata.copy$default(oldEntry, null, state, null, null, 13, null))) : false;
    }

    private final Store clearAndOpenStore(org.vitrivr.cottontail.dbms.execution.transactions.Transaction context2) {
        String storeName = ExtensionsKt.storeName(this.index.getName());
        this.index.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().truncateStore(storeName, context2.getXodusTx());
        Store store = this.index.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(storeName, StoreConfig.USE_EXISTING, context2.getXodusTx(), false);
        if (store == null) {
            throw new DatabaseException.DataCorruptionException("Data store for index " + this.index.getName() + " is missing.");
        }
        return store;
    }

    private static final void close$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ TransactionManager access$getManager$p(AbstractAsyncIndexRebuilder $this) {
        return $this.manager;
    }

    public static final /* synthetic */ long access$getSequenceNumber$p(AbstractAsyncIndexRebuilder $this) {
        return $this.sequenceNumber;
    }

    public static final /* synthetic */ Catalogue access$getCatalogue$p(AbstractAsyncIndexRebuilder $this) {
        return $this.catalogue;
    }

    public static final /* synthetic */ void access$setState$p(AbstractAsyncIndexRebuilder $this, IndexRebuilderState indexRebuilderState) {
        $this.state = indexRebuilderState;
    }

    static {
        Logger logger = LoggerFactory.getLogger(AbstractAsyncIndexRebuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        COUNTER = new AtomicLong(0L);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AbstractAsyncIndexRebuilder$Companion;", "", "()V", "COUNTER", "Ljava/util/concurrent/atomic/AtomicLong;", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER$cottontaildb_dbms", "()Lorg/slf4j/Logger;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER$cottontaildb_dbms() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

