/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.hash;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.binding.Binding;
import org.vitrivr.cottontail.core.queries.binding.BindingContext;
import org.vitrivr.cottontail.core.queries.binding.MissingTuple;
import org.vitrivr.cottontail.core.queries.nodes.traits.NotPartitionableTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.Trait;
import org.vitrivr.cottontail.core.queries.nodes.traits.TraitType;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.BooleanPredicate;
import org.vitrivr.cottontail.core.queries.predicates.ComparisonOperator;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.events.DataEvent;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.execution.transactions.Transaction;
import org.vitrivr.cottontail.dbms.index.basic.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.basic.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.basic.IndexType;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.AsyncIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.hash.BTreeIndexConfig;
import org.vitrivr.cottontail.dbms.index.hash.BTreeIndexCursor;
import org.vitrivr.cottontail.dbms.index.hash.BTreeIndexRebuilder;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;
import org.vitrivr.cottontail.dbms.statistics.selectivity.NaiveSelectivityCalculator;
import org.vitrivr.cottontail.dbms.statistics.selectivity.Selectivity;
import org.vitrivr.cottontail.dbms.statistics.values.ValueStatistics;
import org.vitrivr.cottontail.storage.serializers.SerializerFactory;
import org.vitrivr.cottontail.storage.serializers.values.ValueSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u0011\u001a\u00060\u0012R\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "type", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "newAsyncRebuilder", "Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AsyncIndexRebuilder;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "newRebuilder", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexRebuilder;", "newTx", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;", "Companion", "Tx", "cottontaildb-dbms"})
public final class BTreeIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexType type;
    @NotNull
    private static final Logger LOGGER;
    private static final boolean supportsIncrementalUpdate;
    private static final boolean supportsAsyncRebuild;
    private static final boolean supportsPartitioning;

    public BTreeIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(name, parent);
        this.type = IndexType.BTREE;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Tx tx = (Tx)context2.getTxn().getCachedTxForDBO(this);
        if (tx == null) {
            tx = new Tx(context2);
        }
        return tx;
    }

    @NotNull
    public BTreeIndexRebuilder newRebuilder(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new BTreeIndexRebuilder(this, context2);
    }

    @NotNull
    public AsyncIndexRebuilder<BTreeIndex> newAsyncRebuilder(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        throw new UnsupportedOperationException("BTreeIndex does not support asynchronous index rebuilding.");
    }

    static {
        Logger logger = LoggerFactory.getLogger(BTreeIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        supportsIncrementalUpdate = true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Companion;", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexDescriptor;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "supportsAsyncRebuild", "", "getSupportsAsyncRebuild", "()Z", "supportsIncrementalUpdate", "getSupportsIncrementalUpdate", "supportsPartitioning", "getSupportsPartitioning", "buildConfig", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;", "parameters", "", "", "configBinding", "Ljetbrains/exodus/bindings/ComparableBinding;", "deinitialize", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "initialize", "open", "entity", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "cottontaildb-dbms"})
    public static final class Companion
    implements IndexDescriptor<BTreeIndex> {
        private Companion() {
        }

        @Override
        public boolean getSupportsIncrementalUpdate() {
            return supportsIncrementalUpdate;
        }

        @Override
        public boolean getSupportsAsyncRebuild() {
            return supportsAsyncRebuild;
        }

        @Override
        public boolean getSupportsPartitioning() {
            return supportsPartitioning;
        }

        @Override
        @NotNull
        public BTreeIndex open(@NotNull Name.IndexName name, @NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new BTreeIndex(name, (DefaultEntity)entity);
        }

        @Override
        public boolean initialize(@NotNull Name.IndexName name, @NotNull Catalogue catalogue, @NotNull Transaction context2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                Store store = catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(name), StoreConfig.WITH_DUPLICATES_WITH_PREFIXING, context2.getXodusTx(), true);
                bl = store != null;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to initialize BTREE index " + name + " due to an exception: " + e.getMessage() + ".");
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean deinitialize(@NotNull Name.IndexName name, @NotNull Catalogue catalogue, @NotNull Transaction context2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().removeStore(ExtensionsKt.storeName(name), context2.getXodusTx());
                bl = true;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to de-initialize BTREE index " + name + " due to an exception: " + e.getMessage() + ".");
                bl = false;
            }
            return bl;
        }

        @Override
        @NotNull
        public IndexConfig<BTreeIndex> buildConfig(@NotNull Map<String, String> parameters) {
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            return BTreeIndexConfig.INSTANCE;
        }

        @Override
        @NotNull
        public ComparableBinding configBinding() {
            return BTreeIndexConfig.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001d\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001f\u0010 J\b\u0010!\u001a\u00020\u0015H\u0016J\u0018\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0016J\u001c\u0010)\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002J \u0010*\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030,\u0012\u0004\u0012\u00020-0+2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u000200H\u0016J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u000201H\u0016J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u000202H\u0016R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00063"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "binding", "Lorg/vitrivr/cottontail/storage/serializers/values/ValueSerializer;", "Lorg/vitrivr/cottontail/core/types/Value;", "getBinding$cottontaildb_dbms$annotations", "()V", "getBinding$cottontaildb_dbms", "()Lorg/vitrivr/cottontail/storage/serializers/values/ValueSerializer;", "dataStore", "Ljetbrains/exodus/env/Store;", "getDataStore$cottontaildb_dbms", "()Ljetbrains/exodus/env/Store;", "addMapping", "", "key", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "columnsFor", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "costFor", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "costFor-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "count", "filter", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndexCursor;", "Lorg/vitrivr/cottontail/core/queries/predicates/ComparisonOperator;", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "partition", "Lkotlin/ranges/LongRange;", "removeMapping", "traitsFor", "", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/TraitType;", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/Trait;", "tryApply", "event", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Delete;", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Insert;", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Update;", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nBTreeIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BTreeIndex.kt\norg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,328:1\n1726#2,3:329\n1747#2,3:333\n1#3:332\n9226#4,2:336\n9376#4,4:338\n*S KotlinDebug\n*F\n+ 1 BTreeIndex.kt\norg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx\n*L\n194#1:329,3\n225#1:333,3\n227#1:336,2\n227#1:338,4\n*E\n"})
    public final class Tx
    extends AbstractIndex.Tx {
        @NotNull
        private final ValueSerializer<Value> binding;
        @NotNull
        private final Store dataStore;

        public Tx(QueryContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(BTreeIndex.this, context2);
            ValueSerializer valueSerializer = SerializerFactory.INSTANCE.value(this.getColumns()[0].getType());
            Intrinsics.checkNotNull(valueSerializer, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.storage.serializers.values.ValueSerializer<org.vitrivr.cottontail.core.types.Value>");
            this.binding = valueSerializer;
            Store store = BTreeIndex.this.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(BTreeIndex.this.getName()), StoreConfig.USE_EXISTING, this.getContext().getTxn().getXodusTx(), false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Data store for index " + BTreeIndex.this.getName() + " is missing.");
            }
            this.dataStore = store;
        }

        @NotNull
        public final ValueSerializer<Value> getBinding$cottontaildb_dbms() {
            return this.binding;
        }

        public static /* synthetic */ void getBinding$cottontaildb_dbms$annotations() {
        }

        @NotNull
        public final Store getDataStore$cottontaildb_dbms() {
            return this.dataStore;
        }

        private final boolean addMapping(Value key, long tupleId) {
            ByteIterable keyRaw = this.binding.toEntry(key);
            ArrayByteIterable tupleIdRaw = LongBinding.longToCompressedEntry((long)tupleId);
            return this.dataStore.put(this.getContext().getTxn().getXodusTx(), keyRaw, (ByteIterable)tupleIdRaw);
        }

        private final boolean removeMapping(Value key, long tupleId) {
            ByteIterable keyRaw = this.binding.toEntry(key);
            ArrayByteIterable valueRaw = LongBinding.longToCompressedEntry((long)tupleId);
            Cursor cursor = this.dataStore.openCursor(this.getContext().getTxn().getXodusTx());
            boolean ret = cursor.getSearchBoth(keyRaw, (ByteIterable)valueRaw) && cursor.deleteCurrent();
            cursor.close();
            return ret;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canProcess(@NotNull Predicate predicate) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof BooleanPredicate.Comparison)) return false;
            Iterable $this$all$iv = predicate.getColumns();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Binding.Column it = (Binding.Column)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getPhysical(), this.getColumns()[0])) continue;
                    return false;
                }
                bl = true;
            }
            if (!bl) return false;
            if (((BooleanPredicate.Comparison)predicate).getOperator() instanceof ComparisonOperator.In) return true;
            if (((BooleanPredicate.Comparison)predicate).getOperator() instanceof ComparisonOperator.Equal) return true;
            if (!(((BooleanPredicate.Comparison)predicate).getOperator() instanceof ComparisonOperator.Like)) return false;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<ColumnDef<?>> columnsFor(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                if (!(predicate instanceof BooleanPredicate)) {
                    boolean bl2 = false;
                    String string = "BTree index can only process boolean predicates.";
                    throw new IllegalArgumentException(string.toString());
                }
                List list = ArraysKt.toList((Object[])this.getColumns());
                return list;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Map<TraitType<?>, Trait> traitsFor(@NotNull Predicate predicate) {
            Map map2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                if (!(predicate instanceof BooleanPredicate)) {
                    boolean bl2 = false;
                    String string = "BTree index can only process boolean predicates.";
                    throw new IllegalArgumentException(string.toString());
                }
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)NotPartitionableTrait.INSTANCE, (Object)NotPartitionableTrait.INSTANCE));
            }
            finally {
                lock2.unlock();
            }
            return map2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public float[] costFor-7eHliGg(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                block14: {
                    block13: {
                        boolean bl;
                        block12: {
                            boolean bl2 = false;
                            if (!(predicate instanceof BooleanPredicate.Comparison)) break block13;
                            Iterable $this$any$iv = predicate.getColumns();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    Binding.Column it = (Binding.Column)element$iv;
                                    boolean bl3 = false;
                                    if (!(!Intrinsics.areEqual((Object)it.getPhysical(), this.getColumns()[0]))) continue;
                                    bl = true;
                                    break block12;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) break block14;
                    }
                    float[] fArray = Cost.Companion.getINVALID-7CRCzCo();
                    return fArray;
                }
                EntityTx entityTx = this.getDbo().getParent().newTx(this.getContext());
                ColumnDef<?>[] $this$associateWith$iv = this.getColumns();
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateWith$iv.length), (int)16));
                ColumnDef<?>[] $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                int n = $this$associateWithTo$iv$iv.length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    ColumnDef<?> element$iv$iv;
                    ColumnDef<?> columnDef2 = element$iv$iv = $this$associateWithTo$iv$iv[j];
                    ColumnDef<?> columnDef3 = element$iv$iv;
                    Map map2 = result$iv;
                    boolean bl = false;
                    ValueStatistics<?> valueStatistics = entityTx.columnForName(it.getName()).newTx(this.getContext()).statistics();
                    map2.put(columnDef3, valueStatistics);
                }
                Map statistics2 = result$iv;
                BindingContext $this$costFor_7eHliGg_u24lambda_u249_u24lambda_u248 = this.getContext().getBindings();
                boolean bl = false;
                MissingTuple $this$costFor_7eHliGg_u24lambda_u249_u24lambda_u248_u24lambda_u247 = MissingTuple.INSTANCE;
                boolean bl4 = false;
                float selectivity = NaiveSelectivityCalculator.INSTANCE.estimate-5YmCiTA($this$costFor_7eHliGg_u24lambda_u249_u24lambda_u248, (Tuple)$this$costFor_7eHliGg_u24lambda_u249_u24lambda_u248_u24lambda_u247, (BooleanPredicate)predicate, statistics2);
                long count = this.count();
                long countOut = Selectivity.invoke-impl(selectivity, count);
                float search = (float)Math.log10(count);
                ComparisonOperator comparisonOperator = ((BooleanPredicate.Comparison)predicate).getOperator();
                float[] fArray = ((((((comparisonOperator instanceof ComparisonOperator.Equal ? true : comparisonOperator instanceof ComparisonOperator.NotEqual) ? true : comparisonOperator instanceof ComparisonOperator.Greater) ? true : comparisonOperator instanceof ComparisonOperator.Less) ? true : comparisonOperator instanceof ComparisonOperator.GreaterEqual) ? true : comparisonOperator instanceof ComparisonOperator.LessEqual) ? true : comparisonOperator instanceof ComparisonOperator.In) ? Cost.plus-wQ19W7k((float[])Cost.times-7eHliGg((float[])Cost.Companion.getDISK_ACCESS_READ_SEQUENTIAL-7CRCzCo(), (Number)Float.valueOf(search + (float)countOut)), (float[])Cost.times-7eHliGg((float[])predicate.getCost-7CRCzCo(), (Number)countOut)) : Cost.Companion.getINVALID-7CRCzCo();
                return fArray;
            }
            finally {
                lock2.unlock();
            }
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Insert event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Value value = event.getData().get(this.getColumns()[0]);
            if (value == null) {
                return true;
            }
            Value value2 = value;
            return this.addMapping(value2, event.getTupleId());
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Update event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Pair<Value, Value> pair = event.getData().get(this.getColumns()[0]);
            Value old = pair != null ? (Value)pair.getFirst() : null;
            Pair<Value, Value> pair2 = event.getData().get(this.getColumns()[0]);
            Value value = pair2 != null ? (Value)pair2.getSecond() : null;
            boolean removed = old == null || this.removeMapping(old, event.getTupleId());
            boolean added = value == null || this.addMapping(value, event.getTupleId());
            return removed && added;
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Delete event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Value value = event.getData().get(this.getColumns()[0]);
            if (value == null) {
                return true;
            }
            Value old = value;
            return this.removeMapping(old, event.getTupleId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                l = this.dataStore.count(this.getContext().getTxn().getXodusTx());
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public BTreeIndexCursor<? extends ComparisonOperator> filter(@NotNull Predicate predicate) {
            BTreeIndexCursor bTreeIndexCursor;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                BTreeIndexCursor bTreeIndexCursor2;
                boolean bl = false;
                if (!(predicate instanceof BooleanPredicate.Comparison)) {
                    boolean $i$a$-require-BTreeIndex$Tx$filter$1$22 = false;
                    String $i$a$-require-BTreeIndex$Tx$filter$1$22 = "BTreeIndex.filter() does only support BooleanPredicate.Atomic boolean predicates.";
                    throw new IllegalArgumentException($i$a$-require-BTreeIndex$Tx$filter$1$22.toString());
                }
                BindingContext $this$filter_u24lambda_u2414_u24lambda_u2413 = this.getContext().getBindings();
                boolean bl2 = false;
                MissingTuple $this$filter_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412 = MissingTuple.INSTANCE;
                boolean bl3 = false;
                ComparisonOperator op = ((BooleanPredicate.Comparison)predicate).getOperator();
                if (op instanceof ComparisonOperator.Equal) {
                    Value value = op.getRight().getValue($this$filter_u24lambda_u2414_u24lambda_u2413, (Tuple)$this$filter_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412);
                    Intrinsics.checkNotNull((Object)value);
                    bTreeIndexCursor2 = new BTreeIndexCursor.Equals(value, this);
                } else if (op instanceof ComparisonOperator.Greater) {
                    Value value = op.getRight().getValue($this$filter_u24lambda_u2414_u24lambda_u2413, (Tuple)$this$filter_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412);
                    Intrinsics.checkNotNull((Object)value);
                    bTreeIndexCursor2 = new BTreeIndexCursor.Greater(value, this);
                } else if (op instanceof ComparisonOperator.GreaterEqual) {
                    Value value = op.getRight().getValue($this$filter_u24lambda_u2414_u24lambda_u2413, (Tuple)$this$filter_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412);
                    Intrinsics.checkNotNull((Object)value);
                    bTreeIndexCursor2 = new BTreeIndexCursor.GreaterEqual(value, this);
                } else if (op instanceof ComparisonOperator.Less) {
                    Value value = op.getRight().getValue($this$filter_u24lambda_u2414_u24lambda_u2413, (Tuple)$this$filter_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412);
                    Intrinsics.checkNotNull((Object)value);
                    bTreeIndexCursor2 = new BTreeIndexCursor.Less(value, this);
                } else if (op instanceof ComparisonOperator.LessEqual) {
                    Value value = op.getRight().getValue($this$filter_u24lambda_u2414_u24lambda_u2413, (Tuple)$this$filter_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412);
                    Intrinsics.checkNotNull((Object)value);
                    bTreeIndexCursor2 = new BTreeIndexCursor.LessEqual(value, this);
                } else if (op instanceof ComparisonOperator.In) {
                    bTreeIndexCursor2 = new BTreeIndexCursor.In(op.getRight().getValues($this$filter_u24lambda_u2414_u24lambda_u2413, (Tuple)$this$filter_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412), this);
                } else {
                    throw new IllegalArgumentException("BTreeIndex.filter() does only support =,>=,<=,>,< and IN operators.");
                }
                bTreeIndexCursor = bTreeIndexCursor2;
            }
            finally {
                lock2.unlock();
            }
            return bTreeIndexCursor;
        }

        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<Tuple> filter(@NotNull Predicate predicate, @NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            throw new UnsupportedOperationException("BTreeIndex does not support ranged filtering!");
        }
    }
}

