/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.lsh.signature;

import java.util.SplittableRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.ComplexVectorValue;
import org.vitrivr.cottontail.core.types.NumericValue;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.core.values.Complex32VectorValue;
import org.vitrivr.cottontail.core.values.Complex64VectorValue;
import org.vitrivr.cottontail.core.values.DoubleVectorValue;
import org.vitrivr.cottontail.core.values.FloatVectorValue;
import org.vitrivr.cottontail.dbms.index.lsh.signature.LSHSignature;
import org.vitrivr.cottontail.dbms.index.lsh.signature.LSHSignatureGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0018\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0002\"#B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J!\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J)\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001a\u0010\u001e\u001a\u00020\u001f2\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150!H\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0018\u00010\u000eR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/signature/SBLSHSignatureGenerator;", "Lorg/vitrivr/cottontail/dbms/index/lsh/signature/LSHSignatureGenerator;", "stages", "", "buckets", "seed", "", "dimension", "(IIJI)V", "K", "N", "random", "Ljava/util/SplittableRandom;", "superBit", "Lorg/vitrivr/cottontail/dbms/index/lsh/signature/SBLSHSignatureGenerator$SuperBit;", "computeSuperBitDepth", "d", "k", "generate", "Lorg/vitrivr/cottontail/dbms/index/lsh/signature/LSHSignature;", "vector", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "generate-dna7En8", "(Lorg/vitrivr/cottontail/core/types/VectorValue;)[I", "hashSignature", "signatureReal", "", "signatureComplex", "hashSignature-Rkdy0DY", "([Z[Z)[I", "train", "", "vectors", "Lkotlin/sequences/Sequence;", "Companion", "SuperBit", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nSBLSHSignatureGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBLSHSignatureGenerator.kt\norg/vitrivr/cottontail/dbms/index/lsh/signature/SBLSHSignatureGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n1#2:206\n*E\n"})
public final class SBLSHSignatureGenerator
implements LSHSignatureGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int stages;
    private final int buckets;
    private final long seed;
    private final int dimension;
    private final int K;
    private final int N;
    @NotNull
    private final SplittableRandom random;
    @Nullable
    private SuperBit superBit;
    public static final long LARGE_PRIME = 433494437L;

    public SBLSHSignatureGenerator(int stages, int buckets, long seed, int dimension) {
        this.stages = stages;
        this.buckets = buckets;
        this.seed = seed;
        this.dimension = dimension;
        this.K = this.stages * this.buckets / 2;
        this.N = this.computeSuperBitDepth(this.dimension, this.K);
        this.random = new SplittableRandom(this.seed);
    }

    private final int computeSuperBitDepth(int d, int k) {
        int N;
        for (N = d; N >= 1 && k % N != 0; --N) {
        }
        if (!(N != 0)) {
            boolean bl = false;
            String string = "Super-Bit depth must not be 0";
            throw new IllegalArgumentException(string.toString());
        }
        return N;
    }

    @Override
    public void train(@NotNull Sequence<? extends VectorValue<?>> vectors) {
        Intrinsics.checkNotNullParameter(vectors, (String)"vectors");
        this.superBit = new SuperBit((VectorValue)SequencesKt.first(vectors));
    }

    @Override
    @NotNull
    public int[] generate-dna7En8(@NotNull VectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        SuperBit superBit = this.superBit;
        if (superBit == null) {
            throw new IllegalStateException("SuperBitLSHGenerator has not been initialized and can therefore not be used.");
        }
        SuperBit sb = superBit;
        return vector instanceof ComplexVectorValue ? SBLSHSignatureGenerator.hashSignature-Rkdy0DY$default(this, sb.signatureComplex((ComplexVectorValue)vector), null, 2, null) : SBLSHSignatureGenerator.hashSignature-Rkdy0DY$default(this, sb.signature(vector), null, 2, null);
    }

    private final int[] hashSignature-Rkdy0DY(boolean[] signatureReal, boolean[] signatureComplex) {
        if (!(signatureReal.length == this.K)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long[] acc = new long[this.stages];
        int n = this.stages;
        for (int i2 = 0; i2 < n; ++i2) {
            acc[i2] = 0L;
        }
        int rows = signatureReal.length / this.stages;
        int n2 = signatureReal.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            long j = 0L;
            if (signatureReal[i3]) {
                j = (long)(i3 + 1) * 433494437L;
            }
            if (signatureComplex != null && signatureComplex[i3]) {
                j += (long)(i3 + 1) * 433494437L;
            }
            int k = RangesKt.coerceAtMost((int)(i3 / rows), (int)(this.stages - 1));
            acc[k] = (acc[k] + j) % (long)Integer.MAX_VALUE;
        }
        int[] vector = new int[this.stages];
        int n3 = this.stages;
        for (int i4 = 0; i4 < n3; ++i4) {
            vector[i4] = (int)acc[i4] % this.buckets;
        }
        return LSHSignature.constructor-impl(vector);
    }

    static /* synthetic */ int[] hashSignature-Rkdy0DY$default(SBLSHSignatureGenerator sBLSHSignatureGenerator, boolean[] blArray, boolean[] blArray2, int n, Object object) {
        if ((n & 2) != 0) {
            blArray2 = null;
        }
        return sBLSHSignatureGenerator.hashSignature-Rkdy0DY(blArray, blArray2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/signature/SBLSHSignatureGenerator$Companion;", "", "()V", "LARGE_PRIME", "", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0003J\u0012\u0010\u000b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\fR\u001a\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/signature/SBLSHSignatureGenerator$SuperBit;", "", "species", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "(Lorg/vitrivr/cottontail/dbms/index/lsh/signature/SBLSHSignatureGenerator;Lorg/vitrivr/cottontail/core/types/VectorValue;)V", "hyperplanes", "", "[Lorg/vitrivr/cottontail/core/types/VectorValue;", "signature", "", "vector", "signatureComplex", "Lorg/vitrivr/cottontail/core/types/ComplexVectorValue;", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nSBLSHSignatureGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBLSHSignatureGenerator.kt\norg/vitrivr/cottontail/dbms/index/lsh/signature/SBLSHSignatureGenerator$SuperBit\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n1#2:206\n*E\n"})
    public final class SuperBit {
        @NotNull
        private final VectorValue<?>[] hyperplanes;

        public SuperBit(VectorValue<?> species) {
            Intrinsics.checkNotNullParameter(species, (String)"species");
            if (!(SBLSHSignatureGenerator.this.dimension > 0)) {
                boolean $i$a$-require-SBLSHSignatureGenerator$SuperBit$42 = false;
                String $i$a$-require-SBLSHSignatureGenerator$SuperBit$42 = "Dimension d must be >= 1";
                throw new IllegalArgumentException($i$a$-require-SBLSHSignatureGenerator$SuperBit$42.toString());
            }
            if (!(SBLSHSignatureGenerator.this.N >= 1 && SBLSHSignatureGenerator.this.N <= SBLSHSignatureGenerator.this.dimension)) {
                boolean $i$a$-require-SBLSHSignatureGenerator$SuperBit$52 = false;
                String $i$a$-require-SBLSHSignatureGenerator$SuperBit$52 = "Super-Bit depth N must be 1 <= N <= d";
                throw new IllegalArgumentException($i$a$-require-SBLSHSignatureGenerator$SuperBit$52.toString());
            }
            int L = SBLSHSignatureGenerator.this.K / SBLSHSignatureGenerator.this.N;
            if (!(L >= 1)) {
                boolean $i$a$-require-SBLSHSignatureGenerator$SuperBit$62 = false;
                String $i$a$-require-SBLSHSignatureGenerator$SuperBit$62 = "Number of Super-Bits L must be >= 1";
                throw new IllegalArgumentException($i$a$-require-SBLSHSignatureGenerator$SuperBit$62.toString());
            }
            int n = SBLSHSignatureGenerator.this.K;
            VectorValue[] vectorValueArray = new VectorValue[n];
            for (int $i$a$-require-SBLSHSignatureGenerator$SuperBit$62 = 0; $i$a$-require-SBLSHSignatureGenerator$SuperBit$62 < n; ++$i$a$-require-SBLSHSignatureGenerator$SuperBit$62) {
                DoubleVectorValue doubleVectorValue;
                int n2;
                VectorValue[] vectorValueArray2;
                int n3;
                VectorValue[] vectorValueArray3;
                int n4;
                Object[] objectArray;
                int n5;
                int n6;
                int n7 = $i$a$-require-SBLSHSignatureGenerator$SuperBit$62;
                VectorValue<?> vectorValue = species;
                if (vectorValue instanceof DoubleVectorValue) {
                    n6 = 0;
                    n5 = species.getLogicalSize();
                    objectArray = new double[n5];
                    n4 = n7;
                    vectorValueArray3 = vectorValueArray;
                    while (n6 < n5) {
                        n3 = n6++;
                        objectArray[n3] = SBLSHSignatureGenerator.this.random.nextDouble() - 0.5;
                    }
                    vectorValueArray2 = vectorValueArray3;
                    n2 = n4;
                    doubleVectorValue = DoubleVectorValue.box-impl((double[])DoubleVectorValue.constructor-impl((double[])objectArray));
                } else if (vectorValue instanceof FloatVectorValue) {
                    n6 = 0;
                    n5 = species.getLogicalSize();
                    objectArray = new float[n5];
                    while (n6 < n5) {
                        n3 = n6++;
                        objectArray[n3] = (float)(SBLSHSignatureGenerator.this.random.nextDouble() - 0.5);
                    }
                    vectorValueArray2 = vectorValueArray3;
                    n2 = n4;
                    doubleVectorValue = FloatVectorValue.box-impl((float[])FloatVectorValue.constructor-impl((float[])objectArray));
                } else if (vectorValue instanceof Complex32VectorValue) {
                    n6 = 0;
                    n5 = species.getLogicalSize() * 2;
                    objectArray = new float[n5];
                    while (n6 < n5) {
                        n3 = n6++;
                        objectArray[n3] = (float)(SBLSHSignatureGenerator.this.random.nextDouble() - 0.5);
                    }
                    vectorValueArray2 = vectorValueArray3;
                    n2 = n4;
                    doubleVectorValue = Complex32VectorValue.box-impl((float[])Complex32VectorValue.constructor-impl((float[])objectArray));
                } else if (vectorValue instanceof Complex64VectorValue) {
                    n6 = 0;
                    n5 = species.getLogicalSize() * 2;
                    objectArray = new double[n5];
                    while (n6 < n5) {
                        n3 = n6++;
                        objectArray[n3] = SBLSHSignatureGenerator.this.random.nextDouble() - 0.5;
                    }
                    vectorValueArray2 = vectorValueArray3;
                    n2 = n4;
                    doubleVectorValue = Complex64VectorValue.box-impl((double[])Complex64VectorValue.constructor-impl((double[])objectArray));
                } else {
                    throw new IllegalArgumentException("Unsupported vector type");
                }
                VectorValue rnd = (VectorValue)doubleVectorValue;
                vectorValueArray2[n2] = rnd.div((NumericValue)rnd.norm2());
            }
            VectorValue[] v = vectorValueArray;
            n = 0;
            int n8 = SBLSHSignatureGenerator.this.K;
            VectorValue[] vectorValueArray4 = new VectorValue[n8];
            while (n < n8) {
                int rnd = n++;
                vectorValueArray4[rnd] = v[rnd];
            }
            VectorValue[] w = vectorValueArray4;
            block6: for (int i2 = 0; i2 < L; ++i2) {
                int j = 1;
                int n9 = SBLSHSignatureGenerator.this.N;
                if (j > n9) continue;
                while (true) {
                    for (int k = 1; k < j; ++k) {
                        w[i2 * ((SBLSHSignatureGenerator)SBLSHSignatureGenerator.this).N + j - 1] = w[i2 * SBLSHSignatureGenerator.this.N + j - 1].minus(w[i2 * SBLSHSignatureGenerator.this.N + k - 1].times(w[i2 * SBLSHSignatureGenerator.this.N + j - 1].dot(v[i2 * SBLSHSignatureGenerator.this.N + k - 1])));
                    }
                    w[i2 * ((SBLSHSignatureGenerator)SBLSHSignatureGenerator.this).N + j - 1] = w[i2 * SBLSHSignatureGenerator.this.N + j - 1].div((NumericValue)w[i2 * SBLSHSignatureGenerator.this.N + j - 1].norm2());
                    if (j == n9) continue block6;
                    ++j;
                }
            }
            this.hyperplanes = w;
        }

        @NotNull
        public final boolean[] signature(@NotNull VectorValue<?> vector) {
            Intrinsics.checkNotNullParameter(vector, (String)"vector");
            boolean[] signature = new boolean[this.hyperplanes.length];
            int n = this.hyperplanes.length;
            for (int i2 = 0; i2 < n; ++i2) {
                signature[i2] = this.hyperplanes[i2].dot(vector).asInt-XzlYvWs() >= 0;
            }
            return signature;
        }

        @NotNull
        public final boolean[] signatureComplex(@NotNull ComplexVectorValue<?> vector) {
            Intrinsics.checkNotNullParameter(vector, (String)"vector");
            int n = this.hyperplanes.length;
            boolean[] blArray = new boolean[n];
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                blArray[n2] = n2 % 2 == 0 ? this.hyperplanes[n2].dot((VectorValue)vector).getReal().asInt-XzlYvWs() >= 0 : this.hyperplanes[n2].dot((VectorValue)vector).getImaginary().asInt-XzlYvWs() >= 0;
            }
            return blArray;
        }
    }
}

