/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.ShortBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.queries.binding.BindingContext;
import org.vitrivr.cottontail.core.queries.binding.MissingTuple;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.tuple.StandaloneTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.RealVectorValue;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.dbms.index.pq.IVFPQIndex;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.MultiStageQuantizer;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.PQCodebook;
import org.vitrivr.cottontail.dbms.index.pq.signature.IVFPQSignature;
import org.vitrivr.cottontail.dbms.index.pq.signature.PQLookupTable;
import org.vitrivr.cottontail.utilities.selection.ComparablePair;
import org.vitrivr.cottontail.utilities.selection.MinHeapSelection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001f\u001a\u00020 H\u0016J\f\u0010!\u001a\u00060\"j\u0002`#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0002J\b\u0010'\u001a\u00020\u0002H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u000f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndexCursor;", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$Scan;", "index", "Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndex;", "(Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$Scan;Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndex$Tx;)V", "boc", "Ljava/util/concurrent/atomic/AtomicBoolean;", "coarse", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "cursor", "Ljetbrains/exodus/env/Cursor;", "kotlin.jvm.PlatformType", "getIndex", "()Lorg/vitrivr/cottontail/dbms/index/pq/IVFPQIndex$Tx;", "lookupTable", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable;", "getPredicate", "()Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$Scan;", "produces", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "queue", "Ljava/util/Deque;", "", "subTx", "Ljetbrains/exodus/env/Transaction;", "close", "", "key", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "moveNext", "", "nextCell", "value", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nIVFPQIndexCursor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IVFPQIndexCursor.kt\norg/vitrivr/cottontail/dbms/index/pq/IVFPQIndexCursor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,119:1\n37#2,2:120\n*S KotlinDebug\n*F\n+ 1 IVFPQIndexCursor.kt\norg/vitrivr/cottontail/dbms/index/pq/IVFPQIndexCursor\n*L\n44#1:120,2\n*E\n"})
public final class IVFPQIndexCursor
implements org.vitrivr.cottontail.core.basics.Cursor<Tuple> {
    @NotNull
    private final ProximityPredicate.Scan predicate;
    @NotNull
    private final IVFPQIndex.Tx index;
    @NotNull
    private final PQCodebook coarse;
    @NotNull
    private final PQLookupTable lookupTable;
    private final Transaction subTx;
    private final Cursor cursor;
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final Deque<Short> queue;
    @NotNull
    private final AtomicBoolean boc;

    public IVFPQIndexCursor(@NotNull ProximityPredicate.Scan predicate, @NotNull IVFPQIndex.Tx index) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        this.predicate = predicate;
        this.index = index;
        this.coarse = this.index.getQuantizer$cottontaildb_dbms().getCoarse();
        this.subTx = this.index.getContext().getTxn().getXodusTx().getReadonlySnapshot();
        this.cursor = this.index.getDataStore$cottontaildb_dbms().openCursor(this.subTx);
        Collection $this$toTypedArray$iv = this.index.columnsFor((Predicate)this.predicate);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.produces = thisCollection$iv.toArray(new ColumnDef[0]);
        this.boc = new AtomicBoolean(false);
        int nprobe = this.coarse.getNumberOfCentroids() / 32;
        MinHeapSelection<Comparable> selection2 = new MinHeapSelection<Comparable>(nprobe);
        MissingTuple $this$_init__u24lambda_u241 = MissingTuple.INSTANCE;
        boolean bl = false;
        BindingContext $this$lambda_u241_u24lambda_u240 = this.index.getContext().getBindings();
        boolean bl2 = false;
        MultiStageQuantizer multiStageQuantizer = this.index.getQuantizer$cottontaildb_dbms();
        Value value = this.predicate.getQuery().getValue($this$lambda_u241_u24lambda_u240, (Tuple)$this$_init__u24lambda_u241);
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.types.VectorValue<*>");
        this.lookupTable = multiStageQuantizer.createLookupTable((VectorValue)value);
        int n = this.coarse.getCentroids().length;
        for (int c = 0; c < n; ++c) {
            Integer n2 = c;
            Value value2 = this.predicate.getQuery().getValue($this$lambda_u241_u24lambda_u240, (Tuple)$this$_init__u24lambda_u241);
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.types.RealVectorValue<*>");
            selection2.offer(new ComparablePair<Integer, Comparable>(n2, Double.valueOf(this.coarse.distanceFrom((VectorValue)((RealVectorValue)value2), c))));
        }
        this.queue = new ArrayDeque(nprobe);
        int n3 = selection2.getSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.queue.offer((short)((Number)((ComparablePair)selection2.get(i2)).getFirst()).intValue());
        }
        if (this.nextCell()) {
            this.boc.compareAndExchange(false, true);
        }
    }

    @NotNull
    public final ProximityPredicate.Scan getPredicate() {
        return this.predicate;
    }

    @NotNull
    public final IVFPQIndex.Tx getIndex() {
        return this.index;
    }

    public boolean moveNext() {
        return this.boc.compareAndExchange(true, false) || this.cursor.getNextDup() || this.nextCell();
    }

    public long key() {
        return LongBinding.compressedEntryToLong((ByteIterable)this.cursor.getValue());
    }

    @NotNull
    public Tuple value() {
        ByteIterable byteIterable = this.cursor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getValue(...)");
        IVFPQSignature signature = IVFPQSignature.Companion.fromEntry(byteIterable);
        double approximation = DoubleValue.constructor-impl((double)this.lookupTable.approximateDistance(signature));
        Value[] valueArray = new Value[]{DoubleValue.box-impl((double)approximation)};
        return (Tuple)new StandaloneTuple(signature.getTupleId(), this.produces, valueArray);
    }

    public void close() {
        this.subTx.abort();
        this.cursor.close();
    }

    private final boolean nextCell() {
        Short s = this.queue.poll();
        if (s == null) {
            return false;
        }
        short next = s;
        return this.cursor.getSearchKey((ByteIterable)ShortBinding.shortToEntry((short)next)) != null;
    }

    public boolean hasNext() {
        return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public boolean movePrevious() {
        return Cursor.DefaultImpls.movePrevious((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public boolean moveTo(long tupleId) {
        return Cursor.DefaultImpls.moveTo((org.vitrivr.cottontail.core.basics.Cursor)this, (long)tupleId);
    }

    @NotNull
    public Tuple next() {
        return (Tuple)Cursor.DefaultImpls.next((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

