/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq;

import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.CosineDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.EuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.InnerProductDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.ManhattanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.SquaredEuclideanDistance;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.PQIndex;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002 !B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\t\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\""}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;", "distance", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "numCentroids", "", "subspaces", "seed", "(Lorg/vitrivr/cottontail/core/database/Name$FunctionName;III)V", "getDistance", "()Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getNumCentroids", "()I", "getSeed", "getSubspaces", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "numberOfSubspaces", "d", "toMap", "", "", "toString", "Binding", "Companion", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nPQIndexConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PQIndexConfig.kt\norg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class PQIndexConfig
implements IndexConfig<PQIndex> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.FunctionName distance;
    private final int numCentroids;
    private final int subspaces;
    private final int seed;
    private static final int MAXIMUM_NUMBER_OF_SUBSPACES = 32;
    @NotNull
    public static final String KEY_DISTANCE = "pq.distance";
    @NotNull
    public static final String KEY_NUM_SUBSPACES = "pq.subspaces";
    @NotNull
    public static final String KEY_NUM_CENTROIDS = "pq.centroids";
    @NotNull
    public static final String KEY_SEED = "pq.seed";
    public static final int DEFAULT_CENTROIDS = 256;
    public static final int DEFAULT_SUBSPACES = 8;
    @NotNull
    private static final Set<Name.FunctionName> SUPPORTED_DISTANCES;

    public PQIndexConfig(@NotNull Name.FunctionName distance, int numCentroids, int subspaces, int seed) {
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        this.distance = distance;
        this.numCentroids = numCentroids;
        this.subspaces = subspaces;
        this.seed = seed;
        if (!(this.numCentroids > 0)) {
            boolean $i$a$-require-PQIndexConfig$42 = false;
            String $i$a$-require-PQIndexConfig$42 = "PQIndex requires at least one centroid.";
            throw new IllegalArgumentException($i$a$-require-PQIndexConfig$42.toString());
        }
        if (!(this.numCentroids <= Short.MAX_VALUE)) {
            boolean $i$a$-require-PQIndexConfig$52 = false;
            String $i$a$-require-PQIndexConfig$52 = "PQIndex supports a maximum number of 32767 centroids.";
            throw new IllegalArgumentException($i$a$-require-PQIndexConfig$52.toString());
        }
        if (!SUPPORTED_DISTANCES.contains(this.distance)) {
            boolean bl = false;
            String string = "PQIndex only support L1, L2, L2SQUARED, COSINE and INNERPRODUCT distance.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ PQIndexConfig(Name.FunctionName functionName, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            n3 = (int)System.currentTimeMillis();
        }
        this(functionName, n, n2, n3);
    }

    @NotNull
    public final Name.FunctionName getDistance() {
        return this.distance;
    }

    public final int getNumCentroids() {
        return this.numCentroids;
    }

    public final int getSubspaces() {
        return this.subspaces;
    }

    public final int getSeed() {
        return this.seed;
    }

    public final int numberOfSubspaces(int d) {
        int subspaces = this.subspaces;
        do {
            if (d % subspaces != 0) continue;
            return subspaces;
        } while (++subspaces <= 32);
        subspaces = this.subspaces;
        while (subspaces-- > 1) {
            if (d % subspaces != 0) continue;
            return subspaces;
        }
        return 1;
    }

    @Override
    @NotNull
    public Map<String, String> toMap() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)KEY_DISTANCE, (Object)this.distance.getSimple()), TuplesKt.to((Object)KEY_NUM_CENTROIDS, (Object)String.valueOf(this.numCentroids)), TuplesKt.to((Object)KEY_SEED, (Object)String.valueOf(this.seed))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public int compareTo(@NotNull IndexConfig<PQIndex> other) {
        return IndexConfig.DefaultImpls.compareTo(this, other);
    }

    @NotNull
    public final Name.FunctionName component1() {
        return this.distance;
    }

    public final int component2() {
        return this.numCentroids;
    }

    public final int component3() {
        return this.subspaces;
    }

    public final int component4() {
        return this.seed;
    }

    @NotNull
    public final PQIndexConfig copy(@NotNull Name.FunctionName distance, int numCentroids, int subspaces, int seed) {
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        return new PQIndexConfig(distance, numCentroids, subspaces, seed);
    }

    public static /* synthetic */ PQIndexConfig copy$default(PQIndexConfig pQIndexConfig, Name.FunctionName functionName, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            functionName = pQIndexConfig.distance;
        }
        if ((n4 & 2) != 0) {
            n = pQIndexConfig.numCentroids;
        }
        if ((n4 & 4) != 0) {
            n2 = pQIndexConfig.subspaces;
        }
        if ((n4 & 8) != 0) {
            n3 = pQIndexConfig.seed;
        }
        return pQIndexConfig.copy(functionName, n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "PQIndexConfig(distance=" + this.distance + ", numCentroids=" + this.numCentroids + ", subspaces=" + this.subspaces + ", seed=" + this.seed + ")";
    }

    public int hashCode() {
        int result = this.distance.hashCode();
        result = result * 31 + Integer.hashCode(this.numCentroids);
        result = result * 31 + Integer.hashCode(this.subspaces);
        result = result * 31 + Integer.hashCode(this.seed);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PQIndexConfig)) {
            return false;
        }
        PQIndexConfig pQIndexConfig = (PQIndexConfig)other;
        if (!Intrinsics.areEqual((Object)this.distance, (Object)pQIndexConfig.distance)) {
            return false;
        }
        if (this.numCentroids != pQIndexConfig.numCentroids) {
            return false;
        }
        if (this.subspaces != pQIndexConfig.subspaces) {
            return false;
        }
        return this.seed == pQIndexConfig.seed;
    }

    static {
        Object[] objectArray = new Name.FunctionName[]{ManhattanDistance.Companion.getFUNCTION_NAME(), EuclideanDistance.Companion.getFUNCTION_NAME(), SquaredEuclideanDistance.Companion.getFUNCTION_NAME(), CosineDistance.Companion.getFUNCTION_NAME(), InnerProductDistance.Companion.getFUNCTION_NAME()};
        SUPPORTED_DISTANCES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig$Binding;", "Ljetbrains/exodus/bindings/ComparableBinding;", "()V", "readObject", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;", "stream", "Ljava/io/ByteArrayInputStream;", "writeObject", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "object", "", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nPQIndexConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PQIndexConfig.kt\norg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig$Binding\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
    public static final class Binding
    extends ComparableBinding {
        @NotNull
        public static final Binding INSTANCE = new Binding();

        private Binding() {
        }

        @NotNull
        public PQIndexConfig readObject(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            String string = StringBinding.BINDING.readObject(stream);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readObject(...)");
            return new PQIndexConfig(Name.FunctionName.Companion.create(string), IntegerBinding.readCompressed((ByteArrayInputStream)stream), IntegerBinding.readCompressed((ByteArrayInputStream)stream), IntegerBinding.readCompressed((ByteArrayInputStream)stream));
        }

        public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable<? super PQIndexConfig> object) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(object, (String)"object");
            if (!(object instanceof PQIndexConfig)) {
                boolean bl = false;
                String string = "PQIndexConfig.Binding can only be used to serialize instances of PQIndexConfig.";
                throw new IllegalArgumentException(string.toString());
            }
            StringBinding.BINDING.writeObject(output, (Comparable)((Object)((PQIndexConfig)object).getDistance().getSimple()));
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((PQIndexConfig)object).getNumCentroids());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((PQIndexConfig)object).getSubspaces());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((PQIndexConfig)object).getSeed());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig$Companion;", "", "()V", "DEFAULT_CENTROIDS", "", "DEFAULT_SUBSPACES", "KEY_DISTANCE", "", "KEY_NUM_CENTROIDS", "KEY_NUM_SUBSPACES", "KEY_SEED", "MAXIMUM_NUMBER_OF_SUBSPACES", "SUPPORTED_DISTANCES", "", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getSUPPORTED_DISTANCES", "()Ljava/util/Set;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Name.FunctionName> getSUPPORTED_DISTANCES() {
            return SUPPORTED_DISTANCES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

