/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq.quantizer;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.core.values.DoubleValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ0\u0010\u0015\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0012\b\u0002\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u001a\u001a\u00020\u000eJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001e\u001a\u00020\u000eH\u0016J\u0012\u0010\u001f\u001a\u00020\u000e2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0006J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u001d\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "", "distance", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "centroids", "", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "(Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;[Lorg/vitrivr/cottontail/core/types/VectorValue;)V", "getCentroids", "()[Lorg/vitrivr/cottontail/core/types/VectorValue;", "[Lorg/vitrivr/cottontail/core/types/VectorValue;", "getDistance", "()Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "numberOfCentroids", "", "getNumberOfCentroids", "()I", "subspaceSize", "getSubspaceSize", "component1", "component2", "copy", "(Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;[Lorg/vitrivr/cottontail/core/types/VectorValue;)Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "distanceFrom", "", "vector", "centroidIndex", "equals", "", "other", "hashCode", "quantize", "toString", "", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nPQCodebook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PQCodebook.kt\norg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n12271#2,2:76\n1#3:78\n*S KotlinDebug\n*F\n+ 1 PQCodebook.kt\norg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook\n*L\n16#1:76,2\n*E\n"})
public final class PQCodebook {
    @NotNull
    private final VectorDistance<?> distance;
    @NotNull
    private final VectorValue<?>[] centroids;

    public PQCodebook(@NotNull VectorDistance<?> distance, @NotNull VectorValue<?>[] centroids) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter(distance, (String)"distance");
            Intrinsics.checkNotNullParameter(centroids, (String)"centroids");
            this.distance = distance;
            this.centroids = centroids;
            VectorValue<?>[] $this$all$iv = this.centroids;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int j = 0; j < n; ++j) {
                VectorValue<?> element$iv;
                VectorValue<?> it = element$iv = $this$all$iv[j];
                boolean bl2 = false;
                if (it.getLogicalSize() == this.distance.getType().getLogicalSize()) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Dimensionality of centroids and distance function do not match for PQ codebook.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final VectorDistance<?> getDistance() {
        return this.distance;
    }

    @NotNull
    public final VectorValue<?>[] getCentroids() {
        return this.centroids;
    }

    public final int getSubspaceSize() {
        return this.centroids[0].getLogicalSize();
    }

    public final int getNumberOfCentroids() {
        return this.centroids.length;
    }

    public final int quantize(@NotNull VectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        int smallestIndexSeen = 0;
        Value[] valueArray = new Value[]{vector, this.centroids[0]};
        Value value = this.distance.invoke(valueArray);
        Intrinsics.checkNotNull((Object)value);
        double smallestDistSeen = ((DoubleValue)value).unbox-impl();
        int n = this.centroids.length;
        for (int i2 = 1; i2 < n; ++i2) {
            Value[] valueArray2 = new Value[]{vector, this.centroids[i2]};
            Value value2 = this.distance.invoke(valueArray2);
            Intrinsics.checkNotNull((Object)value2);
            double newDist = ((DoubleValue)value2).unbox-impl();
            if (!(newDist < smallestDistSeen)) continue;
            smallestDistSeen = newDist;
            smallestIndexSeen = i2;
        }
        return smallestIndexSeen;
    }

    public final double distanceFrom(@NotNull VectorValue<?> vector, int centroidIndex) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        if (!(vector.getLogicalSize() == this.getSubspaceSize())) {
            boolean bl = false;
            String string = "Dimension mismatch between sub-vector and codebook.";
            throw new IllegalArgumentException(string.toString());
        }
        Value[] valueArray = new Value[]{vector, this.centroids[centroidIndex]};
        Value value = this.distance.invoke(valueArray);
        Intrinsics.checkNotNull((Object)value);
        return ((DoubleValue)value).unbox-impl();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PQCodebook)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.distance.getSignature(), (Object)((PQCodebook)other).distance.getSignature())) {
            return false;
        }
        if (this.centroids.length != ((PQCodebook)other).centroids.length) {
            return false;
        }
        int n = this.centroids.length;
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = this.centroids[i2].getLogicalSize();
            for (int j = 0; j < n2; ++j) {
                if (Intrinsics.areEqual((Object)this.centroids[i2].get(j), (Object)((PQCodebook)other).centroids[i2].get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.distance.getSignature().hashCode();
        result = 31 * result + Arrays.hashCode(this.centroids);
        return result;
    }

    @NotNull
    public final VectorDistance<?> component1() {
        return this.distance;
    }

    @NotNull
    public final VectorValue<?>[] component2() {
        return this.centroids;
    }

    @NotNull
    public final PQCodebook copy(@NotNull VectorDistance<?> distance, @NotNull VectorValue<?>[] centroids) {
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        Intrinsics.checkNotNullParameter(centroids, (String)"centroids");
        return new PQCodebook(distance, centroids);
    }

    public static /* synthetic */ PQCodebook copy$default(PQCodebook pQCodebook, VectorDistance vectorDistance, VectorValue[] vectorValueArray, int n, Object object) {
        if ((n & 1) != 0) {
            vectorDistance = pQCodebook.distance;
        }
        if ((n & 2) != 0) {
            vectorValueArray = pQCodebook.centroids;
        }
        return pQCodebook.copy(vectorDistance, vectorValueArray);
    }

    @NotNull
    public String toString() {
        return "PQCodebook(distance=" + this.distance + ", centroids=" + Arrays.toString(this.centroids) + ")";
    }
}

