/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.schema;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/dbms/schema/SchemaMetadata;", "", "created", "", "updated", "(JJ)V", "getCreated", "()J", "getUpdated", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "cottontaildb-dbms"})
public final class SchemaMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long created;
    private final long updated;
    @NotNull
    private static final String CATALOGUE_SCHEMA_STORE_NAME = "org.vitrivr.cottontail.schema";

    public SchemaMetadata(long created, long updated) {
        this.created = created;
        this.updated = updated;
    }

    public final long getCreated() {
        return this.created;
    }

    public final long getUpdated() {
        return this.updated;
    }

    public final long component1() {
        return this.created;
    }

    public final long component2() {
        return this.updated;
    }

    @NotNull
    public final SchemaMetadata copy(long created, long updated) {
        return new SchemaMetadata(created, updated);
    }

    public static /* synthetic */ SchemaMetadata copy$default(SchemaMetadata schemaMetadata, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = schemaMetadata.created;
        }
        if ((n & 2) != 0) {
            l2 = schemaMetadata.updated;
        }
        return schemaMetadata.copy(l, l2);
    }

    @NotNull
    public String toString() {
        return "SchemaMetadata(created=" + this.created + ", updated=" + this.updated + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.created);
        result = result * 31 + Long.hashCode(this.updated);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SchemaMetadata)) {
            return false;
        }
        SchemaMetadata schemaMetadata = (SchemaMetadata)other;
        if (this.created != schemaMetadata.created) {
            return false;
        }
        return this.updated == schemaMetadata.updated;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0012J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/dbms/schema/SchemaMetadata$Companion;", "", "()V", "CATALOGUE_SCHEMA_STORE_NAME", "", "fromEntry", "Lorg/vitrivr/cottontail/dbms/schema/SchemaMetadata;", "entry", "Ljetbrains/exodus/ByteIterable;", "init", "", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "transaction", "Ljetbrains/exodus/env/Transaction;", "init$cottontaildb_dbms", "store", "Ljetbrains/exodus/env/Store;", "store$cottontaildb_dbms", "toEntry", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public final void init$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            if (catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(SchemaMetadata.CATALOGUE_SCHEMA_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, transaction, true) == null) {
                throw new DatabaseException.DataCorruptionException("Failed to create schema catalogue store.");
            }
        }

        @NotNull
        public final Store store$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Store store = catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(SchemaMetadata.CATALOGUE_SCHEMA_STORE_NAME, StoreConfig.USE_EXISTING, transaction, false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Failed to open store for schema catalogue.");
            }
            return store;
        }

        @NotNull
        public final SchemaMetadata fromEntry(@NotNull ByteIterable entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            ByteArrayInputStream stream = new ByteArrayInputStream(entry.getBytesUnsafe(), 0, entry.getLength());
            return new SchemaMetadata(LongBinding.readCompressed((ByteArrayInputStream)stream), LongBinding.readCompressed((ByteArrayInputStream)stream));
        }

        @NotNull
        public final ByteIterable toEntry(@NotNull SchemaMetadata entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            LightOutputStream output = new LightOutputStream();
            LongBinding.writeCompressed((LightOutputStream)output, (long)entry.getCreated());
            LongBinding.writeCompressed((LightOutputStream)output, (long)entry.getUpdated());
            ArrayByteIterable arrayByteIterable = output.asArrayByteIterable();
            Intrinsics.checkNotNullExpressionValue((Object)arrayByteIterable, (String)"asArrayByteIterable(...)");
            return (ByteIterable)arrayByteIterable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

