/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.sequence;

import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.values.LongValue;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.general.Tx;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;
import org.vitrivr.cottontail.dbms.schema.DefaultSchema;
import org.vitrivr.cottontail.dbms.sequence.Sequence;
import org.vitrivr.cottontail.dbms.sequence.SequenceTx;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/dbms/sequence/DefaultSequence;", "Lorg/vitrivr/cottontail/dbms/sequence/Sequence;", "name", "Lorg/vitrivr/cottontail/core/database/Name$SequenceName;", "parent", "Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;", "(Lorg/vitrivr/cottontail/core/database/Name$SequenceName;Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$SequenceName;", "getParent", "()Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;", "equals", "", "other", "", "hashCode", "", "newTx", "Lorg/vitrivr/cottontail/dbms/sequence/SequenceTx;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class DefaultSequence
implements Sequence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.SequenceName name;
    @NotNull
    private final DefaultSchema parent;
    @NotNull
    private static final String CATALOGUE_SEQUENCE_STORE_NAME = "org.vitrivr.cottontail.sequences";

    public DefaultSequence(@NotNull Name.SequenceName name, @NotNull DefaultSchema parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
    }

    @Override
    @NotNull
    public Name.SequenceName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DefaultSchema getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public DefaultCatalogue getCatalogue() {
        return this.getParent().getCatalogue();
    }

    @Override
    @NotNull
    public SequenceTx newTx(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SequenceTx sequenceTx = (SequenceTx)context2.getTxn().getCachedTxForDBO(this);
        if (sequenceTx == null) {
            sequenceTx = new Tx(context2);
        }
        return sequenceTx;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DefaultSequence)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((DefaultSequence)other).getParent(), (Object)this.getParent())) {
            return false;
        }
        return Intrinsics.areEqual((Object)((DefaultSequence)other).getName(), (Object)this.getName());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getParent().hashCode();
        return result;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return Sequence.DefaultImpls.getVersion(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/sequence/DefaultSequence$Companion;", "", "()V", "CATALOGUE_SEQUENCE_STORE_NAME", "", "init", "", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "transaction", "Ljetbrains/exodus/env/Transaction;", "store", "Ljetbrains/exodus/env/Store;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public final void init(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            if (catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(DefaultSequence.CATALOGUE_SEQUENCE_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, transaction, true) == null) {
                throw new DatabaseException.DataCorruptionException("Failed to create store for sequence catalogue.");
            }
        }

        @NotNull
        public final Store store(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Store store = catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(DefaultSequence.CATALOGUE_SEQUENCE_STORE_NAME, StoreConfig.USE_EXISTING, transaction, false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Data store for sequences is missing.");
            }
            return store;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0015\u0010\u0011\u001a\u00020\u0012H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u0012H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\u0012H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/dbms/sequence/DefaultSequence$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/sequence/SequenceTx;", "Lorg/vitrivr/cottontail/dbms/general/Tx$WithCommitFinalization;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/sequence/DefaultSequence;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "cache", "Ljava/util/concurrent/atomic/AtomicLong;", "dbo", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/general/DBO;", "store", "Ljetbrains/exodus/env/Store;", "beforeCommit", "", "current", "Lorg/vitrivr/cottontail/core/values/LongValue;", "current-hRrSGgQ", "()J", "next", "next-hRrSGgQ", "reset", "reset-hRrSGgQ", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements SequenceTx,
    Tx.WithCommitFinalization {
        @NotNull
        private final AtomicLong cache;
        @NotNull
        private final Store store;

        public Tx(QueryContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            context2.getTxn().cacheTx(this);
            this.cache = new AtomicLong(0L);
            this.store = Companion.store(DefaultSequence.this.getCatalogue(), this.getContext().getTxn().getXodusTx());
            ByteIterable raw = this.store.get(this.getContext().getTxn().getXodusTx(), NameBinding.Sequence.INSTANCE.toEntry(DefaultSequence.this.getName()));
            if (raw != null) {
                this.cache.set(LongBinding.compressedEntryToLong((ByteIterable)raw));
            }
        }

        @Override
        @NotNull
        public DBO getDbo() {
            return DefaultSequence.this;
        }

        @Override
        public long next-hRrSGgQ() {
            return LongValue.constructor-impl((long)this.cache.incrementAndGet());
        }

        @Override
        public long current-hRrSGgQ() {
            return LongValue.constructor-impl((long)this.cache.get());
        }

        @Override
        public long reset-hRrSGgQ() {
            return LongValue.constructor-impl((long)this.cache.getAndSet(0L));
        }

        @Override
        public void beforeCommit() {
            ArrayByteIterable raw = LongBinding.longToCompressedEntry((long)this.cache.get());
            this.store.put(this.getContext().getTxn().getXodusTx(), NameBinding.Sequence.INSTANCE.toEntry(DefaultSequence.this.getName()), (ByteIterable)raw);
        }
    }
}

