/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.collectors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.BooleanValue;
import org.vitrivr.cottontail.dbms.statistics.collectors.AbstractScalarMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsConfig;
import org.vitrivr.cottontail.dbms.statistics.values.BooleanValueStatistics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/collectors/BooleanMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/AbstractScalarMetricsCollector;", "Lorg/vitrivr/cottontail/core/values/BooleanValue;", "config", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;", "(Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;)V", "numberOfFalseEntries", "", "numberOfTrueEntries", "calculate", "Lorg/vitrivr/cottontail/dbms/statistics/values/BooleanValueStatistics;", "probability", "", "receive", "", "value", "receive-izlU2kE", "cottontaildb-dbms"})
public final class BooleanMetricsCollector
extends AbstractScalarMetricsCollector<BooleanValue> {
    private long numberOfTrueEntries;
    private long numberOfFalseEntries;

    public BooleanMetricsCollector(@NotNull MetricsConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super((Types)Types.Boolean.INSTANCE, config, null);
    }

    public void receive-izlU2kE(@Nullable BooleanValue value) {
        super.receive((Value)value);
        if (value != null) {
            boolean bl = value.unbox-impl();
            if (bl) {
                ++this.numberOfTrueEntries;
            } else if (!bl) {
                ++this.numberOfFalseEntries;
            }
        }
    }

    @NotNull
    public BooleanValueStatistics calculate(float probability) {
        BooleanValueStatistics sampleMetrics = new BooleanValueStatistics(this.numberOfTrueEntries, this.numberOfFalseEntries, this.getNumberOfNullEntries(), this.getNumberOfNonNullEntries(), this.getNumberOfDistinctEntries());
        return new BooleanValueStatistics(1.0f / probability, sampleMetrics);
    }
}

