/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.collectors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.DoubleVectorValue;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsConfig;
import org.vitrivr.cottontail.dbms.statistics.collectors.RealVectorMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.values.DoubleVectorValueStatistics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u000e\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\fR\u0019\u0010\u0010\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u0011\u0010\f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/collectors/DoubleVectorMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/RealVectorMetricsCollector;", "Lorg/vitrivr/cottontail/core/values/DoubleVectorValue;", "logicalSize", "", "config", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;", "(ILorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;)V", "getLogicalSize", "()I", "max", "getMax-aM0kQ94", "()[D", "[D", "min", "getMin-aM0kQ94", "sum", "getSum-aM0kQ94", "calculate", "Lorg/vitrivr/cottontail/dbms/statistics/values/DoubleVectorValueStatistics;", "probability", "", "receive", "", "value", "receive-962Je_c", "([D)V", "cottontaildb-dbms"})
public final class DoubleVectorMetricsCollector
extends RealVectorMetricsCollector<DoubleVectorValue> {
    private final int logicalSize;
    @NotNull
    private final double[] min;
    @NotNull
    private final double[] max;
    @NotNull
    private final double[] sum;

    public DoubleVectorMetricsCollector(int logicalSize, @NotNull MetricsConfig config) {
        int n;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super((Types)new Types.DoubleVector(logicalSize), config, null);
        this.logicalSize = logicalSize;
        int n2 = 0;
        int n3 = this.logicalSize;
        double[] dArray = new double[n3];
        DoubleVectorMetricsCollector doubleVectorMetricsCollector = this;
        while (n2 < n3) {
            n = n2++;
            dArray[n] = Double.MAX_VALUE;
        }
        doubleVectorMetricsCollector.min = DoubleVectorValue.constructor-impl((double[])dArray);
        n2 = 0;
        n3 = this.logicalSize;
        dArray = new double[n3];
        doubleVectorMetricsCollector = this;
        while (n2 < n3) {
            n = n2++;
            dArray[n] = Double.MIN_VALUE;
        }
        doubleVectorMetricsCollector.max = DoubleVectorValue.constructor-impl((double[])dArray);
        this.sum = DoubleVectorValue.constructor-impl((double[])new double[this.logicalSize]);
    }

    public final int getLogicalSize() {
        return this.logicalSize;
    }

    @NotNull
    public final double[] getMin-aM0kQ94() {
        return this.min;
    }

    @NotNull
    public final double[] getMax-aM0kQ94() {
        return this.max;
    }

    @NotNull
    public final double[] getSum-aM0kQ94() {
        return this.sum;
    }

    public void receive-962Je_c(@Nullable double[] value) {
        super.receive(value != null ? DoubleVectorValue.box-impl((double[])value) : null);
        if (value != null) {
            double[] dArray = value;
            int n = dArray.length;
            for (int j = 0; j < n; ++j) {
                int i2 = j;
                double d = dArray[j];
                this.min[i2] = Double.min(d, this.min[i2]);
                this.max[i2] = Double.max(d, this.max[i2]);
                double[] dArray2 = this.sum;
                dArray2[i2] = dArray2[i2] + d;
            }
        }
    }

    @NotNull
    public DoubleVectorValueStatistics calculate(float probability) {
        DoubleVectorValueStatistics sampleMetrics = new DoubleVectorValueStatistics(this.logicalSize, this.getNumberOfNullEntries(), this.getNumberOfNonNullEntries(), this.getNumberOfDistinctEntries(), this.min, this.max, this.sum, null);
        return new DoubleVectorValueStatistics(1.0f / probability, sampleMetrics);
    }
}

